/*
* \file    <mxd_acrux2_sdk.c>
* \brief
* \par    Include files
* \par    (C) 2013 Maxscend Technologies Inc.
* \version
* Revision of last commit: $Rev: 36 $
* Author of last commit  : $Author: maxscend\yanping.wang $
* Date of last commit    : $Date: 2014-08-14 18:59:01 +0800 $
*

*/


#include "mxd_acrux2_cfg.h"
#include "mxd_acrux2_reg.h"
#include "mxd_acrux2_sdk.h"
//#define __DEBUG_TRACE_REG__

#ifdef __DEBUG_TRACE_REG__
#define rf_reg_write(regAddr,regVal) \
{\
    hal_rcb_write (regAddr,regVal);\
    _DBG_TRACE_REGS_(regAddr,regVal);\
}
#else
#define rf_reg_write _rf_reg_write
//void rf_reg_write(MXD_U32 regAddr, MXD_U32 regVal)
//{
//    hal_rcb_write (regAddr,regVal);
//}
#if 1






#if 0//def __DEBUG_TRACE_REG__
#define hal_rcb_write(r,v)  do { dbg(D_ERR "%d: W 0x%02x 0x%02x\n", __LINE__, r, v); spi_write(r, v); } while (0)
#define hal_rcb_read(r,v)   do { dbg(D_ERR "%d: R 0x%02x 0x%02x\n", __LINE__, r, __spi_read(r, v)); } while (0)
#else
#define __BT 0
#define hal_rcb_write(r,v)  do { uint16_t _vv = v; spi_write(r, _vv); mdelay(0); } while (0)
//#define hal_rcb_write(r,v)  do { uint16_t __vv, _vv = v; spi_write(r, _vv); __vv=__spi_read(r); if(__vv!=_vv)dbg(D_ERR "__0x%04d 0x%04d 0x%04d__\n", r, __vv, _vv);} while (0)
#define hal_rcb_read(r,v)   do { uint16_t _vv; spi_read(r, &_vv); *v = _vv; mdelay(0); } while (0)
#endif
#if 1
#define mxdDbgInfo(...)     do { if (mxd_dbg() & 2) { dbg("%s:%d: ", __BASE_FILE__, __LINE__); }; if (mxd_dbg() & 1) dbg(D_ERR __VA_ARGS__); } while (0)
#define OAL_DebugPrint(...) do { if (mxd_dbg() & 2) { dbg("%s:%d: ", __BASE_FILE__, __LINE__); }; if (mxd_dbg() & 1) dbg(D_ERR __VA_ARGS__); } while (0)
#else
#define mxdDbgInfo(...)     do { } while (0)
#define OAL_DebugPrint(...) do { } while (0)
#endif
#if 0
#define MxdSleep(t)         do { volatile int __cnt = t<<20; while (__cnt--); } while (0)
#else
#define MxdSleep(t)         do { if (mxd_dbg() & 1) dbg(D_ERR "sleep %d\n", t); mdelay(t); } while (0)
#endif




#endif
#endif
/* base rf reg interface */
//041x sunzl add
/*
mem_read_addr:
fmrx gain table: 0x800 ~ 0x81f
wfrx gain table: 0x820 ~ 0x91f
btrx gain table: 0x920 ~ 0x9eb
wftx gain table: 0xa00 ~ 0xa3f
bttx gain table: 0xa40 ~ 0xa5f
*/
/* base rf reg interface */
void _rf_reg_write(MXD_U32 regAddr, MXD_U32 regVal)
{
    hal_rcb_write (regAddr,regVal);
}
void rf_reg_read(MXD_U32 regAddr, MXD_U32 * pRegVal)
{
    //for acrux2 
    if(regAddr < 0x800)
    {    
        hal_rcb_read (regAddr,pRegVal);
        return;
    }
    else
    {
        //OAL_DebugPrint(" mem read: \n " ); 
        hal_rcb_write (0x1c9, regAddr);
        hal_rcb_write (0x1ca, 0x1);        
        if( (regAddr>= 0x800 )&&(regAddr<= 0x81f) ) 
        {    //fmrx
            hal_rcb_read (0x1cf, pRegVal);
        } 
        else if(  (regAddr>= 0x820 )&&(regAddr<= 0x91f)  )
        {   // wfrx 
            hal_rcb_read (0x1cc, pRegVal);
        }
        else if(  (regAddr>= 0x920 )&&(regAddr<= 0x9eb)  )
        {   // btrx  
            hal_rcb_read (0x1ce, pRegVal);
        }
        else if(  (regAddr>= 0xa00 )&&(regAddr<= 0xa3f)  )
        {   // wftx  
            hal_rcb_read (0x1cb, pRegVal);
        }
        else if(  (regAddr>= 0xa40 )&&(regAddr<= 0xa5f)  )
        {   // wfrx 
            hal_rcb_read (0x1cd, pRegVal);
        }
        else
            OAL_DebugPrint("read error !\n");
        return;
    }
}



MXD_U16 regBitsGet(MXD_U16 regAddr,MXD_U8 bitH, MXD_U8 bitL)
{
    MXD_U32 regVal=0;
    if (bitH<bitL)
    {   
        bitH = bitH + bitL;
        bitL = bitH - bitL;
        bitH = bitH - bitL;
    }
    rf_reg_read(regAddr,  &regVal);
    return (0xffff&_BSG(regVal,bitH,bitL));
}
MXD_U32 getRegVal(MXD_U32 regAddr)
{
    MXD_U32 regVal;
    rf_reg_read(regAddr, &regVal);
    return regVal;
}

//sunzl add 0519
void acrux2HostWifiTxInit(void)
{
    int i=0;
    MXD_U32 regMap[]=
    {
        //WIFI Tx Init
        0x0200, 0x019f, // enable wifi ldo, if ldo,bg ana
        0x0201, 0x0003, // enable dab ldo
        0x0202, 0x0555, // ldo cfg   //455->555 //lo 1.3V
        0x0203, 0x0004, // Cal bias enable
        0x0204, 0x0124, // enable rx and tx bias
        0x0205, 0x0008, // fiiter tuning enable
        //WIFI mode control
        0x0400, 0xffff, // host enable
        0x020c, 0x000c, // enable PA
        0x020d, 0x0000, // disable bt rx module
        0x020f, 0x0000, // disable wf rx module
        0x0213, 0x0000, //
        0x0214, 0x0077, // enable tx module GM_mode modu_en
        0x021a, 0x001c, // enable tx lo buf, lo mixer
        // WIFI TX gain control
        0x0216, 0x0000, // TX Gain 0050
        0x0218, 0x0007, // Mod CAS
        0x0215, 0x0012, // LO_bias
        0x0219, 0x1fe7, // Output Cap, NEGM, Mod CCTRL
        0x021d, 0x7971, // PAD CFG1
        0x021e, 0x4454, // PAD CFG2
        0x021f, 0x4c31, // PA CFG1
        0x0220, 0x8070, // PA CFG2
    };

    for (i=0;i<sizeof(regMap)/sizeof(regMap[0])/2;i++)
    {
        rf_reg_write(regMap[2*i], regMap[2*i+1]);
    }
    mxdDbgInfo("acrux2HostWifiTxInit done\n");
}
void acrux2HostWifiRxInit(void)
{
    int i=0;
    MXD_U32 regMap[]=
    {
        //WIFI Init
        0x0200 ,0x008f, // enable wifi ldo, if ldo,bg ana
        0x0201 ,0x0001, // enable dab ldo
        0x0203 ,0x0004, // Cal bias enable
        0x0204 ,0x0024, // enable rx and tx bias
        //WIFI mode control
        0x0400 ,0xffff,    // host enable
        0x020c ,0x0003, // enable LNA and sw
        0x020d ,0x0000, // disable bt rx module
        0x020f ,0x003f,  // enable wf rx module; enable wifi res
        0x0214 ,0x0000, // disable tx module
        0x021a ,0x002c, // enable rx lo buf, lo mixer
        // WIFI gain control
        0x0210 ,0x0007, // wf cas bias
        0x0236 ,0x3ffa, // enable no lap function
        0x0211 ,0x0014, // gm bias/ sw bias
        0x0212 ,0x0004, // lna gain
        0x0213 ,0x0306,  // Mixer PGA gain
        0x0217 ,0x0fcc,  // Gm ctrl Gm ID
        0x021b ,0x91ff,   // lna ctrl and sw bias
        0x021c ,0x6464,  // set lna bias 
        0x0222 ,0x0000,  // lna output cap
    };

    for (i=0;i<sizeof(regMap)/sizeof(regMap[0])/2;i++)
    {
        rf_reg_write(regMap[2*i], regMap[2*i+1]);
    }
    mxdDbgInfo("acrux2HostWifiRxInit done\n");

}
void acrux2HostFmRxInit(void)
{
    int i=0;
    MXD_U32 regMap[]=
    {
        0x0200, 0x003f, // enable wifi ldo, if ldo,bg ana
        0x0201, 0x0001, // enable dab ldo
        0x0204, 0x0024, // enable rx and tx bias
        0x0400, 0xffff,
        0x020a, 0x01e7,
        0x020b, 0x0043,
    };

    for (i=0;i<sizeof(regMap)/sizeof(regMap[0])/2;i++)
    {
        rf_reg_write(regMap[2*i], regMap[2*i+1]);
    }
    mxdDbgInfo("acrux2HostWifiRxInit done\n");

}

void acrux2HostBtTxInit(void)
{
    MXD_U32 i=0;
    MXD_U32 regMap[]=
    {// wyp Jun 06, 2014
        0x0200, 0x004f, // enable wifi ldo, if ldo,bg ana
        0x0201, 0x0003, // enable dab ldo
        0x0202, 0x0755, // ldo cfg
        0x0203, 0x0004, // Cal bias enable
        0x0204, 0x0024, // enable rx and tx bias

        0x0400, 0xf3ff, // host enable
        0x020c, 0x000C, // enable PA
        0x020d, 0x0000, // disable bt rx module
        0x020f, 0x0000, // disable wf rx module
        0x0213, 0x0000, //
        0x0214, 0x201f, // enable tx module GM_mode modu_en 201f 017f
        0x021a, 0x001e, // enable tx lo buf, lo mixer

        0x0216, 0x0058, // TX Gain
        0x0218, 0x0007, // Mod CAS
        0x0215, 0x0012, // LO_bias
        0x0219, 0x1fe7, // Output Cap, NEGM, Mod CCTRL

        0x021d, 0x7971, // PAD CFG1
        0x021e, 0xa454, // PAD CFG2
        0x021f, 0x9c31, // PA CFG1
        0x0220, 0x2ca8, // PA CFG2
    };
    for (i=0;i<sizeof(regMap)/sizeof(regMap[0])/2;i++)
    {
        rf_reg_write(regMap[2*i], regMap[2*i+1]);
    }
}

void acrux2HostBtRxInit(void)
{
    MXD_U32 i=0;
    MXD_U32 indexMap[]= // map control of reg0x0534
    {
        // wyp Jun 06, 2014
        0x0200,0x004f, // enable wifi ldo, if ldo,bg ana
        0x0201,0x0001, // enable dab ldo
        0x0203,0x0004, // Cal bias enable
        0x0204,0x0024, // enable rx and tx bias
        //,0x mod,e control
        0x0400,0xffff,    // host enable
        0x020c,0x0003, // enable LNA and sw
        0x020d,0x000f, // disable bt rx module
        0x020f,0x0000,  // enable wf rx module
        0x0214,0x0000, // disable tx module
        // ,0xI ga,in control
        0x0210,0x0010,
        0x0211,0x0020, // gm bias
        0x0212,0x0004, // lna gain
        0x0213,0xb00a,  // Mixer PGA gain
        0x0217,0x0c40,  // Gm ID
        0x021a,0x000d,
        0x021b,0x91ff,   // lna ctrl and sw bias
        0x021c,0x6464,  // set lna bias 
        0x0222,0x0000,  // lna output cap
        //0x019d,0x0002,    // wyp Jun 23, 2014
        0x0236,0x3ff5,
    };
    //_REGBSS(RF_LOPATH_CFG_reg, _BIT2, _BIT0, 0x5);
    for(i= 0 ; i < sizeof(indexMap)/sizeof(indexMap[0]); i+=2)
    {
        rf_reg_write(indexMap[i], indexMap[i+1]);
    }

    mxdDbgInfo("[mxd test]acrux2HostBtRxInit done!\n");
}

void acrux2BtTxGainTbl(void)
{
    int i=0;
    for(i= 0 ; i < sizeof(BtTxGainTbl)/sizeof(BtTxGainTbl[0]); i+=2)
    {
        rf_reg_write(BtTxGainTbl[i], BtTxGainTbl[i+1]);
    }
    mxdDbgInfo("[mxd]acrux2HostBtTxGainInit done!\n");
}

void acrux2BtRxGainTbl()
{
    int forId=0;
    for(forId= 0 ; forId < sizeof(BtRxGainTbl)/sizeof(BtRxGainTbl[0]); forId+=2)
    {
        rf_reg_write(BtRxGainTbl[forId], BtRxGainTbl[forId+1]);
    }

    mxdDbgInfo("[mxd]acrux2BtRxGainTbl done!\n");
}
void acrux2WifiRxGainTbl()
{
    int forId=0;
    for(forId= 0 ; forId < sizeof(WifiRxGainTbl)/sizeof(WifiRxGainTbl[0]); forId+=2)
    {
        rf_reg_write(WifiRxGainTbl[forId], WifiRxGainTbl[forId+1]);
    }

    mxdDbgInfo("[mxd]acrux2BtRxGainTbl done!\n");
}
void acrux2FmRxGainTbl()
{
    int forId=0;
    for(forId= 0 ; forId < sizeof(FmTxGainTbl)/sizeof(FmTxGainTbl[0]); forId+=2)
    {
        rf_reg_write(FmTxGainTbl[forId], FmTxGainTbl[forId+1]);
    }
    mxdDbgInfo("[mxd]acrux2BtRxGainTbl done!\n");
}
void acrux2WifiTxGainTbl()
{
    int forId=0;
    for(forId= 0 ; forId < sizeof(WifiTxGainTbl)/sizeof(WifiTxGainTbl[0]); forId+=2)
    {
        rf_reg_write(WifiTxGainTbl[forId], WifiTxGainTbl[forId+1]);
    }

    mxdDbgInfo("[mxd]acrux2BtRxGainTbl done!\n");
}
void acrux2LoInit(void)
{
    MXD_U32 i=0,temp=0;
    MXD_U32 btTableIdx = 0x010A;
    MXD_U32 regAfcVal = 0;
    MXD_U32 regVal=0;
    MXD_U32 tblLoAfc[96] ={0,};

    rf_reg_write(0x400,0x0001);
    rf_reg_write(0x604,0x7FFF);
    rf_reg_write(0x07e,0x0001);
    rf_reg_write(0x085,0x0037);
    rf_reg_write(0x22e,0x0210);
    rf_reg_write(0x22f,0x0210);
    rf_reg_write(0x600,0x3FFF);
    rf_reg_write(0x601,0x007F);
    //rf_reg_write(0x200,0x00E1);
    _REGBS(0x200, _BIT7);   // wyp May 29, 2014
    _REGBS(0x200, _BIT6);
    _REGBS(0x200, _BIT5);
    _REGBS(0x200, _BIT0);
    rf_reg_write(0x201,0x0201);
    //rf_reg_write(0x201,0x0200);       //sunzl 200->201
    rf_reg_write(0x239,0x0096);
    rf_reg_write(0x23a,0x0027);
    rf_reg_write(0x07f,0x0003);
    rf_reg_write(0x082,0x0000);
    rf_reg_write(0x081,0x1B00);

    rf_reg_read(0x084, &regVal);
    if(1 == (regVal&1))
        mxdDbgInfo("[mxd]78M PLL lock success!\n");
    else
    {
        mxdDbgInfo("[mxd]78M PLL lock fail!\n");
        return ;
    }

    //rf_reg_write(0x201,0x0001);
    rf_reg_write(0x236,0x3FF3);
    rf_reg_write(0x230,0x00FA);
    rf_reg_write(0x231,0x00FA);
    rf_reg_write(0x232,0x00FA);
    rf_reg_write(0x233,0x00B2);
    rf_reg_write(0x234,0x00B2);
    rf_reg_write(0x235,0x00B2);
    rf_reg_write(0x22d,0xFAA5);

    //_REGBS(0x201,_BIT9);      //0x201[9]: 78MHz PLL enable

#ifdef _THREE_SECTION_TBL_
    rf_reg_write(rfmux_wfrx_lna_map_mode,1);    // 3 entry mode
#else
    rf_reg_write(rfmux_wfrx_lna_map_mode,0);    // 32 entry mode
#endif

#ifndef ACRUXII_SET_FREQ_AFC_MODE_// wyp Jun 24, 2014  old afc mode Set Freq
    MxdSleep(1);
    acrux2SetBtFreqInit();
#endif
}
void acrux2BwTRxTblCfg(void)
{
    int i=0;
    MXD_U32 regMap[]=
    {
        0x0432 ,0x0000, //e0w0 idle
        0x0433 ,0x0000, //e0w1 idle
        0x0434 ,0x0000, //e0w2 idle
        0x0435 ,0x0000, //e0w3 idle
        0x0436 ,0xfe09, //e1w0 wfrx
        0x0437 ,0x0001, //e1w1 wfrx
        0x0438 ,0xc806, //e1w2 wfrx
        0x0439 ,0x0323, //e1w3 wfrx
        0x043a ,0x81f9, //e2w0 btrx
        0x043b ,0x0001, //e2w1 btrx
        0x043c ,0xd006, //e2w2 btrx
        0x043d ,0x02d3, //e2w3 btrx
        0x043e ,0x0001, //e3w0 wftx
        0x043f ,0x0031, //e3w1 wftx 0031
        0x0440 ,0xcdfe, //e3w2 wftx cdfe
        0x0441 ,0x048b, //e3w3 wftx //487
        0x0442 ,0x0001, //e4w0 bttx
        0x0443 ,0x01a9, //e4w1 bttx
        0x0444 ,0xd1fe, //e4w2 bttx
        0x0445 ,0x0407, //e4w3 bttx //40b
    };
    for (i=0;i<sizeof(regMap)/sizeof(regMap[0])/2;i++)
    {
        rf_reg_write(regMap[2*i], regMap[2*i+1]);
    } 

}

void acrux2DbgGetRfInfo(MXD_U32 flag)
{
    MXD_U32 regAddr,/*i,*/all,allq,alli;
    MXD_U16 BitI,BitQ[2],lpfi,lpfq;
#if 0 //Br Rx doco
    for(regAddr=0x9e0;regAddr<=0x9eb;regAddr+=2)
    {
        BitI= regBitsGet(regAddr,_BIT10,_BIT3);
        BitQ[0] = regBitsGet(regAddr,_BIT15,_BIT11);
        BitQ[1] = regBitsGet(regAddr+1,_BIT2,_BIT0);
        all = BitQ[0] |BitQ[1]<<5;
        mxdDbgInfo("DbgInfo:BtRx Dcoc I:0x%04x:0x%04x      Q:0x%04x:0x%04x\n",regAddr,BitI,regAddr+1,all);
    }
#endif  
    //wifi dcoc pga
    for(regAddr=0x8e0;regAddr<=0x91f;regAddr+=2)
    {
        BitI= regBitsGet(regAddr,_BIT12,_BIT6);
        BitQ[0] = regBitsGet(regAddr,_BIT15,_BIT13);
        BitQ[1] = regBitsGet(regAddr+1,_BIT3,_BIT0);
        all = BitQ[0] |BitQ[1]<<3;
        mxdDbgInfo("DbgInfo:wifi pga Dcoc I:0x%04x:0x%04x      Q:0x%04x:0x%04x\n",regAddr,BitI,regAddr+1,all);
    }
    //wifi dcoc tia
    for(regAddr=0x820;regAddr<=0x8df;regAddr+=4)
    {
        lpfi= regBitsGet(regAddr+1,_BIT2,_BIT0);
        lpfq= regBitsGet(regAddr+1,_BIT5,_BIT3);

        BitI= regBitsGet(regAddr+1,_BIT11,_BIT6);
        BitQ[0] = regBitsGet(regAddr+1,_BIT15,_BIT12);
        BitQ[1] = regBitsGet(regAddr+2,_BIT1,_BIT0);

        allq = (lpfq<<6) | (BitQ[0] |BitQ[1]<<4);
        alli = (lpfi <<6)| BitI;
        mxdDbgInfo("DbgInfo:wifi tia Dcoc I:0x%04x:0x%04x      Q:0x%04x:0x%04x\n",regAddr+1,alli,regAddr+2,allq);
    }

}

void acrux2DbgGetRegInfo(void)
{
    MXD_U32 i = 0,regVal=0;
    for(i=0x0;i<=0xa50;i++)
    {
        mxdDbgInfo("%x  %x\n",i,getRegVal(i));
    }
}

void acrux2FdInit(void)
{
    // wyp May 30, 2014
    MXD_U32 i = 0,regVal=0;

    _REGBS(rfmux_LDO_EN_CFG1_reg, _BIT0);   //BG_ANA_EN
    _REGBS(rfmux_LDO_EN_CFG1_reg, _BIT3);   //LDO_IF_EN
    _REGBS(RF_LDO_EN_CFG2_reg, _BIT0);      //LDO_DAB_EN
    _REGBS(RF_BIAS_CTRL1_reg, _BIT2);       //CAL_BIAS_EN 
    _REGBS(RF_CAL_PATH1_reg, _BIT2);        //Filter Tuning Enable 
    _REGBS(fd_tune_sel, _BIT0);             // use tuning result

    _REGBC(ctrl_soft_reset_reg, _BIT9); //  Reset FD 0x0000
    _REGBS(ctrl_soft_reset_reg, _BIT9);
    _REG_CHK(ctrl_tuner_status_reg, _BIT0); //Check FD tune finish sync

    for(i=fd_btrx_status_reg; i<=fd_wifirx_status_reg; i++)      //0331
    {
        rf_reg_read(i, &regVal);
        mxdDbgInfo("[mxd][acrux2FdInit] result:: reg0x%x =0x%x\n",i,regVal);
    }
}

MXD_U32 acrux2WifiImbGetStd(MXD_U32 STDAvgTime)
{
    MXD_U16 ii;
    MXD_U32 mxd_value=0;
    for(ii = 0; ii< STDAvgTime; ii++)
    {
        _REGBS(std_std_pulse_reg,_BIT0);// start std
        _REG_CHK(ctrl_tuner_status_reg, _BIT1);
        mxd_value += getRegVal(std_std_mag_status);
    }
    mxd_value = mxd_value/STDAvgTime;
    return mxd_value;
}
int acrux2WifiImbGetDc(MXD_U32 STDAvgTime)
{
    MXD_U16 ii;
    int mxd_value=0;
    for(ii = 0; ii< STDAvgTime; ii++)
    {
        _REGBS(std_std_pulse_reg,_BIT0);// start std
        _REG_CHK(ctrl_tuner_status_reg, _BIT1);
        mxd_value += getRegVal(std_std_real_status);
    }
    mxd_value = mxd_value/STDAvgTime;
    return mxd_value>=32768?(mxd_value-65536):mxd_value;
}

MXD_API_C MXD_U32 acrux2ClbrTxImbWifi(void)
{   
    MXD_U16 H8=0,L8=0;
    MXD_U32 txCalTbl=0x4a2;
    MXD_U32 gidx,wfTxTblAddrBgn=0xa00,calId,Id=0xffff,pdetGain=0;
    MXD_U32 CalGidx[] = {0x02,0x04,0x0b,0x00c};
    MXD_U32 i=0;
#if 1   //  loft cfg
    MXD_U32 cfgMap[]=
    {
        // pll clock
        0x0602 ,0x008D, // forcre clk_txp_da/clk_txp_ad to 26MHz
        0x0204 ,0x0124,     //[8]=1,
        0x0214 ,0x2077,     //[13]=1,[7]=0
        0x0039 ,0x0008,
        0x0400 ,0xfc3f,     //[7]=0,[0]=1
        0x0203 ,0x0004,
        0x0200 ,0x019F,     //[4]=1'b1;[8]=1 !
        0x020A ,0x0021,     //[5]=1'b1,[0]=1'b1
        0x0058 ,0x0002,     //
        0x041d ,0x0010,  //mode_sel[1:0]=2'b10,wftx del !!!!!!!
        0x01b2 ,0x0003, //[2]=0,data from adc,[0]=1,loft enable
        0x01b5 ,0x0f89 ,//0xfe2, 500K//0x0f89, 1M //loft STD cos
        0x01b6 ,0x03d4 ,//0x1ee,//0x03d4, //loft STD sin
        0x01b7 ,0x001f, //std 7,rpt 3
        0x01b8 ,0x0200,
        0x01b9 ,0x0820, //rng-I:20 rng-Q:20
    };

    acrux2HostWifiTxInit();
    _REGBSS(RF_LOPATH_CFG_reg, _BIT3, _BIT0, 0xa);
    _REGBS(rfmux_LDO_EN_CFG1_reg, _BIT7);   //En WiFi_LO LDO
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT6);
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT5);
    acrux2SetFreqChWifi(1);
    acrux2TxEnableNco(_FLAG_FREQ_1M);
    acrux2TxEnableStd(_FLAG_FREQ_1M);

    _REGBS(RF_LDO_EN_CFG2_reg, _BIT9);
    _REGBS(txp_txp_scale_ctrl_reg, _BIT0);
    _REGBS(RF_CAL_PATH1_reg, _BIT3);
    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT5, _BIT4, 0x2);   //10 Tx,01Rx

    for (i=0;i<sizeof(cfgMap)/sizeof(cfgMap[0])/2;i++)
    {
        rf_reg_write(cfgMap[2*i], cfgMap[2*i+1]);
    } 
    //Acrux2pdetCfg(1);
    rf_reg_write(rfmux_host_en_reg, 0xff3f); 
    _REGBC(rfmux_host_en_reg, _BIT9);
    _REGBS(rfmux_host_en_reg,_BIT8);
#endif
    _REGBS(txcal_txcal_para_set,_BIT3); //rfimb_en
    _REGBC(txcal_txcal_para_set,_BIT0); 
    _REGBS(rfmux_host_en_reg,_BIT9);

    acrux2TxEnableStd(_FLAG_FREQ_2M);
    /*for(pdetGain =0; pdetGain<=7; pdetGain++)
      _REGBSS(0x4a3+pdetGain*4, _BIT4,_BIT3,1);
      */
#if 1
    for(gidx =0 ; gidx<sizeof(CalGidx)/sizeof(CalGidx[0]); gidx++)
    {
        calId = regBitsGet(wfTxTblAddrBgn+CalGidx[gidx]*2+1, _BIT7, _BIT3);//get cal id
        Id = calId;
        switch(CalGidx[gidx])
        {
            case 2:
                rf_reg_write(txp_txp_scale_factor_reg,0x008);
                calId = 8;
                break;  
            case 4:
                rf_reg_write(txp_txp_scale_factor_reg,0x008);
                calId = 9;
                break;
            case 0x0b:
                rf_reg_write(txp_txp_scale_factor_reg,0x006);
                calId = 10;
                break;
            case 0x0c:
                rf_reg_write(txp_txp_scale_factor_reg,0x002);
                calId = 11;
                break;
        }
        _WfImbInfo("%d\n",getRegVal(txp_txp_scale_factor_reg));

        _REGBSS(txcal_txcal_rfimb_par_set,_BIT4,_BIT0,CalGidx[gidx]);
        //      acrux2ClbrAutoSetPdetGain(calId);
        acrux2ClbrTxImbSearch(&H8,&L8);
        _REGBSS(txCalTbl+calId*4+3,_BIT12,_BIT5,L8);
        _REGBSS(txCalTbl+calId*4+2,_BIT15,_BIT13,H8&0x7);
        _REGBSS(txCalTbl+calId*4+3,_BIT4,_BIT0,H8>>_BIT3);
        _WfImbInfo("calId:%d,%x,%x,%x,%x\n",calId,txCalTbl+calId*4+3,L8,H8&0x7,H8>>_BIT3);

        mxdDbgInfo("[0x223,0x%04x],[0x1be,0x%04x],TxCalId,%d\n",getRegVal(0x223),getRegVal(0x1be),Id);

    }

#else
    for(gidx =0 ; gidx<sizeof(CalGidx)/sizeof(CalGidx[0]); gidx++)
    {
        calId = regBitsGet(wfTxTblAddrBgn+CalGidx[gidx]*2+1, _BIT7, _BIT3);//get cal id
        Id = calId;
        switch(CalGidx[gidx])
        {
            case 0x006:
                //_REGBSS(0x4a3+6*4, _BIT4,_BIT3,0);//set cal gain pdet
                rf_reg_write(txp_txp_scale_factor_reg,0x006);
                calId = 8;
                break;  
            case 0x00c:
                rf_reg_write(txp_txp_scale_factor_reg,0x008);
                calId = 9;
                break;
            case 0x011:
                rf_reg_write(txp_txp_scale_factor_reg,0x008);
                calId = 10;
                break;
            case 0x017:
                rf_reg_write(txp_txp_scale_factor_reg,0x002);
                calId = 11;
                break;
        }
        _WfImbInfo("%d\n",getRegVal(txp_txp_scale_factor_reg));

        _REGBSS(txcal_txcal_rfimb_par_set,_BIT4,_BIT0,CalGidx[gidx]);
        //      acrux2ClbrAutoSetPdetGain(calId);
        acrux2ClbrTxImbSearch(&H8,&L8);
        _REGBSS(txCalTbl+calId*4+3,_BIT12,_BIT5,L8);
        _REGBSS(txCalTbl+calId*4+2,_BIT15,_BIT13,H8&0x7);
        _REGBSS(txCalTbl+calId*4+3,_BIT4,_BIT0,H8>>_BIT3);
        _WfImbInfo("calId:%d,%x,%x,%x,%x\n",calId,txCalTbl+calId*4+3,L8,H8&0x7,H8>>_BIT3);

        mxdDbgInfo("[0x223,0x%04x],[0x1be,0x%04x],TxCalId,%d\n",getRegVal(0x223),getRegVal(0x1be),Id);

    }
#endif
    _REGBC(rfmux_host_en_reg, _BIT9);
    _REGBC(txcal_txcal_para_set,_BIT3); //rfimb_en
    rf_reg_write(txp_txp_scale_factor_reg,0x08);

    mxdDbgInfo("[mxd]acrux2ClbrTxImbWifi done\n");

    return 0;
}
void acrux2ClbrTxImbSearch(MXD_U16 *H8,MXD_U16 *L8)
{
    MXD_U32 reg_value_H8=0 ,reg_value_L8=0 ,STD_avg_time=0,search_time=0,ii=2,imb_left_reg=0,imb_right_reg=0;
    MXD_U32 MID1_reg=0,MID2_reg=0,imb_L_left_value=0,imb_L_right_value=0,imb_L_MID1_value=0,imb_L_MID2_value=0,
        reg_value_L8_temp_reg_1=0,reg_value_L8_temp_value_1=0,reg_value_L8_temp_reg_2=0,reg_value_L8_temp_value_2=0,
        reg_value_H8_temp_reg_1=0,reg_value_H8_temp_value_1=0,reg_value_H8_temp_reg_2=0,
        reg_value_H8_temp_value_2=0,finalValQ[2]={0},finalRegQ[2]={0},finalValI[2]={0},finalRegI[2]={0};
    //return 0;
    search_time = 2;
    STD_avg_time = 3;
    reg_value_H8 = 128;
    reg_value_L8 = 128;
    rf_reg_write(rfmux_IMB_CFG1_reg, 0x8080); //init

    for (ii = 0 ; ii< search_time; ii++) 
    {
        //cal Q:00~7f
        imb_left_reg = 0;
        imb_right_reg = 127;
        do
        {
            MID1_reg =(imb_left_reg + imb_right_reg)/2;
            MID2_reg = (MID1_reg + imb_right_reg)/2;

            _WfImbInfo("start Q_00_7f:imb_left_reg = %d     MID1_reg = %d     MID2_reg = %d     imb_right_reg = %d\n",
                    imb_left_reg,MID1_reg,MID2_reg,imb_right_reg);

            reg_value_L8 = imb_left_reg;//% get f(L)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT7,_BIT0,reg_value_L8);
            imb_L_left_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = imb_right_reg;//% get f(R)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT7,_BIT0,reg_value_L8);
            imb_L_right_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = MID1_reg;//% get f(MID1)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT7,_BIT0,reg_value_L8);
            imb_L_MID1_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = MID2_reg;//% get f(MID2)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT7,_BIT0,reg_value_L8);
            imb_L_MID2_value = acrux2WifiImbGetStd(3);

            _WfImbInfo("end Q_00_7f:imb_left_reg = %d     MID1_reg = %d     MID2_reg = %d     imb_right_reg = %d\n",
                    imb_left_reg,MID1_reg,MID2_reg,imb_right_reg);

            _WfImbInfo("imb_L_left_value = %d     imb_L_MID1_value = %d     imb_L_MID2_value = %d     imb_L_right_value = %d\n\n",
                    imb_L_left_value,imb_L_MID1_value,imb_L_MID2_value,imb_L_right_value);

            if( imb_L_MID1_value<imb_L_MID2_value)
            {
                imb_right_reg = MID2_reg;
                reg_value_L8_temp_reg_1 = MID1_reg;
                reg_value_L8_temp_value_1 = imb_L_MID1_value;
            }
            else
            {
                imb_left_reg = MID1_reg;
                reg_value_L8_temp_reg_1 = MID2_reg;
                reg_value_L8_temp_value_1 = imb_L_MID2_value;
            }
        }while(_ABS(MID1_reg-MID2_reg)>2);

        //%% cal Q:80~ff
        imb_left_reg = 128;
        imb_right_reg = 255;
        do
        {
            MID1_reg =(imb_left_reg + imb_right_reg)/2;
            MID2_reg = (MID1_reg + imb_right_reg)/2;

            _WfImbInfo("start Q_80_ff:imb_left_reg = %d     MID1_reg = %d     MID2_reg = %d     imb_right_reg = %d\n",
                    imb_left_reg,MID1_reg,(MID2_reg),imb_right_reg);

            reg_value_L8 = imb_left_reg;//% get f(L)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT7,_BIT0,reg_value_L8);
            imb_L_left_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = imb_right_reg;//% get f(R)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT7,_BIT0,reg_value_L8);
            imb_L_right_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = MID1_reg;//% get f(MID1)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT7,_BIT0,reg_value_L8);
            imb_L_MID1_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = MID2_reg;//% get f(MID2)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT7,_BIT0,reg_value_L8);
            imb_L_MID2_value = acrux2WifiImbGetStd(3);
            _WfImbInfo("end Q_80_ff:imb_left_reg = %d     MID1_reg = %d     MID2_reg = %d     imb_right_reg = %d\n",
                    imb_left_reg,MID1_reg,(MID2_reg),imb_right_reg);

            _WfImbInfo("imb_L_left_value = %d     imb_L_MID1_value = %d     imb_L_MID2_value = %d     imb_L_right_value = %d\n\n",
                    imb_L_left_value,imb_L_MID1_value,imb_L_MID2_value,imb_L_right_value);

            if( imb_L_MID1_value<imb_L_MID2_value)
            {
                imb_right_reg = MID2_reg;
                reg_value_L8_temp_reg_2 = MID1_reg;
                reg_value_L8_temp_value_2 = imb_L_MID1_value;
            }
            else
            {
                imb_left_reg = MID1_reg;
                reg_value_L8_temp_reg_2 = MID2_reg;
                reg_value_L8_temp_value_2 = imb_L_MID2_value;
            }
        }while(_ABS(MID1_reg-MID2_reg)>2);
        //set reg_value_L8 
        if (reg_value_L8_temp_value_1<reg_value_L8_temp_value_2)
        {
            reg_value_L8 = reg_value_L8_temp_reg_1;
            finalValQ[ii] = reg_value_L8_temp_value_1;
        }
        else
        {
            reg_value_L8 = reg_value_L8_temp_reg_2;
            finalValQ[ii] = reg_value_L8_temp_value_2;
        }
        finalRegQ[ii] = reg_value_L8;

        if(1==ii)// Finally a comparison //num1 < num2 ?
            (finalValQ[0] < finalValQ[1]) ? (reg_value_L8 = finalRegQ[0]) : (reg_value_L8 = finalRegQ[1]);

        _REGBSS(rfmux_IMB_CFG1_reg, _BIT7,_BIT0,reg_value_L8);
        *L8 = reg_value_L8;
        _WfImbInfo("the Q's best value is 0x%04x,%d,[0x223,0x%04x]\n ",reg_value_L8,reg_value_L8,getRegVal(0x223));

        //cal I:00~7f

        imb_left_reg = 0;
        imb_right_reg = 127;
        do
        {
            MID1_reg =(imb_left_reg + imb_right_reg)/2;
            MID2_reg = (MID1_reg + imb_right_reg)/2;

            _WfImbInfo("I_00_7f:imb_left_reg = %d     MID1_reg = %d     MID2_reg = %d     imb_H_right_reg = %d\n",
                    imb_left_reg,MID1_reg,(MID2_reg),(imb_right_reg));

            reg_value_L8 = imb_left_reg;//% get f(L)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT15,_BIT8,reg_value_L8);
            imb_L_left_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = imb_right_reg;//% get f(R)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT15,_BIT8,reg_value_L8);
            imb_L_right_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = MID1_reg;//% get f(MID1)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT15,_BIT8,reg_value_L8);
            imb_L_MID1_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = MID2_reg;//% get f(MID2)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT15,_BIT8,reg_value_L8);
            imb_L_MID2_value = acrux2WifiImbGetStd(3);
            _WfImbInfo("start I_00_7f:imb_left_reg = %d     MID1_reg = %d     MID2_reg = %d     imb_H_right_reg = %d\n",
                    imb_left_reg,MID1_reg,(MID2_reg),(imb_right_reg));

            _WfImbInfo("end imb_L_left_value = %d     imb_L_MID1_value = %d     imb_L_MID2_value = %d     imb_L_right_value = %d\n\n",
                    imb_L_left_value,imb_L_MID1_value,imb_L_MID2_value,imb_L_right_value);

            if( imb_L_MID1_value<imb_L_MID2_value)
            {
                imb_right_reg = MID2_reg;
                reg_value_H8_temp_reg_1 = MID1_reg;
                reg_value_H8_temp_value_1 = imb_L_MID1_value;
            }
            else
            {
                imb_left_reg = MID1_reg;
                reg_value_H8_temp_reg_1 = MID2_reg;
                reg_value_H8_temp_value_1 = imb_L_MID2_value;
            }
        }while(_ABS(MID1_reg-MID2_reg)>2);

        //%% cal I:80~ff
        imb_left_reg = 128;
        imb_right_reg = 255;
        do
        {
            MID1_reg =(imb_left_reg + imb_right_reg)/2;
            MID2_reg = (MID1_reg + imb_right_reg)/2;

            _WfImbInfo("start Q_80_ff:imb_left_reg = %d     MID1_reg = %d     MID2_reg = %d     imb_L_right_reg = %d\n",
                    (imb_left_reg),(MID1_reg),(MID2_reg),(imb_right_reg));

            reg_value_L8 = imb_left_reg;//% get f(L)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT15,_BIT8,reg_value_L8);
            imb_L_left_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = imb_right_reg;//% get f(R)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT15,_BIT8,reg_value_L8);
            imb_L_right_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = MID1_reg;//% get f(MID1)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT15,_BIT8,reg_value_L8);
            imb_L_MID1_value = acrux2WifiImbGetStd(3);

            reg_value_L8 = MID2_reg;//% get f(MID2)
            _REGBSS(rfmux_IMB_CFG1_reg, _BIT15,_BIT8,reg_value_L8);
            imb_L_MID2_value = acrux2WifiImbGetStd(3);
            _WfImbInfo("end Q_80_ff:imb_left_reg = %d     MID1_reg = %d     MID2_reg = %d     imb_L_right_reg = %d\n",
                    (imb_left_reg),(MID1_reg),(MID2_reg),(imb_right_reg));

            _WfImbInfo("imb_L_left_value = %d     imb_L_MID1_value = %d     imb_L_MID2_value = %d     imb_L_right_value = %d\n\n",
                    imb_L_left_value,imb_L_MID1_value,imb_L_MID2_value,imb_L_right_value);

            if( imb_L_MID1_value<imb_L_MID2_value)
            {
                imb_right_reg = MID2_reg;
                reg_value_L8_temp_reg_2 = MID1_reg;
                reg_value_L8_temp_value_2 = imb_L_MID1_value;
            }
            else
            {
                imb_left_reg = MID1_reg;
                reg_value_H8_temp_reg_2 = MID2_reg;
                reg_value_H8_temp_value_2 = imb_L_MID2_value;
            }
        }while(_ABS(MID1_reg-MID2_reg)>2);
        //set reg_value_H8 
        if (reg_value_H8_temp_value_1<reg_value_L8_temp_value_2)
        {
            reg_value_H8 = reg_value_L8_temp_reg_1;
            finalValI[ii] = reg_value_H8_temp_value_1;

        }
        else
        {
            reg_value_H8 = reg_value_L8_temp_reg_2;
            finalValI[ii] = reg_value_L8_temp_value_2;
        }
        finalRegI[ii] = reg_value_H8;
        if(1==ii)// Finally a comparison //num1 < num2 ?
            (finalValI[0] < finalValI[1]) ? (reg_value_L8 = finalRegI[0]) : (reg_value_L8 = finalRegI[1]);

        _REGBSS(rfmux_IMB_CFG1_reg, _BIT15,_BIT8,reg_value_H8);
        *H8 = reg_value_H8;
        _WfImbInfo("the I's best value is 0x%04x,%d[0x223,0x%04x]\n ",reg_value_H8,reg_value_H8,getRegVal(0x223));
    }

}



MXD_API_C MXD_U32 acrux2ClbrTxImbBt()
{
    MXD_U32 regVal=0,btTxgainAddrbgn=0xa40,calId=0,id=0xffff;           
    MXD_U16 gainIdx=0,MODU_TXIMB=0,TxCalTblStart = 0x04ce,TxCalTblEnd = 0x04e2,H8=0,L8=0;
    MXD_U32 i=0,j=0;
    /**********RF init config*************/
    acrux2HostBtTxInit();
    acrux2SetFreqMhzBt(2400);    //set freq

    rf_reg_write(rfmux_LDO_EN_CFG1_reg, 0x015F);    //[6]=1'b1;[8]=1 ![4]=1???
    rf_reg_write(RF_LDO_EN_CFG2_reg ,0x0203); // 0x201@
    _REGBS(rfmux_BIAS_CTRL2_reg, _BIT8);
    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT3, _BIT2, 0x3);   //
    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT5, _BIT4, 0x2);   //
    _REGBSS(rfmux_mode_table_bt_wifi_ctrl_reg, _BIT4, _BIT1, 0x5);  //
    rf_reg_write(RF_FM_CFG_reg, 0x0021);    //[5]=1'b1,[0]=1'b1
    rf_reg_write(RF_CAL_PATH1_reg,  0x000c);
    rf_reg_write(ctrl_clk_sel_26m_reg ,0x008d); // 0x602
    /**********RF init config*************/
    acrux2TxEnableNco(_FLAG_FREQ_1M);   //NCO 500K
    acrux2TxEnableStd(_FLAG_FREQ_2M);       //std 1M

    _REGBS(txcal_txcal_para_set,_BIT3);     //rfimb_en
    _REGBS(rfmux_host_en_reg,_BIT13);   //
    for(i=9; i<=0x9; i++)
    {
        calId = regBitsGet(btTxgainAddrbgn+i*2+1, _BIT7, _BIT3);//get cal id
        if(calId == id) 
            continue; 
        id = calId;
        _REGBSS(txcal_txcal_rfimb_par_set,_BIT8,_BIT5,i);
        //  acrux2ClbrAutoSetPdetGain(calId);
        acrux2ClbrTxImbSearch(&H8,&L8);
        for(j=0; j<=4; j++)
        {
            _REGBSS(rfmux_tx_cal_tbl_e0w0_reg+calId*4+3-j*4,_BIT12,_BIT5,H8);
            _REGBSS(rfmux_tx_cal_tbl_e0w0_reg+calId*4+2-j*4,_BIT15,_BIT13,L8&0x7);
            _REGBSS(rfmux_tx_cal_tbl_e0w0_reg+calId*4+3-j*4,_BIT4,_BIT0,L8>>_BIT3);
        }
        mxdDbgInfo("acrux2ClbrTxImbBt %x\n",(H8<<8|L8));
    }
    _REGBC(txcal_txcal_para_set,_BIT3);     //rfimb_dis

    rf_reg_write(txp_txp_scale_factor_reg,0x008);
    return 0;
}


int  acrux2ComInit(void)
{
    rf_reg_write(ctrl_soft_reset_reg , 0x0000);//sunzl 0529
    rf_reg_write(ctrl_soft_reset_reg, 0xffff);// soft reset
    acrux2BwTRxTblCfg();
#if __BT
    acrux2BtTxGainTbl();
    acrux2BtRxGainTbl();
#endif
    acrux2WifiRxGainTbl();  
    acrux2WifiTxGainTbl();
#if __BT
    acrux2FmRxGainTbl();
#endif
    acrux2LoInit();
    rf_reg_write(txp_txp_scale_ctrl_reg ,0x0001); // 
    rf_reg_write(txp_txp_scale_factor_reg ,0x0008); // 
    return 0;
}

MXD_API_C void  acrux2WorkInit(void)
{
    int i=0;
    MXD_U32 regVal=0,idLna=0,idPa=0;
    MXD_U32 regMap[]=
    {//
        0x400,  0x0000,     //close host
        0x401,  0x0000,     //open mxd
        0x1b2,  0x0000,     //disable tx Imb/loft
        0x402,  0x3210,
        0x430,  0x3210,
        0x431,  0x7654,
        0x407,  0x0000,
        0x200,  0x01ff,     //ldo
        0x236,  0x3fff,     //rf_reg_write(0x236,0x3FF3);
        0x02d,  0x0000,     //disable NCO   //en 0x24f
        // wyp Jul 08, 2014 @szl junliu
        0x0215, 0x0013, //// wyp Jul 16, 2014 @11N_40M

        0x201,  0x0203,
        0x202,  0x0555,
        0x205,  0x0004,
        0x20a,  0x0000,
        0x408,  0x0000,
        0x409,  0x0000,
    };
    for (i=0;i<sizeof(regMap)/sizeof(regMap[0])/2;i++)
    {
        rf_reg_write(regMap[2*i], regMap[2*i+1]);
    }
    acrux2TxDisableNco();
    //_REGBSS(rfmux_LDO_EN_CFG1_reg,_BIT7,_BIT4,0x0000);
    mxdDbgInfo("[mxd]acrux2WorkInit... !\n");
}

// wyp Jun 09, 2014 Arithmetic progression
//example: func(ch15,ch16,(2508-2380-1),2412-2380,&Dcoc);
void acrux2DcocArithmetic(MXD_U32 minV,MXD_U32 maxV, MXD_U32 sumX, MXD_U32 xn, PMXD_U32 pDcoc)
{
    *pDcoc =((( 2*minV*sumX ) + ( 2*xn*(maxV-minV))+sumX)/(2*sumX));
}

MXD_API_C MXD_U32 acrux2ClbrPoutBt(void)
{
    MXD_U16 i=0,j=0,kk=0,avgmun=5,mimscl=0x80,maxscl=0x40;
    MXD_U16 negm=0,bigScl=0,miniscale=0,index=7;
    MXD_U16 idxAddr=0xa40,poutAddr=0x4ea,poutId=0;
    MXD_U16 targetVal=10000,RefMax=11000,RefMin=9500,range=50;
    int dcVal=0,dcDisPa=0,dcResult=0;
    /**********RF init config*************/
    acrux2HostBtTxInit();
    acrux2SetFreqMhzBt(2400);    //set freq

    rf_reg_write(rfmux_LDO_EN_CFG1_reg, 0x015F);    //[6]=1'b1;[8]=1 ![4]=1???
    rf_reg_write(RF_LDO_EN_CFG2_reg ,0x0203); // 0x201@
    _REGBS(rfmux_BIAS_CTRL2_reg, _BIT8);
    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT3, _BIT2, 0x3);   //
    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT5, _BIT4, 0x2);   //
    _REGBSS(rfmux_mode_table_bt_wifi_ctrl_reg, _BIT4, _BIT1, 0x5);  //
    rf_reg_write(RF_FM_CFG_reg, 0x0021);    //[5]=1'b1,[0]=1'b1
    rf_reg_write(RF_CAL_PATH1_reg,  0x000c);
    rf_reg_write(ctrl_clk_sel_26m_reg ,0x008d); // 0x602

    /**********RF init config*************/
    acrux2TxEnableNco(_FLAG_FREQ_500K); //NCO 500K
    acrux2TxEnableStd(_FLAG_FREQ_0K);   //
    //mxd mode set gain
    rf_reg_write(0x1b2,0);
    _REGBC(0x400, _BIT10);
    _REGBS(0x401, _BIT4);
    rf_reg_write(0x409,index);
    //  
    _REGBC(0x200,_BIT6);    // wyp Aug 14, 2014 disable Lo ldo
    _REGBC(0x214,_BIT13);   // wyp Aug 14, 2014 disable TX dac
    _REGBC(0x20C,_BIT2);    
    _REGBS(0x20C,_BIT1);    
    dcDisPa = acrux2WifiImbGetDc(3);
    _REGBS(0x200,_BIT6);    // wyp Aug 14, 2014 disable Lo ldo
    _REGBS(0x214,_BIT13);   // wyp Aug 14, 2014 disable TX dac
    _REGBS(0x20C,_BIT2);    
    _REGBC(0x20C,_BIT1);    

    _REGBS(0x37, _BIT2);        //enable miniScale
    rf_reg_write(0x38, 0x80);   //default mini scale

    /****************wyp debug***********************/
    index = getRegVal(0x409);
    poutId = regBitsGet(idxAddr+index*2+1,_BIT12,_BIT8);
    negm = regBitsGet(poutAddr+poutId*2,_BIT7,_BIT0);

    dcVal=acrux2WifiImbGetDc(3);
    dcResult = dcVal-dcDisPa;
    /********************************************/
    for(i=0; i<7; i++)      //set negm
    {
        if(dcResult < targetVal)
        {
            rf_reg_write(poutAddr+poutId*2, negm+(i+1)*17); //set mini scale
            dcVal=acrux2WifiImbGetDc(3);
            dcResult = dcVal-dcDisPa;
            mxdDbgInfo("[mxd]acrux2ClbrPoutBt set Negm%x %x %d\n",poutAddr+poutId*2,negm+(i+1)*17,dcResult);
        }
        else
        {
            mxdDbgInfo("[mxd]acrux2ClbrPoutBt set Negm%x %x %d\n",poutAddr+poutId*2,negm+(i)*17,dcResult);
            break;
        }
        if( (dcResult>=(targetVal-range)) && (dcResult<=(targetVal+range)) )
            return 0;
    }
    /********************************************/
    bigScl = getRegVal(0x39);
    for(j=0; j<=4; j++)     //set bigScale
    {
        rf_reg_write(0x39,bigScl);
        dcVal=acrux2WifiImbGetDc(3);
        dcResult = dcVal-dcDisPa;
        mxdDbgInfo("[mxd]acrux2ClbrPoutBt set bigScale %x   %d\n",bigScl,dcResult);
        if (dcResult>RefMax)
        {
            bigScl--;
        }
        else if(dcResult<targetVal)
        {
            bigScl++;
        }
        else
        {
            break;
        }
        if( (dcResult>=(targetVal-range)) && (dcResult<=(targetVal+range))  )
            return 0;
    }
    /********************************************/
    miniscale = getRegVal(0x38);
    for(kk=miniscale; kk>=0x40; kk--)       //set minScale
    {
        if (dcResult>targetVal)
        {
            miniscale = kk;
        }
        else
        {
            break;
        }
        rf_reg_write(0x38,miniscale);
        dcVal=acrux2WifiImbGetDc(3);
        dcResult = dcVal-dcDisPa;
        mxdDbgInfo("[mxd]acrux2ClbrPoutBt set Mini Scale %x %d\n",miniscale,dcResult);
        if( (dcResult>=(targetVal-range)) && (dcResult<=(targetVal+range)) )
            return 0;
    }

    /********************************************/
    return 0;
}
MXD_API_C MXD_U32 acrux2ClbrRximbBt(void)
{
    //
    return 0;
}

MXD_API_C MXD_U32 acrux2ClbrRximbWifi(void)
{
    //
    return 0;
}

void acrux2ClbrDcocBtSetMem(MXD_U16 flags, MXD_U16 gianId, MXD_U16 Vdcoc)
{
    // wyp Jun 10, 2014
    MXD_U32 regVal=0,i=0,PgaI=0,PgaQ=0,TiaI=0,TiaQ=0;
    MXD_U32 pgaAddr=0x9e0,tiaAddr=0x920;

    if(DCOC_PGA==flags) //pga
    {
        PgaI = Vdcoc>>8;
        PgaQ = Vdcoc&0x00FF;
        _REGBSS(pgaAddr+gianId*2,_BIT10,_BIT3,PgaI);
        _REGBSS(pgaAddr+gianId*2,_BIT15,_BIT11,(PgaI&0x001f));
        _REGBSS(pgaAddr+gianId*2+1,_BIT2,_BIT0,PgaI>>5);
    }
    else if(DCOC_TIA==flags)    //tia
    {
        TiaI = Vdcoc>>8;
        TiaQ = Vdcoc&0x00FF;
        _REGBSS(tiaAddr+gianId*4,_BIT15,_BIT15,TiaI&0x1);   //zl@@@@
        _REGBSS(tiaAddr+gianId*4+1,_BIT6,_BIT0,TiaI>>1);
        _REGBSS(tiaAddr+gianId*4+1,_BIT14,_BIT7,TiaQ);
    }
    else
    {
        for(i=0x9e0; i<=0x9ea; i+=2)
        {
            PgaI =regBitsGet(i,_BIT10,_BIT3);
            PgaQ = ((regBitsGet(i+1,_BIT2,_BIT0))<<5|(regBitsGet(i,_BIT15,_BIT11)));
            mxdDbgInfo("[acrux2ClbrDcocBtDebugInfo] PgaI[%d]:0x%x;  PgaQ:0x%x\n",(i-0x9e0)/2,PgaI,PgaQ);
        }
        for(i=0x920; i<=0x9dc; i+=4)
        {
            TiaI = ((regBitsGet(i,_BIT15,_BIT15))|(regBitsGet(i+1,_BIT6,_BIT0))<<1);
            TiaQ = regBitsGet(i+1,_BIT14,_BIT7);
            mxdDbgInfo("[acrux2ClbrDcocBtDebugInfo] TiaI[%d]:0x%x;  TiaQ:0x%x\n",(i-0x920)/4,TiaI,TiaQ);
        }
    }
}

void acrux2ClbrDcocBtDebugInfo(PMXD_U16 pDcocTia,PMXD_U16 pDcocPga)
{
    // wyp May 16, 2014
    MXD_U32 regVal=0,i=0,PgaI=0,PgaQ=0,TiaI=0,TiaQ=0;
    for(i=0x9e0; i<=0x9ea; i+=2)
    {
        PgaI =regBitsGet(i,_BIT10,_BIT3);
        PgaQ = ((regBitsGet(i+1,_BIT2,_BIT0))<<5|(regBitsGet(i,_BIT15,_BIT11)));
        *pDcocPga++ = (PgaI<<8)|PgaQ;
        mxdDbgInfo("[acrux2ClbrDcocBtDebugInfo] PgaI[%d]:0x%x;  PgaQ:0x%x\n",(i-0x9e0)/2,PgaI,PgaQ);
    }
    for(i=0x920; i<=0x9dc; i+=4)
    {
        TiaI = ((regBitsGet(i,_BIT15,_BIT15))|(regBitsGet(i+1,_BIT6,_BIT0))<<1);
        TiaQ = regBitsGet(i+1,_BIT14,_BIT7);
        *pDcocTia++ = (TiaI<<8)|TiaQ;
        mxdDbgInfo("[acrux2ClbrDcocBtDebugInfo] TiaI[%d]:0x%x;  TiaQ:0x%x\n",(i-0x920)/4,TiaI,TiaQ);
    }
}

void acrux2ClbrDcocBtDebugTest(void)
{
    // wyp May 20, 2014
    MXD_U32 i=0,adcI=0,adcQ=0,regVal=0,gainId=0;
    _REGBS(rfmux_host_en_reg, _BIT15);
    _REGBS(rfmux_mxd_en_reg, _BIT0);
    _REGBS(rfmux_mxd_en_reg, _BIT3);


    _REGBS(dcoc_dcoc_path_switch_reg, _BIT6);
    _REGBC(dcoc_dcoc_path_switch_reg, _BIT7);
    for(i=0; i<=31; i++)
    {
        _REGBSS(rfmux_btrx_map_control_mxd_reg, _BIT4, _BIT0, i);
        _REGBSS(rfmux_btrx_map_control_mxd_reg, _BIT12, _BIT8, i);
        rf_reg_read(dcoc_fm_idat_reg,&regVal);
        rf_reg_read(rfmux_btrx_actual_gidx_reg,&gainId);
        mxdDbgInfo("[acrux2ClbrDcocBtDebugTest]0x423:%x DCOC I: %x  %d  \n",gainId,regVal,regVal);
    }
    _REGBC(dcoc_dcoc_path_switch_reg, _BIT6);
    _REGBS(dcoc_dcoc_path_switch_reg, _BIT7);
    for(i=0; i<=31; i++)
    {
        _REGBSS(rfmux_btrx_map_control_mxd_reg, _BIT4, _BIT0, i);
        _REGBSS(rfmux_btrx_map_control_mxd_reg, _BIT12, _BIT8, i);
        rf_reg_read(dcoc_fm_idat_reg,&regVal);
        rf_reg_read(rfmux_btrx_actual_gidx_reg,&gainId);
        mxdDbgInfo("[acrux2ClbrDcocBtDebugTest]0x423:%x DCOC Q: %x  %d  \n",gainId,regVal,regVal);
    }


}

void acrux2ClbrDcocBtbegin()
{
    MXD_U32 regVal=0,i=0;
    _REGBS(dcoc_dcoc_bgn_triger, _BIT1);//  auto begin
    _REG_CHK(dcoc_rfcali_dcoc_state_reg, _BIT4);
    rf_reg_read(dcoc_rfcali_dcoc_state_reg, &regVal);

    if(0 == (regVal&0x0010))
    {
        mxdDbgInfo("[mxd]acrux2 BtIf dcoc fail ########--0x%x\n",regVal);
    }
    else
    {
        mxdDbgInfo("[mxd]acrux2 BtIf dcoc success --0x%x\n",regVal);
    }

}

MXD_API_C MXD_U32 acrux2ClbrDcocBt(void)
{
    // wyp May 20, 2014
    MXD_U32 regVal=0,i=0,j=0,temp=0,DcocQ=0x80,DcocI=0x80;
    MXD_U16 gainTia96[48]={0,};
    MXD_U16 gainPga96[6] ={0,};
    MXD_U16 gainTia97[48]={0,};
    MXD_U16 gainPga97[6] ={0,};
    MXD_U16 minV=0, maxV=0, x1=2380, x2=2500, xn=2400;

    /************* EN LDO ************/ 
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT5);   //Fm ldo
    _REGBS(rfmux_LDO_EN_CFG1_reg, _BIT6);   //Bt ldo
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT7);   //Wifi ldo
    _REGBSS(RF_LOPATH_CFG_reg,_BIT3,_BIT0,0x5); //En BT LOMixer

    acrux2HostBtRxInit();       //host bt rx
    acrux2SetFreqMhzBt(2400);       //ch97 freq 2380
#ifdef DCOC_ARITHMETIC
    acrux2SetFreqMhzBt(96);     //set freq  2500
#endif
    //acrux2ClbrDcocBtDebugInfo();      //debug info




    /**************Bt Rx pga dcoc cfg**********************/
       _REGBSS(rfmux_mode_table_bt_wifi_ctrl_reg, _BIT2,_BIT1,0x1);  //bt  rx lna gain table

    rf_reg_write(rfmux_BT_WF_RXGAIN_reg, 0x037e);   //for test only
    rf_reg_write(rfmux_host_en_reg, 0x0001);    //btrx host enable,bt dcoc from cal,mode enable    
    rf_reg_write(rfmux_LDO_EN_CFG1_reg, 0x005F);    //[4]=1'b1; sf  // wyp May 29, 2014  bit[7]->bit[6]
    rf_reg_write(RF_FM_CFG_reg, 0x0021);    //[5]=1'b1,[0]=1'b1
    rf_reg_write(frxp_frxp_aip_ctrl_reg, 0x000b);   // adc data original code
    rf_reg_write(dcoc_dcoc_path_switch_reg, 0x0800);    // val and source from cpu//
    rf_reg_write(dcoc_dcoc_path_polartiy_reg, 0x03ff);  // dcoc polarity set 1
    _REGBC(rfmux_BTRX_CFG1_reg, _BIT3); //disable BT_TIA_DCOC_EN
    _REGBC(rfmux_BTRX_CFG1_reg, _BIT1); //disable BT_RX_EN
    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT5, _BIT4, 0x1);   //sw rx

    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT3, _BIT0, 0x0);   //sw rx
    rf_reg_write(dcoc_dcoc_ctrl_reg, 0x0000);   //auto
    rf_reg_write(dcoc_dcoc_wrok_en, 0x0008);    //bt pga dcoc mode enable    bit[3]
    acrux2ClbrDcocBtbegin();
    /**************Bt Rx pga dcoc cfg done**********************/
    _REGBS(dcoc_dcoc_path_switch_reg,_BIT9);    // wyp Jun 18, 2014


    /**************Bt Rx TIA dcoc cfg**********************/
    //rf_reg_write(frxp_frxp_aip_ctrl_reg, 0x002b); // adc data original code
    rf_reg_write(dcoc_dcoc_wrok_en, 0x0004);    //bt tia dcoc mode enable    bit[2]
    _REGBS(rfmux_BTRX_CFG1_reg, _BIT3); //enable BT_TIA_DCOC_EN
    _REGBS(rfmux_BTRX_CFG1_reg, _BIT1); //enable BT_RX_EN
    _REGBSS(dcoc_dcoc_fmbt_gidx_set, _BIT6, _BIT4, 0x5);    //bt pga index set // // wyp Jun 18, 2014
    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT3, _BIT0, 0x3);   //sw rx
    acrux2ClbrDcocBtbegin();


    //acrux2ClbrDcocBtDebugInfo(gainTia97,gainPga97);       //debug info
#ifdef DCOC_ARITHMETIC
    acrux2ClbrDcocBtDebugInfo(gainTia96,gainPga96);     //debug info
    acrux2SetFreqMhzBt(97); //set freq  2380
    _REGBC(rfmux_BTRX_CFG1_reg, _BIT3); //disable BT_TIA_DCOC_EN
    _REGBC(rfmux_BTRX_CFG1_reg, _BIT1); //disable BT_RX_EN
    rf_reg_write(dcoc_dcoc_wrok_en, 0x0008);    //bt pga dcoc mode enable    bit[3]
    acrux2ClbrDcocBtbegin();

    rf_reg_write(dcoc_dcoc_wrok_en, 0x0004);    //bt tia dcoc mode enable    bit[2]
    _REGBS(rfmux_BTRX_CFG1_reg, _BIT3); //enable BT_TIA_DCOC_EN
    _REGBS(rfmux_BTRX_CFG1_reg, _BIT1); //enable BT_RX_EN
    rf_reg_write(dcoc_dcoc_btrx_pga_dcoc_set, 0x05);    //bt pga index set // wyp Jun 05, 2014@liujun
    acrux2ClbrDcocBtbegin();
    acrux2ClbrDcocBtDebugInfo(gainTia97,gainPga97);     //debug info

    for(xn=2400;xn<=2495;xn+=5)
    {
        for(i=0;i<=3;i++)   //gain oxc d e f
        {   
            minV= gainTia97[gGainid[i]]>>8;
            maxV= gainTia96[gGainid[i]]>>8;
            acrux2DcocArithmetic(minV, maxV, x2-x1-1, xn-x1, &DcocI);
            minV = gainTia97[gGainid[i]]&0x00FF;
            maxV = gainTia96[gGainid[i]]&0x00FF;
            acrux2DcocArithmetic(minV, maxV, x2-x1-1, xn-x1, &DcocQ);
            gBtChTiaDcoc[(xn-2400)/5*4+i] =(DcocI<<8)|DcocQ;

            minV = gainPga97[gGainid[i+4]]>>8;
            maxV = gainPga96[gGainid[i+4]]>>8;
            acrux2DcocArithmetic(minV, maxV, x2-x1-1, xn-x1, &DcocI);
            minV = gainPga97[gGainid[i+4]]&0x00FF;
            maxV = gainPga96[gGainid[i+4]]&0x00FF;
            acrux2DcocArithmetic(minV, maxV, x2-x1-1, xn-x1, &DcocQ);
            gBtChPgaDcoc[(xn-2400)/5*4+i] =(DcocI<<8)|DcocQ;
        }
    } 

    /*
       for(i=0;i<sizeof(gBtChTiaDcoc)/sizeof(gBtChTiaDcoc[0]);i++)
       {
       if(i%4==0)
       mxdDbgInfo("\n");
       mxdDbgInfo("0x%x    ",gBtChTiaDcoc[i]);

       }
       mxdDbgInfo("---------\n");
       for(i=0;i<sizeof(gBtChPgaDcoc)/sizeof(gBtChPgaDcoc[0]);i++)
       {
       if(i%4==0)
       mxdDbgInfo("\n");
       mxdDbgInfo("0x%x    ",gBtChPgaDcoc[i]);

       }
       for(i=0;i<sizeof(gainTia96)/sizeof(gainTia96[0]);i++)
       {
       mxdDbgInfo("dcoc tia array: %x  %x\n",gainTia96[i],gainTia97[i]);
       }
       for(i=0;i<sizeof(gainPga96)/sizeof(gainPga96[0]);i++)
       {
       mxdDbgInfo("dcoc pga array: %x  x\n",gainPga96[i],gainPga97[i]);
       }   
       */
#endif
    /**************normal  cfg**********************/
    _REGBS(dcoc_dcoc_path_switch_reg,_BIT1);
    _REGBC(dcoc_dcoc_wrok_en,_BIT2);
    _REGBC(dcoc_dcoc_wrok_en,_BIT3);

    /**************normal  cfg**********************/

    //acrux2ClbrDcocBtDebugTest();  //debug test for adc values
    return 0;
}

void acrux2WifiPgaInit(void)
{
    int forId=0;
    MXD_U32 cfgMap[]= // map control of reg0x0534
    { 
        //ADC REG
        //0x0213 ,0x037e,  // for test only
        0x0400 ,0x0001, //0x400 :0xb  host search //0x400 :0x1 tbl mode   
        //0x0200 ,0x009F,   //[4]=1'b1;
        0x020A ,0x0021,     //[5]=1'b1,[0]=1'b1
        0x0058 ,0x002b,     // adc data original code
        0x019d ,0x0800,     // val and source from cpu//
        0x019e ,0x03ff,  // dcoc polarity set 1
        0x01a9 ,0x001f,     //  dcoc mode enable
        //pga,0xtest,
        0x0203 ,0x0004,
        0x020f ,0x0029, //0019,39
        0x01a8 ,0x0000, //auto
        0x01a9 ,0x0002, //wf pga enable
    };

    for(forId= 0 ; forId < sizeof(cfgMap)/sizeof(cfgMap[0]); forId+=2)
    {
        rf_reg_write(cfgMap[forId], cfgMap[forId+1]);
    }

    mxdDbgInfo("[mxd]acrux2HostWfRxInit done!\n");
}
void acrux2WifiTiaInit(void)
{
    int forId=0;
    MXD_U32 cfgMap[]= // map control of reg0x0534
    {
#if 0
        0x0213  ,0x025e,  // for test only
        0x0400  ,0x0001, //0x400 :0xb  host search //0x400 :0x1 tbl mode   
        0x0200  ,0x009F,    //[4]=1'b1;
        0x020A  ,0x0021,    //[5]=1'b1,[0]=1'b1
        0x0058  ,0x002b,    // adc data original code
        0x019d  ,0x0800,    // val and source from cpu//0c00
        0x019e  ,0x03ff,  // dcoc polarity set 1
        0x01a9  ,0x001f,    //  dcoc mode enable
        0x0203  ,0x0000,
        0x020f  ,0x003f,
        0x01a9  ,0x0001, //wf tia enable
        0x01a8  ,0x0000,    // [0]dcoc auto/manual mode ,wf tia
#endif
        //0x0213    ,0x025e,
        0x0203  ,0x0000, 
        0x020f  ,0x003f, 
        0x01a9  ,0x0001, 
        0x01a8  ,0x0000, 
    };

    for(forId= 0 ; forId < sizeof(cfgMap)/sizeof(cfgMap[0]); forId+=2)
    {
        rf_reg_write(cfgMap[forId], cfgMap[forId+1]);
    }
    mxdDbgInfo("[mxd]acrux2WifiTiaInit done!\n");
}
//0528 sunzl
void acrux2WifiPgaInitManual(void)
{
    int forId=0;
    MXD_U32 cfgMap[]= // map control of reg0x0534
    { 
        //ADC REG
        //0x0213 ,0x037e,  // for test only
        0x19d,0x800,
        0x19e,0x3ff,
        0x0203 ,0x0004,
        //0x020f ,0x0029, //0019,39
        0x01a9 ,0x0002, //wf pga enable
        0x1a8,0x0001,
    };

    for(forId= 0 ; forId < sizeof(cfgMap)/sizeof(cfgMap[0]); forId+=2)
    {
        rf_reg_write(cfgMap[forId], cfgMap[forId+1]);
    }

    //  mxdDbgInfo("[mxd test]acrux2WifiPgaInit done!\n");
}
//0528 sunzl
void acrux2WifiTiaInitManual(void)
{
    int forId=0;
    MXD_U32 cfgMap[]= // map control of reg0x0534
    {
        0x0400  ,0x0001, //0x400 :0xb  host search //0x400 :0x1 tbl mode   
        0x0200  ,0x009F,    //[4]=1'b1;
        0x020A  ,0x0021,    //[5]=1'b1,[0]=1'b1
        0x0058  ,0x002b,    // adc data original code
        0x019d  ,0x0800,    // val and source from cpu//0c00
        0x019e  ,0x03ff,  // dcoc polarity set 1
        0x01a9  ,0x001f,    //  dcoc mode enable
        0x0203  ,0x0000,
        0x020f  ,0x003f,
        0x01a9  ,0x0001, //wf tia enable
        0x01a8  ,0x0001,    // [0]manual mode ,wf tia
    };

    for(forId= 0 ; forId < sizeof(cfgMap)/sizeof(cfgMap[0]); forId+=2)
    {
        rf_reg_write(cfgMap[forId], cfgMap[forId+1]);
    }
    //  mxdDbgInfo("[mxd test]acrux2WifiTiaInit done!\n");
}

MXD_U16 acrux2DcocDbgWifiInfo(MXD_U32 flag)
{
    MXD_U32 regAddr,i=0,all,allq,alli /*,Tia*/;
    MXD_U16 BitI,BitQ[2],lpfi,lpfq;
    if(0 == flag)
        return 0;
    //wifi dcoc pga
    for(regAddr=0x8e0;regAddr<=0x91f;regAddr+=2)
    {
        BitI= regBitsGet(regAddr,_BIT12,_BIT6);
        BitQ[0] = regBitsGet(regAddr,_BIT15,_BIT13);
        BitQ[1] = regBitsGet(regAddr+1,_BIT3,_BIT0);
        all = BitQ[0] |BitQ[1]<<3;
        mxdDbgInfo("%02d wifi pga I:0x%04x:0x%04x      Q:0x%04x:0x%04x\n",i++,regAddr,BitI,regAddr+1,all);
    }
    //wifi dcoc tia
    i=0;
    for(regAddr=0x820;regAddr<=0x8df;regAddr+=4)
    {
        lpfi= regBitsGet(regAddr+1,_BIT2,_BIT0);
        lpfq= regBitsGet(regAddr+1,_BIT5,_BIT3);

        BitI= regBitsGet(regAddr+1,_BIT11,_BIT6);
        BitQ[0] = regBitsGet(regAddr+1,_BIT15,_BIT12);
        BitQ[1] = regBitsGet(regAddr+2,_BIT1,_BIT0);

        allq = (lpfq<<6) | (BitQ[0] |BitQ[1]<<4);
        alli = (lpfi <<6)| BitI;
        mxdDbgInfo("%02d wifi tia I:0x%04x:0x%04x      Q:0x%04x:0x%04x\n",i++,regAddr+1,alli,regAddr+2,allq);
    }
    mxdDbgInfo("\n");
    return 1;
}
void acrux2DcocDbgFmInfo()
{
    MXD_U32 FmGainAddr = 0x800,Ival,Qval;
    for(FmGainAddr = 0x800;FmGainAddr <= 0x81f; FmGainAddr+=2)
    {
        Ival = regBitsGet(FmGainAddr,_BIT13,_BIT7);
        Qval = regBitsGet(FmGainAddr,_BIT15,_BIT14);
        Qval |= regBitsGet(FmGainAddr+1,_BIT4,_BIT0)<<2;
        mxdDbgInfo("FmDcoc I:0x%04x,0x%04x,0x%04x    Q:0x%04x,0x%04x,0x%04x\n",FmGainAddr,getRegVal(FmGainAddr),Ival,FmGainAddr+1,getRegVal(FmGainAddr+1),Qval);
    }
    mxdDbgInfo("\n");
}
MXD_U32 acrux2WifiGainTest(MXD_U32 flag)
{
    MXD_U32 gidxLna,gidxPa;
    MXD_U32 /*adcI,adcQ,*/gIndex,regVal[2];

    if(flag == 0)
        return 0;
    for(gidxPa = 0; gidxPa<=3; gidxPa++)
    {
        for(gidxLna = 0; gidxLna<=0x01f; gidxLna++)
        {   
            gIndex = (gidxLna<<8|gidxPa);

            regVal[0] = getRegVal(0x040d);
            regVal[1] = getRegVal(0x019d);
            rf_reg_write(0x40d,gIndex);
            rf_reg_write(0x19d,0x810);

            mxdDbgInfo("adcI:    %d    ",getRegVal(0x056));
            rf_reg_write(0x19d,0x820);
            mxdDbgInfo("adcQ:    %d\n",getRegVal(0x056));
            MxdSleep(1);
        }
    }
    rf_reg_write(0x40d,regVal[0]);
    rf_reg_write(0x19d,0x810);
    mxdDbgInfo("\n");

    return 0;
}

void acrux2ClbrDcocWifi(void)
{
    int forId=0x820/*,i*/;
    MXD_U32 regVal;

    acrux2HostWifiRxInit();
    acrux2SetFreqChWifi(2412);
#if 0
    acrux2WifiRxGainTbl();  
#endif
    acrux2DcocDbgWifiInfo(_DEBUG_INFO_);

    //Wifi Rx pga dcoc
    acrux2WifiPgaInit();
    //rf_reg_write(rfmux_wfrx_lna_map_mode,1);
    rf_reg_write(rfmux_mxd_en_reg,2);
    rf_reg_write(rfmux_mode_table_bt_wifi_ctrl_reg, 0x0004);  // wifi rx lna gain table
    rf_reg_write(dcoc_dcoc_bgn_triger   ,0x0002);   // start auto search dcoc trig:1:manual trig;2:auto_trig
    _REG_CHK(dcoc_rfcali_dcoc_state_reg, _BIT4);
    rf_reg_read(dcoc_rfcali_dcoc_state_reg, &regVal);

    if(0 == (regVal&0x0010))
    {
        mxdDbgInfo("[mxd]acrux2 if dcoc fail --0x%x\n",regVal);
    }
    else
    {
        mxdDbgInfo("[mxd]acrux2 if dcoc success --0x%x\n",regVal);
    }
    rf_reg_write(dcoc_dcoc_wrok_en  ,0x0000);   //restore mode 

    //Wfii Rx tia dcoc
    acrux2WifiTiaInit();
    rf_reg_write(dcoc_dcoc_bgn_triger   ,0x0002);   // start auto search dcoc trig:1:manual trig;2:auto_trig

    _REG_CHK(dcoc_rfcali_dcoc_state_reg, _BIT4);
    rf_reg_read(dcoc_rfcali_dcoc_state_reg, &regVal);
    if(0 == (regVal&0x0010))
    {
        mxdDbgInfo("[mxd]acrux2 if dcoc fail --0x%x\n",regVal);
    }
    else
    {
        mxdDbgInfo("[mxd]acrux2 if dcoc success --0x%x\n",regVal);
    }
    rf_reg_write(dcoc_dcoc_wrok_en  ,0x0000);//restore mode 
    acrux2DcocDbgWifiInfo(_DEBUG_INFO_);
    acrux2WifiGainTest(_DEBUG_INFO_);

    mxdDbgInfo("[mxd] wifi dcoc done \n");
}
//0528 sunzl
MXD_API_C MXD_U32 acrux2ClbrDcocWifiManual(void)
{ 
    int forId=0x820;
    MXD_U32 WfRxGainId;
    MXD_U32 regVal,regValI,regValQ,lpfI,lpfQ,lpfIQ,tiaI,tiaQ,tiaIQ;
    MXD_U32 aciCfg = 0,sizeGainId;
    MXD_U16 *gain_id_aci = NULL;

#if 0
    acrux2WifiRxGainTbl();  
#endif  
    acrux2HostWifiRxInit();
    acrux2SetFreqChWifi(2412);
    _REGBS(0x200, _BIT7);   //En WiFi_LO LDO
    _REGBC(0x200, _BIT6);
    _REGBC(0x200, _BIT5);
    _REGBSS(0x236, _BIT3, _BIT0, 0xa);

    acrux2DcocDbgWifiInfo(_DEBUG_INFO_);
    rf_reg_write(rfmux_mxd_en_reg,2);
    //rf_reg_write(rfmux_wfrx_lna_map_mode,1);
    rf_reg_write(rfmux_mode_table_bt_wifi_ctrl_reg, 0x0004);  // wifi rx lna gain table
    for(aciCfg = 0; aciCfg<2 ; aciCfg++)
    {
        if(aciCfg == 0)//no aci
        {
            _REGBC(0x414,_BIT7);// no Aci 
            gain_id_aci = manual_gain_id_noaci;
            sizeGainId = sizeof(manual_gain_id_noaci);
            mxdDbgInfo("wifi dcoc no aci mode\n");
        }
        else//aci
        {
            _REGBC(0x414,_BIT7);// Aci 
            gain_id_aci = manual_gain_id_aci;
            sizeGainId = sizeof(manual_gain_id_aci);
            mxdDbgInfo("wifi dcoc aci mode\n");
        }
        for(WfRxGainId =0; WfRxGainId< sizeGainId; WfRxGainId++)
        {
            //Wf Rx tia dcoc 
            acrux2WifiTiaInitManual();
            _REGBS(dcoc_dcoc_wrok_en ,_BIT7);//PGA dcoc from cpu enable
            //_REGBSS(dcoc_dcoc_wrok_en ,_BIT12,_BIT12,0);//PGA dcoc from cpu enable

            rf_reg_write(dcoc_dcoc_wfrx_if_dcoc_set ,0x2040); // PGA DCOC CPU default value

            _REGBSS(dcoc_dcoc_ctrl_reg, _BIT3,_BIT1,4);//Tia DCOC Cal set enable
            _REGBSS(dcoc_dcoc_ctrl_reg,_BIT9,_BIT4, *(gain_id_aci+WfRxGainId*2*sizeof(MXD_U16)));   //set TIA search gain idx
            _REGBSS(dcoc_dcoc_wf_gidx_set,_BIT10,_BIT5, *(gain_id_aci+WfRxGainId*2*sizeof(MXD_U16)));    //set TIA Gain idx match to DCOC search idx
            _REGBSS(dcoc_dcoc_wf_gidx_set,_BIT4,_BIT0, *(gain_id_aci+(WfRxGainId*2+1)*sizeof(MXD_U16)));    //set PGA Gain idx match to next step DCOC search idx

            rf_reg_write(dcoc_dcoc_bgn_triger, 0x0001);    // start manual search dcoc trig:1:manual trig;2:auto_trig
            _REG_CHK(dcoc_rfcali_dcoc_state_reg, _BIT0);
            rf_reg_read(dcoc_rfcali_dcoc_state_reg, &regVal);
            if(0 == (regVal&0x0001))
            {
                mxdDbgInfo("[mxd]acrux2 Tia dcoc fail --0x%x\n",regVal);
            }

            _REGBSS(dcoc_dcoc_wrok_en ,_BIT7,_BIT7,0); 
            rf_reg_read(dcoc_dcoc_daci_reg, &regValI); //get the DCOC cal value
            rf_reg_read(dcoc_dcoc_dacq_reg, &regValQ); //get the DCOC cal value

            //Wifi Rx pga dcoc     
            acrux2WifiPgaInitManual();
            tiaI = (regValI>>3) & 0x3f;
            lpfI =  regValI & 0x07;
            tiaQ = (regValQ>>3) & 0x3f;
            lpfQ =  regValQ & 0x07;

            tiaIQ = tiaQ + (tiaI<<6);
            lpfIQ = lpfQ + (lpfI<<3);

            rf_reg_write(dcoc_dcoc_wfrx_rf_tia_dcoc_set, tiaIQ); // set TIA CPU DCOC value
            rf_reg_write(dcoc_dcoc_wfrx_rf_lpf_dcoc_set, lpfIQ); // set TIA CPU DCOC value
            _REGBSS(dcoc_dcoc_wrok_en ,_BIT6,_BIT5,3); //TIA dcoc from cpu enable

            _REGBSS(dcoc_dcoc_ctrl_reg,_BIT9,_BIT4,*(gain_id_aci+(WfRxGainId*2+1)*sizeof(MXD_U16)));
            _REGBSS(dcoc_dcoc_ctrl_reg, _BIT3,_BIT1,3); 

            rf_reg_write(dcoc_dcoc_bgn_triger, 0x0001);    // start manual search dcoc trig:1:manual trig;2:auto_trig
            _REG_CHK(dcoc_rfcali_dcoc_state_reg, _BIT0);
            rf_reg_read(dcoc_rfcali_dcoc_state_reg, &regVal);
            if(0 == (regVal&0x0001))
            {
                mxdDbgInfo("[mxd]acrux2 Pga dcoc fail --0x%x\n",regVal);
            }

            rf_reg_write(dcoc_dcoc_wrok_en ,0x0000); //restore mode 
            _REGBSS(dcoc_dcoc_wrok_en ,_BIT6,_BIT5,0); //TIA dcoc from cpu disable

        }
    }


    acrux2DcocDbgWifiInfo(_DEBUG_INFO_);
    acrux2WifiGainTest(_DEBUG_INFO_);
    mxdDbgInfo("[mxd]acrux2ClbrDcocWifiManual wifi dcoc done \n");
    return 0;
}
void acrux2ClbrDcocFm()
{
    MXD_U32 forId=0,regVal=0,fmgidx=0;
    MXD_U32 cfgMap[] = 
    {
        0x0400, 0x0001,
        0x0058, 0x002b,     // adc data original code
        0x019d, 0x0800,     // val and source from cpu//
        0x019e, 0x03ff,     // dcoc polarity set 1
        //pga test
        0x0203, 0x0004,
        0x020f, 0x0029, //0019,39
        0x01a8, 0x0000, //auto
        0x01a9, 0x0010,     // [4]=1,fm dcoc mode enable

    };
#if 0
    mxdDbgInfo("0x092,0x%04x\n",getRegVal(0x092));
    acrux2ComInit();
    mxdDbgInfo("0x092,0x%04x\n",getRegVal(0x092));
#endif
    acrux2HostFmRxInit();
    _REGBS(0x200, _BIT5);   //open FM LDO
    _REGBS(0x200, _BIT4);   //open FM LDO
    _REGBC(0x200, _BIT6);   
    _REGBC(0x200, _BIT7);
    //  acrux2SetFreqKhzFm(1080);

    for(forId= 0 ; forId < sizeof(cfgMap)/sizeof(cfgMap[0]); forId+=2)
    {
        rf_reg_write(cfgMap[forId], cfgMap[forId+1]);
    }
    rf_reg_write(0x401, 0x020);

    acrux2DcocDbgFmInfo();
    rf_reg_write(0x01a7, 0x0002);   // dcoc trig:1:manual trig;2:auto_trig

    _REG_CHK(dcoc_rfcali_dcoc_state_reg,_BIT4);
    rf_reg_read(dcoc_rfcali_dcoc_state_reg,&regVal);
    if(0 == (regVal&0x10))//zl????
        mxdDbgInfo("[mxd]acrux2ClbrDcocFm rfcali_dcoc_state_reg fail \n");

    rf_reg_write(dcoc_dcoc_wrok_en, 0x0000);
#if 0
    rf_reg_write(0x209,1);
    rf_reg_write(0x208,5);
    rf_reg_write(0x20a,0x167);
    rf_reg_write(0x20a,0x1e7);

#endif  
    acrux2DcocDbgFmInfo();

    mxdDbgInfo("[mxd]acrux2ClbrDcocFm done\n");
}

void acrux2ClbrAutoSetPdetGain(MXD_U32 calId)
{
    MXD_U32 j=0,txcalAddrbgn=0x4a2;
    MXD_U32 pdetgain=0,pdet[4]={0,};
    pdetgain = regBitsGet(txcalAddrbgn+calId*4+1, _BIT4, _BIT3);        //get  pdetgain
    for(j=0; j<=3; j++)
    {
        _REGBSS(txcalAddrbgn+calId*4+1, _BIT4, _BIT3, j);   
        pdet[j]=acrux2WifiImbGetStd(5);
        //_btLoftMxdDbgInfo("pdet%d %d\n",j,pdet[j]);
    }
    if((pdet[1]>pdet[0])&& (pdetgain == 0))
    {
        pdetgain++;
        _btLoftMxdDbgInfo("[mxd]acrux2ClbrAutoSetPdetGain @0 Saturation setpdetGain: %d\n",pdetgain);
    }
    else if((pdet[2]>pdet[1]) && (pdetgain == 1) )
    {
        pdetgain++;
        _btLoftMxdDbgInfo("[mxd]acrux2ClbrAutoSetPdetGain @1 Saturation setpdetGain: %d\n",pdetgain);
    }
    else
    {
        _btLoftMxdDbgInfo("[mxd]acrux2ClbrAutoSetPdetGain pdetGain: %d\n",pdetgain);
    }
    _REGBSS(txcalAddrbgn+calId*4+1, _BIT4, _BIT3, pdetgain);

}

MXD_API_C MXD_U32  acrux2ClbrLoftBt(void)
{
    // wyp May 21, 2014
    MXD_U32 i=0,regVal=0,mag=0,result=0,tmpLoftCfg=0,clbrIdx=6;
    MXD_U32 bestTxLoftCtrl=0,btTxgainAddrbgn=0xa40,calId=0,id=0xffff;
    MXD_U32 btTxLoftDaci8bit=0, btTxLoftDacq8bit=0;
    MXD_U32 btTxLoftiStdMin=0, btTxLoftqStdMin=0;
    MXD_U32 btTxLoftImageValue=0;
    MXD_U32 iLoftDac=0,qLoftDac=0,minMag=0xffff,finalVal=0;

    /************* EN LDO ************/ 
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT5);   //Fm ldo
    _REGBS(rfmux_LDO_EN_CFG1_reg, _BIT6);   //Bt ldo
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT7);   //Wifi ldo
    _REGBSS(RF_LOPATH_CFG_reg,_BIT3,_BIT0,0x5); //En BT LOMixer

    acrux2HostBtTxInit();       //host tx bt
    acrux2SetFreqMhzBt(2400);   //set freq

    acrux2TxEnableStd(_FLAG_FREQ_500K);     //std 500K
    rf_reg_write(RF_LDO_EN_CFG2_reg ,0x0203); // 0x201@
    rf_reg_write(ctrl_clk_sel_26m_reg ,0x008d); // 0x602

    acrux2TxEnableNco(_FLAG_FREQ_500K); //NCO 500K
    _REGBS(rfmux_TX_CFG1_reg, _BIT13);
    _REGBC(rfmux_TX_CFG1_reg, _BIT7);
    _REGBS(rfmux_BIAS_CTRL2_reg, _BIT8);

    //_REGBS(0x32, _BIT6);
    rf_reg_write(txp_txp_scale_ctrl_reg ,0x0001); // 
    rf_reg_write(txp_txp_scale_factor_reg ,0x0008); // 

    //ADC REG
    rf_reg_write(RF_BIAS_CTRL1_reg, 0x0004);
    rf_reg_write(RF_CAL_PATH1_reg,  0x000c);
    rf_reg_write(rfmux_LDO_EN_CFG1_reg, 0x015F);    //[6]=1'b1;[8]=1 ![4]=1???
    rf_reg_write(RF_FM_CFG_reg, 0x0021);    //[5]=1'b1,[0]=1'b1
    rf_reg_write(frxp_frxp_aip_ctrl_reg,    0x0002);    //
    rf_reg_write(rfmux_TX_CFG1_reg, 0x201f);        // wyp Jul 16, 2014 bt tx en   0x211f 0x207f
    rf_reg_write(rfmux_TX_GAIN_reg, 0x0028);

    _REGBSS(rfmux_TX_MOD_CFG2_reg, _BIT4, _BIT0,0x0);// wyp Aug 06, 2014@xiao
    _REGBSS(RF_TX_CFG2_reg, _BIT3, _BIT1,0x0);


    /**********RF bt loft config*************/
    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT3, _BIT2, 0x3);   //
    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT5, _BIT4, 0x2);   //
    _REGBSS(rfmux_host_en_reg, _BIT11, _BIT10, 0x0);    //
    _REGBS(rfmux_host_en_reg,_BIT0);    //
    //_REGBC(rfmux_host_en_reg,_BIT13); //
    _REGBSS(rfmux_mode_table_bt_wifi_ctrl_reg, _BIT4, _BIT1, 0x5);  //
    _REGBSS(txcal_txcal_para_set, _BIT3, _BIT0, 0x3);   //0x1b2 loft enable
    rf_reg_write(txcal_txcal_loft_cos_set, 0x0fe2);     //loft STD cos
    rf_reg_write(txcal_txcal_loft_sin_set, 0x01ee);     //loft STD sin
    _REGBSS(txcal_txcal_std_set, _BIT4, _BIT0, 0x1f);   // 0x1b7    2^n Horner 2^(n+5)
    _REGBSS(txcal_txcal_loft_par_set, _BIT10, _BIT9, 0x1);  // 0x1b8    step=1  
    _REGBSS(txcal_txcal_loft_range_set, _BIT5 , _BIT0, LOFT_DAC_Q_RNG); // 0x1b9    rangeI
    _REGBSS(txcal_txcal_loft_range_set, _BIT11, _BIT6, LOFT_DAC_I_RNG); // 0x1b9    rangeQ  
    /**********RF bt loft config end*************/

    /**************seach  loft**********************/
    for (i=0x0;i<=0x9;i++)  //gain id   for (i=0x0;i<=0xF;i+=4) 
    {
        calId = regBitsGet(btTxgainAddrbgn+i*2+1, _BIT7, _BIT3);//get cal id
        if(calId == id) 
            continue; 
        id = calId;

        if( (i>=0)&&(i<=3) )
            rf_reg_write(0x039,0x0d);
        else
            rf_reg_write(0x039,0x08);

        _REGBSS(txcal_txcal_loft_par_set,_BIT8,_BIT5,i); //set bt tx gain idx
        //  acrux2ClbrAutoSetPdetGain(calId);
        _REGBS(txcal_txcal_search_bgn,_BIT0); //0x1b3[0] begin search
        _REG_CHK(txcal_txcal_loft_result, _BIT0); //0x1bd[0] loft search done flags
        rf_reg_read(txcal_txcal_loft_result,&result);   //check done flags
        if ((0x1&result)==0)
            mxdDbgInfo("[AcruxClbrLoftBt] txcal_loft_result is not done!!.######$$%$#$####\n##############\n");
        regVal=0;
        rf_reg_read(txcal_txcal_loft_dac_result, &regVal); //0x01ba get daci/q result
        btTxLoftDaci8bit = _BSG(regVal,_BIT15,_BIT8);   //I
        btTxLoftDacq8bit = _BSG(regVal,_BIT7,_BIT0);    //Q
        rf_reg_read(txcal_txcal_real, &btTxLoftiStdMin); //0x01c2  get lofti bt std result(min)
        rf_reg_read(txcal_txcal_imag, &btTxLoftqStdMin); //0x01c3  get lofti bt std result(min)
        rf_reg_read(txcal_txcal_mag, &btTxLoftImageValue); //0x01c1 get loft image value 
        bestTxLoftCtrl = ((btTxLoftDacq8bit<<8)&0xFF00) | (btTxLoftDaci8bit&0x00FF);    // BIT15~BIT8 for btTxLoftDacq; BIT7~BIT0 for btTxLoftDaci
        /*
           _btLoftMxdDbgInfo("[mxd] bcruxClbrLoftBt:: Search for GainIdx 0x%d done, Daci %x, Dacq %x, iStd %x, qStd %x, ImageValue %x\n ",
           i,
           btTxLoftDaci8bit,
           btTxLoftDacq8bit,
           btTxLoftiStdMin,
           btTxLoftqStdMin,
           btTxLoftImageValue);
           */

        rf_reg_write(txcal_txcal_para_set,0x002);
        rf_reg_write(rfmux_mxd_en_reg,0x0010);
        rf_reg_write(rfmux_bttx_mxd_gidx_reg,i);

        finalVal = acrux2LoftTwoDimensionalSrarch(bestTxLoftCtrl,calId);

        //update cal table      
        //rf_reg_write(rfmux_tx_cal_tbl_e0w0_reg+calId*4,bestTxLoftCtrl);   //
        _btLoftMxdDbgInfo("acrux2ClbrLoftBt  addr:  %x  val:    %x\n",rfmux_tx_cal_tbl_e0w0_reg+calId*4,finalVal);
        //mxdDbgInfo("wyp:%d    %x\n",i,rfmux_tx_cal_tbl_e0w0_reg+calId*4);

    }
    /**************seach  loft**********************/
    //update cal table
    /**************normal  cfg**********************
      for (i=0x0;i<=0xF;i+=3) //gain id
      rf_reg_write(rfmux_tx_cal_tbl_e11w0_reg+4*(i/3),bestTxLoftCtrl);    //


    /**************normal  cfg**********************/
    _REGBC(txcal_txcal_para_set, _BIT0);        //loft disable

    /**************normal  cfg end**********************/


    return 0;
}
void Acrux2pdetCfg(MXD_U32 Val)
{
    MXD_U32 gidx = 0x4a3;
    for(gidx = 0x4a3; gidx<= 0x4a3+4*7; gidx+=4)
    {
        _REGBSS(gidx, _BIT4,_BIT3,Val);
        //      mxdDbgInfo("%d    0x%04x,0x%04x\n",i,gidx,getRegVal(gidx)>>3&3);
    }
}

MXD_U32 acrux2LoftTwoDimensionalSrarch(MXD_U32 defaultVal, MXD_U32 CalId)
{
    MXD_U32 IReg[11],QReg[11],loftDac=0,bestStdAndReg[2] = {0xffff,0xffff},tempStd;//bestStdAndReg:0,betterStd , corresponding regVal
    MXD_U32 txCalTbl=0x4a2;
    int offset=0,ii=0,jj=0,range = 5;

    _WfLoftInfo("default:0x%04x\n",defaultVal);

    for (offset=range*(-1),jj=0 ; offset<=range ; offset++,jj++)
    {
        IReg[jj] = (defaultVal >> 8) + offset;
        _WfLoftInfo("I default:0x%04x,lift offset8+%d:%x,Ireg:%x\n",defaultVal,defaultVal>>8,offset,IReg[jj]);
        QReg[jj] = (defaultVal & 0xff) + offset;
        _WfLoftInfo("Q default:0x%04x,right offset&0xff+%d:%x,Ireg:%x\n",defaultVal,defaultVal&0xff,offset,QReg[jj]);
    }
    _WfLoftInfo("loftDac    real    std500K\n");
    for (ii=0 ; ii<range*2+1 ; ii++)
    {
        for (jj=0 ; jj<range*2+1 ; jj++)
        {
            loftDac = (IReg[ii]<<8)|QReg[jj];
            rf_reg_write(txCalTbl+CalId*4,loftDac);
            //acrux2TxEnableStd(_FLAG_FREQ_0K);
            //rf_reg_write(std_std_pulse_reg,1);
            //real = getRegVal(std_std_real_status);            
            //acrux2TxEnableStd(_FLAG_FREQ_1M);
            tempStd = acrux2WifiImbGetStd(3);

            if (bestStdAndReg[0]>tempStd)
            {
                bestStdAndReg[0] = tempStd;
                bestStdAndReg[1] = loftDac;
            }
            _WfLoftInfo("0x%04x    %d\n",loftDac,tempStd);
        }
    }
    rf_reg_write(txCalTbl+CalId*4,bestStdAndReg[1]);
    mxdDbgInfo("LoftCal    %x    %x    %d\n",defaultVal,bestStdAndReg[1],bestStdAndReg[0]);
    return bestStdAndReg[1];
}
MXD_API_C MXD_U32  acrux2ClbrLoftWifi(void)
{
    MXD_U16 gainId=0,i=0,TxCalTblStart = 0x04a2;
    MXD_U32 regVal=0,txCalTbl=0x4a2;
    MXD_U32 result=0,STDminI=0,STDminQ=0,loftImage=0,loftDac=0;
    MXD_U32 gidx=0,Id=0xffff,calId=0,wfTxTblAddrBgn=0xa00;
    MXD_U32 finalVal,gidxDbg,calTestFlag=0;
    MXD_U32 calGain[] = {0,1,2,3,4,5,6,7};
    MXD_U32 cfgMap[]=
    {
        // pll clock
        0x0602 ,0x008D, // forcre clk_txp_da/clk_txp_ad to 26MHz
        0x0204 ,0x0124,     //[8]=1,
        0x0214 ,0x2077,     //[13]=1,[7]=0
        0x0039 ,0x0008,
        0x0400 ,0xfc3f,     //[7]=0,[0]=1
        0x0203 ,0x0004,
        0x0200 ,0x019F,     //[4]=1'b1;[8]=1 !
        0x020A ,0x0021,     //[5]=1'b1,[0]=1'b1
        0x0058 ,0x0002,     //
        0x041d ,0x0010,  //mode_sel[1:0]=2'b10,wftx del !!!!!!!
        0x01b2 ,0x0003, //[2]=0,data from adc,[0]=1,loft enable
        0x01b5 ,0x0f89 ,//0xfe2, 500K//0x0f89, 1M //loft STD cos
        0x01b6 ,0x03d4 ,//0x1ee,//0x03d4, //loft STD sin
        0x01b7 ,0x001f, //std 7,rpt 3
        0x01b8 ,0x0200,
        0x01b9 ,0x0820, //rng-I:20 rng-Q:20
    };

    acrux2HostWifiTxInit();
    _REGBSS(RF_LOPATH_CFG_reg, _BIT3, _BIT0, 0xa);
    _REGBS(rfmux_LDO_EN_CFG1_reg, _BIT7);   //En WiFi_LO LDO
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT6);
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT5);
    acrux2SetFreqChWifi(1);
    acrux2TxEnableNco(_FLAG_FREQ_1M);
    acrux2TxEnableStd(_FLAG_FREQ_1M);

    _REGBS(RF_LDO_EN_CFG2_reg, _BIT9);
    _REGBS(txp_txp_scale_ctrl_reg, _BIT0);
    _REGBS(RF_CAL_PATH1_reg, _BIT3);
    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT5, _BIT4, 0x2);   //10 Tx,01Rx

    for (i=0;i<sizeof(cfgMap)/sizeof(cfgMap[0])/2;i++)
    {
        rf_reg_write(cfgMap[2*i], cfgMap[2*i+1]);
    } 
    //Acrux2pdetCfg(1);
    rf_reg_write(rfmux_host_en_reg, 0xff3f);
    _REGBC(rfmux_host_en_reg, _BIT9);
    _REGBS(rfmux_host_en_reg,_BIT8);

    for(gidx =4; gidx<=11; gidx++)
    {
        gidxDbg = gidx;

        calId = regBitsGet(wfTxTblAddrBgn+gidxDbg*2+1, _BIT7, _BIT3);//get cal id
        if(Id == calId)
            continue;
        Id = calId;
        for(i=0;i<7;i++)
        {
            if(Id == calGain[i])
            {
                calTestFlag = 1;
                break;
            }
        }
        if(!calTestFlag)
            mxdDbgInfo("####wifi loft tbl error\n");
        switch(calId)
        {
            case 0: // 4
                rf_reg_write(txp_txp_scale_factor_reg,0x0F);//f
                break;
            case 2: // 5
                rf_reg_write(txp_txp_scale_factor_reg,0x0F);//f
                break;      
            case 4: // 6
                rf_reg_write(txp_txp_scale_factor_reg,0x0c);//c
                break;  
            case 6: //7
                rf_reg_write(txp_txp_scale_factor_reg,0x09);//9
                break;  
            case 7: // 8
                rf_reg_write(txp_txp_scale_factor_reg,0x08);//8
                break;
            case 1: //9
                rf_reg_write(txp_txp_scale_factor_reg,0x09);//8
                break;
            case 3: //A
                rf_reg_write(txp_txp_scale_factor_reg,0x05);//5
                break;
            case 5: //B
                rf_reg_write(txp_txp_scale_factor_reg,0x04);// 4
                break;
        }
        MxdSleep(1);
        _REGBSS(txcal_txcal_loft_par_set,_BIT4,_BIT0,gidxDbg);
        _WfLoftInfo("%x,%x\n",gidxDbg,getRegVal(0x39));
        //acrux2ClbrAutoSetPdetGain(calId);
        rf_reg_write(txcal_txcal_search_bgn, 0x001); //loft trig
        _REG_CHK(txcal_txcal_loft_result,_BIT0);
        rf_reg_read(txcal_txcal_loft_result, &regVal);

        if(0 == (regVal&0x1))
        {
            mxdDbgInfo("[mxd] wifi loft #####error\n");
        }
        //read status
        rf_reg_read(txcal_txcal_loft_dac_result, &result);
        rf_reg_read(txcal_txcal_real, &STDminI);
        rf_reg_read(txcal_txcal_imag, &STDminQ);
        rf_reg_read(txcal_txcal_mag, &loftImage);
        _WfLoftInfo("I:0x%04x, Q:0x%04x    STDminI:0x%04x,STDminQ:0x%04x, Image:0x%04x\n",
                result>>8,result&0xff,STDminI,STDminQ,loftImage);
        loftDac = (result>>8)|((result&0xff)<<8);

        rf_reg_write(txcal_txcal_para_set,0x002);
        rf_reg_write(rfmux_mxd_en_reg,0x004);
        rf_reg_write(rfmux_wftx_gidx_reg,gidxDbg);

        finalVal = acrux2LoftTwoDimensionalSrarch(loftDac,Id);
        //      if(gidxDbg == 12)
        //          rf_reg_write(txCalTbl+7*4,getRegVal(txCalTbl+6*4));
        mxdDbgInfo("loftADC : [0x%04x, 0x%04x]    TxCalId,%d    Gain,0x%04x\n",txCalTbl+Id*4,finalVal,Id,gidxDbg);

        rf_reg_write(txcal_txcal_para_set,0x0003);
        rf_reg_write(rfmux_mxd_en_reg,0x0000);
    }

    rf_reg_write(txp_txp_scale_factor_reg,0x008);   
    for(gidx = 0x4a3,i=0; gidx<= 0x4e7; gidx+=4,i++)
    {
        _WfLoftInfo("%d    0x%04x,0x%04x\n",i,gidx,getRegVal(gidx)>>3&3);
    }
    mxdDbgInfo("acrux2ClbrLoftWifi done\n");

    return 0;
}

int acrux2Abs(int val)
{
    return val>0?val:(val*(-1));
}
MXD_U32 acrux2PoutNegmCapAdjustment(int  DcStandard, int DcDisPa, int *DcResult)
{
    MXD_U32 scal,bestScale=0x08,gidx=0,poutCalId = 0;
    MXD_U32 poutCalAddrBgn = 0x4ea,wfTxTblAddrBgn = 0xa00,negmCtrl,capCtrl;
    int DcMin = 32768,range = 1,DcScale,DcTemp;
    MXD_U32 savePoutId[] = {8,0,9,1},i=0,x=0,ID,nemg,cap;

    gidx = getRegVal(0x408);
    poutCalId = regBitsGet(wfTxTblAddrBgn+gidx*2+1, _BIT12, _BIT8);//get pout cal id
    capCtrl = regBitsGet(poutCalAddrBgn+poutCalId*2,_BIT3,_BIT0);
    negmCtrl = regBitsGet(poutCalAddrBgn+poutCalId*2,_BIT7,_BIT4);  

    for(i=0;i<32;i++)
    {
        ID= regBitsGet(wfTxTblAddrBgn+i*2+1, _BIT12, _BIT8);//get pout cal id
        cap = regBitsGet(poutCalAddrBgn+ID*2,_BIT3,_BIT0);
        nemg = regBitsGet(poutCalAddrBgn+ID*2,_BIT7,_BIT4); 

        mxdDbgInfo("%d    %d    %d\n",ID,cap,nemg);
    }

    for (scal=0; scal<= 7; scal += range)
    {
        _REGBSS(poutCalAddrBgn+poutCalId*2,_BIT3,_BIT0,scal+capCtrl);
        _REGBSS(poutCalAddrBgn+poutCalId*2,_BIT7,_BIT4,scal+negmCtrl);

        DcScale = acrux2WifiImbGetDc(3);
        DcScale = acrux2Abs(DcScale - DcDisPa);
        DcTemp = acrux2Abs(DcScale - DcStandard);

        if (DcTemp <= DcMin)
        {
            DcMin = DcTemp;
            bestScale = scal;
        }
        else
            break;
        if(DcTemp <50)
        {
            for(i=0;i<sizeof(savePoutId)/sizeof(savePoutId[0]); i++)
            {
                if(savePoutId[i] == poutCalId)
                {
                    _REGBSS(poutCalAddrBgn+savePoutId[i]*2,_BIT3,_BIT0,capCtrl+bestScale);
                    _REGBSS(poutCalAddrBgn+savePoutId[i]*2,_BIT7,_BIT4,negmCtrl+bestScale);
                    //          mxdDbgInfo("%d    %d    %d\n",savePoutId[i],regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT3,_BIT0),regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT7,_BIT4));

                }
                else
                {
                    _REGBSS(poutCalAddrBgn+savePoutId[i]*2,_BIT3,_BIT0,(regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT3,_BIT0)+bestScale));
                    _REGBSS(poutCalAddrBgn+savePoutId[i]*2,_BIT7,_BIT4,(regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT7,_BIT4)+bestScale));
                    //      mxdDbgInfo("%d    %d    %d\n",savePoutId[i],regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT3,_BIT0),regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT7,_BIT4));

                }
            }
            mxdDbgInfo("[mxd] acrux2PoutNegmCapAdjustment return %x    %d\n",bestScale,DcMin);
            return 1;
        }
        mxdDbgInfo("[mxd] acrux2PoutNegmCapAdjustment %x    %d\n",bestScale,DcMin);
    }

    for(i=0;i<sizeof(savePoutId)/sizeof(savePoutId[0]); i++)
    {
        if(savePoutId[i] == 8)
        {
            _REGBSS(poutCalAddrBgn+savePoutId[i]*2,_BIT3,_BIT0,capCtrl+bestScale);
            _REGBSS(poutCalAddrBgn+savePoutId[i]*2,_BIT7,_BIT4,negmCtrl+bestScale);
            //      mxdDbgInfo("%d    %d    %d\n",savePoutId[i],regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT3,_BIT0),regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT7,_BIT4));

        }
        else
        {
            _REGBSS(poutCalAddrBgn+savePoutId[i]*2,_BIT3,_BIT0,(regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT3,_BIT0)+bestScale));
            _REGBSS(poutCalAddrBgn+savePoutId[i]*2,_BIT7,_BIT4,(regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT7,_BIT4)+bestScale));
            //      mxdDbgInfo("%d    %d    %d\n",savePoutId[i],regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT3,_BIT0),regBitsGet(poutCalAddrBgn+savePoutId[i]*2,_BIT7,_BIT4));

        }
    }

    for(i=0;i<32;i++)
    {
        ID= regBitsGet(wfTxTblAddrBgn+i*2+1, _BIT12, _BIT8);//get pout cal id
        cap = regBitsGet(poutCalAddrBgn+ID*2,_BIT3,_BIT0);
        nemg = regBitsGet(poutCalAddrBgn+ID*2,_BIT7,_BIT4); 

        mxdDbgInfo("%d    %d    %d\n",ID,cap,nemg);
    }


    *DcResult = DcMin;

    mxdDbgInfo("[mxd] acrux2PoutNegmCapAdjustment best %x, DcMin %d\n",bestScale,DcMin);

    return 0;
}

MXD_U32 acrux2PoutBigAdjustment(int DcStandard, int DcDisPa, int *DcResult)
{
    MXD_U32 scal,bestScale=0x08;
    int DcMin = 32768,range = 1,DcScale,DcTemp;

    if (*DcResult > DcStandard)
        range = range*(-1);

    for (scal=8; scal<= 0x0c && scal>0; scal = scal+range)
    {
        rf_reg_write(0x39,scal);
        DcScale = acrux2WifiImbGetDc(3);
        DcScale = acrux2Abs(DcScale - DcDisPa);
        DcTemp = acrux2Abs(DcScale - DcStandard);

        if (DcTemp <=DcMin )
        {
            DcMin = DcTemp;
            bestScale = scal;
        }
        else
            break;
        if(DcTemp <50)
        {
            *DcResult = DcMin;
            rf_reg_write(0x39,bestScale);

            mxdDbgInfo("[mxd] acrux2PoutBigAdjustment return %x    %d\n",bestScale,DcMin);
            return 1;
        }
        mxdDbgInfo("[mxd] acrux2PoutBigAdjustment %x    %d\n",bestScale,DcMin);
    }
    *DcResult = DcMin;
    rf_reg_write(0x39,bestScale);

    mxdDbgInfo("[mxd] acrux2PoutBigAdjustment best %x, DcMin %d\n",bestScale,DcMin);
    return 0;
}
MXD_U32 acrux2PoutSmallAdjustment(int DcStandard,int DcDisPa , int *DcResult)
{

    MXD_U32 scale = 0x80,bestScale=0x80,betterRange = 10;
    int range = 1,DcMin = 32768 , DcScale=0,DcTemp;

    rf_reg_write(0x037,5); // en bias scale
    for ( ; scale >0x40; scale--)
    {
        rf_reg_write(0x38,scale);
        DcScale = acrux2WifiImbGetDc(3);
        DcScale = acrux2Abs(DcScale - DcDisPa);
        DcTemp = acrux2Abs(DcStandard - DcScale);

        if ( DcTemp<= DcMin)
        {
            DcMin = DcTemp;
            bestScale = scale;
        }
        else
            break;
        if(DcTemp <50)
        {   
            *DcResult = DcMin;
            rf_reg_write(0x38,bestScale);
            mxdDbgInfo("[mxd] acrux2PoutSmallAdjustment return %x    %d\n",bestScale,DcMin);
            return 1;
        }
        mxdDbgInfo("[mxd] acrux2PoutSmallAdjustment %x    %d\n",scale,DcMin);
    }

    *DcResult = DcMin;
    rf_reg_write(0x38,bestScale);

    mxdDbgInfo("[mxd] acrux2PoutSmallAdjustment best %x, DcMin %d\n",bestScale,DcMin);

    return 0;
}

MXD_API_C MXD_U32 acrux2ClbrPoutWifi(void)
{

    MXD_U32 save200,save214,save20c,i=0,ret=0;
    int DcVal=0,DcDisPa=0,DcResult=0,DcStandard=14165;//14.7dB;
#if 1 
    //from loft
    MXD_U32 cfgMap[]=
    {
        // pll clock
        0x0602 ,0x008D, // forcre clk_txp_da/clk_txp_ad to 26MHz
        0x0204 ,0x0124,     //[8]=1,
        0x0214 ,0x2077,     //[13]=1,[7]=0
        0x0039 ,0x0008,
        0x0400 ,0xfc3f,     //[7]=0,[0]=1
        0x0203 ,0x0004,
        0x0200 ,0x019F,     //[4]=1'b1;[8]=1 !
        0x020A ,0x0021,     //[5]=1'b1,[0]=1'b1
        0x0058 ,0x0002,     //
        0x041d ,0x0010,  //mode_sel[1:0]=2'b10,wftx del !!!!!!!
        0x01b2 ,0x0003, //[2]=0,data from adc,[0]=1,loft enable
        0x01b5 ,0x0f89 ,//0xfe2, 500K//0x0f89, 1M //loft STD cos
        0x01b6 ,0x03d4 ,//0x1ee,//0x03d4, //loft STD sin
        0x01b7 ,0x001f, //std 7,rpt 3
        0x01b8 ,0x0200,
        0x01b9 ,0x0820, //rng-I:20 rng-Q:20
    };


    //from imb
    _REGBC(rfmux_host_en_reg, _BIT9);
    _REGBC(txcal_txcal_para_set,_BIT3); //rfimb_en
    rf_reg_write(txp_txp_scale_factor_reg,0x08);
    //
    acrux2HostWifiTxInit();
    _REGBSS(RF_LOPATH_CFG_reg, _BIT3, _BIT0, 0xa);
    _REGBS(rfmux_LDO_EN_CFG1_reg, _BIT7);   //En WiFi_LO LDO
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT6);
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT5);
    acrux2SetFreqChWifi(1);
    acrux2TxEnableNco(_FLAG_FREQ_1M);
    acrux2TxEnableStd(_FLAG_FREQ_1M);

    _REGBS(RF_LDO_EN_CFG2_reg, _BIT9);
    _REGBS(txp_txp_scale_ctrl_reg, _BIT0);
    _REGBS(RF_CAL_PATH1_reg, _BIT3);
    _REGBSS(rfmux_BW_RF_CFG1_reg, _BIT5, _BIT4, 0x2);   //10 Tx,01Rx

    for (i=0;i<sizeof(cfgMap)/sizeof(cfgMap[0])/2;i++)
    {
        rf_reg_write(cfgMap[2*i], cfgMap[2*i+1]);
    } 
    //Acrux2pdetCfg(1);
    rf_reg_write(rfmux_host_en_reg, 0xff3f); 
    _REGBC(rfmux_host_en_reg, _BIT9);
    _REGBS(rfmux_host_en_reg,_BIT8);


#endif
    Acrux2pdetCfg(2);

    rf_reg_write(0x1b2,2);
    rf_reg_write(0x401,4);
    rf_reg_write(0x38,0x80);
    rf_reg_write(0x39,0x8);

    rf_reg_write(0x408,0x0b);   


    acrux2TxEnableStd(_FLAG_FREQ_0K);
    DcVal = acrux2WifiImbGetDc(3);

    rf_reg_read(0x200,&save200);
    rf_reg_read(0x214,&save214);
    rf_reg_read(0x20c,&save20c);

    rf_reg_write(0x200,0x1f);
    rf_reg_write(0x214,0x10);
    rf_reg_write(0x20c,0x2a);

    DcDisPa = acrux2WifiImbGetDc(3);

    DcResult = DcVal - DcDisPa;

    //mxdDbgInfo("pout %d = %d-%d\n",DcResult,DcVal,DcDisPa);
    rf_reg_write(0x200,save200);
    rf_reg_write(0x214,save214);
    rf_reg_write(0x20c,save20c);

    mxdDbgInfo("pout %d to %d ,DcDisPa  %d\n",DcResult,DcStandard,DcDisPa);
    if(DcResult <DcStandard)
        ret = acrux2PoutNegmCapAdjustment(DcStandard,DcDisPa,&DcResult);//--++
    if(!ret)
    {
        ret = acrux2PoutBigAdjustment(DcStandard,DcDisPa,&DcResult);
        if(!ret)
            acrux2PoutSmallAdjustment(DcStandard,DcDisPa,&DcResult);
    }
    Acrux2pdetCfg(1);
    mxdDbgInfo("Pout done\n");

    return 0;
}


MXD_U32 acrux2WifiAciCfg(MXD_U32 aciFlag)
{
    if( 1 == aciFlag)
    {
        _REGBS(rfmux_lna_sat_aci_reg,_BIT7);
        mxdDbgInfo("wifi aci mode enable\n");
    }
    else if( 0 == aciFlag)
    {
        _REGBC(rfmux_lna_sat_aci_reg,_BIT7);
        mxdDbgInfo("wifi aci mode disable\n");
    }
    else
    {
        mxdDbgInfo("####acrux2WifiRxAci aciflag %x error\n",aciFlag);
        return 1;
    }
    return 0;
}
MXD_U32 acrux2BtAciCfg(MXD_U32 aciFlag)
{
    if( 1 == aciFlag)
    {
        _REGBS(rfmux_lna_sat_aci_reg,_BIT0);
        mxdDbgInfo("Bt aci mode enable\n");
    }
    else if(0 == aciFlag)
    {
        _REGBC(rfmux_lna_sat_aci_reg,_BIT0);
        mxdDbgInfo("Bt aci mode disable\n");
    }
    else
    {
        mxdDbgInfo("####acrux2BtRxAci aciflag %x error\n",aciFlag);
        return 1;
    }
    return 0;

}
MXD_U32 acrux2ImbCalIdRecovery(MXD_U32 index)
{

    MXD_U32 calId=0, TxCalId=0;
    calId = regBitsGet(0xa00+index*2+1, _BIT7, _BIT3);//get cal id

    if ((index <= 3&&index>=0)||(index <= 0x13&&index>=0x10))
    {
        TxCalId = 8;
    }
    else if ((index>=4&&index<=8)||(index>=0x14&&index<=0x18))
    {
        TxCalId = 9;
    }
    else if ((index>=9&&index<=0xb)||(index>=0x19&&index<=0x1b))
    {
        TxCalId = 10;
    }
    else 
    {
        TxCalId = 11;
    }
    _REGBSS(0x4a2+calId*4+3,_BIT12,_BIT5,regBitsGet(0x4a2+TxCalId*4+3,_BIT12,_BIT5));
    _REGBSS(0x4a2+calId*4+2,_BIT15,_BIT13,regBitsGet(0x4a2+TxCalId*4+2,_BIT15,_BIT13));
    _REGBSS(0x4a2+calId*4+3,_BIT4,_BIT0,regBitsGet(0x4a2+TxCalId*4+3,_BIT4,_BIT0));

    rf_reg_write(0x408,index);

    if ( (index<=0xf) && (index>=0x0) )
    {
        _REGBC(0x440, _BIT10);
    }
    else if( (index <= 0x1f) && (index>=0x10) )
    {
        _REGBS(0x440, _BIT10);
    }
    else
    {
        mxdDbgInfo("[mxd]acrux2ImbCalIdRecovery is set fail.  index:%x  \n",index);
    }

    return 0;
}
#define _CHANGE_INDEX_ 12
MXD_U32 acrux2ChangeIndex()
{

    MXD_U32 needChangeIdx[] = {0x00,0x03,0x06,0x09,0x0c,0x0f,0x10,0x13,0x16,0x19,0x1c,0x1f};
    MXD_U32 poutCalId[_CHANGE_INDEX_],txCalId[_CHANGE_INDEX_],paMap[_CHANGE_INDEX_],
        pgaGain[_CHANGE_INDEX_],modulator[_CHANGE_INDEX_],loftResult[_CHANGE_INDEX_],
        poutResult[_CHANGE_INDEX_],imbResult[4];
    MXD_U32 tblAddrBgn = 0xa00,calAddrBgn = 0x4a2,poutAddrBgn = 0x4ea;
    MXD_U32 paMapH,paMapL,imbIL,imbIR,imbQ;
    MXD_U32 i=0;

    for(i = 0; i < _CHANGE_INDEX_; i++) //save tbl
    {
        pgaGain[i] = regBitsGet((needChangeIdx[i]*2)+tblAddrBgn, _BIT13, _BIT10);
        paMapL = regBitsGet((needChangeIdx[i]*2)+tblAddrBgn, _BIT15, _BIT14); 
        paMapH = ( regBitsGet((needChangeIdx[i]*2)+tblAddrBgn+1, _BIT2, _BIT0)); 
        paMap[i] = (paMapH << 2) | paMapL;

        txCalId[i] = regBitsGet((needChangeIdx[i]*2)+tblAddrBgn+1, _BIT7, _BIT3); 
        rf_reg_read(calAddrBgn+txCalId[i] *4,&loftResult[i]);

        modulator[i] = regBitsGet((needChangeIdx[i]*2)+tblAddrBgn, _BIT2, _BIT0);
        poutCalId[i] =  regBitsGet((needChangeIdx[i]*2)+tblAddrBgn+1, _BIT12, _BIT8);
        poutResult[i] = regBitsGet(poutAddrBgn+poutCalId[i]*2, _BIT7, _BIT0);

        mxdDbgInfo("modulator %d ,loft %x,pgaGain %x,poutCalId %x,poutResult %x,pal %d,pah %d,pa %x\n",
                modulator[i],loftResult[i],pgaGain[i],poutCalId[i],poutResult[i],paMapL,paMapH,paMap[i]);

    }
    for(i = 0; i< 4; i++) //save imb tbl
    {
        imbQ = regBitsGet(calAddrBgn+(i+8)*4+3,_BIT12,_BIT5);
        imbIR = regBitsGet(calAddrBgn+(i+8)*4+2,_BIT15,_BIT13);
        imbIL = regBitsGet(calAddrBgn+(i+8)*4+3,_BIT4,_BIT0);

        imbResult[i] = ( ((imbIL<<3) | imbIR ) << 8) | imbQ;
        mxdDbgInfo("imb save 0x%04x    0x%04x\n",i,imbResult[i]);
    }

    for(i = 0; i < _CHANGE_INDEX_; i++) //recovery tbl
    {
        _REGBSS(tblAddrBgn+i*2,_BIT13, _BIT10, pgaGain[i]);
        paMapH = paMap[i] >> 2;
        paMapL = paMap[i] & 0x04;
        _REGBSS(tblAddrBgn+i*2,_BIT15, _BIT14, paMapL);
        _REGBSS(tblAddrBgn+i*2+1,_BIT2, _BIT0, paMapH);

        _REGBSS(tblAddrBgn+i*2+1,_BIT7, _BIT3, txCalId[i]);
        rf_reg_write(txCalId[i]*4+calAddrBgn,loftResult[i]);

        _REGBSS(tblAddrBgn+i*2,_BIT2, _BIT0, modulator[i]);
        imbQ = imbResult[modulator[i] - 2] & 0xff;
        imbIR = (imbResult[modulator[i] - 2]>>_BIT8) & 0x07;
        imbIL = (imbResult[modulator[i] - 2]>>_BIT11) & 0x1f;
        _REGBSS(txCalId[i]*4+calAddrBgn+3,_BIT12, _BIT5 ,imbQ);//imb
        _REGBSS(txCalId[i]*4+calAddrBgn+2,_BIT15, _BIT13 ,imbIR);//imb
        _REGBSS(txCalId[i]*4+calAddrBgn+3,_BIT4, _BIT0 ,imbIL);//imb

        _REGBSS(tblAddrBgn+i*2+1,_BIT12, _BIT8, poutCalId[i]);
        _REGBSS(poutAddrBgn+poutCalId[i]*2,_BIT7, _BIT0, poutResult[i]);
    }
    for(i = 12; i <=0x1f; i++)
    {
        _REGBSS(tblAddrBgn+i*2,_BIT13, _BIT10, pgaGain[11]);
        //paMapH = paMap[i] >> 2;
        //paMapL = paMap[i] & 0x04;
        _REGBSS(tblAddrBgn+i*2,_BIT15, _BIT14, paMapL);
        _REGBSS(tblAddrBgn+i*2+1,_BIT2, _BIT0, paMapH);

        _REGBSS(tblAddrBgn+i*2+1,_BIT7, _BIT3, txCalId[11]);
        rf_reg_write( regBitsGet(i*2+tblAddrBgn+1, _BIT7, _BIT3),loftResult[11]);

        _REGBSS(tblAddrBgn+i*2,_BIT2, _BIT0, modulator[11]);
        //imbQ = imbResult[modulator[i] - 2] & 0xff;
        //imbIR = (imbResult[modulator[i] - 2]>>_BIT8) & 0x07;
        //imbIL = (imbResult[modulator[i] - 2]>>_BIT11) & 0x1f;
        _REGBSS(regBitsGet(tblAddrBgn+i+1,_BIT7, _BIT3)*4+calAddrBgn+3,_BIT12, _BIT5 ,imbQ);//imb
        _REGBSS(regBitsGet(tblAddrBgn+i+1,_BIT7, _BIT3)*4+calAddrBgn+2,_BIT15, _BIT13 ,imbIR);//imb
        _REGBSS(regBitsGet(tblAddrBgn+i+1,_BIT7, _BIT3)*4+calAddrBgn+3,_BIT4, _BIT0 ,imbIL);//imb

        _REGBSS(tblAddrBgn+i*2+1,_BIT12, _BIT8, poutCalId[11]);
        _REGBSS(poutAddrBgn+regBitsGet(i*2+tblAddrBgn+1, _BIT12, _BIT8)*2,_BIT7, _BIT0, poutResult[11]);

    }

    return 0;
}
//041x sunzl add success 
int acrux2SetFreqKhzFm(MXD_U32 freqKhz)
{
    MXD_U32 flagRegAfc=0;
    MXD_U16 fmCh=freqKhz-870;
    MXD_U16 i=0;

    if ((freqKhz>1080)||(freqKhz<870))//70.0MHz~108MHz
    {
        mxdDbgInfo("[mxd]FM inputError@ castorSetFreqHKhzFm! freq=%d00kHz\n", freqKhz);
        return 1;
    }
    //acrux2LoInit();
    //  _REGBS(0x200, _BIT5);   //open FM LDO
    //  _REGBS(0x200, _BIT4);   //open FM LDO
    //  _REGBC(0x200, _BIT6);   
    //  _REGBC(0x200, _BIT7);   
    _REGBSS(0x183, _BIT4, _BIT2, 7);
    //  _REGBC(0x183, _BIT5);   
    //  _REGBC(0x183, _BIT1);   
    //  _REGBC(0x183, _BIT0);
    if(( freqKhz>=750) &&(freqKhz<=900))    //zl@@@
    {
        _REGBSS(0x18a,_BIT13,_BIT12,1);
    }
    else
    {
        _REGBSS(0x18a,_BIT13,_BIT12,2);
    }
    _REGBC(0x08c, _BIT0);   //open FM LDO

    rf_reg_write(0x089, gFmFreqKhz[fmCh*3+0]);
    rf_reg_write(0x188, gFmFreqKhz[fmCh*3+1]);
    rf_reg_write(0x189, gFmFreqKhz[fmCh*3+2]); 

    MxdSleep(10);
    rf_reg_read(0x092, &flagRegAfc);//delay 20us

    if (0==(flagRegAfc&4))
    {
        mxdDbgInfo("[mxd]FM Lo UnLock######! freq=%d00kHz\n", freqKhz);
        return 1;
    }
    else
    {
        mxdDbgInfo("[mxd]FM Locked!  freq=%d00kHz\n", freqKhz);
    }
    return 0;
}
//041x sunzl add success 
int acrux2SetFreqChWifi(MXD_U32 freqCh)
{
    MXD_U32 regVal;                     //zl@@@
    MXD_U32  wifiCh ,IsfreqMHz;

    if( (freqCh >=1) &&( freqCh <=16))// is input channel 
    {
        wifiCh = freqCh - 1;
    }
    else if ((freqCh>=2380)&&(freqCh<=2500))// is input freq 
    {
        IsfreqMHz = (freqCh-2412)%5 ; 

        if(IsfreqMHz == 0)
            wifiCh = (freqCh - 2412)/5;

        else if(freqCh == 2380)
            wifiCh = 14;

        else if(freqCh == 2500)
            wifiCh = 15;

        else
        {
            OAL_DebugPrint("pls set Wifi channel form 2380 to 2500!\n");
            return 1;
        }
    }
    else
    {
        OAL_DebugPrint("pls set Wifi channel form 1 to 16!\n");
        return 1;
    }

    //_REGBS(0x200, _BIT7); //En WiFi_LO LDO
    //_REGBC(0x200, _BIT6);
    //_REGBC(0x200, _BIT5);
    //_REGBS(0x236, _BIT1); //En WiFi LOMixer
    _REGBC(0x08e, _BIT0);   //open FM LDO

    rf_reg_write(0x8b, gFreqChWifi[wifiCh*3+0]);
    rf_reg_write(0x7c, gFreqChWifi[wifiCh*3+1]);
    rf_reg_write(0x7d, gFreqChWifi[wifiCh*3+2]);

    _REG_CHK(0x092,_BIT0);
    rf_reg_read(0x092, &regVal);
    if (0 == (regVal&1))
    {
        mxdDbgInfo("[mxd][acruxSetFreqMhzWifi] WF UnLocked!##### freqMHz=%d  freqCh=%d  tstLo= %dMhz FreqMHz = %dMhz\n", freqCh, wifiCh,(2412+5*wifiCh)*4/3,2412+5*wifiCh);
        return 1;
    }
    else
    {
        if((freqCh == 15)||(freqCh == 2380))
            mxdDbgInfo("[mxd][acruxSetFreqMhzWifi] WF Locked! freqMHz=%d  freqCh=%d  tstLo= %dMhz FreqMHz = %dMhz\n", freqCh, wifiCh,2380*4/3,2380);

        else if((freqCh == 16)||(freqCh == 2500))
            mxdDbgInfo("[mxd][acruxSetFreqMhzWifi] WF Locked! freqMHz=%d  freqCh=%d  tstLo= %dMhz FreqMHz = %dMhz\n", freqCh, wifiCh,2500*4/3,2500);

        else
            mxdDbgInfo("[mxd][acruxSetFreqMhzWifi] WF Locked! freqMHz=%d  freqCh=%d  tstLo= %dMhz FreqMHz = %dMhz\n", freqCh, wifiCh,(2412+5*wifiCh)*4/3,2412+5*wifiCh);
    }
    //_REGBS(0x237,_BIT2);
    return 0;
}
//041x sunzl add success 
int acrux2SetFreqMhzBt(MXD_U32 freqMHz)
{
    MXD_U32 flagRegAfc=0,i=0;
    MXD_U32 freqCh=0;
    MXD_U32 regVal;

    if((freqMHz<=2595) && (freqMHz >=2400))//zl@@@
    {
        freqCh=freqMHz-2400;
        mxdDbgInfo("[mxd]enter acruxSetFreqMhzBt! freqMHz = %d! \n ", freqMHz);
    }
    else if( (freqMHz<=97) && (freqMHz >=0) )//zl@@@
    {
        freqCh=freqMHz;
        mxdDbgInfo("[mxd]enter acruxSetFreqMhzBt! freqMHz = %d! \n ", freqMHz+2400);
    }
    else
    {
        mxdDbgInfo("[mxd]BT input error@acruxSetFreqMhzBt! freqMHz=%d  freqCh=%d  tstLo= %dMhz\n", freqMHz, freqCh,freqMHz*4/3);
        return 1;
    }
    //_REGBS(0x200, _BIT6);
    /************* STEP1: EN LDO ************/ 
    //_REGBS(0x236, _BIT0); //En BT LOMixer

#ifdef ACRUXII_SET_FREQ_AFC_MODE_// wyp Jun 24, 2014  old afc mode Set Freq
    _REGBS(fafc_setup_reg, _BIT0);  // set bt cfg ,lo use AFC mode 
    //_REGBS(fafc_setup_reg, _BIT1);    // if want to switch to fafc , set 0x183[0/1/5] 3 bits to 0
    _REGBS(fafc_setup_reg, _BIT5);  // FAFC mode need write  0x093~0x182 , same to acrux

    rf_reg_write(0x8a, gFreqMhzBt[freqCh*3+0]); //#define vco_lock_bt_bit (1<<2) 0x0044
    rf_reg_write(0x18c,gFreqMhzBt[freqCh*3+1]); //BT_DIVN_MSB 0x0142
    rf_reg_write(0x18d,gFreqMhzBt[freqCh*3+2]); //BT_DIVN_LSB 0x0143

#else
    rf_reg_write(fafc_idx_bt_reg,freqMHz-2400);
#endif

    rf_reg_read(0x092, &regVal);
    if (0 == (regVal&2))
    {
        mxdDbgInfo("[mxd][acruxSetFreqMhzBt] BT UnLock######! freqMHz=%d freqCh=%d tstLo= %dMhz \n", freqMHz,freqCh,freqMHz*4/3);
        return 1;
    }
    else
    {
        if((freqMHz<=2595) && (freqMHz >=2400))
            mxdDbgInfo("[mxd][acruxSetFreqMhzBt] BT Locked! freqMHz=%d  freqCh=%d  tstLo= %dMhz\n", freqMHz, freqCh,freqMHz*4/3);
        else if( (freqMHz<=95) && (freqMHz >=0) )
            mxdDbgInfo("[mxd][acruxSetFreqMhzBt] BT Locked! freqMHz=%d  freqCh=%d  tstLo= %dMhz\n", freqMHz+2400, freqCh+2400,(freqMHz+2400)*4/3);
    }


#ifdef DCOC_ARITHMETIC
    // wyp Jun 10, 2014 update dcoc
    if( (freqMHz<=2595) && (freqMHz >=2400) )
    {
        for(i=0;i<=3;i++)
        {
            acrux2ClbrDcocBtSetMem(DCOC_TIA,gGainid[i],gBtChTiaDcoc[(freqMHz-2400)/5+i]);   //tia
            acrux2ClbrDcocBtSetMem(DCOC_PGA,gGainid[i+4],gBtChPgaDcoc[(freqMHz-2400)/5+i]);//pga
        }
    }
    else if( (freqMHz<=95) && (freqMHz >=0) )//zl@@@
    {
        for(i=0;i<=3;i++)
        {
            acrux2ClbrDcocBtSetMem(DCOC_TIA,gGainid[i],gBtChTiaDcoc[freqMHz/5+i]);  //tia
            acrux2ClbrDcocBtSetMem(DCOC_PGA,gGainid[i+4],gBtChPgaDcoc[freqMHz/5+i]);//pga
        }
    }
    acrux2ClbrDcocBtSetMem(3,3,3);
#endif
    return 0;
}
// wyp Jun 24, 2014
int acrux2SetBtFreqInit(void)
{
    MXD_U32 flagRegAfc=0,i=0;
    MXD_U32 freqCh=0;
    MXD_U32 regVal=0;
    MXD_U32 tblLoAfc[96] ={0,};

    /************* EN LDO ************/ 
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT5);   //Fm ldo
    _REGBS(rfmux_LDO_EN_CFG1_reg, _BIT6);   //Bt ldo
    _REGBC(rfmux_LDO_EN_CFG1_reg, _BIT7);   //Wifi ldo
    _REGBSS(RF_LOPATH_CFG_reg,_BIT3,_BIT0,0x5); //En BT LOMixer

    _REGBS(fafc_setup_reg, _BIT0);  // set bt cfg ,lo use AFC mode 
    _REGBS(fafc_setup_reg, _BIT5);  // FAFC mode need write  0x093~0x182 , same to acrux
    for (i=0; i<=95; i++)
    {
        rf_reg_write(afc_fvco_bt_config, gFreqMhzBt[i*3+0]); //#define vco_lock_bt_bit (1<<2) 0x0044
        rf_reg_write(fafc_sdm_divn_bt_hi,gFreqMhzBt[i*3+1]); //BT_DIVN_MSB 0x0142
        rf_reg_write(fafc_sdm_divn_bt_lo,gFreqMhzBt[i*3+2]); //BT_DIVN_LSB 0x0143
        MxdSleep(1);
        //_REG_CHK(afc_SYN_STATUS_from_afc_reg, _BIT1); //check VCO_LOCK_BT 0x0055
        rf_reg_read(afc_SYN_STATUS_from_afc_reg, &regVal);
        if ( 0==( regVal & VCO_LOCK_BT_bit) )
        {
            mxdDbgInfo("Error: lock is fail! \n");      
            return 1;
        }

        rf_reg_read(afc_tune_bt_status,  &tblLoAfc[i]);     //
        mxdDbgInfo("loFafcInit: %dMHz  ::AfcVal=0x%x  | target_8a=0x%04x |  divnH_18c=0x%04x  | divnH_18d=0x%04x |    \n", 2400+i, tblLoAfc[i], gFreqMhzBt[i*2*3+0],gFreqMhzBt[i*2*3+1],gFreqMhzBt[i*2*3+2]);      

        // update sdm divn Table
        rf_reg_write( fafc_sdm_divn_bt_0_hi+i*2 ,gFreqMhzBt[i*3+1]);
        rf_reg_write( fafc_sdm_divn_bt_0_lo+i*2 ,gFreqMhzBt[i*3+2]);
        if (  0!= (i&0x01)  ) 
        {
            regVal = (  (tblLoAfc[i]<<8 ) |  tblLoAfc[i-1] );
            rf_reg_write( fafc_tune_bt_0_1+ i/2,regVal);    //          
        }

    }
    rf_reg_write(fafc_setup_reg ,0);        //set FAFC mode
    return 0;

}

void acrux2SetRfEntry(int flag) // 1: bt only 0:all idle
{
    return;
}


MXD_API_C void acrux2TxEnableNco(int flagModeFreq)
{

    MXD_U32 i=0;

    MXD_U32 regMap[]=
    {
        // nco1 config
        0x0013,0xb13b,  //500k
        0x0027,0x6270,      //  1M  //0x0013,//0x0010,//406.25k  //0x0013, // 500k
    };
    rf_reg_write(txp_nco_zero_ctrl_reg ,0x024f);// nco1 enable
    rf_reg_write(txp_txp_nco1_freq_h_reg,regMap[flagModeFreq*2]);
    rf_reg_write(txp_txp_nco1_freq_l_reg,regMap[flagModeFreq*2+1]);
    _REGBS(0x443, _BIT12);
    _REGBS(0x444, _BIT9);
    _REGBS(0x43f, _BIT12);
    _REGBS(0x440, _BIT9);

}
MXD_API_C void acrux2TxDisableNco(void)
{
    rf_reg_write(txp_nco_zero_ctrl_reg, 0x0);// nco disable
    rf_reg_write(txp_txp_nco1_freq_h_reg,0x0);
    rf_reg_write(txp_txp_nco1_freq_l_reg,0x0);

    _REGBC(0x443, _BIT12);
    _REGBC(0x444, _BIT9);
    _REGBC(0x43f, _BIT12);
    _REGBC(0x440, _BIT9);
}
void  acrux2TxEnableStd(MXD_U32 flagModeFreq)
{
    MXD_U32 mxd_value = 0,STDAvgTime = 3/*,ii*//*,reg*/;
    MXD_U16  val[]=    //cos  sin       
    {
        0x0fe2, 0x01ee,   // 500k//0x0fec, 0x0191, //406.25  //0x0fe2, 0x01ee,   // 500k
        0x0f89, 0x03d4,   // 1M   //0x0fb1, 0x031f,//406.25*2 //0x0f89, 0x03d4,   // 1M   
        0x1000, 0x0000, //0K            //0k
        0x0e2b, 0x0770, // 2M
    };
    if (flagModeFreq!=1 && flagModeFreq!=0&&flagModeFreq!=2&&flagModeFreq!=3)
    {
        mxdDbgInfo("acrux2TxEnableStd:: input error  flagModeFreq !\n");
    }
    rf_reg_write(std_std_cos_reg,val[flagModeFreq*2]); //0x0163
    rf_reg_write(std_std_sin_reg,val[flagModeFreq*2+1]); //0x0164
    _REGBS(std_std_ctrl_reg, _BIT12); //en std
}
MXD_API_C int MxdRfInit(void)
{
    //P_CLBR_PARA_S pClbrPara = (P_CLBR_PARA_S)pParaIn;
    mxdDbgInfo("MXD_SDK version V1.0   %s \n","$Rev: 45 $");
    mxdDbgInfo("MXD_SDK build time   %s - %s \n",__DATE__,__TIME__);

    acrux2ComInit();
    mxdDbgInfo("MxdRfInit:: acrux2ComInit done!\n");

    acrux2FdInit();
    mxdDbgInfo("MxdRfInit:: acrux2FdInit done! \n");

#ifdef _DCOC_WIFI_MANUAL_
    acrux2ClbrDcocWifiManual();
#else
    acrux2ClbrDcocWifi();
#endif
    mxdDbgInfo("MxdRfInit:: acrux2ClbrDcocWifi done!\n");

#if __BT
    acrux2ClbrDcocBt();
    mxdDbgInfo("MxdRfInit:: acrux2ClbrDcoc done!\n");
#endif

    //wifi tx calibration
    acrux2ClbrLoftWifi();
    mxdDbgInfo("MxdRfInit:: acrux2ClbrLoftWifi done!\n");

    acrux2ClbrTxImbWifi();
    mxdDbgInfo("MxdRfInit:: acrux2ClbrTxImbWifi done!\n");

    acrux2ClbrPoutWifi();
    mxdDbgInfo("MxdRfInit:: acrux2ClbrPoutWifi done!\n");

#if __BT
    //bt tx calibration
    acrux2ClbrLoftBt();
    mxdDbgInfo("MxdRfInit:: acrux2ClbrLoftBt done!\n");

    acrux2ClbrTxImbBt();
    mxdDbgInfo("MxdRfInit:: acrux2ClbrTxImbBt done!\n");

    acrux2ClbrPoutBt();
    mxdDbgInfo("MxdRfInit:: acrux2ClbrPoutBt done!\n");

    //acrux2ClbrRximbBt();
    //mxdDbgInfo("MxdRfInit:: acrux2ClbrRximbBt done!\n");
#endif

    //acrux2ClbrRximbWifi();
    //mxdDbgInfo("MxdRfInit:: acrux2ClbrRximbWifi done!\n");

    acrux2WorkInit();
    mxdDbgInfo("MxdRfInit:: acrux2WorkInit done!\n");

    //acrux2DbgGetRfInfo(0);
    mxdDbgInfo("MxdRfInit:: finished! \n");
    return 0;
}
MXD_API_C MXD_U32 MxdRfModeCfg(MXD_U32 modeFlags)
{
    MXD_U32 i=0;
    rf_reg_write(rfmux_maxscend_mode_table_idx_reg,modeFlags);
    if( _RF_MODE_INIT ==modeFlags )         //idle  
    {
        //MxdRfSetBtMode(0);
        //MxdRfSetWifiMode(0);
        mxdDbgInfo("[mxd] MxdRfModeCfg set _RF_MODE_INIT %d\n",modeFlags);
    }
    else if( _RF_MODE_WIFI_RX==modeFlags)   //wifi rx
    {
        //MxdRfSetBtMode(0);
        //MxdRfSetWifiMode(1);
        _REGBSS(0x20c, _BIT5, _BIT4, 0x2);  //SiP SW control  rx
        rf_reg_write(0x41d,0x0004);
        rf_reg_write(0x401,0x0003);
        mxdDbgInfo("[mxd] MxdRfModeCfg set _RF_MODE_WIFI_RX %d\n",modeFlags);
    }
    else if( _RF_MODE_WIFI_TXRX==modeFlags)   //wifi rx
    {
        //MxdRfSetBtMode(0);
        //MxdRfSetWifiMode(1);
        _REGBSS(0x20c, _BIT5, _BIT4, 0x1);  //SiP SW control  rx
        rf_reg_write(0x41d,0x0004);
        rf_reg_write(0x401,0x0003);
        _REGBC(0x440, _BIT4);   // wyp Jul 16, 2014  Lo unlock , on/off pa,Lo lock 
        _REGBS(0x440, _BIT4);
        mxdDbgInfo("[mxd] MxdRfModeCfg set _RF_MODE_WIFI_TXRX %d\n",modeFlags);
    }
    else if( _RF_MODE_BT_RX==modeFlags)     //bt rx
    {
        //MxdRfSetBtMode(1);
        //MxdRfSetWifiMode(0);
        _REGBSS(0x20c, _BIT5, _BIT4, 0x1);  //SiP SW control  rx
        rf_reg_write(0x41d,0x0002);
        rf_reg_write(0x401,0x0009);
        mxdDbgInfo("[mxd] MxdRfModeCfg set _RF_MODE_BT_RX %d\n",modeFlags);
    }
    else if( _RF_MODE_WIFI_TX==modeFlags)   //wifi tx
    {
        //MxdRfSetBtMode(0);
        //MxdRfSetWifiMode(1);
        //_REGBSS(0x20c, _BIT5, _BIT4, 0x2);  //SiP SW control  tx
        //rf_reg_write(0x41d,0x0010);
        //rf_reg_write(0x401,0x0003);
        //_REGBC(0x440, _BIT4);   // wyp Jul 16, 2014  Lo unlock , on/off pa,Lo lock 
        //_REGBS(0x440, _BIT4);
        //mxdDbgInfo("[mxd] MxdRfModeCfg set _RF_MODE_WIFI_TX %d\n",modeFlags);
    }
    else if( _RF_MODE_BT_TX==modeFlags)     //bt tx
    {
        //MxdRfSetBtMode(1);
        //MxdRfSetWifiMode(0);
        _REGBSS(0x20c, _BIT5, _BIT4, 0x2);  //SiP SW control  tx
        rf_reg_write(0x41d,0x0008);
        rf_reg_write(0x401,0x0011);
        mxdDbgInfo("[mxd] MxdRfModeCfg set _RF_MODE_BT_TX %d\n",modeFlags);
    }
    else    //fail
    {
        mxdDbgInfo("[mxd] MxdRfModeCfg set mode fail! please check modeflags:%d",modeFlags);
    }
    return 0;
}


int MxdRfGetClbrPara(P_CLBR_PARA_S pClbrPara)
{
    return 0;
}

int MxdRfSetClbrPara(P_CLBR_PARA_S pClbrPara)
{
    return 0;
}

MXD_API_C int MxdRfSetBtMode(unsigned short flagEn1Dis0)    // flag =1 work  0:idle
{
    MXD_U32 flagStatusBt=0;

    mxdDbgInfo("[mxd]enter MxdRfSetBtMode!, flagEn1Dis0 = %d. \n ", flagEn1Dis0);
    if (0==flagEn1Dis0)
    {    //idle
        /************* STEP1: EN LDO ************/ 
        //_REGBC(0x200, _BIT6); //disable bt lo
        _REGBC(0x236, _BIT0);   //dis BT LOMixer
        _REGBC(0x236, _BIT2);   //dis BT LOMixer
        mxdDbgInfo("[mxd]BT Mode disable!\n ");
    }
    else if (1==flagEn1Dis0)
    {
        /************* STEP1: EN LDO ************/ 
        //_REGBS(0x200, _BIT6); //enable bt lo
        _REGBS(0x236, _BIT0);   //En BT LOMixer
        _REGBS(0x236, _BIT2);   //En wf LOMixer
        mxdDbgInfo("[mxd]BT Mode enable!\n ");
    }
    return 0;
}
MXD_API_C int MxdRfSetWifiMode(unsigned short flagEn1Dis0)    // flag =1 work  0:idle
{
    MXD_U32 flagStatusWifi=0;

    mxdDbgInfo("[mxd]enter MxdRfSetWifiMode!, flagEn1Dis0 = %d. \n ", flagEn1Dis0);
    if (0==flagEn1Dis0)
    {    //idle
        /************* STEP1: DIS LDO ************/ 
        //_REGBC(0x200, _BIT7); //disable wf lo
        _REGBC(0x236, _BIT1);   //dis wf LOMixer
        _REGBC(0x236, _BIT3);   //dis wf LOMixer
        mxdDbgInfo("[mxd]Wifi Mode disable!\n ");
    }
    else if (1==flagEn1Dis0)
    {//work
        /************* STEP1: EN LDO ************/ 
        //_REGBS(0x200, _BIT7); //enable wf lo
        _REGBS(0x236, _BIT1);   //En wf LOMixer
        _REGBS(0x236, _BIT3);   //En wf LOMixer
        mxdDbgInfo("[mxd]Wifi Mode enable!\n ");
    }
    return 0;
}
int MxdRfSetFmMode(unsigned short flagEn1Dis0)    // flag =1 work  0:idle
{
    MXD_U32 flagStatusFm=0;

    mxdDbgInfo("[mxd]enter MxdRfSetFmMode!, flagEn1Dis0 = %d. \n ", flagEn1Dis0);
    if (0==flagEn1Dis0)
    {    //idle
        /************* STEP1: DISLDO ************/ 
        //_REGBC(0x200, _BIT5); //open FM LDO
        //_REGBC(0x200, _BIT4); //open FM LDO
        mxdDbgInfo("[mxd]Fm Mode disable!\n ");
    }
    else if (1==flagEn1Dis0)
    {//work
        /************* STEP1: EN LDO ************/ 
        //_REGBS(0x200, _BIT5); //open FM LDO
        //_REGBS(0x200, _BIT4); //open FM LDO
        mxdDbgInfo("[mxd]Fm Mode enable!\n ");
    }
    return 0;   

}
MXD_API_C int MxdRfSetFreqMHzBt(unsigned int freqMHz)
{
    /*
       if(0 == acrux2SetFreqMhzBt(freqMHz))
       return 0;
       return 1;
       */
    return (acrux2SetFreqMhzBt(freqMHz));
}

MXD_API_C int MxdRfSetFreqChWifi(unsigned int freqCh)
{
    return (acrux2SetFreqChWifi(freqCh));
}


int MxdRfSetFreqKHzFm(unsigned int freqKHz)
{
    return (acrux2SetFreqKhzFm(freqKHz));
}


MXD_API_C void MxdRfWorkModeSel(unsigned short flagBB_MXD)
{
    if(0 == flagBB_MXD)
    {
        _REGBC(0x400, _BIT0);
        _REGBC(0x401, _BIT0);
    }
    else //(1 == flagBB_MXD)
    {
        _REGBC(0x400, _BIT0);
        _REGBS(0x401, _BIT0);
    }

}

MXD_API_C void MxdRfGainModeSel(unsigned short flagBB_MXD)
{
    if(0 == flagBB_MXD)
    {
        rf_reg_write(0x400, 0x0);
        rf_reg_write(0x401, 0x0);
    }
    else //(1 == flagBB_MXD)
    {
        rf_reg_write(0x400, 0x0);
        //rf_reg_write(0x401, 0x0);
    }
}

#ifdef __MATLAB_DLL__

MXD_API_C int MxdTestDll(int numberA, int numberB )
{
    return (numberA+numberB);
}



MXD_API_C int MxdOpenDevice(void)
{
    gpDevice = NULL;
    gpDevice = MxdPorting_SetupMasterSpi( 1,SPI_CPOL0_CPHA0, 20000 );
    if (NULL==gpDevice)
        return 1;
    else
        return 0;
}
MXD_API_C int MxdCloseDevice(void)
{
    if(NULL==gpDevice)
    {
        return 1;
    }
    else
    {
        MxdPorting_StopMasterSpi(gpDevice);
    }
    return 0;
}
#endif



MXD_API_C MXD_U32 MxdRbusRead(MXD_U32 Addr)
{
    MXD_U32 val=0;
    rf_reg_read(Addr,&val);
    return val;
}
MXD_API_C void MxdRbusWrite(MXD_U32 Addr,MXD_U32 Value)
{
    rf_reg_write(Addr,Value);
}


MXD_API_C int MxdRfSetTxGainBt(unsigned int gainId)
{
    _REGBSS(rfmux_bttx_mxd_gidx_reg, _BIT3, _BIT0, gainId);
    return 0;
}
MXD_API_C int MxdRfSetRxGainBt(unsigned int gainId)
{
    _REGBSS(rfmux_btrx_map_control_mxd_reg, _BIT4,  _BIT0, gainId);
    _REGBSS(rfmux_btrx_map_control_mxd_reg, _BIT12, _BIT8, gainId);
    return 0;
}
MXD_API_C int MxdRfSetTxGainWifi(unsigned int gainId)
{
    _REGBSS(rfmux_wftx_gidx_reg, _BIT4, _BIT0, gainId);
    acrux2ImbCalIdRecovery(gainId);
    return 0;
}
MXD_API_C int MxdRfSetRxGainWifi(unsigned int gainId)
{
    _REGBSS(rfmux_wfrx_map_control_reg, _BIT4,  _BIT0, gainId);
    _REGBSS(rfmux_wfrx_map_control_reg, _BIT12, _BIT8, gainId);
    return 0;
}

void MxdRfPulse(MXD_S32 rssi,MXD_U32 rate1, MXD_U32 rate2) // 0: auto   1: cfgAci 2: cfgSens.
{
}
void MxdPowerDown(MXD_U16 flags)
{
    if( 1==flags )
    {
        __POWER_DOWN__;
        mxdDbgInfo("[mxd]Input MxdPowerDown \n");
    }
    else if( 0==flags )
    {
        __PRESET_MODE__;
        __FUNCTION_MODE__;
        mxdDbgInfo("[mxd]Output MxdPowerDown \n");
    }
    else
    {
        mxdDbgInfo("[mxd]MxdPowerDown fail, flags = %d\n",flags);
    }
}
void MxdRfTxrxPinCtrl()
{
    mxdDbgInfo("TX_EN no ap\n");
}




MXD_U32 acrux2ReadTmpr(void)
{
    MXD_U32 tmprVal=0;
    int i=0;
    rf_reg_write(RF_TEMP_SENSE_reg,0);
    _REGBS(RF_TEMP_SENSE_reg,8);    //enable
    //ldo cfg
    _REGBSS(0x200,_BIT3, _BIT0,0xf);
    _REGBS(0x201,_BIT0);
    _REGBS(0x201,_BIT9);


    for(i=7;i>=0;i--)
    {
        _REGBS(RF_TEMP_SENSE_reg,i);
        rf_reg_read(ioproc_TEMP_SENSE_OUT,&tmprVal);
        if(0 != tmprVal)
            _REGBC(RF_TEMP_SENSE_reg,i);
    }

    tmprVal = regBitsGet(RF_TEMP_SENSE_reg, _BIT7, _BIT0);
    mxdDbgInfo("[mxd test]  Temperature tese val:   %x\n",tmprVal);
    return tmprVal;
}

int MxdRfReadTmpr(void)
{
    return(acrux2ReadTmpr());
}

int MxdRfSetWifiAci(MXD_U32 aciFlag)
{
    return (acrux2WifiAciCfg(aciFlag));
}
int MxdRfSetBtAci(MXD_U32 aciFlag)
{
    return (acrux2BtAciCfg(aciFlag));
}


