/**
 ****************************************************************************************
 *
 * @file phy_sdmb2b.c
 *
 * @brief
 *
 * Copyright (C) RivieraWaves 2014-2019
 *
 ****************************************************************************************
 */


#include "rwnx_config.h"
#include "phy.h"
#include "dbg.h"
#include "rd.h"
#include "reg_mac_core.h"

/// PHY driver context.
struct phy_env_tag
{
    /// Currently configured channel
    struct mac_chan_op chan;
};

struct phy_env_tag phy_env;

void phy_init(const struct phy_cfg_tag *cfg)
{
    phy_env.chan.band         = PHY_BAND_5G;
    phy_env.chan.type         = PHY_CHNL_BW_OTHER;
    phy_env.chan.prim20_freq  =
    phy_env.chan.center1_freq =
    phy_env.chan.center2_freq = PHY_UNUSED;

    // Adjust the MAC HW timings to the reduced clocking we are using on the SDM B2B setup
    nxmac_timings_1_set(0x02805050);
    nxmac_timings_2_set(0x0002D009);
    nxmac_timings_3_set(0x05014190);
    nxmac_timings_5_set(0x0003200A);
    nxmac_timings_6_set(0x00028010);
    nxmac_timings_9_set(0x19028050);
}

void phy_reset(void)
{
}

void phy_mdm_isr(void)
{
}

void phy_rc_isr(void)
{
}

void phy_get_version(uint32_t *version_1, uint32_t *version_2)
{
}

void phy_set_channel(const struct mac_chan_op *chan, uint8_t index)
{
    phy_env.chan = *chan;
}

void phy_get_channel(struct phy_channel_info *info, uint8_t index)
{
    // Map the band, channel type, primary channel index on info1
    info->info1 = phy_env.chan.band | (phy_env.chan.type << 8) | (phy_env.chan.prim20_freq << 16);
    // Map center freq on info2
    info->info2 = phy_env.chan.center1_freq | (phy_env.chan.center2_freq << 16);
}

void phy_stop(void)
{
}

uint32_t phy_get_channel_switch_dur(void)
{
    return 1500;
}

bool phy_has_radar_pulse(int rd_idx)
{
    return false;
}

bool phy_get_radar_pulse(int rd_idx, struct phy_radar_pulse *pulse)
{
    return false;
}

#if NX_DEBUG_DUMP
void phy_get_diag_state(struct dbg_debug_info_tag *dbg_info)
{
}
#endif

bool phy_uf_supported(void)
{
    return false;
}

void phy_uf_enable(bool enable)
{
}

bool phy_vht_supported(void)
{
    return false;
}

bool phy_he_supported(void)
{
    return false;
}

bool phy_ldpc_tx_supported(void)
{
    return false;
}

bool phy_ldpc_rx_supported(void)
{
    return false;
}

bool phy_bfmee_supported(void)
{
    return false;
}

bool phy_bfmer_supported(void)
{
    return false;
}

bool phy_mu_mimo_rx_supported(void)
{
    return false;
}

bool phy_mu_mimo_tx_supported(void)
{
    return false;
}

#if RW_MUMIMO_RX_EN
void phy_set_group_id_info(uint32_t membership_addr, uint32_t userpos_addr)
{
}
#endif

void phy_set_aid(uint16_t aid)
{
}

uint8_t phy_get_bw(void)
{
    return 0;
}

uint8_t phy_get_nss(void)
{
    return 0;
}

uint8_t phy_get_ntx(void)
{
    return (0);
}

uint8_t phy_get_nrx(void)
{
    return (0);
}

uint8_t phy_get_bfr_mem_size(void)
{
    return (0);
}

void phy_get_rf_gain_idx(int8_t *power, uint8_t *idx)
{
    /* TO BE COMPLETED. For now set idx to power for debug */
    *idx = (uint8_t)*power;
}

void phy_get_rf_gain_capab(int8_t *max, int8_t *min)
{
    /* TO BE UPDATED with correct value */
    *max = 25; // dBm
    *min = 0;  // dBm
}

uint8_t phy_switch_antenna_paths(void)
{
    return 0;
}
