/**
 ****************************************************************************************
 *
 * @file phy_colibri.c
 *
 * @brief File containing the nX Radio physical layer driver API.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup PHY
 * @{
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
// for configuration dependent directives
#include "rwnx_config.h"
#include "dbg.h"
#include "phy.h"

/*
 * GLOBALS
 ****************************************************************************************
 */
/// Global PHY driver environment.
struct phy_env_tag phy_env;


/*
 * FUNCTION DEFINITIONS
 ****************************************************************************************
 */
/// @todo Add mode information parameter: 11n, 11a/g, 11b...
void phy_set_channel(const struct mac_chan_op chan, uint8_t index)
{
    dbg(D_PHY D_INF "Switch to center1_idx %d, band %d\n", center1_idx, band);
}

void phy_stop(void)
{
}


/**
 ****************************************************************************************
 * @brief Radio initialization function.
 * This function is called at radio power up or after a radio reset(phy_stop()).
 * It resets the radio, turns on PLL, calibrates the oscillator to 40MHz,
 * turns on channels, calibrates PLL on 2440MHz and calibrates the filters.
 ****************************************************************************************
 */
void phy_init(void)
{
}

/// @}
