/**
 ****************************************************************************************
 *
 * @file rwnx_platform.c
 *
 * @brief RWNX reference platform initialization.
 *
 * Copyright (C) RivieraWaves 2019-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup PLATFORM_DRIVERS
 * @{
 ****************************************************************************************
 */

#include "rwnx_config.h"
#include "crm.h"
#include "sysctrl.h"
#include "intc.h"
#include "button.h"
#include "ipc_emb.h"
#include "dma.h"
#include "la.h"


void rwnx_platform_init(void)
{
    // MAC/MODEM Clock initialization
    crm_init();
    // system controller initialization
    sysctrl_init();
    // configure the interrupt controller
    intc_init();
    // initialize push button
    button_init();
    // initialize the IPC on the embedded side
    ipc_emb_init();
    // initialize the DMA
    dma_init();
    #if NX_DEBUG_DUMP
    // initialize the embedded logic analyzer
    la_init();
    #endif
}

/// @}


