/**
 ****************************************************************************************
 *
 * @file sysctrl.c
 *
 * @brief Definition of the reference platform system controller block.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */

/**
 ****************************************************************************************
 * @addtogroup SYS_CNTRL
 * @{
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "sysctrl.h"
#include "reg_sysctrl.h"


/// Clock gating mask
#define CLOCK_GATING_BITS (SYSCTRL_MAC_PI_CLK_GATING_EN_BIT | SYSCTRL_MAC_PI_TX_CLK_GATING_EN_BIT |\
                           SYSCTRL_MAC_PI_RX_CLK_GATING_EN_BIT | SYSCTRL_MAC_CORE_CLK_GATING_EN_BIT |\
                           SYSCTRL_MAC_CRYPT_CLK_GATING_EN_BIT | SYSCTRL_MAC_CORE_TX_CLK_GATING_EN_BIT |\
                           SYSCTRL_MAC_CORE_RX_CLK_GATING_EN_BIT | SYSCTRL_MAC_WT_CLK_GATING_EN_BIT |\
                           SYSCTRL_MPIF_CLK_GATING_EN_BIT)

void sysctrl_init(void)
{
    // Set DIAG MUX
    sysctrl_diag_conf1_set(SYSCTRL_DIAG_SEL_EN_BIT | DIAG_MAC);

    // Enable Clock gating
    sysctrl_misc_cntl_set(sysctrl_misc_cntl_get() | CLOCK_GATING_BITS);
}

/// @}
