/**
 ****************************************************************************************
 *
 * @file sysctrl.h
 *
 * @brief Declaration of the reference platform system controller block.
 *
 * Copyright (C) RivieraWaves 2011-2019
 *
 ****************************************************************************************
 */
#ifndef _SYSCTRL_H_
#define _SYSCTRL_H_

/**
 ****************************************************************************************
 * @defgroup SYS_CNTRL SYS_CNTRL
 * @ingroup PLATFORM_DRIVERS
 * @brief Declaration of the System Control.
 * @{
 ****************************************************************************************
 */

/*
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "co_math.h"
#include "reg_sysctrl.h"

/*
 * MACROS
 ****************************************************************************************
 */
/// @name GPIO definitions
/// @{

/// LED indicating the CPU is sleeping
#define LED_SLEEP         CO_BIT(2)
/// LED indicating the CPU is running
#define LED_RUN           CO_BIT(0)
/// LED indicating a reception
#define LED_RX            CO_BIT(1)
/// Macro to output a value on the GPIOs
#define GPIO_OUT(val)     sysctrl_gpio_out_set(val)
/// Macro to enable LED
#define LED_ON(led)       sysctrl_gpio_out_set(sysctrl_gpio_out_get() | (led))
/// Macro to disable LED
#define LED_OFF(led)      sysctrl_gpio_out_set(sysctrl_gpio_out_get() & ~(led))

/// @}


/// @name DIAG control definitions
/// These values defines the effect on the DIAGMUX
/// @{

/// MICTOR test
#define DIAG_MICTOR_TEST     0
/// Debug diags
#define DIAG_DBG             1
/// Target0 diags
#define DIAG_TARGET0         2
/// Target1 diags
#define DIAG_TARGET1         3
/// DMA0 diags
#define DIAG_DMA0            4
/// DMA1 diags
#define DIAG_DMA1            5
/// JTAG diags
#define DIAG_JTAG            6
/// TAP diags
#define DIAG_TAP             7
/// Processor diags
#define DIAG_PROC            8
/// PLF0 diags
#define DIAG_PLF0            9
/// PLF1 diags
#define DIAG_PLF1            10
/// PLF2 diags
#define DIAG_PLF2            11
/// MAC HW diags
#define DIAG_MAC             12

/// @}


/**
 ****************************************************************************************
 * @brief Initialize the reference platform system controller
 ****************************************************************************************
 */
void sysctrl_init(void);

/// @}

#endif // _SYSCTRL_H_
