#!/bin/bash

# generate memory information in order to track mem change and easily get FW size.
# work only for APS-GCC

##### FUNCTIONS DEFINITIONS ######
generate_memory_info() {
    # target build directory using TARGET name
    local target_build_dir="$1/build/$3"
    # location of compiled APS FW.elf
    local comp_fw="${target_build_dir}/fw.elf"
    # global memory information file
    local global_mem_info_file="$4/meminfo/meminfo_aps.csv"

    # mem_size
    local mem_size="Error,Error,Error,Error"  
    echo "TARGET_COMPILE = $2"
	echo "BUILD_FOLDER = $3"
    echo "COMP_FW = ${comp_fw}"

    if [ -e ${comp_fw} ] ; then
        # Retrieve memory information using aps-size
		mem_size=`aps-size "${comp_fw}" | grep "${comp_fw}" | sed "s/[ \t][\t ]*/,/g" | cut -d , -f 2-5`
	
		# Compute the binary size (Text + Data)
		IFS=',' read -ra SIZE <<< "$mem_size"
		let total=${SIZE[0]}+${SIZE[1]}
	    
        # create dedicated meminfo csv file
        mkdir -p $4/meminfo

		local mem_info_file="$4/meminfo/$2.csv"
        echo "mem_info_file = ${mem_info_file}"
		echo "Text,Data,Bss,Total_elf,Total" > $mem_info_file
		echo "${mem_size},${total}" >> $mem_info_file 
    fi

	# Create global memory info file if does not exist
	if ! [ -e ${global_mem_info_file} ]
	then
		echo "Target,Text,Data,Bss,Total_elf,Total" > $global_mem_info_file
	fi
	
    # Append memory information to meminfo file
    echo "$2,${mem_size},${total}" >> $global_mem_info_file
}


####################     MAIN CODE     #########################

# Retrieve the parameters: base_directory, compilation target, build_folder mem_info_dir
# Example: ./build_mem_info.sh ../../.. lmac1 lmac_aps3_trident ./logs/logs_2015_12_02
base_dir=$1
target_proj=$2
build_dir=$3
mem_info_dir=$4

# Now generate memory information
generate_memory_info "${base_dir}" "${target_proj}" "${build_dir}" "${mem_info_dir}"
