"""SCons.Tool.gcc

Tool-specific initialization for cevaXx

There normally shouldn't be any need to import this module directly.
It will usually be imported through the generic SCons.Tool.Tool()
selection method.

"""

#
# Copyright (c) 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008 The SCons Foundation
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
# KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
# WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

__revision__ = ""

import os
import os.path
import string
import sys

import SCons.Action
import SCons.Builder
import SCons.Defaults
import SCons.Tool
import SCons.Util

def exists(env):
    return find(env)

def generate(env):

    # Mostly it is the same as gcc and friends...
    gnu_tools = ['gcc', 'gnulink', 'ar', 'gas']
    for tool in gnu_tools:
        SCons.Tool.Tool(tool)(env)

    #=====================================================================================
    # Paths for tools environment
    #=====================================================================================
    try:
        ceva_x_path = os.environ['CEVAXTOOLS']
    except KeyError:
        print "CevaXx tools install error"
        raise

    #path to all tool executables - no bin folder, all directly in CEVAXTOOLS path
    for n in os.environ:
       env['ENV'][n] = os.environ[n]
    env.PrependENVPath('PATH', os.path.normpath(ceva_x_path))
    #env.PrependENVPath('PATH', ceva_license_path)

    #the toolchain needs the path to the tools to find other files
    env['ENV']['CEVAXTOOLS'] = ceva_x_path

    #CEVA tools require a clear TMP path, use Windows one or create a new one
    #env['ENV']['LM_LICENSE_FILE'] = os.environ['LM_LICENSE_FILE']
    if sys.platform == 'win32':
        env['ENV']['TEMP'] = os.environ['TEMP']
        env['ENV']['TMP'] = os.environ['TMP']

    #Libs     - may be unused if linker file readds them
    env.Append(LIBPATH = [ os.path.normpath(ceva_x_path), os.path.normpath(ceva_x_path + '\\libs') ])

    #=====================================================================================
    # Tools to launch
    #=====================================================================================
    env['CC'] = 'cevaxcc'
    env['AS'] = 'cevaxasm'
    env['LINK'] = 'cofflnk'

    #file extensions
    env['OBJSUFFIX'] = '.o'
    env['PROGSUFFIX'] = '.a'

    #=====================================================================================
    # Tool options
    #=====================================================================================
    #from command line or env_init in scutils
    env['CCCPU'] = '${_concat("-TARG:arch=", CPU, "", __env__)}'
    env['CEVAOPTIM'] = '${_concat("-O", OPTIM, "", __env__)}'

    env['ASCPU'] = '${_concat("-", CPU, "", __env__)}'
    # linker info file target
    env['LINKINFO'] = '${_concat("-l ", LINKINFOFILE, "", __env__)}'
    # linker script - normally not an option but the last argument in linker command line call
    env['LINKMAP'] = '${_concat("", LINKMAPFILE, "", __env__)}'
    env.Append(_LIBFLAGS = " $LINKINFO $LINKMAP")

    #=====================================================================================
    # Tools command line formation
    #=====================================================================================
    #call of CEVA compiler
    env['CCCOM'] = '$CC -o $TARGET $CCCPU $CEVAOPTIM $CCFLAGS $TRACEFLAGS $_CCCOMCOM $SOURCES'
    #call of CEVA Assembler
    env['ASCOM'] = '$AS $ASCPU $ASFLAGS -o $TARGET $SOURCES'
    #call of CEVA linker
    env['LINKCOM'] = '$LINK -o $TARGET $LINKFLAGS $LINKINFO $LINKMAP'#$__RPATH  $SOURCES  $_LIBDIRFLAGS $_LIBFLAGS

    #=====================================================================================
    # Code and Data memory base addresses
    #=====================================================================================
    env['CODE_MEM'] = {'base_add': 0x00000000, 'endianness': 'big'};
    env['DATA_MEM'] = {'base_add': 0x00800000, 'endianness': 'little'};

    #=====================================================================================
    # Register generation related
    #=====================================================================================
    #Specific ENV variable used for register generation - stdint will not be used due to co_types defines
    #env['REG_GEN_STDINT_NOT_AVAIL'] = False


