"""SCons.Tool.gcc

Tool-specific initialization for gcc 

There normally shouldn't be any need to import this module directly.
It will usually be imported through the generic SCons.Tool.Tool()
selection method.

"""

#
# Copyright (c) 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008 The SCons Foundation
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
# KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
# WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#


import os
import os.path
import string

import SCons.Action
import SCons.Builder
import SCons.Defaults
import SCons.Tool
import SCons.Util
import cc

# define the suffixes that are supported
CSuffixes = ['.c', '.C']

# This is what we search for to find mingw:
key_program = 'gcc'

def find(env):
    # First search in the SCons path and then the OS path:
    return env.WhereIs(key_program) or SCons.Util.WhereIs(key_program)

def generate(env):
    # define C compilation rules
    static_obj, shared_obj = SCons.Tool.createObjBuilders(env)
    
    for suffix in CSuffixes:
        static_obj.add_action(suffix, SCons.Defaults.CAction)
        shared_obj.add_action(suffix, SCons.Defaults.ShCAction)
        static_obj.add_emitter(suffix, SCons.Defaults.StaticObjectEmitter)
        shared_obj.add_emitter(suffix, SCons.Defaults.SharedObjectEmitter)
    
    env['CC'] = 'gcc'

    env['CCCOM']     = '$CC -g $_CPPINCFLAGS -c $SOURCES -o $TARGET'

    SCons.Tool.createProgBuilder(env)

    env['LINK'] = 'gcc'
  
    env['LINKCOM']     = '$LINK -o $TARGET $_LIBDIRFLAGS $SOURCES  '
    
    env['INCPREFIX']  = '-I'
    env['INCSUFFIX']  = ''
 
    env['LIBLINKPREFIX']= ''
    env['LIBLINKSUFFIX']= '.a'
   
    env['OBJSUFFIX'] = '.o'
    env['LIBPREFIX'] = '-l'
    env['LIBSUFFIX'] = ''
 
def exists(env):
    return find(env)
