"""SCons.Tool.gcc

Tool-specific initialization for Microblaze GCC provided by Petalogix

There normally shouldn't be any need to import this module directly.
It will usually be imported through the generic SCons.Tool.Tool()
selection method.
"""

__revision__ = ""

import os
import os.path
import string

import SCons.Action
import SCons.Builder
import SCons.Defaults
import SCons.Tool
import SCons.Util

#mbgcc_prefix = 'mb-linux-'
mbgcc_prefix = 'microblaze-uclinux-'
#mbgcc_version = '4.1.2'
#mbgcc_target = 'microblaze-linux-elf'

def exists(env):
    return find(env)

def find(env):
    try:
        mbgcc_path = os.environ['GCC_PETA_PATH']
    except KeyError:
        print "MICROBLAZE GCC install error: please set GCC_PETA_PATH, for instance:\n" \
            + "/opt/microblaze-uclinux-tools"
        raise
    # First search in the SCons path and then the OS path:
    return mbgcc_path

def generate(env):

    # Mostly it is the same as gcc and friends...
    gnu_tools = ['gcc', 'g++', 'gnulink', 'ar', 'gas']
    for tool in gnu_tools:
        SCons.Tool.Tool(tool)(env)

    # retrieve the gnuarm install directory, and add it to bin and lib paths
    mbgcc_path = find(env)
    env.PrependENVPath('PATH', os.path.join(mbgcc_path, 'bin'))
    #env.Append(LIBPATH = [ gnuarm_path, os.path.join(mbgcc_path, '../../../../arm-elf/lib') ])

    # retrieve the parameters of the compilation
    env['MBCPU'] = '${_concat("-mcpu=", CPU, "", __env__)}'
    env['MBOPTIM'] = '${_concat("-O", OPTIM, "", __env__)}'

    #... but a few things differ:

    # add some flags common to C and C++ and to assembly
    env['CC'] = mbgcc_prefix + 'gcc'
    env['CCCOM']    = '$CC -o $TARGET -c $MBCPU $MBOPTIM $CCFLAGS $_CCCOMCOM $SOURCES'

    env['AS'] = mbgcc_prefix + 'as'
    env['ASCOM']    = '$AS $MBCPU $ASFLAGS -o $TARGET $SOURCES'

    env.PrependENVPath('PATH', os.path.join(mbgcc_path, 'bin'))

    # add the info file output in the link flags if LINKINFOFILE exists
    #env['LINKINFO'] = '-Xlinker -Map -Xlinker $LINKINFOFILE'
    env['LINKINFO'] = '${_concat(" -Xlinker -Map -Xlinker", LINKINFOFILE, "", __env__)}'

    #env['LINKINFO'] = ' -Map $LINKINFOFILE '
    # add the linker script at the end of the link command line

    #if 'LINKMAPFILE' not in env:
    #    os.path.join(mbgcc_path, 'microblaze-uclinux/lib'),

    #env['LINKMAP'] = ' -T $LINKMAPFILE '
    #env.Append(LINKFLAGS = " $LINKINFO $LINKMAP")



    #env.Append(LINKFLAGS = " -r "
        #+ os.path.join(mbgcc_path, 'microblaze-uclinux/lib/crt0.o') + " " )
        #+ os.path.join(mbgcc_path, 'lib/gcc/microblaze-uclinux/3.4.1/crti.o') + " "
        #+ os.path.join(mbgcc_path, 'lib/gcc/microblaze-uclinux/3.4.1/crtbegin.o') + " ")

    #env.Append(LIBS = ['c', 'gcc'])

    env['LINKFLAGS'] += ['$LINKINFO']
    env['LINK'] = mbgcc_prefix + 'gcc'
    #env.Append(LIBPATH = [
        #os.path.join(mbgcc_path, 'microblaze-uclinux/lib'),
        #os.path.join(mbgcc_path, 'lib/gcc/microblaze-uclinux/3.4.1')] )

    # Some setting from the platform also have to be overridden:
    env['OBJSUFFIX'] = '.o'
    env['LIBPREFIX'] = ''
    env['LIBSUFFIX'] = '.a'
    env['PROGSUFFIX'] = ''

