"""SCons.Tool.gcc

Tool-specific initialization for Microblaze GCC provided by Xilinx

There normally shouldn't be any need to import this module directly.
It will usually be imported through the generic SCons.Tool.Tool()
selection method.
"""

__revision__ = ""

import os
import os.path
import string

import SCons.Action
import SCons.Builder
import SCons.Defaults
import SCons.Tool
import SCons.Util

def exists(env):
    return find(env)

def find(env):
    try:
        mbgcc_path = os.environ['GCC_XILINX_PATH']
    except KeyError:
        print "MICROBLAZE GCC install error: please set GCC_XILINX_PATH, for instance:\n" \
            + "???"
        raise
    # First search in the SCons path and then the OS path:
    return mbgcc_path

def generate(env):

    # Mostly it is the same as gcc and friends...
    gnu_tools = ['gcc', 'g++', 'gnulink', 'ar', 'gas']
    for tool in gnu_tools:
        SCons.Tool.Tool(tool)(env)

    # retrieve the gnuarm install directory, and add it to bin and lib paths
    mbgcc_path = find(env)
    env.PrependENVPath('PATH', os.path.join(mbgcc_path, 'bin'))
    env.Append(LIBPATH = [ mbgcc_path ]) #, os.path.join(mbgcc_path, 'bin') ])

    # retrieve the parameters of the compilation
    env['MBCPU'] = '${_concat("-mcpu=", CPU, "", __env__)}'
    env['MBOPTIM'] = '${_concat("-O", OPTIM, "", __env__)}'

    #... but a few things differ:

    # add some flags common to C and C++ and to assembly
    env['CC'] = 'mb-gcc'
    env['CCCOM']    = '$CC -o $TARGET -c $MBCPU $MBOPTIM $CCFLAGS $_CCCOMCOM $SOURCES'

    env['AS'] = 'mb-as'
    env['ASCOM']    = '$AS $MBCPU $ASFLAGS -o $TARGET $SOURCES'

    # add the info file output in the link flags
    #env['LINKINFO'] = '${_concat("-Map ", LINKINFOFILE, "", __env__)}'
    env['LINKINFO'] = ' -Xlinker -Map -Xlinker $LINKINFOFILE '
    # add the linker script at the end of the link command line
    #env['LINKMAP'] = '${_concat("-T", LINKMAPFILE, "", __env__)}'
    #env['LINKMAP'] = ' $LINKMAPFILE '
    env.Append(_LIBFLAGS = " $LINKINFO $LINKMAP $MBCPU ")
    env['LINK'] = 'mb-gcc'
    #env.Append(_LIBFLAGS = " $LINKSCRIPT $MBCPU ")

    # Some setting from the platform also have to be overridden:
    env['OBJSUFFIX'] = '.o'
    env['LIBPREFIX'] = ''
    env['LIBSUFFIX'] = '.a'
    env['PROGSUFFIX'] = ''

