//===== Copyright  1996-2005, Valve Corporation, All rights reserved. ======//
//
// Purpose: 
//
//===========================================================================//

#ifndef COLORFORMAT_H
#define COLORFORMAT_H

#ifdef _WIN32
#pragma once
#endif

#include <stdio.h>
#include "mathlib/vector.h"
#include "mathlib/vector2d.h"
#include "mathlib/vector4d.h"
#include "mathlib/vertexcolor.h"

enum ColorFormat_t
{
	COLOR_FORMAT_UNKNOWN = 0,
	COLOR_FORMAT_R32G32B32A32_TYPELESS = 1,
	COLOR_FORMAT_R32G32B32A32_FLOAT = 2,
	COLOR_FORMAT_R32G32B32A32_UINT = 3,
	COLOR_FORMAT_R32G32B32A32_SINT = 4,
	COLOR_FORMAT_R32G32B32_TYPELESS = 5,
	COLOR_FORMAT_R32G32B32_FLOAT = 6,
	COLOR_FORMAT_R32G32B32_UINT = 7,
	COLOR_FORMAT_R32G32B32_SINT = 8,
	COLOR_FORMAT_R16G16B16A16_TYPELESS = 9,
	COLOR_FORMAT_R16G16B16A16_FLOAT = 10,
	COLOR_FORMAT_R16G16B16A16_UNORM = 11,
	COLOR_FORMAT_R16G16B16A16_UINT = 12,
	COLOR_FORMAT_R16G16B16A16_SNORM = 13,
	COLOR_FORMAT_R16G16B16A16_SINT = 14,
	COLOR_FORMAT_R32G32_TYPELESS = 15,
	COLOR_FORMAT_R32G32_FLOAT = 16,
	COLOR_FORMAT_R32G32_UINT = 17,
	COLOR_FORMAT_R32G32_SINT = 18,
	COLOR_FORMAT_R32G8X24_TYPELESS = 19,
	COLOR_FORMAT_D32_FLOAT_S8X24_UINT = 20,
	COLOR_FORMAT_R32_FLOAT_X8X24_TYPELESS = 21,
	COLOR_FORMAT_X32_TYPELESS_G8X24_UINT = 22,
	COLOR_FORMAT_R10G10B10A2_TYPELESS = 23,
	COLOR_FORMAT_R10G10B10A2_UNORM = 24,
	COLOR_FORMAT_R10G10B10A2_UINT = 25,
	COLOR_FORMAT_R11G11B10_FLOAT = 26,
	COLOR_FORMAT_R8G8B8A8_TYPELESS = 27,
	COLOR_FORMAT_R8G8B8A8_UNORM = 28,
	COLOR_FORMAT_R8G8B8A8_UNORM_SRGB = 29,
	COLOR_FORMAT_R8G8B8A8_UINT = 30,
	COLOR_FORMAT_R8G8B8A8_SNORM = 31,
	COLOR_FORMAT_R8G8B8A8_SINT = 32,
	COLOR_FORMAT_R16G16_TYPELESS = 33,
	COLOR_FORMAT_R16G16_FLOAT = 34,
	COLOR_FORMAT_R16G16_UNORM = 35,
	COLOR_FORMAT_R16G16_UINT = 36,
	COLOR_FORMAT_R16G16_SNORM = 37,
	COLOR_FORMAT_R16G16_SINT = 38,
	COLOR_FORMAT_R32_TYPELESS = 39,
	COLOR_FORMAT_D32_FLOAT = 40,
	COLOR_FORMAT_R32_FLOAT = 41,
	COLOR_FORMAT_R32_UINT = 42,
	COLOR_FORMAT_R32_SINT = 43,
	COLOR_FORMAT_R24G8_TYPELESS = 44,
	COLOR_FORMAT_D24_UNORM_S8_UINT = 45,
	COLOR_FORMAT_R24_UNORM_X8_TYPELESS = 46,
	COLOR_FORMAT_X24_TYPELESS_G8_UINT = 47,
	COLOR_FORMAT_R8G8_TYPELESS = 48,
	COLOR_FORMAT_R8G8_UNORM = 49,
	COLOR_FORMAT_R8G8_UINT = 50,
	COLOR_FORMAT_R8G8_SNORM = 51,
	COLOR_FORMAT_R8G8_SINT = 52,
	COLOR_FORMAT_R16_TYPELESS = 53,
	COLOR_FORMAT_R16_FLOAT = 54,
	COLOR_FORMAT_D16_UNORM = 55,
	COLOR_FORMAT_R16_UNORM = 56,
	COLOR_FORMAT_R16_UINT = 57,
	COLOR_FORMAT_R16_SNORM = 58,
	COLOR_FORMAT_R16_SINT = 59,
	COLOR_FORMAT_R8_TYPELESS = 60,
	COLOR_FORMAT_R8_UNORM = 61,
	COLOR_FORMAT_R8_UINT = 62,
	COLOR_FORMAT_R8_SNORM = 63,
	COLOR_FORMAT_R8_SINT = 64,
	COLOR_FORMAT_A8_UNORM = 65,
	COLOR_FORMAT_R1_UNORM = 66,
	COLOR_FORMAT_R9G9B9E5_SHAREDEXP = 67,
	COLOR_FORMAT_R8G8_B8G8_UNORM = 68,
	COLOR_FORMAT_G8R8_G8B8_UNORM = 69,
	COLOR_FORMAT_BC1_TYPELESS = 70,
	COLOR_FORMAT_BC1_UNORM = 71,
	COLOR_FORMAT_BC1_UNORM_SRGB = 72,
	COLOR_FORMAT_BC2_TYPELESS = 73,
	COLOR_FORMAT_BC2_UNORM = 74,
	COLOR_FORMAT_BC2_UNORM_SRGB = 75,
	COLOR_FORMAT_BC3_TYPELESS = 76,
	COLOR_FORMAT_BC3_UNORM = 77,
	COLOR_FORMAT_BC3_UNORM_SRGB = 78,
	COLOR_FORMAT_BC4_TYPELESS = 79,
	COLOR_FORMAT_BC4_UNORM = 80,
	COLOR_FORMAT_BC4_SNORM = 81,
	COLOR_FORMAT_BC5_TYPELESS = 82,
	COLOR_FORMAT_BC5_UNORM = 83,
	COLOR_FORMAT_BC5_SNORM = 84,
	COLOR_FORMAT_B5G6R5_UNORM = 85,
	COLOR_FORMAT_B5G5R5A1_UNORM = 86,
	COLOR_FORMAT_B8G8R8A8_UNORM = 87,
	COLOR_FORMAT_B8G8R8X8_UNORM = 88,
	COLOR_FORMAT_FORCE_UINT = 0xffffffffUL,
};

template < class T > inline ColorFormat_t ComputeColorFormat( T* )
{
	return COLOR_FORMAT_UNKNOWN;
}

template <> inline ColorFormat_t ComputeColorFormat( float32* )
{
	return COLOR_FORMAT_R32_FLOAT;
}

template <> inline ColorFormat_t ComputeColorFormat( Vector2D* )
{
	return COLOR_FORMAT_R32G32_FLOAT;
}

template <> inline ColorFormat_t ComputeColorFormat( Vector* )
{
	return COLOR_FORMAT_R32G32B32_FLOAT;
}

template <> inline ColorFormat_t ComputeColorFormat( Vector4D* )
{
	return COLOR_FORMAT_R32G32B32A32_FLOAT;
}

template <> inline ColorFormat_t ComputeColorFormat( VertexColor_t* )
{
	// FIXME: How to get at SRGB formats?
	return COLOR_FORMAT_R8G8B8A8_UNORM;
}


#endif // COLORFORMAT_H
