//===== Copyright  1996-2007, Valve Corporation, All rights reserved. ======//
//
// Purpose: defines constants to use for the materialsystem and shaderapi
// SetxxxRenderingParameter functions
//
// $NoKeywords: $
//
//===========================================================================//

#ifndef RENDERPARM_H
#define RENDERPARM_H

#ifndef _WIN32
#pragma once
#endif

enum RenderParamInt_t
{
	INT_RENDERPARM_ENABLE_FIXED_LIGHTING = 0,
	INT_RENDERPARM_MORPH_ACCUMULATOR_X_OFFSET,
	INT_RENDERPARM_MORPH_ACCUMULATOR_Y_OFFSET,
	INT_RENDERPARM_MORPH_ACCUMULATOR_SUBRECT_WIDTH,
	INT_RENDERPARM_MORPH_ACCUMULATOR_SUBRECT_HEIGHT,
	INT_RENDERPARM_MORPH_ACCUMULATOR_4TUPLE_COUNT,

	INT_RENDERPARM_MORPH_WEIGHT_X_OFFSET,
	INT_RENDERPARM_MORPH_WEIGHT_Y_OFFSET,
	INT_RENDERPARM_MORPH_WEIGHT_SUBRECT_WIDTH,
	INT_RENDERPARM_MORPH_WEIGHT_SUBRECT_HEIGHT,

	INT_RENDERPARM_WRITE_DEPTH_TO_DESTALPHA,

	INT_RENDERPARM_BACK_BUFFER_INDEX,
	
// @Deferred - Biohazard
	INT_RENDERPARM_DEFERRED_RENDER_STAGE,
	INT_RENDERPARM_DEFERRED_SHADOW_MODE,
	INT_RENDERPARM_DEFERRED_SHADOW_INDEX,
	INT_RENDERPARM_DEFERRED_SHADOW_RADIOSITY,
	INT_RENDERPARM_DEFERRED_RADIOSITY_CASCADE,

	MAX_INT_RENDER_PARMS = 20
};

// for INT_RENDERPARM_BACK_BUFFER_INDEX
#define BACK_BUFFER_INDEX_DEFAULT	0
#define BACK_BUFFER_INDEX_HDR		1

enum RenderParamFloat_t
{
	FLOAT_RENDERPARM_DEST_ALPHA_DEPTH_SCALE = 0,
	FLOAT_RENDERPARM_SPECULAR_POWER,
	
	MAX_FLOAT_RENDER_PARMS = 20
};

enum RenderParamTexture_t
{
	TEXTURE_RENDERPARM_AMBIENT_OCCLUSION = 0,
	TEXTURE_RENDERPARM_FOW = 1,

	MAX_TEXTURE_RENDER_PARMS = 2
};


enum RenderParamVector_t
{
	VECTOR_RENDERPARM_GLOBAL_LIGHT_DIRECTION = 0,
	VECTOR_RENDERPARM_GLOBAL_FOW_MINS,
	VECTOR_RENDERPARM_GLOBAL_FOW_MAXS,
	VECTOR_RENDERPARM_WIND_DIRECTION,	

	MAX_VECTOR_RENDER_PARMS  = 20
};

// ENABLE_FIXED_LIGHTING modes:
#define ENABLE_FIXED_LIGHTING_NONE 0
#define ENABLE_FIXED_LIGHTING_BASICLIGHT 1
#define ENABLE_FIXED_LIGHTING_OUTPUTMRTS_FOR_DEFERRED_LIGHTING 2
#define ENABLE_FIXED_LIGHTING_OUTPUTNORMAL_AND_DEPTH 3

// @Deferred - Biohazard
enum
{
	DEFERRED_RENDER_STAGE_INVALID = 0,
	DEFERRED_RENDER_STAGE_GBUFFER,
	DEFERRED_RENDER_STAGE_SHADOWPASS,
	DEFERRED_RENDER_STAGE_COMPOSITION,
};

#endif // RENDERPARM_H
