---
UID: TP:security
ms.assetid: b363e999-e030-3061-ae49-cc5ffd5ea84d
ms.date: 01/11/2019
ms.keywords: 
ms.topic: conceptual
---

# Security and Identity

## -description

Overview of the Security and Identity technology.

To develop Security and Identity, you need these headers:

 * [aclapi.h](../aclapi/index.md)
 * [aclui.h](../aclui/index.md)
 * [adtgen.h](../adtgen/index.md)
 * [authz.h](../authz/index.md)
 * [azroles.h](../azroles/index.md)
 * [bcrypt.h](../bcrypt/index.md)
 * [casetup.h](../casetup/index.md)
 * [celib.h](../celib/index.md)
 * [certadm.h](../certadm/index.md)
 * [certbcli.h](../certbcli/index.md)
 * [certcli.h](../certcli/index.md)
 * [certenc.h](../certenc/index.md)
 * [certenroll.h](../certenroll/index.md)
 * [certexit.h](../certexit/index.md)
 * [certif.h](../certif/index.md)
 * [certmod.h](../certmod/index.md)
 * [certpol.h](../certpol/index.md)
 * [certpoleng.h](../certpoleng/index.md)
 * [certsrv.h](../certsrv/index.md)
 * [certview.h](../certview/index.md)
 * [credssp.h](../credssp/index.md)
 * [cryptdlg.h](../cryptdlg/index.md)
 * [cryptuiapi.h](../cryptuiapi/index.md)
 * [cryptxml.h](../cryptxml/index.md)
 * [dpapi.h](../dpapi/index.md)
 * [dssec.h](../dssec/index.md)
 * [iads.h](../iads/index.md)
 * [identitycommon.h](../identitycommon/index.md)
 * [identityprovider.h](../identityprovider/index.md)
 * [identitystore.h](../identitystore/index.md)
 * [keycredmgr.h](../keycredmgr/index.md)
 * [lsalookup.h](../lsalookup/index.md)
 * [mscat.h](../mscat/index.md)
 * [mssip.h](../mssip/index.md)
 * [ncrypt.h](../ncrypt/index.md)
 * [ncryptprotect.h](../ncryptprotect/index.md)
 * [npapi.h](../npapi/index.md)
 * [ntlsa.h](../ntlsa/index.md)
 * [ntsecapi.h](../ntsecapi/index.md)
 * [sas.h](../sas/index.md)
 * [scesvc.h](../scesvc/index.md)
 * [schannel.h](../schannel/index.md)
 * [sddl.h](../sddl/index.md)
 * [securityappcontainer.h](../securityappcontainer/index.md)
 * [slpublic.h](../slpublic/index.md)
 * [sspi.h](../sspi/index.md)
 * [subauth.h](../subauth/index.md)
 * [tokenbinding.h](../tokenbinding/index.md)
 * [tpmvscmgr.h](../tpmvscmgr/index.md)
 * [wincred.h](../wincred/index.md)
 * [wincrypt.h](../wincrypt/index.md)
 * [winnetwk.h](../winnetwk/index.md)
 * [winsafer.h](../winsafer/index.md)
 * [winscard.h](../winscard/index.md)
 * [winsvc.h](../winsvc/index.md)
 * [wintrust.h](../wintrust/index.md)
 * [winwlx.h](../winwlx/index.md)
 * [xenroll.h](../xenroll/index.md)

For programming guidance for this technology, see:
* [Authentication](/windows/desktop/secauthn)
* [Authorization](/windows/desktop/secauthz)
* [Best Practices for the Security APIs](/windows/desktop/secbp)
* [Certificate Enrollment API](/windows/desktop/seccertenroll)
* [Cryptography API: Next Generation](/windows/desktop/seccng)
* [Cryptography](/windows/desktop/seccrypto)
* [Security Glossary](/windows/desktop/secgloss)
* [Security Management](/windows/desktop/secmgmt)
* [Security WMI Providers](/windows/desktop/secprov)
* [Software Licensing API](https://docs.microsoft.com/previous-versions/windows/desktop/secslapi)

