---
UID: NE:activationregistration.ActivationType
title: ActivationType (activationregistration.h)
description: Specifies the kind of activation for an activatable class.
old-location: winrt\activationtype.htm
tech.root: WinRT
ms.assetid: 200257CC-FE26-407F-8AE4-4DB7030AB4E7
ms.date: 12/05/2018
ms.keywords: ActivationType, ActivationType enumeration [Windows Runtime], ActivationType_InProcess, ActivationType_OutOfProcess, ActivationType_RemoteProcess, __x_ABI_CWindows_CFoundation_CActivationType, activationregistration/ActivationType, activationregistration/ActivationType_InProcess, activationregistration/ActivationType_OutOfProcess, activationregistration/ActivationType_RemoteProcess, winrt.activationtype
f1_keywords:
- activationregistration/ActivationType
dev_langs:
- c++
req.header: activationregistration.h
req.include-header: Objidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows 8.1 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- activationregistration.h
api_name:
- ActivationType
targetos: Windows
req.typenames: ActivationType
req.redist: 
ms.custom: 19H1
---

# ActivationType enumeration


## -description


Specifies the kind of activation for an activatable class.


## -enum-fields




### -field ActivationType_InProcess

Specifies in-process activation.


### -field ActivationType_OutOfProcess

Specifies out-of-process activation.


### -field ActivationType_RemoteProcess

Specifies remote-process activation.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/activationregistration/nn-activationregistration-iactivatableclassregistration">IActivatableClassRegistration</a>
 

 

