---
UID: NF:amsi.AmsiResultIsMalware
title: AmsiResultIsMalware macro (amsi.h)
description: Determines if the result of a scan indicates that the content should be blocked.
old-location: amsi\amsiresultismalware.htm
tech.root: AMSI
ms.assetid: 1C7B48D9-FD1C-48B5-AA7F-0ED7382E106A
ms.date: 12/05/2018
ms.keywords: AmsiResultIsMalware, AmsiResultIsMalware function [Antimalware Scan Interface], amsi.amsiresultismalware, amsi/AmsiResultIsMalware
f1_keywords:
- amsi/AmsiResultIsMalware
dev_langs:
- c++
req.header: amsi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Amsi.lib
req.dll: Amsi.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- amsi.dll
api_name:
- AmsiResultIsMalware
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# AmsiResultIsMalware macro


## -description


Determines if the result of a scan indicates that the content should be blocked.


## -parameters




### -param r [in]

The <a href="https://docs.microsoft.com/windows/desktop/api/amsi/ne-amsi-amsi_result">AMSI_RESULT</a> returned by <a href="https://docs.microsoft.com/windows/desktop/api/amsi/nf-amsi-amsiscanbuffer">AmsiScanBuffer</a> or <a href="https://docs.microsoft.com/windows/desktop/api/amsi/nf-amsi-amsiscanstring">AmsiScanString</a>.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/amsi/ne-amsi-amsi_result">AMSI_RESULT</a>



<a href="https://docs.microsoft.com/windows/desktop/api/amsi/nf-amsi-amsiscanbuffer">AmsiScanBuffer</a>



<a href="https://docs.microsoft.com/windows/desktop/api/amsi/nf-amsi-amsiscanstring">AmsiScanString</a>
 

 

