---
UID: NF:amsi.IAntimalwareProvider.DisplayName
title: IAntimalwareProvider::DisplayName (amsi.h)
description: The name of the antimalware provider to be displayed.
old-location: amsi\iantimalwareprovider_displayname.htm
tech.root: AMSI
ms.assetid: 05284A95-2D45-4102-91A5-60313182F5FB
ms.date: 12/05/2018
ms.keywords: DisplayName, DisplayName method [Antimalware Scan Interface], DisplayName method [Antimalware Scan Interface],IAntimalwareProvider interface, IAntimalwareProvider interface [Antimalware Scan Interface],DisplayName method, IAntimalwareProvider.DisplayName, IAntimalwareProvider::DisplayName, amsi.iantimalwareprovider_displayname, amsi/IAntimalwareProvider::DisplayName
f1_keywords:
- amsi/IAntimalwareProvider.DisplayName
dev_langs:
- c++
req.header: amsi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- amsi.h
api_name:
- IAntimalwareProvider.DisplayName
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IAntimalwareProvider::DisplayName


## -description


The name of the antimalware provider to be displayed.


## -parameters




### -param displayName [out]

A pointer to a <b>LPWSTR</b> that contains the display name.


## -returns



This method can return one of these values.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
Success.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
</dl>
</td>
<td width="60%">
The argument is invalid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_NOT_VALID_STATE</b></dt>
</dl>
</td>
<td width="60%">
The object is not initialized.

</td>
</tr>
</table>
 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/amsi/nn-amsi-iantimalwareprovider">IAntimalwareProvider</a>
 

 

