---
UID: NF:amsi.IAntimalwareProvider.Scan
title: IAntimalwareProvider::Scan (amsi.h)
description: Scan a stream of content.
old-location: amsi\iantimalwareprovider_scan.htm
tech.root: AMSI
ms.assetid: 4E503E86-4248-45B4-BB9B-54A5E16128A6
ms.date: 12/05/2018
ms.keywords: IAntimalwareProvider interface [Antimalware Scan Interface],Scan method, IAntimalwareProvider.Scan, IAntimalwareProvider::Scan, Scan, Scan method [Antimalware Scan Interface], Scan method [Antimalware Scan Interface],IAntimalwareProvider interface, amsi.iantimalwareprovider_scan, amsi/IAntimalwareProvider::Scan
f1_keywords:
- amsi/IAntimalwareProvider.Scan
dev_langs:
- c++
req.header: amsi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- amsi.h
api_name:
- IAntimalwareProvider.Scan
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IAntimalwareProvider::Scan


## -description


Scan a stream of content.


## -parameters




### -param stream [in]

The <a href="https://docs.microsoft.com/windows/desktop/api/amsi/nn-amsi-iamsistream">IAmsiStream</a> stream to be scanned.


### -param result [out]

The result of the scan. See <a href="https://docs.microsoft.com/windows/desktop/api/amsi/ne-amsi-amsi_result">AMSI_RESULT</a>.


## -returns



This method can return one of these values.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
Success.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
</dl>
</td>
<td width="60%">
One or more argument is invalid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_NOT_VALID_STATE</b></dt>
</dl>
</td>
<td width="60%">
The object is not initialized.

</td>
</tr>
</table>
 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/amsi/ne-amsi-amsi_result">AMSI_RESULT</a>



<a href="https://docs.microsoft.com/windows/desktop/api/amsi/nn-amsi-iamsistream">IAmsiStream</a>



<a href="https://docs.microsoft.com/windows/desktop/api/amsi/nn-amsi-iantimalwareprovider">IAntimalwareProvider</a>
 

 

