---
UID: NN:amsi.IAntimalwareProvider
title: IAntimalwareProvider (amsi.h)
description: Represents the provider of the antimalware product.
old-location: amsi\iantimalwareprovider.htm
tech.root: AMSI
ms.assetid: 4413744E-09BE-49CE-9DAF-8D2716C7A7E5
ms.date: 02/21/2019
ms.keywords: IAntimalwareProvider, IAntimalwareProvider interface [Antimalware Scan Interface], IAntimalwareProvider interface [Antimalware Scan Interface],described, amsi.iantimalwareprovider, amsi/IAntimalwareProvider
f1_keywords:
- amsi/IAntimalwareProvider
dev_langs:
- c++
req.header: amsi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- amsi.h
api_name:
- IAntimalwareProvider
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IAntimalwareProvider interface

## -description

Represents the provider of the antimalware product. For a code example, see the [IAntimalwareProvider interface sample](https://github.com/Microsoft/Windows-classic-samples/tree/master/Samples/AmsiProvider).

The **IAntimalwareProvider** interface inherits from the [IUnknown interface](/windows/desktop/api/unknwn/nn-unknwn-iunknown).

## -remarks

As of Windows 10, version 1903, Windows has added a way to enable Authenticode + Windows Hardware Quality Labs (WHQL) signing checks for providers. The feature is disabled by default, for both 32-bit and 64-bit processes. If you are creating a provider for test purposes, then you can enable or disable sign checks by setting the following Windows Registry value appropriately. The value is a DWORD.

`Computer\HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\AMSI\FeatureBits`

|Value|Behavior|
|-|-|
|0x1|The signing check is disabled. This is the default behavior. You can also use this value, temporarily, while testing.|
|0x2|The check for Authenticode + WHQL signing is enabled.|

Deleting the registry value altogether behaves as if the value 0x1 were present.

> [!NOTE]
> As a provider, you must use the `/ac` switch (with the [SignTool](/windows/win32/seccrypto/signtool)) to cross-sign with an Authenticode certificate. Once you've signed your binary, you can then verify it by using the SignTool and the `/kp` option. If the SignTool returns no error, then your binary is properly signed.

> [!IMPORTANT]
> Even though the Windows Registry value is not protected by the operating system, your computer's antivirus provider might protect the value, thus making it write-protected.

To check whether or not your provider is loading, you can [view code integrity events](/windows-hardware/drivers/install/viewing-code-integrity-events). Be sure to [enable verbose logging of code integrity diagnostic events](/windows-hardware/drivers/install/enabling-the-system-event-audit-log#how-to-enable-verbose-logging-of-code-integrity-diagnostic-events). The event IDs to look for are *3040* and *3041*. Here are some examples.

```
Log Name:      Microsoft-Windows-CodeIntegrity/Verbose
Source:        Microsoft-Windows-CodeIntegrity
Date:          M/DD/YYYY H:MM:SS PM
Event ID:      3040
Task Category: (14)
Level:         Verbose
Keywords:      
User:          [DOMAIN_NAME]\Administrator
Computer:      [COMPUTER_NAME]
Description:
Code Integrity started retrieving the cached data of [PATH_AND_FILENAME] file.
Event Xml:
<Event xmlns="http://schemas.microsoft.com/win/2004/08/events/event">
  <System>
    <Provider Name="Microsoft-Windows-CodeIntegrity" Guid="{4ee76bd8-3cf4-44a0-a0ac-3937643e37a3}" />
    <EventID>3040</EventID>
    <Version>0</Version>
    <Level>5</Level>
    <Task>14</Task>
    <Opcode>1</Opcode>
    <Keywords>0x4000000000000000</Keywords>
    <TimeCreated SystemTime="YYYY-MM-DDT02:26:48.875954700Z" />
    <EventRecordID>7</EventRecordID>
    <Correlation />
    <Execution ProcessID="4972" ThreadID="7752" ProcessorID="1" KernelTime="14" UserTime="2" />
    <Channel>Microsoft-Windows-CodeIntegrity/Verbose</Channel>
    <Computer>[COMPUTER_NAME]</Computer>
    <Security UserID="[USER_SID]" />
  </System>
  <EventData>
    <Data Name="FileNameLength">40</Data>
    <Data Name="FileNameBuffer">[PATH_AND_FILENAME]</Data>
  </EventData>
</Event>
```

```
Log Name:      Microsoft-Windows-CodeIntegrity/Verbose
Source:        Microsoft-Windows-CodeIntegrity
Date:          M/DD/YYYY H:MM:SS PM
Event ID:      3041
Task Category: (14)
Level:         Verbose
Keywords:      
User:          [DOMAIN_NAME]\Administrator
Computer:      [COMPUTER_NAME]
Description:
Code Integrity completed retrieval of file cache. Status 0xC0000225.
Event Xml:
<Event xmlns="http://schemas.microsoft.com/win/2004/08/events/event">
  <System>
    <Provider Name="Microsoft-Windows-CodeIntegrity" Guid="{4ee76bd8-3cf4-44a0-a0ac-3937643e37a3}" />
    <EventID>3041</EventID>
    <Version>2</Version>
    <Level>5</Level>
    <Task>14</Task>
    <Opcode>2</Opcode>
    <Keywords>0x4000000000000000</Keywords>
    <TimeCreated SystemTime="YYYY-MM-DDT02:26:48.875964700Z" />
    <EventRecordID>8</EventRecordID>
    <Correlation />
    <Execution ProcessID="4972" ThreadID="7752" ProcessorID="1" KernelTime="14" UserTime="2" />
    <Channel>Microsoft-Windows-CodeIntegrity/Verbose</Channel>
    <Computer>[COMPUTER_NAME]</Computer>
    <Security UserID="[USER_SID]" />
  </System>
  <EventData>
    <Data Name="Status">0xc0000225</Data>
    <Data Name="CachedFlags">0x0</Data>
    <Data Name="CacheSource">0</Data>
    <Data Name="CachedPolicy">0</Data>
  </EventData>
</Event>
```

## -see-also

[IAntimalwareProvider interface sample](https://github.com/Microsoft/Windows-classic-samples/tree/master/Samples/AmsiProvider)

[SignTool](/windows/win32/seccrypto/signtool)
