---
UID: NE:appxpackaging.APPX_PACKAGE_ARCHITECTURE
title: APPX_PACKAGE_ARCHITECTURE (appxpackaging.h)
description: Specifies the processor architectures supported by a package.
old-location: appxpkg\appx_package_architecture.htm
tech.root: appxpkg
ms.assetid: 8BC7ABF0-448F-4405-AA82-49C6DB3F230C
ms.date: 12/05/2018
ms.keywords: APPX_PACKAGE_ARCHITECTURE, APPX_PACKAGE_ARCHITECTURE enumeration [App packaging and management], APPX_PACKAGE_ARCHITECTURE_ARM, APPX_PACKAGE_ARCHITECTURE_ARM64, APPX_PACKAGE_ARCHITECTURE_NEUTRAL, APPX_PACKAGE_ARCHITECTURE_X64, APPX_PACKAGE_ARCHITECTURE_X86, appxpackaging/APPX_PACKAGE_ARCHITECTURE, appxpackaging/APPX_PACKAGE_ARCHITECTURE_ARM, appxpackaging/APPX_PACKAGE_ARCHITECTURE_ARM64, appxpackaging/APPX_PACKAGE_ARCHITECTURE_NEUTRAL, appxpackaging/APPX_PACKAGE_ARCHITECTURE_X64, appxpackaging/APPX_PACKAGE_ARCHITECTURE_X86, appxpkg.appx_package_architecture
f1_keywords:
- appxpackaging/APPX_PACKAGE_ARCHITECTURE
dev_langs:
- c++
req.header: appxpackaging.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: AppxPackaging.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- AppxPackaging.h
api_name:
- APPX_PACKAGE_ARCHITECTURE
targetos: Windows
req.typenames: APPX_PACKAGE_ARCHITECTURE
req.redist: 
ms.custom: 19H1
---

# APPX_PACKAGE_ARCHITECTURE enumeration


## -description


Specifies the processor architectures supported by a package.


## -enum-fields




### -field APPX_PACKAGE_ARCHITECTURE_X86

The x86 processor architecture.


### -field APPX_PACKAGE_ARCHITECTURE_ARM

The ARM processor architecture.


### -field APPX_PACKAGE_ARCHITECTURE_X64

The x64 processor architecture.


### -field APPX_PACKAGE_ARCHITECTURE_NEUTRAL

Any  processor architecture.


### -field APPX_PACKAGE_ARCHITECTURE_ARM64

The 64-bit ARM processor architecture.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/appxpackaging/nf-appxpackaging-iappxmanifestpackageid-getarchitecture">IAppxManifestPackageId::GetArchitecture</a>
 

 

