---
UID: NF:audioclient.IAudioClock.GetFrequency
title: IAudioClock::GetFrequency (audioclient.h)
description: The GetFrequency method gets the device frequency.
old-location: coreaudio\iaudioclock_getfrequency.htm
tech.root: CoreAudio
ms.assetid: 4ad17f03-a353-4ac5-9f07-b5dc7c3b530f
ms.date: 12/05/2018
ms.keywords: GetFrequency, GetFrequency method [Core Audio], GetFrequency method [Core Audio],IAudioClock interface, IAudioClock interface [Core Audio],GetFrequency method, IAudioClock.GetFrequency, IAudioClock::GetFrequency, IAudioClockGetFrequency, audioclient/IAudioClock::GetFrequency, coreaudio.iaudioclock_getfrequency
f1_keywords:
- audioclient/IAudioClock.GetFrequency
dev_langs:
- c++
req.header: audioclient.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Audioclient.h
api_name:
- IAudioClock.GetFrequency
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IAudioClock::GetFrequency


## -description



The <b>GetFrequency</b> method gets the device frequency.




## -parameters




### -param pu64Frequency [out]

Pointer to a <b>UINT64</b> variable into which the method writes the device frequency. For more information, see Remarks.


## -returns



If the method succeeds, it returns S_OK. If it fails, possible return codes include, but are not limited to, the values shown in the following table.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_POINTER</b></dt>
</dl>
</td>
<td width="60%">
Parameter <i>pu64Frequency</i> is <b>NULL</b>.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>AUDCLNT_E_DEVICE_INVALIDATED</b></dt>
</dl>
</td>
<td width="60%">
The audio endpoint device has been unplugged, or the audio hardware or associated hardware resources have been reconfigured, disabled, removed, or otherwise made unavailable for use.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>AUDCLNT_E_SERVICE_NOT_RUNNING</b></dt>
</dl>
</td>
<td width="60%">
The Windows audio service is not running.

</td>
</tr>
</table>
 




## -remarks



The device frequency is the frequency generated by the hardware clock in the audio device. This method reports the device frequency in units that are compatible with those of the device position that the <a href="https://docs.microsoft.com/windows/desktop/api/audioclient/nf-audioclient-iaudioclock-getposition">IAudioClock::GetPosition</a> method reports. For example, if, for a particular stream, the <b>GetPosition</b> method expresses the position <i>p</i> as a byte offset, the <b>GetFrequency</b> method expresses the frequency <i>f</i> in bytes per second. For any stream, the offset in seconds from the start of the stream can always be reliably calculated as <i>p</i>/<i>f</i> regardless of the units in which <i>p</i> and <i>f</i> are expressed.

In Windows Vista, the device frequency reported by successive calls to <b>GetFrequency</b> never changes during the lifetime of a stream.

If the clock generated by an audio device runs at a nominally constant frequency, the frequency might still vary slightly over time due to drift or jitter with respect to a reference clock. The reference clock might be a wall clock or the system clock used by the <b>QueryPerformanceCounter</b> function. The <b>GetFrequency</b> method ignores such variations and simply reports a constant frequency. However, the position reported by the <b>IAudioClient::GetPosition</b> method takes all such variations into account to report an accurate position value each time it is called. For more information about <b>QueryPerformanceCounter</b>, see the Windows SDK documentation.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/audioclient/nn-audioclient-iaudioclock">IAudioClock Interface</a>



<a href="https://docs.microsoft.com/windows/desktop/api/audioclient/nf-audioclient-iaudioclock-getposition">IAudioClock::GetPosition</a>
 

 

