---
UID: NF:audioengineendpoint.IAudioOutputEndpointRT.ReleaseOutputDataPointer
title: IAudioOutputEndpointRT::ReleaseOutputDataPointer (audioengineendpoint.h)
description: Releases the pointer to the output buffer.
old-location: termserv\iaudiooutputendpointrt_releaseoutputdatapointer.htm
tech.root: TermServ
ms.assetid: 55b7d55e-b684-4c6e-a937-e8922732857d
ms.date: 12/05/2018
ms.keywords: IAudioOutputEndpointRT interface [Remote Desktop Services],ReleaseOutputDataPointer method, IAudioOutputEndpointRT.ReleaseOutputDataPointer, IAudioOutputEndpointRT::ReleaseOutputDataPointer, ReleaseOutputDataPointer, ReleaseOutputDataPointer method [Remote Desktop Services], ReleaseOutputDataPointer method [Remote Desktop Services],IAudioOutputEndpointRT interface, audioengineendpoint/IAudioOutputEndpointRT::ReleaseOutputDataPointer, termserv.iaudiooutputendpointrt_releaseoutputdatapointer
f1_keywords:
- audioengineendpoint/IAudioOutputEndpointRT.ReleaseOutputDataPointer
dev_langs:
- c++
req.header: audioengineendpoint.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7
req.target-min-winversvr: Windows Server 2008 R2
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Audioengineendpoint.h
api_name:
- IAudioOutputEndpointRT.ReleaseOutputDataPointer
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IAudioOutputEndpointRT::ReleaseOutputDataPointer


## -description


The <b>ReleaseOutputDataPointer</b> method releases the pointer to the output buffer.


## -parameters




### -param pConnectionProperty [in]

A pointer to an  <a href="https://docs.microsoft.com/windows/desktop/api/audioapotypes/ns-audioapotypes-apo_connection_property">APO_CONNECTION_PROPERTY</a>structure. The values in the structure must not be changed. The caller sets the members as follows:

<ul>
<li><b>pBuffer</b> is set to the pointer to the output data buffer returned by the <a href="https://docs.microsoft.com/windows/desktop/api/audioengineendpoint/nf-audioengineendpoint-iaudiooutputendpointrt-getoutputdatapointer">IAudioOutputEndpointRT::GetOutputDataPointer</a> method.</li>
<li><b>u32ValidFrameCount</b> is set to the actual number of frames that have been generated by the audio engine. The value might not be the same as the frame count passed in the <i>u32FrameCount</i> parameter of the <a href="https://docs.microsoft.com/windows/desktop/api/audioengineendpoint/nf-audioengineendpoint-iaudiooutputendpointrt-getoutputdatapointer">GetOutputDataPointer</a> method.</li>
<li><b>u32BufferFlags</b> is set to <b>BUFFER_VALID</b> if the output buffer pointed to by the <b>pBuffer</b> member contains valid data. <b>u32BufferFlags</b> is set to <b>BUFFER_SILENT</b> if the output buffer contains only silent data. The data in the buffer does not actually need to be silence, but the buffer specified in the <b>pBuffer</b> member must be capable of holding all the frames of silence contained in the  <b>u32ValidFrameCount</b> member. 
Therefore, if <b>BUFFER_SILENT</b> is specified, the endpoint should write silence in the
    output buffer.</li>
</ul>

## -returns



This method does not return a value.




## -remarks



<b>ReleaseOutputDataPointer</b> notifies the endpoint that the audio engine has completed the task of writing data in the output buffer and no longer requires the data pointer. This method also relays information such as the time that corresponds to the audio samples in the
    output buffer, the number of frames generated by the audio engine, and whether the buffer
    is full of valid data or silence data.
    Based on this information, an  endpoint that represents a looped buffer and is attached to the output of the
    audio engine can advance its
    write position in the buffer.
    A value of zero in the <i>u32FrameCount</i> parameter of the <a href="https://docs.microsoft.com/windows/desktop/api/audioengineendpoint/nf-audioengineendpoint-iaudiooutputendpointrt-getoutputdatapointer">GetOutputDataPointer</a> method indicates that the audio engine did not write any valid data in the output buffer. The <i>u32FrameCount</i> parameter value must be less than or equal to the frame count specified in <b>GetOutputDataPointer</b>. The endpoint must not
    assume that all data requested by <b>GetOutputDataPointer</b> was actually generated.

This method can be called from a real-time processing thread. The
    implementation of this method must not block, access
    paged memory, or call any blocking system routines.

The Remote Desktop Services AudioEndpoint API is for use in Remote Desktop scenarios; it is not for client applications.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/audioengineendpoint/nn-audioengineendpoint-iaudiooutputendpointrt">IAudioOutputEndpointRT</a>
 

 

