---
UID: NE:avrfsdk.eHeapEnumerationLevel
title: eHeapEnumerationLevel (avrfsdk.h)
description: Determines whether the enumeration operation should continue or stop.
old-location: winprog\eheapenumerationlevel.htm
tech.root: DevNotes
ms.assetid: f8260ae8-eb1e-45f4-babc-905f4af7e3b1
ms.date: 12/05/2018
ms.keywords: HeapEnumerationEverything, HeapEnumerationStop, avrfsdk/HeapEnumerationEverything, avrfsdk/HeapEnumerationStop, avrfsdk/eHeapEnumerationLevel, base.eheapenumerationlevel, eHeapEnumerationLevel, eHeapEnumerationLevel enumeration [Windows API], winprog.eheapenumerationlevel
f1_keywords:
- avrfsdk/eHeapEnumerationLevel
dev_langs:
- c++
req.header: avrfsdk.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Avrfsdk.h
api_name:
- eHeapEnumerationLevel
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# eHeapEnumerationLevel enumeration


## -description


Determines whether the enumeration operation should continue or stop.


## -enum-fields




### -field HeapEnumerationEverything

A constant that specifies the enumeration should continue.


### -field HeapEnumerationStop

A constant that specifies to the <a href="https://docs.microsoft.com/windows/desktop/api/avrfsdk/nf-avrfsdk-verifierenumerateresource">VerifierEnumerateResource</a> function when the enumeration operation should stop.

Codes from 0x1 to 0xFFFFFFE are reserved.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DevNotes/resource-enumeration">Resource Enumeration</a>



<a href="https://docs.microsoft.com/windows/desktop/api/avrfsdk/nf-avrfsdk-verifierenumerateresource">VerifierEnumerateResource</a>
 

 

