---
UID: NF:azroles.IAzApplicationGroup.DeleteMember
title: IAzApplicationGroup::DeleteMember (azroles.h)
description: Removes the specified security identifier (SID) in text form from the list of accounts that belong to the application group.
old-location: security\iazapplicationgroup_deletemember.htm
tech.root: SecAuthZ
ms.assetid: 9db3b162-b37d-4a86-a3c0-cb594370238b
ms.date: 12/05/2018
ms.keywords: AzApplicationGroup object [Security],DeleteMember method, DeleteMember, DeleteMember method [Security], DeleteMember method [Security],AzApplicationGroup object, DeleteMember method [Security],IAzApplicationGroup interface, IAzApplicationGroup interface [Security],DeleteMember method, IAzApplicationGroup.DeleteMember, IAzApplicationGroup::DeleteMember, azroles/IAzApplicationGroup::DeleteMember, security.iazapplicationgroup_deletemember
f1_keywords:
- azroles/IAzApplicationGroup.DeleteMember
dev_langs:
- c++
req.header: azroles.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Azroles.lib
req.dll: Azroles.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Azroles.dll
api_name:
- IAzApplicationGroup.DeleteMember
- AzApplicationGroup.DeleteMember
targetos: Windows
req.typenames: 
req.redist: Windows Server 2003 Administration Tools Pack on Windows XP
ms.custom: 19H1
---

# IAzApplicationGroup::DeleteMember


## -description


The <b>DeleteMember</b> method removes  the specified <a href="https://docs.microsoft.com/windows/desktop/SecGloss/s-gly">security identifier</a> (SID) in text form from the list of  accounts that belong to the application group.


## -parameters




### -param bstrProp [in]

String that contains the text form of the SID to remove from the list of  accounts that belong to the application group.


### -param varReserved [in, optional]

Reserved for future use.


## -remarks



To view the list of SIDs of accounts that belong to this application group in text form, use the <a href="https://docs.microsoft.com/windows/desktop/api/azroles/nf-azroles-iazapplicationgroup-get_members">Members</a> property.



