---
UID: NE:bcrypt.__unnamed_enum_3
title: DSAFIPSVERSION_ENUM (bcrypt.h)
description: Contains FIPS version information.
old-location: security\dsafipsversion_enum.htm
tech.root: SecCNG
ms.assetid: 6797D7C0-3451-464E-9261-61217ADAB9C1
ms.date: 12/05/2018
ms.keywords: DSAFIPSVERSION_ENUM, DSAFIPSVERSION_ENUM enumeration [Security], DSA_FIPS186_2, DSA_FIPS186_3, bcrypt/DSAFIPSVERSION_ENUM, bcrypt/DSA_FIPS186_2, bcrypt/DSA_FIPS186_3, security.dsafipsversion_enum
f1_keywords:
- bcrypt/DSAFIPSVERSION_ENUM
dev_langs:
- c++
req.header: bcrypt.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Bcrypt.h
api_name:
- DSAFIPSVERSION_ENUM
targetos: Windows
req.typenames: DSAFIPSVERSION_ENUM
req.redist: 
ms.custom: 19H1
---

# DSAFIPSVERSION_ENUM enumeration


## -description


The <b>DSAFIPSVERSION_ENUM</b> enumeration type contains FIPS version information. It is used by the <a href="https://docs.microsoft.com/windows/desktop/api/bcrypt/ns-bcrypt-bcrypt_dsa_key_blob_v2">BCRYPT_DSA_KEY_BLOB_V2</a> and <a href="https://docs.microsoft.com/windows/desktop/api/bcrypt/ns-bcrypt-bcrypt_dsa_parameter_header_v2">BCRYPT_DSA_PARAMETER_HEADER_V2</a> structures.


## -enum-fields




### -field DSA_FIPS186_2

Federal Information Processing Standard (FIPS) 2.


### -field DSA_FIPS186_3

Federal Information Processing Standard (FIPS) 3.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/bcrypt/ns-bcrypt-bcrypt_dsa_key_blob_v2">BCRYPT_DSA_KEY_BLOB_V2</a>



<a href="https://docs.microsoft.com/windows/desktop/api/bcrypt/ns-bcrypt-bcrypt_dsa_parameter_header_v2">BCRYPT_DSA_PARAMETER_HEADER_V2</a>
 

 

