---
UID: NN:bdatif.IEnumGuideDataProperties
title: IEnumGuideDataProperties (bdatif.h)
description: The IEnumGuideDataProperties interface represents a collection of guide data properties that has been generated by the TIF.
old-location: mstv\ienumguidedataproperties.htm
tech.root: mstv
ms.assetid: ae4db426-7e90-4cb6-b53a-2cb7074308fc
ms.date: 12/05/2018
ms.keywords: IEnumGuideDataProperties, IEnumGuideDataProperties interface [Microsoft TV Technologies], IEnumGuideDataProperties interface [Microsoft TV Technologies],described, IEnumGuideDataPropertiesInterface, bdatif/IEnumGuideDataProperties, mstv.ienumguidedataproperties
f1_keywords:
- bdatif/IEnumGuideDataProperties
dev_langs:
- c++
req.header: bdatif.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Bdatif.h
api_name:
- IEnumGuideDataProperties
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IEnumGuideDataProperties interface


## -description



The <b>IEnumGuideDataProperties</b> interface represents a collection of guide data properties that has been generated by the TIF. Separate collections are created for programs, services, and schedule entries. This interface is obtained from the TIF using the following methods.

<ul>
<li>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/bdatif/nf-bdatif-iguidedata-getprogramproperties">IGuideData::GetProgramProperties</a>.</li>
<li>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/bdatif/nf-bdatif-iguidedata-getscheduleentryproperties">IGuideData::GetScheduleEntryProperties</a>
</li>
<li>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/bdatif/nf-bdatif-iguidedata-getserviceproperties">IGuideData::GetServiceProperties</a>
</li>
</ul>



## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IEnumGuideDataProperties</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IEnumGuideDataProperties</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IEnumGuideDataProperties</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/bdatif/nf-bdatif-ienumguidedataproperties-clone">Clone</a>
</td>
<td align="left" width="63%">
Creates a copy of the collection. (Currently not implemented.)

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/bdatif/nf-bdatif-ienumguidedataproperties-next">Next</a>
</td>
<td align="left" width="63%">
Retrieves the next item or items in the collection.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/bdatif/nf-bdatif-ienumguidedataproperties-reset">Reset</a>
</td>
<td align="left" width="63%">
Sets the enumerator to the first item in the collection.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/bdatif/nf-bdatif-ienumguidedataproperties-skip">Skip</a>
</td>
<td align="left" width="63%">
Skips the specified number of items. (Currently not implemented.)

</td>
</tr>
</table> 


## -remarks



To declare the interface identifier (IID) for this interface, use the <b>__uuidof</b> operator: <code>__uuidof(IEnumGuideDataProperties)</code>.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mstv/bda-interfaces">BDA Interfaces</a>
 

 

