---
UID: NE:bits5_0.BITS_FILE_PROPERTY_ID
title: BITS_FILE_PROPERTY_ID (bits5_0.h)
description: Defines constants that specify ID values corresponding to background copy file properties.
old-location: bits\bits_file_property_id.htm
tech.root: Bits
ms.assetid: A14E301E-029E-43C8-B012-8FFFA652EA40
ms.date: 02/20/2019
ms.keywords: BITS_FILE_PROPERTY_ID, BITS_FILE_PROPERTY_ID enumeration [BITS], BITS_FILE_PROPERTY_ID_HTTP_RESPONSE_HEADERS, bits.bits_file_property_id, bits5_0/BITS_FILE_PROPERTY_ID, bits5_0/BITS_FILE_PROPERTY_ID_HTTP_RESPONSE_HEADERS
f1_keywords:
- bits5_0/BITS_FILE_PROPERTY_ID
dev_langs:
- c++
req.header: bits5_0.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Bits5_0.h
api_name:
- BITS_FILE_PROPERTY_ID
targetos: Windows
req.typenames: BITS_FILE_PROPERTY_ID
req.redist: 
---

# BITS_FILE_PROPERTY_ID enumeration

## -description
Defines constants that specify ID values corresponding to background copy file properties. See [IBackgroundCopyFile5::GetProperty method](/windows/desktop/delivery_optimization/ibackgroundcopyfile5-getproperty) and [SetProperty method](/windows/desktop/delivery_optimization/ibackgroundcopyfile5-setproperty).

## -enum-fields

### -field BITS_FILE_PROPERTY_ID_HTTP_RESPONSE_HEADERS

The full set of HTTP response headers from the server's last HTTP response packet.

## -see-also

* [IBackgroundCopyFile5::GetProperty method](/windows/desktop/delivery_optimization/ibackgroundcopyfile5-getproperty)
* [SetProperty method](/windows/desktop/delivery_optimization/ibackgroundcopyfile5-setproperty)
