---
UID: NE:bthledef._BTH_LE_GATT_EVENT_TYPE
title: BTH_LE_GATT_EVENT_TYPE (bthledef.h)
description: The BTH_LE_GATT_EVENT_TYPE enumeration describes the different types of Bluetooth Low Energy (LE) generic attribute (GATT) profile events.
old-location: bltooth\bth_le_gatt_event_type.htm
tech.root: bltooth
ms.assetid: 6AF30DEA-2018-4AA2-B13A-BD31BD641F9F
ms.date: 12/05/2018
ms.keywords: BTH_LE_GATT_EVENT_TYPE, BTH_LE_GATT_EVENT_TYPE enumeration [Bluetooth Devices], CharacteristicValueChangedEvent, bltooth.bth_le_gatt_event_type, bthledef/BTH_LE_GATT_EVENT_TYPE, bthledef/CharacteristicValueChangedEvent
f1_keywords:
- bthledef/BTH_LE_GATT_EVENT_TYPE
dev_langs:
- c++
req.header: bthledef.h
req.include-header: BthLEDef.h
req.target-type: Windows
req.target-min-winverclnt: Versions:\_Supported in Windows 8
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- BthLEDef.h
api_name:
- BTH_LE_GATT_EVENT_TYPE
targetos: Windows
req.typenames: BTH_LE_GATT_EVENT_TYPE
req.redist: 
ms.custom: 19H1
---

# BTH_LE_GATT_EVENT_TYPE enumeration


## -description


The BTH_LE_GATT_EVENT_TYPE enumeration describes the different types of Bluetooth Low Energy (LE) generic attribute (GATT) profile  events.


## -enum-fields




### -field CharacteristicValueChangedEvent

The characteristic value has changed.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/bthledef/nc-bthledef-pfnbluetooth_gatt_event_callback">Bluetooth GATT Event Callback Function</a>



<a href="https://docs.microsoft.com/windows/desktop/api/bluetoothleapis/nf-bluetoothleapis-bluetoothgattregisterevent">BluetoothGATTRegisterEvent</a>
 

 

