---
UID: NF:casetup.ICertSrvSetupKeyInformation.get_ExistingCACertificate
title: ICertSrvSetupKeyInformation::get_ExistingCACertificate (casetup.h)
description: Gets or sets the binary value that has been encoded by using Distinguished Encoding Rules (DER) and that is the binary value of the certification authority (CA) certificate that corresponds to an existing key.
old-location: security\icertsrvsetupkeyinformation_existingcacertificate.htm
tech.root: SecCrypto
ms.assetid: 54a3ad75-8aa9-4e1b-b9ea-006f3b2cbf29
ms.date: 12/05/2018
ms.keywords: ExistingCACertificate property [Security], ExistingCACertificate property [Security],ICertSrvSetupKeyInformation interface, ICertSrvSetupKeyInformation interface [Security],ExistingCACertificate property, ICertSrvSetupKeyInformation.ExistingCACertificate, ICertSrvSetupKeyInformation.get_ExistingCACertificate, ICertSrvSetupKeyInformation::ExistingCACertificate, ICertSrvSetupKeyInformation::get_ExistingCACertificate, ICertSrvSetupKeyInformation::put_ExistingCACertificate, casetup/ICertSrvSetupKeyInformation::ExistingCACertificate, casetup/ICertSrvSetupKeyInformation::get_ExistingCACertificate, casetup/ICertSrvSetupKeyInformation::put_ExistingCACertificate, get_ExistingCACertificate, security.icertsrvsetupkeyinformation_existingcacertificate
f1_keywords:
- casetup/ICertSrvSetupKeyInformation.ExistingCACertificate
dev_langs:
- c++
req.header: casetup.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Datacenter, Windows Server 2008 Enterprise [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Casetup.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Certocm.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Certocm.dll
api_name:
- ICertSrvSetupKeyInformation.ExistingCACertificate
- ICertSrvSetupKeyInformation.get_ExistingCACertificate
- ICertSrvSetupKeyInformation.put_ExistingCACertificate
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ICertSrvSetupKeyInformation::get_ExistingCACertificate


## -description


The <b>ExistingCACertificate</b> property gets or sets the binary value that has been encoded by using <a href="https://docs.microsoft.com/windows/desktop/SecGloss/d-gly">Distinguished Encoding Rules</a> (DER) and that is the binary value of the <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">certification authority</a> (CA) certificate that corresponds to an existing key.

This property is read/write.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/casetup/nn-casetup-icertsrvsetupkeyinformation">ICertSrvSetupKeyInformation</a>
 

 

