---
UID: NF:certadm.IOCSPAdmin.get_OCSPCAConfigurationCollection
title: IOCSPAdmin::get_OCSPCAConfigurationCollection (certadm.h)
description: Gets an instance of an OCSPCAConfigurationCollection object. This object represents the set of certification authority (CA) certificates for which an Online Certificate Status Protocol (OCSP) responder service can handle status requests.
old-location: security\iocspadmin_ocspcaconfigurationcollection_method.htm
tech.root: SecCrypto
ms.assetid: 77be6c77-f693-448b-ad2d-f148b2b3dc78
ms.date: 12/05/2018
ms.keywords: IOCSPAdmin interface [Security],OCSPCAConfigurationCollection property, IOCSPAdmin.OCSPCAConfigurationCollection, IOCSPAdmin.get_OCSPCAConfigurationCollection, IOCSPAdmin::OCSPCAConfigurationCollection, IOCSPAdmin::get_OCSPCAConfigurationCollection, OCSPCAConfigurationCollection property [Security], OCSPCAConfigurationCollection property [Security],IOCSPAdmin interface, certadm/IOCSPAdmin::OCSPCAConfigurationCollection, certadm/IOCSPAdmin::get_OCSPCAConfigurationCollection, get_OCSPCAConfigurationCollection, security.iocspadmin_ocspcaconfigurationcollection_method
f1_keywords:
- certadm/IOCSPAdmin.OCSPCAConfigurationCollection
dev_langs:
- c++
req.header: certadm.h
req.include-header: Certsrv.h
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Datacenter, Windows Server 2008 Enterprise [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Certadm.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Certadm.lib
req.dll: Certadm.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Certadm.dll
api_name:
- IOCSPAdmin.OCSPCAConfigurationCollection
- IOCSPAdmin.get_OCSPCAConfigurationCollection
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IOCSPAdmin::get_OCSPCAConfigurationCollection


## -description


The <b>OCSPCAConfigurationCollection</b> property gets an instance of an <b>OCSPCAConfigurationCollection</b> object. This object represents the set of <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">certification authority</a> (CA) certificates for which an Online Certificate Status Protocol (OCSP) responder service can handle status requests.

This property is read-only.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/certadm/nn-certadm-iocspadmin">IOCSPAdmin</a>
 

 

