---
UID: NF:certadm.IOCSPCAConfiguration.get_SigningCertificate
title: IOCSPCAConfiguration::get_SigningCertificate (certadm.h)
description: Gets or sets a signing certificate that has been encoded by using Distinguished Encoding Rules (DER). An Online Certificate Status Protocol (OCSP) responder service uses this certificate to sign its responses to certificate status requests.
old-location: security\iocspcaconfiguration_signingcertificate_method.htm
tech.root: SecCrypto
ms.assetid: 8635c9f0-3c70-4037-8633-7a3440aff6c8
ms.date: 12/05/2018
ms.keywords: IOCSPCAConfiguration interface [Security],SigningCertificate property, IOCSPCAConfiguration.SigningCertificate, IOCSPCAConfiguration.get_SigningCertificate, IOCSPCAConfiguration::SigningCertificate, IOCSPCAConfiguration::get_SigningCertificate, IOCSPCAConfiguration::put_SigningCertificate, SigningCertificate property [Security], SigningCertificate property [Security],IOCSPCAConfiguration interface, certadm/IOCSPCAConfiguration::SigningCertificate, certadm/IOCSPCAConfiguration::get_SigningCertificate, certadm/IOCSPCAConfiguration::put_SigningCertificate, get_SigningCertificate, security.iocspcaconfiguration_signingcertificate_method
f1_keywords:
- certadm/IOCSPCAConfiguration.SigningCertificate
dev_langs:
- c++
req.header: certadm.h
req.include-header: Certserv.h
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Datacenter, Windows Server 2008 Enterprise [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Certadm.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Certadm.lib
req.dll: Certadm.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Certadm.dll
api_name:
- IOCSPCAConfiguration.SigningCertificate
- IOCSPCAConfiguration.get_SigningCertificate
- IOCSPCAConfiguration.put_SigningCertificate
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IOCSPCAConfiguration::get_SigningCertificate


## -description


The <b>SigningCertificate</b> property gets or sets a signing certificate that has been encoded by using <a href="https://docs.microsoft.com/windows/desktop/SecGloss/d-gly">Distinguished Encoding Rules</a> (DER). An Online Certificate Status Protocol (OCSP) responder service uses this certificate to sign its responses to certificate status requests.

This property is read/write.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/certadm/nn-certadm-iocspcaconfiguration">IOCSPCAConfiguration</a>
 

 

