---
UID: NF:certadm.IOCSPProperty.get_Name
title: IOCSPProperty::get_Name (certadm.h)
description: Gets the identifier part of the name-value pair represented by an OCSPProperty object.
old-location: security\iocspproperty_name_method.htm
tech.root: SecCrypto
ms.assetid: 33980a7c-0ae5-470b-a55a-f3e19c8846a6
ms.date: 12/05/2018
ms.keywords: IOCSPProperty interface [Security],Name property, IOCSPProperty.Name, IOCSPProperty.get_Name, IOCSPProperty::Name, IOCSPProperty::get_Name, Name property [Security], Name property [Security],IOCSPProperty interface, certadm/IOCSPProperty::Name, certadm/IOCSPProperty::get_Name, get_Name, security.iocspproperty_name_method
f1_keywords:
- certadm/IOCSPProperty.Name
dev_langs:
- c++
req.header: certadm.h
req.include-header: Certserv.h
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Datacenter, Windows Server 2008 Enterprise [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Certadm.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Certadm.lib
req.dll: Certadm.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Certadm.dll
api_name:
- IOCSPProperty.Name
- IOCSPProperty.get_Name
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IOCSPProperty::get_Name


## -description


The <b>Name</b> property gets the identifier part of the name-value pair represented by an <b>OCSPProperty</b> object.

This property is read-only.


## -parameters


## -remarks



For possible values of <i>pVal</i>, see <a href="https://docs.microsoft.com/windows/desktop/api/certadm/nf-certadm-iocspadmin-get_ocspserviceproperties">OCSPServiceProperties</a> or <a href="https://docs.microsoft.com/windows/desktop/api/certadm/nf-certadm-iocspcaconfiguration-get_providerproperties">ProviderProperties</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/certadm/nn-certadm-iocspproperty">IOCSPProperty</a>
 

 

