---
UID: NF:certadm.IOCSPProperty.get_Value
title: IOCSPProperty::get_Value (certadm.h)
description: Gets or sets the data part of the name-value pair represented by an OCSPProperty object.
old-location: security\iocspproperty_value_method.htm
tech.root: SecCrypto
ms.assetid: 6c0b37fb-381d-4224-9d4a-a22e9b2b4e6e
ms.date: 12/05/2018
ms.keywords: IOCSPProperty interface [Security],Value property, IOCSPProperty.Value, IOCSPProperty.get_Value, IOCSPProperty::Value, IOCSPProperty::get_Value, IOCSPProperty::put_Value, Value property [Security], Value property [Security],IOCSPProperty interface, certadm/IOCSPProperty::Value, certadm/IOCSPProperty::get_Value, certadm/IOCSPProperty::put_Value, get_Value, security.iocspproperty_value_method
f1_keywords:
- certadm/IOCSPProperty.Value
dev_langs:
- c++
req.header: certadm.h
req.include-header: Certserv.h
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Datacenter, Windows Server 2008 Enterprise [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Certadm.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Certadm.lib
req.dll: Certadm.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Certadm.dll
api_name:
- IOCSPProperty.Value
- IOCSPProperty.get_Value
- IOCSPProperty.put_Value
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IOCSPProperty::get_Value


## -description


The <b>Value</b> property gets or sets the data part of the name-value pair represented by an <b>OCSPProperty</b> object.

This property is read/write.


## -parameters


## -remarks



For possible values of <i>newVal</i> and <i>pVal</i>, see <a href="https://docs.microsoft.com/windows/desktop/api/certadm/nf-certadm-iocspadmin-get_ocspserviceproperties">OCSPServiceProperties</a> or <a href="https://docs.microsoft.com/windows/desktop/api/certadm/nf-certadm-iocspcaconfiguration-get_providerproperties">ProviderProperties</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/certadm/nn-certadm-iocspproperty">IOCSPProperty</a>
 

 

