---
UID: NE:certenroll.Pkcs10AllowedSignatureTypes
title: Pkcs10AllowedSignatureTypes (certenroll.h)
description: Specifies the type of signature permitted when signing a certificate request.
old-location: security\pkcs10allowedsignaturetypes_enum.htm
tech.root: seccertenroll
ms.assetid: b5c6a28b-d46b-4d93-adc2-625a82d6df7a
ms.date: 12/05/2018
ms.keywords: AllowedKeySignature, AllowedNullSignature, Pkcs10AllowedSignatureTypes, Pkcs10AllowedSignatureTypes enumeration [Security], certenroll/AllowedKeySignature, certenroll/AllowedNullSignature, certenroll/Pkcs10AllowedSignatureTypes, security.pkcs10allowedsignaturetypes_enum
f1_keywords:
- certenroll/Pkcs10AllowedSignatureTypes
dev_langs:
- c++
req.header: certenroll.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- CertEnroll.h
api_name:
- Pkcs10AllowedSignatureTypes
targetos: Windows
req.typenames: Pkcs10AllowedSignatureTypes
req.redist: 
ms.custom: 19H1
---

# Pkcs10AllowedSignatureTypes enumeration


## -description


The <b>Pkcs10AllowedSignatureTypes</b> enumeration type specifies the type of signature permitted when signing a <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">certificate request</a>. This enumeration is used by the <a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nf-certenroll-ix509certificaterequestpkcs10-checksignature">CheckSignature</a> method on the <a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nn-certenroll-ix509certificaterequestpkcs10">IX509CertificateRequestPkcs10</a> interface to determine whether a signature exists and is valid.


## -enum-fields




### -field AllowedKeySignature

Signatures generated by using <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">cryptographic keys</a> are allowed.


### -field AllowedNullSignature

Null signatures are allowed. A null signature is a SHA-1 <a href="https://docs.microsoft.com/windows/desktop/SecGloss/h-gly">hash</a>.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/SecCertEnroll/certenroll-enumerations">CertEnroll Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/SecCertEnroll/certenroll-interfaces">CertEnroll Interfaces</a>



<a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nf-certenroll-ix509certificaterequestpkcs10-checksignature">CheckSignature</a>
 

 

