---
UID: NE:certenroll.WebSecurityLevel
title: WebSecurityLevel (certenroll.h)
description: Specifies whether a web-enabled method or property is safe for scripting.
old-location: security\websecuritylevel_enum.htm
tech.root: seccertenroll
ms.assetid: fa87ec81-59d9-495c-9b2e-5394678cd020
ms.date: 12/05/2018
ms.keywords: LevelSafe, LevelUnsafe, WebSecurityLevel, WebSecurityLevel enumeration [Security], certenroll/LevelSafe, certenroll/LevelUnsafe, certenroll/WebSecurityLevel, security.websecuritylevel_enum
f1_keywords:
- certenroll/WebSecurityLevel
dev_langs:
- c++
req.header: certenroll.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- CertEnroll.h
api_name:
- WebSecurityLevel
targetos: Windows
req.typenames: WebSecurityLevel
req.redist: 
ms.custom: 19H1
---

# WebSecurityLevel enumeration


## -description


The <b>WebSecurityLevel</b> enumeration type specifies whether a web-enabled method or property is safe for scripting.


## -enum-fields




### -field LevelUnsafe

The method is not safe for scripting.


### -field LevelSafe

The method is safe for scripting.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/SecCertEnroll/certenroll-enumerations">CertEnroll Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/SecCertEnroll/certenroll-interfaces">CertEnroll Interfaces</a>
 

 

