---
UID: NF:certenroll.IX509CertificateRequest.get_ClientId
title: IX509CertificateRequest::get_ClientId (certenroll.h)
description: Specifies and retrieves a value that identifies the executable that created the request.
old-location: security\ix509certificaterequest_clientid_property.htm
tech.root: seccertenroll
ms.assetid: 728dba16-cda8-4eca-8cf0-4e6139e3808b
ms.date: 12/05/2018
ms.keywords: ClientId property [Security], ClientId property [Security],IX509CertificateRequest interface, IX509CertificateRequest interface [Security],ClientId property, IX509CertificateRequest.ClientId, IX509CertificateRequest.get_ClientId, IX509CertificateRequest::ClientId, IX509CertificateRequest::get_ClientId, IX509CertificateRequest::put_ClientId, certenroll/IX509CertificateRequest::ClientId, certenroll/IX509CertificateRequest::get_ClientId, certenroll/IX509CertificateRequest::put_ClientId, get_ClientId, security.ix509certificaterequest_clientid_property
f1_keywords:
- certenroll/IX509CertificateRequest.ClientId
dev_langs:
- c++
req.header: certenroll.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: CertEnroll.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- CertEnroll.dll
api_name:
- IX509CertificateRequest.ClientId
- IX509CertificateRequest.get_ClientId
- IX509CertificateRequest.put_ClientId
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IX509CertificateRequest::get_ClientId


## -description


The <b>ClientId</b> property specifies and retrieves a value that identifies the executable that created the request. For example, a request can be generated by using a request wizard, by an auto-enrollment process, or by other means. This property is web enabled for both input and output.

This property is read/write.


## -parameters


## -remarks



You must initialize the request object before calling this property. You can call this property before calling the <a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nf-certenroll-ix509certificaterequest-encode">Encode</a> method.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nn-certenroll-ix509certificaterequest">IX509CertificateRequest</a>



<a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nn-certenroll-ix509certificaterequestcertificate">IX509CertificateRequestCertificate</a>



<a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nn-certenroll-ix509certificaterequestcmc">IX509CertificateRequestCmc</a>



<a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nn-certenroll-ix509certificaterequestpkcs10">IX509CertificateRequestPkcs10</a>



<a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nn-certenroll-ix509certificaterequestpkcs7">IX509CertificateRequestPkcs7</a>



<a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nn-certenroll-ix509signatureinformation">IX509SignatureInformation</a>
 

 

