---
UID: NF:certenroll.IX509CertificateRequestPkcs10.CheckSignature
title: IX509CertificateRequestPkcs10::CheckSignature (certenroll.h)
description: Verifies that the certificate request has been signed and that the signature is valid.
old-location: security\ix509certificaterequestpkcs10_checksignature_method.htm
tech.root: seccertenroll
ms.assetid: 8ef520d9-f6d4-46fd-8e91-c2113ea8eb20
ms.date: 12/05/2018
ms.keywords: AllowedKeySignature, AllowedNullSignature, CheckSignature, CheckSignature method [Security], CheckSignature method [Security],IX509CertificateRequestPkcs10 interface, IX509CertificateRequestPkcs10 interface [Security],CheckSignature method, IX509CertificateRequestPkcs10.CheckSignature, IX509CertificateRequestPkcs10::CheckSignature, certenroll/IX509CertificateRequestPkcs10::CheckSignature, security.ix509certificaterequestpkcs10_checksignature_method
f1_keywords:
- certenroll/IX509CertificateRequestPkcs10.CheckSignature
dev_langs:
- c++
req.header: certenroll.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: CertEnroll.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- CertEnroll.dll
api_name:
- IX509CertificateRequestPkcs10.CheckSignature
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IX509CertificateRequestPkcs10::CheckSignature


## -description


The <b>CheckSignature</b> method verifies that the certificate request has been signed and that the signature is valid.


## -parameters




### -param AllowedSignatureTypes [in]

An <a href="https://docs.microsoft.com/windows/desktop/api/certenroll/ne-certenroll-pkcs10allowedsignaturetypes">Pkcs10AllowedSignatureTypes</a> enumeration value. This can be a bitwise combination of the following values.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="AllowedKeySignature"></a><a id="allowedkeysignature"></a><a id="ALLOWEDKEYSIGNATURE"></a><dl>
<dt><b>AllowedKeySignature</b></dt>
<dt></dt>
</dl>
</td>
<td width="60%">
Signatures generated by using asymmetric keys are permitted. If this flag is set, the signature is verified against the public key in the PKCS #10 request.

</td>
</tr>
<tr>
<td width="40%"><a id="AllowedNullSignature"></a><a id="allowednullsignature"></a><a id="ALLOWEDNULLSIGNATURE"></a><dl>
<dt><b>AllowedNullSignature</b></dt>
<dt></dt>
</dl>
</td>
<td width="60%">
Null-signed signatures are permitted.

</td>
</tr>
</table>
 


## -returns



If the function succeeds, the function returns <b>S_OK</b>.

If the function fails, it returns an <b>HRESULT</b> value that indicates the error. Possible values include, but are not limited to, those in the following table. For a list of common error codes, see <a href="https://docs.microsoft.com/windows/desktop/SecCrypto/common-hresult-values">Common HRESULT Values</a>.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>CRYPT_E_NO_SIGNER</b></dt>
</dl>
</td>
<td width="60%">
The certificate request has not been signed.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_INVALID_STATE</b></dt>
</dl>
</td>
<td width="60%">
The signature type is not specified by the <i>AllowedSignatureTypes</i> parameter.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>NTE_BAD_SIGNATURE</b></dt>
</dl>
</td>
<td width="60%">
The value specified by the <i>AllowedSignatureTypes</i> parameter is not a member of the <a href="https://docs.microsoft.com/windows/desktop/api/certenroll/ne-certenroll-pkcs10allowedsignaturetypes">Pkcs10AllowedSignatureTypes</a> enumeration type.

</td>
</tr>
</table>
 




## -remarks



This method uses the public key to decrypt the signature and compares the signature to a hash of the certificate request.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nn-certenroll-ix509certificaterequestpkcs10">IX509CertificateRequestPkcs10</a>
 

 

