---
UID: NF:certenroll.IX509CertificateRequestPkcs10V3.get_EncryptionStrength
title: IX509CertificateRequestPkcs10V3::get_EncryptionStrength (certenroll.h)
description: Identifies the bit length for the EncryptionAlgorithm to use for encryption. If the EncryptionAlgorithm only supports one bit length, then you do not need to specify a value for the EncryptionStrength property.
old-location: security\ix509certificaterequestpkcs10v3_encryptionstrength.htm
tech.root: seccertenroll
ms.assetid: 4c3f1825-ded8-4692-9ad9-b6c09beffc71
ms.date: 12/05/2018
ms.keywords: EncryptionStrength property [Security], EncryptionStrength property [Security],IX509CertificateRequestPkcs10V3 interface, IX509CertificateRequestPkcs10V3 interface [Security],EncryptionStrength property, IX509CertificateRequestPkcs10V3.EncryptionStrength, IX509CertificateRequestPkcs10V3.get_EncryptionStrength, IX509CertificateRequestPkcs10V3::EncryptionStrength, IX509CertificateRequestPkcs10V3::get_EncryptionStrength, IX509CertificateRequestPkcs10V3::put_EncryptionStrength, certenroll/IX509CertificateRequestPkcs10V3::EncryptionStrength, certenroll/IX509CertificateRequestPkcs10V3::get_EncryptionStrength, certenroll/IX509CertificateRequestPkcs10V3::put_EncryptionStrength, get_EncryptionStrength, security.ix509certificaterequestpkcs10v3_encryptionstrength
f1_keywords:
- certenroll/IX509CertificateRequestPkcs10V3.EncryptionStrength
dev_langs:
- c++
req.header: certenroll.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Certenroll.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Certenroll.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Certenroll.dll
api_name:
- IX509CertificateRequestPkcs10V3.EncryptionStrength
- IX509CertificateRequestPkcs10V3.get_EncryptionStrength
- IX509CertificateRequestPkcs10V3.put_EncryptionStrength
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IX509CertificateRequestPkcs10V3::get_EncryptionStrength


## -description


Identifies the bit length for the <a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nf-certenroll-ix509certificaterequestpkcs10v3-get_encryptionalgorithm">EncryptionAlgorithm</a> to use for encryption. If the <b>EncryptionAlgorithm</b> only supports one bit length, then you do not need to specify a value for the <b>EncryptionStrength</b> property.

This property is read/write.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/certenroll/nn-certenroll-ix509certificaterequestpkcs10v3">IX509CertificateRequestPkcs10V3</a>
 

 

