---
UID: NF:chstring.CHString.LoadStringW(UINT,LPWSTR,UINT)
title: CHString::LoadStringW(UINT,LPWSTR,UINT) (chstring.h)
description: The LoadStringW method reads a Windows string resource (identified by nID) into an existing CHString object.
old-location: wmi\chstring_loadstringw.htm
tech.root: WmiSdk
ms.assetid: b5dca7ce-41b2-4290-bb15-23e0a8d64bd1
ms.date: 12/05/2018
ms.keywords: CHString interface [Windows Management Instrumentation],LoadStringW method, CHString.LoadStringW, CHString.LoadStringW(UINT,LPWSTR,UINT), CHString::LoadStringW, CHString::LoadStringW(UINT,LPWSTR,UINT), LoadStringW, LoadStringW method [Windows Management Instrumentation], LoadStringW method [Windows Management Instrumentation],CHString interface, _hmm_chstring_loadstringw, chstring/CHString::LoadStringW, wmi.chstring_loadstringw
f1_keywords:
- chstring/CHString.LoadStringW
dev_langs:
- c++
req.header: chstring.h
req.include-header: FwCommon.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: FrameDyn.lib
req.dll: FrameDynOS.dll; FrameDyn.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- FrameDynOS.dll
- FrameDyn.dll
api_name:
- CHString.LoadStringW
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CHString::LoadStringW(UINT,LPWSTR,UINT)


## -description


<p class="CCE_Message">[The <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/chstring">CHString</a> class 
    is part of the WMI Provider Framework which is now considered in final state, and no further development, 
    enhancements, or updates will be available for non-security related issues affecting these libraries. The 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/wmi_v2/windows-management-infrastructure">MI APIs</a> should be used for all new 
    development.]

The <b>LoadStringW</b> method reads a Windows string resource (identified by <i>nID</i>) into an existing <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/chstring">CHString</a> object.


## -parameters




### -param nID

Windows string resource identifier.


### -param lpszBuf

The buffer into which the string resource is read.


### -param nMaxBuf

The maximum number of bytes that can be read into the buffer.




## -returns



If the <b>LoadStringW</b> method is successful, the resource string is loaded into the <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/chstring">CHString</a> object, and the method returns a nonzero value. If the method is unsuccessful, it returns zero.



