---
UID: NF:chstring.CHString.operator LPCWSTR
title: CHString::operator LPCWSTR (chstring.h)
description: The operator LPCWSTR conversion operator provides an efficient method to access the NULL-terminated C string contained in a CHString object.
old-location: wmi\chstring_operator_lpcwstr.htm
tech.root: WmiSdk
ms.assetid: f7b7575e-e442-487f-9123-c82c471fecdf
ms.date: 12/05/2018
ms.keywords: ??BCHString@@QBEPBGXZ, ??BCHString@@QEBAPEBGXZ, CHString interface [Windows Management Instrumentation],operator LPCWSTR method, CHString.operator LPCWSTR, CHString::operator LPCWSTR, chstring/CHString::operator LPCWSTR, operator LPCWSTR, operator LPCWSTR method [Windows Management Instrumentation], operator LPCWSTR method [Windows Management Instrumentation],CHString interface, wmi.chstring_operator_lpcwstr
f1_keywords:
- chstring/CHString.operator LPCWSTR
dev_langs:
- c++
req.header: chstring.h
req.include-header: FwCommon.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: FrameDyn.lib
req.dll: FrameDynOS.dll; FrameDyn.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- FrameDynOS.dll
- FrameDyn.dll
api_name:
- CHString.operator LPCWSTR
- ??BCHString@@QBEPBGXZ
- ??BCHString@@QEBAPEBGXZ
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CHString::operator LPCWSTR


## -description


<p class="CCE_Message">[The <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/chstring">CHString</a> class 
    is part of the WMI Provider Framework which is now considered in final state, and no further development, 
    enhancements, or updates will be available for non-security related issues affecting these libraries. The 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/wmi_v2/windows-management-infrastructure">MI APIs</a> should be used for all new 
    development.]

The <b>operator LPCWSTR</b> conversion operator provides an efficient method to access the <b>NULL</b>-terminated C string contained in a <a href="https://docs.microsoft.com/windows/desktop/WmiSdk/chstring">CHString</a> object.


## -parameters






## -returns



This method does not return a value.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/chstring">CHString</a>
 

 

