---
UID: NE:clusapi.CLCTL_CODES
title: CLCTL_CODES (clusapi.h)
description: Enumerates the possible operations that a control code will perform.
old-location: mscs\clctl_codes.htm
tech.root: MsCS
ms.assetid: daf9a556-e365-4fb3-9378-8b5d526dc1fe
ms.date: 12/05/2018
ms.keywords: CLCTL_ADD_CRYPTO_CHECKPOINT, CLCTL_ADD_CRYPTO_CHECKPOINT_EX, CLCTL_ADD_DEPENDENCY, CLCTL_ADD_OWNER, CLCTL_ADD_REGISTRY_CHECKPOINT, CLCTL_ADD_REGISTRY_CHECKPOINT_32BIT, CLCTL_ADD_REGISTRY_CHECKPOINT_64BIT, CLCTL_BATCH_BLOCK_KEY, CLCTL_BATCH_UNBLOCK_KEY, CLCTL_BLOCK_GEM_SEND_RECV, CLCTL_CHECK_VOTER_DOWN, CLCTL_CHECK_VOTER_EVICT, CLCTL_CLEAR_NODE_CONNECTION_INFO, CLCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS, CLCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY, CLCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY, CLCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN, CLCTL_CLUSTER_NAME_CHANGED, CLCTL_CLUSTER_VERSION_CHANGED, CLCTL_CODES, CLCTL_CODES enumeration [Failover Cluster], CLCTL_DELETE, CLCTL_DELETE_CRYPTO_CHECKPOINT, CLCTL_DELETE_REGISTRY_CHECKPOINT, CLCTL_DISABLE_SHARED_VOLUME_DIRECTIO, CLCTL_ENABLE_SHARED_VOLUME_DIRECTIO, CLCTL_ENUM_COMMON_PROPERTIES, CLCTL_ENUM_PRIVATE_PROPERTIES, CLCTL_EVICT_NODE, CLCTL_FILESERVER_SHARE_ADD, CLCTL_FILESERVER_SHARE_DEL, CLCTL_FILESERVER_SHARE_MODIFY, CLCTL_FILESERVER_SHARE_REPORT, CLCTL_FIXUP_ON_UPGRADE, CLCTL_FORCE_QUORUM, CLCTL_FSWITNESS_GET_EPOCH_INFO, CLCTL_FSWITNESS_RELEASE_LOCK, CLCTL_FSWITNESS_SET_EPOCH_INFO, CLCTL_GET_ARB_TIMEOUT, CLCTL_GET_CHARACTERISTICS, CLCTL_GET_CLASS_INFO, CLCTL_GET_CLUSDB_TIMESTAMP, CLCTL_GET_CLUSTER_SERVICE_ACCOUNT_NAME, CLCTL_GET_COMMON_PROPERTIES, CLCTL_GET_COMMON_PROPERTY_FMTS, CLCTL_GET_COMMON_RESOURCE_PROPERTY_FMTS, CLCTL_GET_CRYPTO_CHECKPOINTS, CLCTL_GET_DNS_NAME, CLCTL_GET_FAILURE_INFO, CLCTL_GET_FLAGS, CLCTL_GET_FQDN, CLCTL_GET_GEMID_VECTOR, CLCTL_GET_GUM_LOCK_OWNER, CLCTL_GET_ID, CLCTL_GET_LOADBAL_PROCESS_LIST, CLCTL_GET_NAME, CLCTL_GET_NETWORK, CLCTL_GET_NETWORK_NAME, CLCTL_GET_NODE, CLCTL_GET_OPERATION_CONTEXT, CLCTL_GET_PRIVATE_PROPERTIES, CLCTL_GET_PRIVATE_PROPERTY_FMTS, CLCTL_GET_PRIVATE_RESOURCE_PROPERTY_FMTS, CLCTL_GET_REGISTRY_CHECKPOINTS, CLCTL_GET_REQUIRED_DEPENDENCIES, CLCTL_GET_RESOURCE_TYPE, CLCTL_GET_ROUTESTATUS_BASIC, CLCTL_GET_ROUTESTATUS_EXTENDED, CLCTL_GET_RO_COMMON_PROPERTIES, CLCTL_GET_RO_PRIVATE_PROPERTIES, CLCTL_GET_SHARED_VOLUME_ID, CLCTL_GET_STATE_CHANGE_TIME, CLCTL_GET_STORAGE_CONFIGURATION, CLCTL_GET_STORAGE_CONFIG_ATTRIBUTES, CLCTL_GET_STUCK_NODES, CLCTL_GROUPSET_GET_GROUPS, CLCTL_GROUPSET_GET_PROVIDER_GROUPS, CLCTL_GROUPSET_GET_PROVIDER_GROUPSETS, CLCTL_GROUP_GET_LAST_MOVE_TIME, CLCTL_GROUP_GET_PROVIDER_GROUPS, CLCTL_GROUP_GET_PROVIDER_GROUPSETS, CLCTL_HOLD_IO, CLCTL_INITIALIZE, CLCTL_INJECT_GEM_FAULT, CLCTL_INSTALL_NODE, CLCTL_INTRODUCE_GEM_REPAIR_DELAY, CLCTL_IPADDRESS_RELEASE_LEASE, CLCTL_IPADDRESS_RENEW_LEASE, CLCTL_IS_QUORUM_BLOCKED, CLCTL_JOINING_GROUP, CLCTL_LEAVING_GROUP, CLCTL_NETNAME_CREDS_NOTIFYCAM, CLCTL_NETNAME_CREDS_UPDATED, CLCTL_NETNAME_DELETE_CO, CLCTL_NETNAME_GET_OU_FOR_VCO, CLCTL_NETNAME_GET_VIRTUAL_SERVER_TOKEN, CLCTL_NETNAME_REGISTER_DNS_RECORDS, CLCTL_NETNAME_REPAIR_VCO, CLCTL_NETNAME_RESET_VCO, CLCTL_NETNAME_SET_PWD_INFO, CLCTL_NETNAME_VALIDATE_VCO, CLCTL_NOTIFY_OWNER_CHANGE, CLCTL_NOTIFY_QUORUM_STATUS, CLCTL_POOL_GET_DRIVE_INFO, CLCTL_PROVIDER_STATE_CHANGE, CLCTL_QUERY_DELETE, CLCTL_QUERY_MAINTENANCE_MODE, CLCTL_REMOVE_DEPENDENCY, CLCTL_REMOVE_NODE, CLCTL_REMOVE_OWNER, CLCTL_REPLICATION_GET_ELIGIBLE_LOGDISKS, CLCTL_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS, CLCTL_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS, CLCTL_REPLICATION_GET_LOG_INFO, CLCTL_REPLICATION_GET_LOG_VOLUME, CLCTL_REPLICATION_GET_REPLICATED_DISKS, CLCTL_REPLICATION_GET_REPLICATED_PARTITION_INFO, CLCTL_REPLICATION_GET_REPLICA_VOLUMES, CLCTL_REPLICATION_GET_RESOURCE_GROUP, CLCTL_RESOURCE_PREPARE_UPGRADE, CLCTL_RESOURCE_UPGRADE_COMPLETED, CLCTL_RESOURCE_UPGRADE_DLL, CLCTL_RESUME_IO, CLCTL_RW_MODIFY_NOOP, CLCTL_SEND_DUMMY_GEM_MESSAGES, CLCTL_SET_ACCOUNT_ACCESS, CLCTL_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES, CLCTL_SET_CLUSTER_S2D_ENABLED, CLCTL_SET_COMMON_PROPERTIES, CLCTL_SET_CSV_MAINTENANCE_MODE, CLCTL_SET_DNS_DOMAIN, CLCTL_SET_MAINTENANCE_MODE, CLCTL_SET_NAME, CLCTL_SET_PRIVATE_PROPERTIES, CLCTL_SET_SHARED_VOLUME_BACKUP_MODE, CLCTL_SET_STORAGE_CONFIGURATION, CLCTL_SHUTDOWN, CLCTL_STARTING_PHASE1, CLCTL_STARTING_PHASE2, CLCTL_STATE_CHANGE_REASON, CLCTL_STORAGE_CLUSTER_DISK, CLCTL_STORAGE_GET_AVAILABLE_DISKS, CLCTL_STORAGE_GET_AVAILABLE_DISKS_EX, CLCTL_STORAGE_GET_AVAILABLE_DISKS_EX2_INT, CLCTL_STORAGE_GET_CLUSPORT_DISK_COUNT, CLCTL_STORAGE_GET_DIRTY, CLCTL_STORAGE_GET_DISKID, CLCTL_STORAGE_GET_DISK_INFO, CLCTL_STORAGE_GET_DISK_INFO_EX, CLCTL_STORAGE_GET_DISK_INFO_EX2, CLCTL_STORAGE_GET_DISK_NUMBER, CLCTL_STORAGE_GET_DISK_NUMBER_INFO, CLCTL_STORAGE_GET_DRIVELETTERS, CLCTL_STORAGE_GET_MOUNTPOINTS, CLCTL_STORAGE_GET_RESOURCEID, CLCTL_STORAGE_GET_SHARED_VOLUME_INFO, CLCTL_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES, CLCTL_STORAGE_GET_SHARED_VOLUME_STATES, CLCTL_STORAGE_IS_CLUSTERABLE, CLCTL_STORAGE_IS_CSV_FILE, CLCTL_STORAGE_IS_PATH_VALID, CLCTL_STORAGE_IS_SHARED_VOLUME, CLCTL_STORAGE_REMAP_DRIVELETTER, CLCTL_STORAGE_REMOVE_VM_OWNERSHIP, CLCTL_STORAGE_SET_DRIVELETTER, CLCTL_STORAGE_SYNC_CLUSDISK_DB, CLCTL_UNKNOWN, CLCTL_VALIDATE_CHANGE_GROUP, CLCTL_VALIDATE_COMMON_PROPERTIES, CLCTL_VALIDATE_DIRECTORY, CLCTL_VALIDATE_NETNAME, CLCTL_VALIDATE_PATH, CLCTL_VALIDATE_PRIVATE_PROPERTIES, _CLCTL_CODES, _CLCTL_CODES enumeration [Failover Cluster], clusapi/CLCTL_ADD_CRYPTO_CHECKPOINT, clusapi/CLCTL_ADD_CRYPTO_CHECKPOINT_EX, clusapi/CLCTL_ADD_DEPENDENCY, clusapi/CLCTL_ADD_OWNER, clusapi/CLCTL_ADD_REGISTRY_CHECKPOINT, clusapi/CLCTL_ADD_REGISTRY_CHECKPOINT_32BIT, clusapi/CLCTL_ADD_REGISTRY_CHECKPOINT_64BIT, clusapi/CLCTL_BATCH_BLOCK_KEY, clusapi/CLCTL_BATCH_UNBLOCK_KEY, clusapi/CLCTL_BLOCK_GEM_SEND_RECV, clusapi/CLCTL_CHECK_VOTER_DOWN, clusapi/CLCTL_CHECK_VOTER_EVICT, clusapi/CLCTL_CLEAR_NODE_CONNECTION_INFO, clusapi/CLCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS, clusapi/CLCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY, clusapi/CLCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY, clusapi/CLCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN, clusapi/CLCTL_CLUSTER_NAME_CHANGED, clusapi/CLCTL_CLUSTER_VERSION_CHANGED, clusapi/CLCTL_CODES, clusapi/CLCTL_DELETE, clusapi/CLCTL_DELETE_CRYPTO_CHECKPOINT, clusapi/CLCTL_DELETE_REGISTRY_CHECKPOINT, clusapi/CLCTL_DISABLE_SHARED_VOLUME_DIRECTIO, clusapi/CLCTL_ENABLE_SHARED_VOLUME_DIRECTIO, clusapi/CLCTL_ENUM_COMMON_PROPERTIES, clusapi/CLCTL_ENUM_PRIVATE_PROPERTIES, clusapi/CLCTL_EVICT_NODE, clusapi/CLCTL_FILESERVER_SHARE_ADD, clusapi/CLCTL_FILESERVER_SHARE_DEL, clusapi/CLCTL_FILESERVER_SHARE_MODIFY, clusapi/CLCTL_FILESERVER_SHARE_REPORT, clusapi/CLCTL_FIXUP_ON_UPGRADE, clusapi/CLCTL_FORCE_QUORUM, clusapi/CLCTL_FSWITNESS_GET_EPOCH_INFO, clusapi/CLCTL_FSWITNESS_RELEASE_LOCK, clusapi/CLCTL_FSWITNESS_SET_EPOCH_INFO, clusapi/CLCTL_GET_ARB_TIMEOUT, clusapi/CLCTL_GET_CHARACTERISTICS, clusapi/CLCTL_GET_CLASS_INFO, clusapi/CLCTL_GET_CLUSDB_TIMESTAMP, clusapi/CLCTL_GET_CLUSTER_SERVICE_ACCOUNT_NAME, clusapi/CLCTL_GET_COMMON_PROPERTIES, clusapi/CLCTL_GET_COMMON_PROPERTY_FMTS, clusapi/CLCTL_GET_COMMON_RESOURCE_PROPERTY_FMTS, clusapi/CLCTL_GET_CRYPTO_CHECKPOINTS, clusapi/CLCTL_GET_DNS_NAME, clusapi/CLCTL_GET_FAILURE_INFO, clusapi/CLCTL_GET_FLAGS, clusapi/CLCTL_GET_FQDN, clusapi/CLCTL_GET_GEMID_VECTOR, clusapi/CLCTL_GET_GUM_LOCK_OWNER, clusapi/CLCTL_GET_ID, clusapi/CLCTL_GET_LOADBAL_PROCESS_LIST, clusapi/CLCTL_GET_NAME, clusapi/CLCTL_GET_NETWORK, clusapi/CLCTL_GET_NETWORK_NAME, clusapi/CLCTL_GET_NODE, clusapi/CLCTL_GET_OPERATION_CONTEXT, clusapi/CLCTL_GET_PRIVATE_PROPERTIES, clusapi/CLCTL_GET_PRIVATE_PROPERTY_FMTS, clusapi/CLCTL_GET_PRIVATE_RESOURCE_PROPERTY_FMTS, clusapi/CLCTL_GET_REGISTRY_CHECKPOINTS, clusapi/CLCTL_GET_REQUIRED_DEPENDENCIES, clusapi/CLCTL_GET_RESOURCE_TYPE, clusapi/CLCTL_GET_ROUTESTATUS_BASIC, clusapi/CLCTL_GET_ROUTESTATUS_EXTENDED, clusapi/CLCTL_GET_RO_COMMON_PROPERTIES, clusapi/CLCTL_GET_RO_PRIVATE_PROPERTIES, clusapi/CLCTL_GET_SHARED_VOLUME_ID, clusapi/CLCTL_GET_STATE_CHANGE_TIME, clusapi/CLCTL_GET_STORAGE_CONFIGURATION, clusapi/CLCTL_GET_STORAGE_CONFIG_ATTRIBUTES, clusapi/CLCTL_GET_STUCK_NODES, clusapi/CLCTL_GROUPSET_GET_GROUPS, clusapi/CLCTL_GROUPSET_GET_PROVIDER_GROUPS, clusapi/CLCTL_GROUPSET_GET_PROVIDER_GROUPSETS, clusapi/CLCTL_GROUP_GET_LAST_MOVE_TIME, clusapi/CLCTL_GROUP_GET_PROVIDER_GROUPS, clusapi/CLCTL_GROUP_GET_PROVIDER_GROUPSETS, clusapi/CLCTL_HOLD_IO, clusapi/CLCTL_INITIALIZE, clusapi/CLCTL_INJECT_GEM_FAULT, clusapi/CLCTL_INSTALL_NODE, clusapi/CLCTL_INTRODUCE_GEM_REPAIR_DELAY, clusapi/CLCTL_IPADDRESS_RELEASE_LEASE, clusapi/CLCTL_IPADDRESS_RENEW_LEASE, clusapi/CLCTL_IS_QUORUM_BLOCKED, clusapi/CLCTL_JOINING_GROUP, clusapi/CLCTL_LEAVING_GROUP, clusapi/CLCTL_NETNAME_CREDS_NOTIFYCAM, clusapi/CLCTL_NETNAME_CREDS_UPDATED, clusapi/CLCTL_NETNAME_DELETE_CO, clusapi/CLCTL_NETNAME_GET_OU_FOR_VCO, clusapi/CLCTL_NETNAME_GET_VIRTUAL_SERVER_TOKEN, clusapi/CLCTL_NETNAME_REGISTER_DNS_RECORDS, clusapi/CLCTL_NETNAME_REPAIR_VCO, clusapi/CLCTL_NETNAME_RESET_VCO, clusapi/CLCTL_NETNAME_SET_PWD_INFO, clusapi/CLCTL_NETNAME_VALIDATE_VCO, clusapi/CLCTL_NOTIFY_OWNER_CHANGE, clusapi/CLCTL_NOTIFY_QUORUM_STATUS, clusapi/CLCTL_POOL_GET_DRIVE_INFO, clusapi/CLCTL_PROVIDER_STATE_CHANGE, clusapi/CLCTL_QUERY_DELETE, clusapi/CLCTL_QUERY_MAINTENANCE_MODE, clusapi/CLCTL_REMOVE_DEPENDENCY, clusapi/CLCTL_REMOVE_NODE, clusapi/CLCTL_REMOVE_OWNER, clusapi/CLCTL_REPLICATION_GET_ELIGIBLE_LOGDISKS, clusapi/CLCTL_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS, clusapi/CLCTL_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS, clusapi/CLCTL_REPLICATION_GET_LOG_INFO, clusapi/CLCTL_REPLICATION_GET_LOG_VOLUME, clusapi/CLCTL_REPLICATION_GET_REPLICATED_DISKS, clusapi/CLCTL_REPLICATION_GET_REPLICATED_PARTITION_INFO, clusapi/CLCTL_REPLICATION_GET_REPLICA_VOLUMES, clusapi/CLCTL_REPLICATION_GET_RESOURCE_GROUP, clusapi/CLCTL_RESOURCE_PREPARE_UPGRADE, clusapi/CLCTL_RESOURCE_UPGRADE_COMPLETED, clusapi/CLCTL_RESOURCE_UPGRADE_DLL, clusapi/CLCTL_RESUME_IO, clusapi/CLCTL_RW_MODIFY_NOOP, clusapi/CLCTL_SEND_DUMMY_GEM_MESSAGES, clusapi/CLCTL_SET_ACCOUNT_ACCESS, clusapi/CLCTL_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES, clusapi/CLCTL_SET_CLUSTER_S2D_ENABLED, clusapi/CLCTL_SET_COMMON_PROPERTIES, clusapi/CLCTL_SET_CSV_MAINTENANCE_MODE, clusapi/CLCTL_SET_DNS_DOMAIN, clusapi/CLCTL_SET_MAINTENANCE_MODE, clusapi/CLCTL_SET_NAME, clusapi/CLCTL_SET_PRIVATE_PROPERTIES, clusapi/CLCTL_SET_SHARED_VOLUME_BACKUP_MODE, clusapi/CLCTL_SET_STORAGE_CONFIGURATION, clusapi/CLCTL_SHUTDOWN, clusapi/CLCTL_STARTING_PHASE1, clusapi/CLCTL_STARTING_PHASE2, clusapi/CLCTL_STATE_CHANGE_REASON, clusapi/CLCTL_STORAGE_CLUSTER_DISK, clusapi/CLCTL_STORAGE_GET_AVAILABLE_DISKS, clusapi/CLCTL_STORAGE_GET_AVAILABLE_DISKS_EX, clusapi/CLCTL_STORAGE_GET_AVAILABLE_DISKS_EX2_INT, clusapi/CLCTL_STORAGE_GET_CLUSPORT_DISK_COUNT, clusapi/CLCTL_STORAGE_GET_DIRTY, clusapi/CLCTL_STORAGE_GET_DISKID, clusapi/CLCTL_STORAGE_GET_DISK_INFO, clusapi/CLCTL_STORAGE_GET_DISK_INFO_EX, clusapi/CLCTL_STORAGE_GET_DISK_INFO_EX2, clusapi/CLCTL_STORAGE_GET_DISK_NUMBER, clusapi/CLCTL_STORAGE_GET_DISK_NUMBER_INFO, clusapi/CLCTL_STORAGE_GET_DRIVELETTERS, clusapi/CLCTL_STORAGE_GET_MOUNTPOINTS, clusapi/CLCTL_STORAGE_GET_RESOURCEID, clusapi/CLCTL_STORAGE_GET_SHARED_VOLUME_INFO, clusapi/CLCTL_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES, clusapi/CLCTL_STORAGE_GET_SHARED_VOLUME_STATES, clusapi/CLCTL_STORAGE_IS_CLUSTERABLE, clusapi/CLCTL_STORAGE_IS_CSV_FILE, clusapi/CLCTL_STORAGE_IS_PATH_VALID, clusapi/CLCTL_STORAGE_IS_SHARED_VOLUME, clusapi/CLCTL_STORAGE_REMAP_DRIVELETTER, clusapi/CLCTL_STORAGE_REMOVE_VM_OWNERSHIP, clusapi/CLCTL_STORAGE_SET_DRIVELETTER, clusapi/CLCTL_STORAGE_SYNC_CLUSDISK_DB, clusapi/CLCTL_UNKNOWN, clusapi/CLCTL_VALIDATE_CHANGE_GROUP, clusapi/CLCTL_VALIDATE_COMMON_PROPERTIES, clusapi/CLCTL_VALIDATE_DIRECTORY, clusapi/CLCTL_VALIDATE_NETNAME, clusapi/CLCTL_VALIDATE_PATH, clusapi/CLCTL_VALIDATE_PRIVATE_PROPERTIES, clusapi/_CLCTL_CODES, msclus/CLCTL_ADD_CRYPTO_CHECKPOINT, msclus/CLCTL_ADD_CRYPTO_CHECKPOINT_EX, msclus/CLCTL_ADD_DEPENDENCY, msclus/CLCTL_ADD_OWNER, msclus/CLCTL_ADD_REGISTRY_CHECKPOINT, msclus/CLCTL_ADD_REGISTRY_CHECKPOINT_32BIT, msclus/CLCTL_ADD_REGISTRY_CHECKPOINT_64BIT, msclus/CLCTL_BATCH_BLOCK_KEY, msclus/CLCTL_BATCH_UNBLOCK_KEY, msclus/CLCTL_BLOCK_GEM_SEND_RECV, msclus/CLCTL_CHECK_VOTER_DOWN, msclus/CLCTL_CHECK_VOTER_EVICT, msclus/CLCTL_CLEAR_NODE_CONNECTION_INFO, msclus/CLCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS, msclus/CLCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY, msclus/CLCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY, msclus/CLCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN, msclus/CLCTL_CLUSTER_NAME_CHANGED, msclus/CLCTL_CLUSTER_VERSION_CHANGED, msclus/CLCTL_CODES, msclus/CLCTL_DELETE, msclus/CLCTL_DELETE_CRYPTO_CHECKPOINT, msclus/CLCTL_DELETE_REGISTRY_CHECKPOINT, msclus/CLCTL_DISABLE_SHARED_VOLUME_DIRECTIO, msclus/CLCTL_ENABLE_SHARED_VOLUME_DIRECTIO, msclus/CLCTL_ENUM_COMMON_PROPERTIES, msclus/CLCTL_ENUM_PRIVATE_PROPERTIES, msclus/CLCTL_EVICT_NODE, msclus/CLCTL_FILESERVER_SHARE_ADD, msclus/CLCTL_FILESERVER_SHARE_DEL, msclus/CLCTL_FILESERVER_SHARE_MODIFY, msclus/CLCTL_FILESERVER_SHARE_REPORT, msclus/CLCTL_FIXUP_ON_UPGRADE, msclus/CLCTL_FORCE_QUORUM, msclus/CLCTL_FSWITNESS_GET_EPOCH_INFO, msclus/CLCTL_FSWITNESS_RELEASE_LOCK, msclus/CLCTL_FSWITNESS_SET_EPOCH_INFO, msclus/CLCTL_GET_ARB_TIMEOUT, msclus/CLCTL_GET_CHARACTERISTICS, msclus/CLCTL_GET_CLASS_INFO, msclus/CLCTL_GET_CLUSDB_TIMESTAMP, msclus/CLCTL_GET_CLUSTER_SERVICE_ACCOUNT_NAME, msclus/CLCTL_GET_COMMON_PROPERTIES, msclus/CLCTL_GET_COMMON_PROPERTY_FMTS, msclus/CLCTL_GET_COMMON_RESOURCE_PROPERTY_FMTS, msclus/CLCTL_GET_CRYPTO_CHECKPOINTS, msclus/CLCTL_GET_DNS_NAME, msclus/CLCTL_GET_FAILURE_INFO, msclus/CLCTL_GET_FLAGS, msclus/CLCTL_GET_FQDN, msclus/CLCTL_GET_GEMID_VECTOR, msclus/CLCTL_GET_GUM_LOCK_OWNER, msclus/CLCTL_GET_ID, msclus/CLCTL_GET_LOADBAL_PROCESS_LIST, msclus/CLCTL_GET_NAME, msclus/CLCTL_GET_NETWORK, msclus/CLCTL_GET_NETWORK_NAME, msclus/CLCTL_GET_NODE, msclus/CLCTL_GET_OPERATION_CONTEXT, msclus/CLCTL_GET_PRIVATE_PROPERTIES, msclus/CLCTL_GET_PRIVATE_PROPERTY_FMTS, msclus/CLCTL_GET_PRIVATE_RESOURCE_PROPERTY_FMTS, msclus/CLCTL_GET_REGISTRY_CHECKPOINTS, msclus/CLCTL_GET_REQUIRED_DEPENDENCIES, msclus/CLCTL_GET_RESOURCE_TYPE, msclus/CLCTL_GET_ROUTESTATUS_BASIC, msclus/CLCTL_GET_ROUTESTATUS_EXTENDED, msclus/CLCTL_GET_RO_COMMON_PROPERTIES, msclus/CLCTL_GET_RO_PRIVATE_PROPERTIES, msclus/CLCTL_GET_SHARED_VOLUME_ID, msclus/CLCTL_GET_STATE_CHANGE_TIME, msclus/CLCTL_GET_STORAGE_CONFIGURATION, msclus/CLCTL_GET_STORAGE_CONFIG_ATTRIBUTES, msclus/CLCTL_GET_STUCK_NODES, msclus/CLCTL_GROUPSET_GET_GROUPS, msclus/CLCTL_GROUPSET_GET_PROVIDER_GROUPS, msclus/CLCTL_GROUPSET_GET_PROVIDER_GROUPSETS, msclus/CLCTL_GROUP_GET_LAST_MOVE_TIME, msclus/CLCTL_GROUP_GET_PROVIDER_GROUPS, msclus/CLCTL_GROUP_GET_PROVIDER_GROUPSETS, msclus/CLCTL_HOLD_IO, msclus/CLCTL_INITIALIZE, msclus/CLCTL_INJECT_GEM_FAULT, msclus/CLCTL_INSTALL_NODE, msclus/CLCTL_INTRODUCE_GEM_REPAIR_DELAY, msclus/CLCTL_IPADDRESS_RELEASE_LEASE, msclus/CLCTL_IPADDRESS_RENEW_LEASE, msclus/CLCTL_IS_QUORUM_BLOCKED, msclus/CLCTL_JOINING_GROUP, msclus/CLCTL_LEAVING_GROUP, msclus/CLCTL_NETNAME_CREDS_NOTIFYCAM, msclus/CLCTL_NETNAME_CREDS_UPDATED, msclus/CLCTL_NETNAME_DELETE_CO, msclus/CLCTL_NETNAME_GET_OU_FOR_VCO, msclus/CLCTL_NETNAME_GET_VIRTUAL_SERVER_TOKEN, msclus/CLCTL_NETNAME_REGISTER_DNS_RECORDS, msclus/CLCTL_NETNAME_REPAIR_VCO, msclus/CLCTL_NETNAME_RESET_VCO, msclus/CLCTL_NETNAME_SET_PWD_INFO, msclus/CLCTL_NETNAME_VALIDATE_VCO, msclus/CLCTL_NOTIFY_OWNER_CHANGE, msclus/CLCTL_NOTIFY_QUORUM_STATUS, msclus/CLCTL_POOL_GET_DRIVE_INFO, msclus/CLCTL_PROVIDER_STATE_CHANGE, msclus/CLCTL_QUERY_DELETE, msclus/CLCTL_QUERY_MAINTENANCE_MODE, msclus/CLCTL_REMOVE_DEPENDENCY, msclus/CLCTL_REMOVE_NODE, msclus/CLCTL_REMOVE_OWNER, msclus/CLCTL_REPLICATION_GET_ELIGIBLE_LOGDISKS, msclus/CLCTL_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS, msclus/CLCTL_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS, msclus/CLCTL_REPLICATION_GET_LOG_INFO, msclus/CLCTL_REPLICATION_GET_LOG_VOLUME, msclus/CLCTL_REPLICATION_GET_REPLICATED_DISKS, msclus/CLCTL_REPLICATION_GET_REPLICATED_PARTITION_INFO, msclus/CLCTL_REPLICATION_GET_REPLICA_VOLUMES, msclus/CLCTL_REPLICATION_GET_RESOURCE_GROUP, msclus/CLCTL_RESOURCE_PREPARE_UPGRADE, msclus/CLCTL_RESOURCE_UPGRADE_COMPLETED, msclus/CLCTL_RESOURCE_UPGRADE_DLL, msclus/CLCTL_RESUME_IO, msclus/CLCTL_RW_MODIFY_NOOP, msclus/CLCTL_SEND_DUMMY_GEM_MESSAGES, msclus/CLCTL_SET_ACCOUNT_ACCESS, msclus/CLCTL_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES, msclus/CLCTL_SET_CLUSTER_S2D_ENABLED, msclus/CLCTL_SET_COMMON_PROPERTIES, msclus/CLCTL_SET_CSV_MAINTENANCE_MODE, msclus/CLCTL_SET_DNS_DOMAIN, msclus/CLCTL_SET_MAINTENANCE_MODE, msclus/CLCTL_SET_NAME, msclus/CLCTL_SET_PRIVATE_PROPERTIES, msclus/CLCTL_SET_SHARED_VOLUME_BACKUP_MODE, msclus/CLCTL_SET_STORAGE_CONFIGURATION, msclus/CLCTL_SHUTDOWN, msclus/CLCTL_STARTING_PHASE1, msclus/CLCTL_STARTING_PHASE2, msclus/CLCTL_STATE_CHANGE_REASON, msclus/CLCTL_STORAGE_CLUSTER_DISK, msclus/CLCTL_STORAGE_GET_AVAILABLE_DISKS, msclus/CLCTL_STORAGE_GET_AVAILABLE_DISKS_EX, msclus/CLCTL_STORAGE_GET_AVAILABLE_DISKS_EX2_INT, msclus/CLCTL_STORAGE_GET_CLUSPORT_DISK_COUNT, msclus/CLCTL_STORAGE_GET_DIRTY, msclus/CLCTL_STORAGE_GET_DISKID, msclus/CLCTL_STORAGE_GET_DISK_INFO, msclus/CLCTL_STORAGE_GET_DISK_INFO_EX, msclus/CLCTL_STORAGE_GET_DISK_INFO_EX2, msclus/CLCTL_STORAGE_GET_DISK_NUMBER, msclus/CLCTL_STORAGE_GET_DISK_NUMBER_INFO, msclus/CLCTL_STORAGE_GET_DRIVELETTERS, msclus/CLCTL_STORAGE_GET_MOUNTPOINTS, msclus/CLCTL_STORAGE_GET_RESOURCEID, msclus/CLCTL_STORAGE_GET_SHARED_VOLUME_INFO, msclus/CLCTL_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES, msclus/CLCTL_STORAGE_GET_SHARED_VOLUME_STATES, msclus/CLCTL_STORAGE_IS_CLUSTERABLE, msclus/CLCTL_STORAGE_IS_CSV_FILE, msclus/CLCTL_STORAGE_IS_PATH_VALID, msclus/CLCTL_STORAGE_IS_SHARED_VOLUME, msclus/CLCTL_STORAGE_REMAP_DRIVELETTER, msclus/CLCTL_STORAGE_REMOVE_VM_OWNERSHIP, msclus/CLCTL_STORAGE_SET_DRIVELETTER, msclus/CLCTL_STORAGE_SYNC_CLUSDISK_DB, msclus/CLCTL_UNKNOWN, msclus/CLCTL_VALIDATE_CHANGE_GROUP, msclus/CLCTL_VALIDATE_COMMON_PROPERTIES, msclus/CLCTL_VALIDATE_DIRECTORY, msclus/CLCTL_VALIDATE_NETNAME, msclus/CLCTL_VALIDATE_PATH, msclus/CLCTL_VALIDATE_PRIVATE_PROPERTIES, msclus/_CLCTL_CODES, mscs.clctl_codes
f1_keywords:
- clusapi/CLCTL_CODES
dev_langs:
- c++
req.header: clusapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Enterprise, Windows Server 2008 Datacenter
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- kbSyntax
api_type:
- <TBD>
api_location:
- 
api_name:
- CLCTL_CODES
targetos: Windows
req.typenames: CLCTL_CODES
req.redist: 
ms.custom: 19H1
---

# CLCTL_CODES enumeration


## -description


This enumeration enumerates the possible operations that a control code will perform. For 
    more information, see 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/control-code-architecture">Control Code Architecture</a>.


## -enum-fields




### -field CLCTL_UNKNOWN

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-unknown">CLUSCTL_CLUSTER_UNKNOWN</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-unknown">CLUSCTL_GROUP_UNKNOWN</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-unknown">CLUSCTL_NETINTERFACE_UNKNOWN</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-unknown">CLUSCTL_NETWORK_UNKNOWN</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-unknown">CLUSCTL_NODE_UNKNOWN</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-unknown">CLUSCTL_RESOURCE_TYPE_UNKNOWN</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-unknown">CLUSCTL_RESOURCE_UNKNOWN</a>.


### -field CLCTL_GET_CHARACTERISTICS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-characteristics">CLUSCTL_GROUP_GET_CHARACTERISTICS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-characteristics">CLUSCTL_NETINTERFACE_GET_CHARACTERISTICS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-characteristics">CLUSCTL_NETWORK_GET_CHARACTERISTICS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-characteristics">CLUSCTL_NODE_GET_CHARACTERISTICS</a>,
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-characteristics">CLUSCTL_RESOURCE_GET_CHARACTERISTICS</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-characteristics">CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS</a>.


### -field CLCTL_GET_FLAGS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-flags">CLUSCTL_GROUP_GET_FLAGS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-flags">CLUSCTL_NETINTERFACE_GET_FLAGS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-flags">CLUSCTL_NETWORK_GET_FLAGS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-flags">CLUSCTL_NODE_GET_FLAGS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-flags">CLUSCTL_RESOURCE_GET_FLAGS</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-flags">CLUSCTL_RESOURCE_TYPE_GET_FLAGS</a>.


### -field CLCTL_GET_CLASS_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-class-info">CLUSCTL_RESOURCE_GET_CLASS_INFO</a> 
       and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-class-info">CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO</a>.


### -field CLCTL_GET_REQUIRED_DEPENDENCIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-required-dependencies">CLUSCTL_RESOURCE_GET_REQUIRED_DEPENDENCIES</a> and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-required-dependencies">CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES</a>.


### -field CLCTL_GET_ARB_TIMEOUT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-arb-timeout">CLUSCTL_RESOURCE_TYPE_GET_ARB_TIMEOUT</a>.


### -field CLCTL_GET_FAILURE_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-failure-info">CLUSCTL_RESOURCE_GET_FAILURE_INFO</a>.


### -field CLCTL_GET_NAME

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-name">CLUSCTL_GROUP_GET_NAME</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-name">CLUSCTL_NETINTERFACE_GET_NAME</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-name">CLUSCTL_NETWORK_GET_NAME</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-name">CLUSCTL_NODE_GET_NAME</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-name">CLUSCTL_RESOURCE_GET_NAME</a>.


### -field CLCTL_GET_RESOURCE_TYPE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-resource-type">CLUSCTL_RESOURCE_GET_RESOURCE_TYPE</a>.


### -field CLCTL_GET_NODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-node">CLUSCTL_NETINTERFACE_GET_NODE</a>.


### -field CLCTL_GET_NETWORK

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-network">CLUSCTL_NETINTERFACE_GET_NETWORK</a>.


### -field CLCTL_GET_ID

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-id">CLUSCTL_GROUP_GET_ID</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-id">CLUSCTL_NETINTERFACE_GET_ID</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-id">CLUSCTL_NETWORK_GET_ID</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-id">CLUSCTL_NODE_GET_ID</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-id">CLUSCTL_RESOURCE_GET_ID</a>.


### -field CLCTL_GET_FQDN

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-fqdn">CLUSCTL_CLUSTER_GET_FQDN</a>.


### -field CLCTL_GET_CLUSTER_SERVICE_ACCOUNT_NAME

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-cluster-service-account-name">CLUSCTL_NODE_GET_CLUSTER_SERVICE_ACCOUNT_NAME</a>.


### -field CLCTL_CHECK_VOTER_EVICT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-check-voter-evict">CLUSCTL_CLUSTER_CHECK_VOTER_EVICT</a>.


### -field CLCTL_CHECK_VOTER_DOWN

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-check-voter-down">CLUSCTL_CLUSTER_CHECK_VOTER_DOWN</a>.


### -field CLCTL_SHUTDOWN

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-shutdown">CLUSCTL_CLUSTER_SHUTDOWN</a>.


### -field CLCTL_ENUM_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-enum-common-properties">CLUSCTL_CLUSTER_ENUM_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-enum-common-properties">CLUSCTL_GROUP_ENUM_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-enum-common-properties">CLUSCTL_NETINTERFACE_ENUM_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-enum-common-properties">CLUSCTL_NETWORK_ENUM_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-enum-common-properties">CLUSCTL_NODE_ENUM_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-enum-common-properties">CLUSCTL_RESOURCE_ENUM_COMMON_PROPERTIES</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-enum-common-properties">CLUSCTL_RESOURCE_TYPE_ENUM_COMMON_PROPERTIES</a>.


### -field CLCTL_GET_RO_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-ro-common-properties">CLUSCTL_CLUSTER_GET_RO_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-get-ro-common-properties">CLUSCTL_COLLECTION_GET_RO_COMMON_PROPERTIES</a>, <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-ro-common-properties">CLUSCTL_GROUP_GET_RO_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-ro-common-properties">CLUSCTL_NETINTERFACE_GET_RO_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-ro-common-properties">CLUSCTL_NETWORK_GET_RO_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-ro-common-properties">CLUSCTL_NODE_GET_RO_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-ro-common-properties">CLUSCTL_RESOURCE_GET_RO_COMMON_PROPERTIES</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-ro-common-properties">CLUSCTL_RESOURCE_TYPE_GET_RO_COMMON_PROPERTIES</a>.


### -field CLCTL_GET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-common-properties">CLUSCTL_CLUSTER_GET_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-get-common-properties">CLUSCTL_COLLECTION_GET_COMMON_PROPERTIES</a>, <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-common-properties">CLUSCTL_GROUP_GET_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-common-properties">CLUSCTL_NETINTERFACE_GET_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-common-properties">CLUSCTL_NETWORK_GET_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-common-properties">CLUSCTL_NODE_GET_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-common-properties">CLUSCTL_RESOURCE_GET_COMMON_PROPERTIES</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-common-properties">CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTIES</a>.


### -field CLCTL_SET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-common-properties">CLUSCTL_CLUSTER_SET_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-set-common-properties">CLUSCTL_COLLECTION_SET_COMMON_PROPERTIES</a>, <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-set-common-properties">CLUSCTL_GROUP_SET_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-set-common-properties">CLUSCTL_NETINTERFACE_SET_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-set-common-properties">CLUSCTL_NETWORK_SET_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-set-common-properties">CLUSCTL_NODE_SET_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-common-properties">CLUSCTL_RESOURCE_SET_COMMON_PROPERTIES</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-set-common-properties">CLUSCTL_RESOURCE_TYPE_SET_COMMON_PROPERTIES</a>.


### -field CLCTL_VALIDATE_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-validate-common-properties">CLUSCTL_CLUSTER_VALIDATE_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-validate-common-properties">CLUSCTL_GROUP_VALIDATE_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-validate-common-properties">CLUSCTL_NETINTERFACE_VALIDATE_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-validate-common-properties">CLUSCTL_NETWORK_VALIDATE_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-validate-common-properties">CLUSCTL_NODE_VALIDATE_COMMON_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-validate-common-properties">CLUSCTL_RESOURCE_TYPE_VALIDATE_COMMON_PROPERTIES</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-validate-common-properties">CLUSCTL_RESOURCE_VALIDATE_COMMON_PROPERTIES</a>.


### -field CLCTL_GET_COMMON_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-common-property-fmts">CLUSCTL_CLUSTER_GET_COMMON_PROPERTY_FMTS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-common-property-fmts">CLUSCTL_GROUP_GET_COMMON_PROPERTY_FMTS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-common-property-fmts">CLUSCTL_NETINTERFACE_GET_COMMON_PROPERTY_FMTS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-common-property-fmts">CLUSCTL_NETWORK_GET_COMMON_PROPERTY_FMTS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-common-property-fmts">CLUSCTL_NODE_GET_COMMON_PROPERTY_FMTS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-common-property-fmts">CLUSCTL_RESOURCE_GET_COMMON_PROPERTY_FMTS</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-common-property-fmts">CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTY_FMTS</a>.


### -field CLCTL_GET_COMMON_RESOURCE_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-common-resource-property-fmts">CLUSCTL_RESOURCE_TYPE_GET_COMMON_RESOURCE_PROPERTY_FMTS</a>.


### -field CLCTL_ENUM_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-enum-private-properties">CLUSCTL_CLUSTER_ENUM_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-enum-private-properties">CLUSCTL_GROUP_ENUM_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-enum-private-properties">CLUSCTL_NETINTERFACE_ENUM_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-enum-private-properties">CLUSCTL_NETWORK_ENUM_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-enum-private-properties">CLUSCTL_NODE_ENUM_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-enum-private-properties">CLUSCTL_RESOURCE_ENUM_PRIVATE_PROPERTIES</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-enum-private-properties">CLUSCTL_RESOURCE_TYPE_ENUM_PRIVATE_PROPERTIES</a>.


### -field CLCTL_GET_RO_PRIVATE_PROPERTIES

see 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-ro-private-properties">CLUSCTL_CLUSTER_GET_RO_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-ro-private-properties">CLUSCTL_GROUP_GET_RO_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-ro-private-properties">CLUSCTL_NETINTERFACE_GET_RO_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-ro-private-properties">CLUSCTL_NETWORK_GET_RO_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-ro-private-properties">CLUSCTL_NODE_GET_RO_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-ro-private-properties">CLUSCTL_RESOURCE_GET_RO_PRIVATE_PROPERTIES</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-ro-private-properties">CLUSCTL_RESOURCE_TYPE_GET_RO_PRIVATE_PROPERTIES</a>.


### -field CLCTL_GET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-private-properties">CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-private-properties">CLUSCTL_GROUP_GET_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-private-properties">CLUSCTL_NETINTERFACE_GET_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-private-properties">CLUSCTL_NETWORK_GET_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-private-properties">CLUSCTL_NODE_GET_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-private-properties">CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTIES</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-private-properties">CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTIES</a>.


### -field CLCTL_SET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-private-properties">CLUSCTL_CLUSTER_SET_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-set-private-properties">CLUSCTL_GROUP_SET_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-set-private-properties">CLUSCTL_NETINTERFACE_SET_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-set-private-properties">CLUSCTL_NETWORK_SET_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-set-private-properties">CLUSCTL_NODE_SET_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-private-properties">CLUSCTL_RESOURCE_SET_PRIVATE_PROPERTIES</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-set-private-properties">CLUSCTL_RESOURCE_TYPE_SET_PRIVATE_PROPERTIES</a>.


### -field CLCTL_VALIDATE_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-validate-private-properties">CLUSCTL_CLUSTER_VALIDATE_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-validate-private-properties">CLUSCTL_GROUP_VALIDATE_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-validate-private-properties">CLUSCTL_NETINTERFACE_VALIDATE_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-validate-private-properties">CLUSCTL_NETWORK_VALIDATE_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-validate-private-properties">CLUSCTL_NODE_VALIDATE_PRIVATE_PROPERTIES</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-validate-private-properties">CLUSCTL_RESOURCE_TYPE_VALIDATE_PRIVATE_PROPERTIES</a>, 
       and <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-validate-private-properties">CLUSCTL_RESOURCE_VALIDATE_PRIVATE_PROPERTIES</a>.


### -field CLCTL_GET_PRIVATE_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-private-property-fmts">CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTY_FMTS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-private-property-fmts">CLUSCTL_GROUP_GET_PRIVATE_PROPERTY_FMTS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-private-property-fmts">CLUSCTL_NETINTERFACE_GET_PRIVATE_PROPERTY_FMTS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-private-property-fmts">CLUSCTL_NETWORK_GET_PRIVATE_PROPERTY_FMTS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-private-property-fmts">CLUSCTL_NODE_GET_PRIVATE_PROPERTY_FMTS</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-private-property-fmts">CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTY_FMTS</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-private-property-fmts">CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTY_FMTS</a>.


### -field CLCTL_GET_PRIVATE_RESOURCE_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-private-resource-property-fmts">CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_RESOURCE_PROPERTY_FMTS</a>.


### -field CLCTL_ADD_REGISTRY_CHECKPOINT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-registry-checkpoint">CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT</a>.


### -field CLCTL_DELETE_REGISTRY_CHECKPOINT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-delete-registry-checkpoint">CLUSCTL_RESOURCE_DELETE_REGISTRY_CHECKPOINT</a>.


### -field CLCTL_GET_REGISTRY_CHECKPOINTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-registry-checkpoints">CLUSCTL_RESOURCE_GET_REGISTRY_CHECKPOINTS</a>.


### -field CLCTL_ADD_CRYPTO_CHECKPOINT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-crypto-checkpoint">CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT</a>.


### -field CLCTL_DELETE_CRYPTO_CHECKPOINT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-delete-crypto-checkpoint">CLUSCTL_RESOURCE_DELETE_CRYPTO_CHECKPOINT</a>.


### -field CLCTL_GET_CRYPTO_CHECKPOINTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-crypto-checkpoints">CLUSCTL_RESOURCE_GET_CRYPTO_CHECKPOINTS</a>.


### -field CLCTL_RESOURCE_UPGRADE_DLL

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-upgrade-dll">CLUSCTL_RESOURCE_UPGRADE_DLL</a>.


### -field CLCTL_ADD_REGISTRY_CHECKPOINT_64BIT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-registry-checkpoint-64bit">CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_64BIT</a>.


### -field CLCTL_ADD_REGISTRY_CHECKPOINT_32BIT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-registry-checkpoint-32bit">CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_32BIT</a>.


### -field CLCTL_GET_LOADBAL_PROCESS_LIST

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-loadbal-process-list">CLUSCTL_RESOURCE_GET_LOADBAL_PROCESS_LIST</a>.


### -field CLCTL_SET_ACCOUNT_ACCESS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-account-access">CLUSCTL_CLUSTER_SET_ACCOUNT_ACCESS</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_GET_NETWORK_NAME

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-network-name">CLUSCTL_RESOURCE_GET_NETWORK_NAME</a>.


### -field CLCTL_NETNAME_GET_VIRTUAL_SERVER_TOKEN

See the following topics:

<ul>
<li>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-get-virtual-server-token">CLUSCTL_RESOURCE_NETNAME_GET_VIRTUAL_SERVER_TOKEN</a>
</li>
<li>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-rlua-get-virtual-server-token">CLUSCTL_RESOURCE_RLUA_GET_VIRTUAL_SERVER_TOKEN</a>
</li>
</ul>
<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2012 R2.



See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-get-virtual-server-token">CLUSCTL_RESOURCE_NETNAME_GET_VIRTUAL_SERVER_TOKEN</a>.


### -field CLCTL_NETNAME_REGISTER_DNS_RECORDS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-register-dns-records">CLUSCTL_RESOURCE_NETNAME_REGISTER_DNS_RECORDS</a>.


### -field CLCTL_GET_DNS_NAME

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-dns-name">CLUSCTL_RESOURCE_GET_DNS_NAME</a>.


### -field CLCTL_NETNAME_SET_PWD_INFO

See the following topics:

<ul>
<li>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-set-pwd-info">CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFO</a>
</li>
<li>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-rlua-set-pwd-info">CLUSCTL_RESOURCE_RLUA_SET_PWD_INFO</a>
</li>
</ul>
<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available until Windows Server 2012 R2.




### -field CLCTL_NETNAME_DELETE_CO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-delete-co">CLUSCTL_RESOURCE_NETNAME_DELETE_CO</a>.


### -field CLCTL_NETNAME_VALIDATE_VCO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-validate-vco">CLUSCTL_RESOURCE_NETNAME_VALIDATE_VCO</a>.


### -field CLCTL_NETNAME_RESET_VCO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-reset-vco">CLUSCTL_RESOURCE_NETNAME_RESET_VCO</a>.


### -field CLCTL_NETNAME_REPAIR_VCO

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-repair-vco">CLUSCTL_RESOURCE_NETNAME_REPAIR_VCO</a>



### -field CLCTL_STORAGE_GET_DISK_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-disk-info">CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO</a>.


### -field CLCTL_STORAGE_GET_AVAILABLE_DISKS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-available-disks">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS</a>.


### -field CLCTL_STORAGE_IS_PATH_VALID

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-is-path-valid">CLUSCTL_RESOURCE_STORAGE_IS_PATH_VALID</a>.


### -field CLCTL_STORAGE_SYNC_CLUSDISK_DB

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-sync-clusdisk-db">CLUSCTL_RESOURCE_TYPE_STORAGE_SYNC_CLUSDISK_DB</a>.


### -field CLCTL_STORAGE_GET_DISK_NUMBER_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-disk-number-info">CLUSCTL_RESOURCE_STORAGE_GET_DISK_NUMBER_INFO</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2016.




### -field CLCTL_QUERY_DELETE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-query-delete">CLUSCTL_GROUP_QUERY_DELETE</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-query-delete">CLUSCTL_RESOURCE_QUERY_DELETE</a>, and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-query-delete">CLUSCTL_RESOURCE_TYPE_QUERY_DELETE</a>.


### -field CLCTL_IPADDRESS_RENEW_LEASE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-ipaddress-renew-lease">CLUSCTL_RESOURCE_IPADDRESS_RENEW_LEASE</a>.


### -field CLCTL_IPADDRESS_RELEASE_LEASE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-ipaddress-release-lease">CLUSCTL_RESOURCE_IPADDRESS_RELEASE_LEASE</a>.


### -field CLCTL_QUERY_MAINTENANCE_MODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-query-maintenance-mode">CLUSCTL_RESOURCE_QUERY_MAINTENANCE_MODE</a>.


### -field CLCTL_SET_MAINTENANCE_MODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-maintenance-mode">CLUSCTL_RESOURCE_SET_MAINTENANCE_MODE</a>.


### -field CLCTL_STORAGE_SET_DRIVELETTER

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-set-driveletter">CLUSCTL_RESOURCE_STORAGE_SET_DRIVELETTER</a>.


### -field CLCTL_STORAGE_GET_DRIVELETTERS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-driveletters">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DRIVELETTERS</a>.


### -field CLCTL_STORAGE_GET_DISK_INFO_EX

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-disk-info-ex">CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX</a>.


### -field CLCTL_STORAGE_GET_AVAILABLE_DISKS_EX

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-available-disks-ex">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX</a>.


### -field CLCTL_STORAGE_GET_DISK_INFO_EX2

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-disk-info-ex2">CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX2</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_STORAGE_GET_CLUSPORT_DISK_COUNT

TBD


### -field CLCTL_STORAGE_REMAP_DRIVELETTER

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-remap-driveletter">CLUSCTL_RESOURCE_TYPE_STORAGE_REMAP_DRIVELETTER</a>.


### -field CLCTL_STORAGE_GET_DISKID

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-diskid">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DISKID</a>.


### -field CLCTL_STORAGE_IS_CLUSTERABLE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-is-clusterable">CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CLUSTERABLE</a>.


### -field CLCTL_STORAGE_REMOVE_VM_OWNERSHIP

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-remove-vm-ownership">CLUSCTL_RESOURCE_TYPE_STORAGE_REMOVE_VM_OWNERSHIP</a>.


### -field CLCTL_STORAGE_GET_MOUNTPOINTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-mountpoints">CLUSCTL_RESOURCE_STORAGE_GET_MOUNTPOINTS</a>.


### -field CLCTL_STORAGE_GET_DIRTY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-dirty">CLUSCTL_RESOURCE_STORAGE_GET_DIRTY</a>.


### -field CLCTL_STORAGE_GET_SHARED_VOLUME_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-shared-volume-info">CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_INFO</a>.


### -field CLCTL_STORAGE_IS_CSV_FILE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-is-csv-file">CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CSV_FILE</a>.


### -field CLCTL_STORAGE_GET_RESOURCEID

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-resourceid">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_RESOURCEID</a>.


### -field CLCTL_VALIDATE_PATH

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-gen-app-validate-path">CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_PATH</a> and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-gen-script-validate-path">CLUSCTL_RESOURCE_TYPE_GEN_SCRIPT_VALIDATE_PATH</a>.


### -field CLCTL_VALIDATE_NETNAME

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-netname-validate-netname">CLUSCTL_RESOURCE_TYPE_NETNAME_VALIDATE_NETNAME</a>.


### -field CLCTL_VALIDATE_DIRECTORY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-gen-app-validate-directory">CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_DIRECTORY</a>.


### -field CLCTL_BATCH_BLOCK_KEY

Not supported.


### -field CLCTL_BATCH_UNBLOCK_KEY

Not supported.


### -field CLCTL_FILESERVER_SHARE_ADD

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fileserver-share-add">CLUSCTL_RESOURCE_FILESERVER_SHARE_ADD</a>.


### -field CLCTL_FILESERVER_SHARE_DEL

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fileserver-share-del">CLUSCTL_RESOURCE_FILESERVER_SHARE_DEL</a>.


### -field CLCTL_FILESERVER_SHARE_MODIFY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fileserver-share-modify">CLUSCTL_RESOURCE_FILESERVER_SHARE_MODIFY</a>.


### -field CLCTL_FILESERVER_SHARE_REPORT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fileserver-share-report">CLUSCTL_RESOURCE_FILESERVER_SHARE_REPORT</a>.


### -field CLCTL_NETNAME_GET_OU_FOR_VCO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-netname-get-ou-for-vco">CLUSCTL_RESOURCE_TYPE_NETNAME_GET_OU_FOR_VCO</a>.


### -field CLCTL_ENABLE_SHARED_VOLUME_DIRECTIO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-enable-shared-volume-directio">CLUSCTL_RESOURCE_ENABLE_SHARED_VOLUME_DIRECTIO</a>.


### -field CLCTL_DISABLE_SHARED_VOLUME_DIRECTIO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-disable-shared-volume-directio">CLUSCTL_RESOURCE_DISABLE_SHARED_VOLUME_DIRECTIO</a>.


### -field CLCTL_GET_SHARED_VOLUME_ID

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-shared-volume-id">CLUSCTL_CLUSTER_GET_SHARED_VOLUME_ID</a>.


### -field CLCTL_SET_CSV_MAINTENANCE_MODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-csv-maintenance-mode">CLUSCTL_RESOURCE_SET_CSV_MAINTENANCE_MODE</a>.


### -field CLCTL_SET_SHARED_VOLUME_BACKUP_MODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-shared-volume-backup-mode">CLUSCTL_RESOURCE_SET_SHARED_VOLUME_BACKUP_MODE</a>.


### -field CLCTL_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-shared-volume-partition-names">CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES</a>.


### -field CLCTL_STORAGE_GET_SHARED_VOLUME_STATES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-shared-volume-states">CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_STATES</a>.


### -field CLCTL_STORAGE_IS_SHARED_VOLUME

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-is-shared-volume">CLUSCTL_RESOURCE_STORAGE_IS_SHARED_VOLUME</a>.


### -field CLCTL_GET_CLUSDB_TIMESTAMP

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-clusdb-timestamp">CLUSCTL_CLUSTER_GET_CLUSDB_TIMESTAMP</a>.


### -field CLCTL_RW_MODIFY_NOOP

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-rw-modify-noop">CLUSCTL_RESOURCE_RW_MODIFY_NOOP</a>



### -field CLCTL_IS_QUORUM_BLOCKED

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-is-quorum-blocked">CLUSCTL_RESOURCE_IS_QUORUM_BLOCKED</a>.


### -field CLCTL_POOL_GET_DRIVE_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-pool-get-drive-info">CLUSCTL_RESOURCE_POOL_GET_DRIVE_INFO</a>.


### -field CLCTL_GET_GUM_LOCK_OWNER

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-gum-lock-owner">CLUSCTL_CLUSTER_GET_GUM_LOCK_OWNER</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2012 R2.




### -field CLCTL_GET_STUCK_NODES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-stuck-nodes">CLUSCTL_NODE_GET_STUCK_NODES</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2012 R2.




### -field CLCTL_INJECT_GEM_FAULT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-inject-gem-fault">CLUSCTL_NODE_INJECT_GEM_FAULT</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2012 R2.




### -field CLCTL_INTRODUCE_GEM_REPAIR_DELAY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-introduce-gem-repair-delay">CLUSCTL_NODE_INTRODUCE_GEM_REPAIR_DELAY</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2012 R2.




### -field CLCTL_SEND_DUMMY_GEM_MESSAGES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-send-dummy-gem-messages">CLUSCTL_NODE_SEND_DUMMY_GEM_MESSAGES</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2012 R2.




### -field CLCTL_BLOCK_GEM_SEND_RECV

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-block-gem-send-recv">CLUSCTL_NODE_BLOCK_GEM_SEND_RECV</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2012 R2.




### -field CLCTL_GET_GEMID_VECTOR

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-gemid-vector">CLUSCTL_NODE_GET_GEMID_VECTOR</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2012 R2.




### -field CLCTL_ADD_CRYPTO_CHECKPOINT_EX

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-crypto-checkpoint-ex">CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT_EX</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2012 R2.




### -field CLCTL_GROUP_GET_LAST_MOVE_TIME

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-last-move-time">CLUSCTL_GROUP_GET_LAST_MOVE_TIME</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_SET_STORAGE_CONFIGURATION

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-storage-configuration">CLUSCTL_CLUSTER_SET_STORAGE_CONFIGURATION</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_GET_STORAGE_CONFIGURATION

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-storage-configuration">CLUSCTL_CLUSTER_GET_STORAGE_CONFIGURATION</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_GET_STORAGE_CONFIG_ATTRIBUTES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-storage-config-attributes">CLUSCTL_CLUSTER_GET_STORAGE_CONFIG_ATTRIBUTES</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_REMOVE_NODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-remove-node">CLUSCTL_CLUSTER_REMOVE_NODE</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_IS_FEATURE_INSTALLED


### -field CLCTL_IS_S2D_FEATURE_SUPPORTED


### -field CLCTL_STORAGE_GET_PHYSICAL_DISK_INFO


### -field CLCTL_STORAGE_GET_CLUSBFLT_PATHS


### -field CLCTL_STORAGE_GET_CLUSBFLT_PATHINFO


### -field CLCTL_CLEAR_NODE_CONNECTION_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-clear-node-connection-info">CLUSCTL_CLUSTER_CLEAR_NODE_CONNECTION_INFO</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_SET_DNS_DOMAIN

See <a href="https://msdn.microsoft.com/C08360F8-4930-4BEA-B831-CD380EBCFF7D">CLUSCTL_CLUSTER_SET_DNS_DOMAIN</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CTCTL_GET_ROUTESTATUS_BASIC


### -field CTCTL_GET_ROUTESTATUS_EXTENDED


### -field CTCTL_GET_FAULT_DOMAIN_STATE


### -field CLCTL_STORAGE_GET_AVAILABLE_DISKS_EX2_INT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-available-disks-ex2-int">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INT</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2012 R2.




### -field CLCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cloud-witness-resource-type-validate-credentials">CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cloud-witness-resource-update-token">CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_RESOURCE_PREPARE_UPGRADE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-prepare-upgrade">CLUSCTL_RESOURCE_PREPARE_UPGRADE</a> and <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-prepare-upgrade">CLUSCTL_RESOURCE_TYPE_PREPARE_UPGRADE</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2016.




### -field CLCTL_RESOURCE_UPGRADE_COMPLETED

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-upgrade-completed">CLUSCTL_RESOURCE_UPGRADE_COMPLETED</a> and <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-upgrade-completed">CLUSCTL_RESOURCE_TYPE_UPGRADE_COMPLETED</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2016.




### -field CLCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cloud-witness-resource-type-validate-credentials-with-key">CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cloud-witness-resource-update-key">CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_REPLICATION_GET_LOG_INFO

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-log-info">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_INFO</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_REPLICATION_GET_ELIGIBLE_LOGDISKS


<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-eligible-logdisks">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_LOGDISKS</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS


<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-eligible-target-datadisks">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS


<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-eligible-source-datadisks">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_REPLICATION_GET_REPLICATED_DISKS


<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-replicated-disks">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_DISKS</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_REPLICATION_GET_REPLICA_VOLUMES


<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-replica-volumes">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICA_VOLUMES</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_REPLICATION_GET_LOG_VOLUME


<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-log-volume">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_VOLUME</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_REPLICATION_GET_RESOURCE_GROUP


<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-resource-group">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_RESOURCE_GROUP</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_REPLICATION_GET_REPLICATED_PARTITION_INFO


<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-replicated-partition-info">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_PARTITION_INFO</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLCTL_GET_STATE_CHANGE_TIME

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-state-change-time">CLUSCTL_RESOURCE_GET_STATE_CHANGE_TIME</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2016.




### -field CLCTL_SET_CLUSTER_S2D_ENABLED

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-cluster-das-mode-enabled">CLUSCTL_CLUSTER_SET_CLUSTER_S2D_ENABLED</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2016.




### -field CLCTL_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-cluster-s2d-cache-metadata-reserve-bytes">CLUSCTL_CLUSTER_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2016.




### -field CLCTL_GROUPSET_GET_GROUPS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-get-groups">CLUSCTL_GROUPSET_GET_GROUPS</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2016.




### -field CLCTL_GROUPSET_GET_PROVIDER_GROUPS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-get-provider-groups">CLUSCTL_GROUPSET_GET_PROVIDER_GROUPS</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2016.




### -field CLCTL_GROUPSET_GET_PROVIDER_GROUPSETS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-get-provider-collections">CLUSCTL_GROUPSET_GET_PROVIDER_GROUPSETS</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2016.




### -field CLCTL_GROUP_GET_PROVIDER_GROUPS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-provider-groups">CLUSCTL_GROUP_GET_PROVIDER_GROUPS</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2016.




### -field CLCTL_GROUP_GET_PROVIDER_GROUPSETS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-provider-collections">CLUSCTL_GROUP_GET_PROVIDER_GROUPSETS</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available until Windows Server 2016.




### -field CLCTL_GROUP_SET_CCF_FROM_MASTER


### -field CLCTL_GET_INFRASTRUCTURE_SOFS_BUFFER


### -field CLCTL_SET_INFRASTRUCTURE_SOFS_BUFFER


### -field CLCTL_NOTIFY_INFRASTRUCTURE_SOFS_CHANGED


### -field CLCTL_SCALEOUT_COMMAND


### -field CLCTL_SCALEOUT_CONTROL


### -field CLCTL_SCALEOUT_GET_CLUSTERS


### -field CLCTL_RELOAD_AUTOLOGGER_CONFIG


### -field CLCTL_DELETE

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-delete">CLUSCTL_RESOURCE_DELETE</a>.


### -field CLCTL_INSTALL_NODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-install-node">CLUSCTL_RESOURCE_INSTALL_NODE</a> and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-install-node">CLUSCTL_RESOURCE_TYPE_INSTALL_NODE</a>.


### -field CLCTL_EVICT_NODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-evict-node">CLUSCTL_RESOURCE_EVICT_NODE</a> and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-evict-node">CLUSCTL_RESOURCE_TYPE_EVICT_NODE</a>.


### -field CLCTL_ADD_DEPENDENCY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-dependency">CLUSCTL_RESOURCE_ADD_DEPENDENCY</a>.


### -field CLCTL_REMOVE_DEPENDENCY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-remove-dependency">CLUSCTL_RESOURCE_REMOVE_DEPENDENCY</a>.


### -field CLCTL_ADD_OWNER

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-owner">CLUSCTL_RESOURCE_ADD_OWNER</a>.


### -field CLCTL_REMOVE_OWNER

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-remove-owner">CLUSCTL_RESOURCE_REMOVE_OWNER</a>.


### -field CLCTL_SET_NAME

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-name">CLUSCTL_RESOURCE_SET_NAME</a>.


### -field CLCTL_CLUSTER_NAME_CHANGED

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-cluster-name-changed">CLUSCTL_RESOURCE_CLUSTER_NAME_CHANGED</a>.


### -field CLCTL_CLUSTER_VERSION_CHANGED

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-cluster-version-changed">CLUSCTL_RESOURCE_CLUSTER_VERSION_CHANGED</a> and 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-cluster-version-changed">CLUSCTL_RESOURCE_TYPE_CLUSTER_VERSION_CHANGED</a>.


### -field CLCTL_FIXUP_ON_UPGRADE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-fixup-on-upgrade">CLUSCTL_RESOURCE_TYPE_FIXUP_ON_UPGRADE</a>.


### -field CLCTL_STARTING_PHASE1

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-starting-phase1">CLUSCTL_RESOURCE_TYPE_STARTING_PHASE1</a>.


### -field CLCTL_STARTING_PHASE2

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-starting-phase2">CLUSCTL_RESOURCE_TYPE_STARTING_PHASE2</a>.


### -field CLCTL_HOLD_IO

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-hold-io">CLUSCTL_RESOURCE_TYPE_HOLD_IO</a>.


### -field CLCTL_RESUME_IO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-resume-io">CLUSCTL_RESOURCE_TYPE_RESUME_IO</a>.


### -field CLCTL_FORCE_QUORUM

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-force-quorum">CLUSCTL_RESOURCE_FORCE_QUORUM</a>.


### -field CLCTL_INITIALIZE

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-initialize">CLUSCTL_RESOURCE_INITIALIZE</a>.


### -field CLCTL_STATE_CHANGE_REASON

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-state-change-reason">CLUSCTL_RESOURCE_STATE_CHANGE_REASON</a>.


### -field CLCTL_PROVIDER_STATE_CHANGE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-provider-state-change">CLUSCTL_RESOURCE_PROVIDER_STATE_CHANGE</a>.


### -field CLCTL_LEAVING_GROUP

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-leaving-group">CLUSCTL_RESOURCE_LEAVING_GROUP</a>.


### -field CLCTL_JOINING_GROUP

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-joining-group">CLUSCTL_RESOURCE_JOINING_GROUP</a>.


### -field CLCTL_FSWITNESS_GET_EPOCH_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fswitness-get-epoch-info">CLUSCTL_RESOURCE_FSWITNESS_GET_EPOCH_INFO</a>.


### -field CLCTL_FSWITNESS_SET_EPOCH_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fswitness-set-epoch-info">CLUSCTL_RESOURCE_FSWITNESS_SET_EPOCH_INFO</a>.


### -field CLCTL_FSWITNESS_RELEASE_LOCK

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fswitness-release-lock">CLUSCTL_RESOURCE_FSWITNESS_RELEASE_LOCK</a>.


### -field CLCTL_NETNAME_CREDS_NOTIFYCAM

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-creds-notifycam">CLUSCTL_RESOURCE_NETNAME_CREDS_NOTIFYCAM</a>.


### -field CLCTL_NOTIFY_QUORUM_STATUS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-notify-quorum-status">CLUSCTL_RESOURCE_NOTIFY_QUORUM_STATUS</a>.


### -field CLCTL_NOTIFY_MONITOR_SHUTTING_DOWN


### -field CLCTL_GET_OPERATION_CONTEXT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-operation-context">CLUSCTL_RESOURCE_GET_OPERATION_CONTEXT</a>.


### -field CLCTL_NOTIFY_OWNER_CHANGE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-notify-owner-change">CLUSCTL_RESOURCE_NOTIFY_OWNER_CHANGE</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2012 R2.




### -field CLCTL_VALIDATE_CHANGE_GROUP

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-validate-change-group">CLUSCTL_RESOURCE_VALIDATE_CHANGE_GROUP</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




#### - CLCTL_GET_ROUTESTATUS_BASIC

See 
       TBD.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




#### - CLCTL_GET_ROUTESTATUS_EXTENDED

See 
       TBD.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




#### - CLCTL_NETNAME_CREDS_UPDATED

Not supported.

<b>Windows Server 2008 R2:  </b>See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-creds-updated">CLUSCTL_RESOURCE_NETNAME_CREDS_UPDATED</a>.




#### - CLCTL_STORAGE_CLUSTER_DISK

Not supported.

<b>Windows Server 2008 R2:  </b>See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-cluster-disk">CLUSCTL_RESOURCE_STORAGE_CLUSTER_DISK</a>.




#### - CLCTL_STORAGE_GET_DISK_NUMBER

Not supported.

<b>Windows Server 2008 R2:  </b>See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-disk-number">CLUSCTL_RESOURCE_STORAGE_GET_DISK_NUMBER</a>.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/control-code-architecture">Control Code Architecture</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-enumerations">Failover Cluster Enumerations</a>
 

 

