---
UID: NE:clusapi.CLUSCTL_CLUSTER_CODES
title: CLUSCTL_CLUSTER_CODES (clusapi.h)
description: Enumerates cluster control codes used by the ClusterControl function.
old-location: mscs\clusctl_cluster_codes.htm
tech.root: MsCS
ms.assetid: b5ce8c3c-3a5d-4785-a3ce-b8b37c6c5dc8
ms.date: 12/05/2018
ms.keywords: CLUSCTL_CLUSTER_BATCH_BLOCK_KEY, CLUSCTL_CLUSTER_BATCH_UNBLOCK_KEY, CLUSCTL_CLUSTER_CHECK_VOTER_DOWN, CLUSCTL_CLUSTER_CHECK_VOTER_EVICT, CLUSCTL_CLUSTER_CLEAR_NODE_CONNECTION_INFO, CLUSCTL_CLUSTER_CODES, CLUSCTL_CLUSTER_CODES enumeration [Failover Cluster], CLUSCTL_CLUSTER_ENUM_COMMON_PROPERTIES, CLUSCTL_CLUSTER_ENUM_PRIVATE_PROPERTIES, CLUSCTL_CLUSTER_GET_CLUSDB_TIMESTAMP, CLUSCTL_CLUSTER_GET_COMMON_PROPERTIES, CLUSCTL_CLUSTER_GET_COMMON_PROPERTY_FMTS, CLUSCTL_CLUSTER_GET_FQDN, CLUSCTL_CLUSTER_GET_GUM_LOCK_OWNER, CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTIES, CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTY_FMTS, CLUSCTL_CLUSTER_GET_RO_COMMON_PROPERTIES, CLUSCTL_CLUSTER_GET_RO_PRIVATE_PROPERTIES, CLUSCTL_CLUSTER_GET_SHARED_VOLUME_ID, CLUSCTL_CLUSTER_GET_STORAGE_CONFIGURATION, CLUSCTL_CLUSTER_GET_STORAGE_CONFIG_ATTRIBUTES, CLUSCTL_CLUSTER_REMOVE_NODE, CLUSCTL_CLUSTER_SET_ACCOUNT_ACCESS, CLUSCTL_CLUSTER_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES, CLUSCTL_CLUSTER_SET_CLUSTER_S2D_ENABLED, CLUSCTL_CLUSTER_SET_COMMON_PROPERTIES, CLUSCTL_CLUSTER_SET_DNS_DOMAIN, CLUSCTL_CLUSTER_SET_PRIVATE_PROPERTIES, CLUSCTL_CLUSTER_SET_STORAGE_CONFIGURATION, CLUSCTL_CLUSTER_SHUTDOWN, CLUSCTL_CLUSTER_UNKNOWN, CLUSCTL_CLUSTER_VALIDATE_COMMON_PROPERTIES, CLUSCTL_CLUSTER_VALIDATE_PRIVATE_PROPERTIES, _CLUSCTL_CLUSTER_CODES, _CLUSCTL_CLUSTER_CODES enumeration [Failover Cluster], clusapi/CLUSCTL_CLUSTER_BATCH_BLOCK_KEY, clusapi/CLUSCTL_CLUSTER_BATCH_UNBLOCK_KEY, clusapi/CLUSCTL_CLUSTER_CHECK_VOTER_DOWN, clusapi/CLUSCTL_CLUSTER_CHECK_VOTER_EVICT, clusapi/CLUSCTL_CLUSTER_CLEAR_NODE_CONNECTION_INFO, clusapi/CLUSCTL_CLUSTER_CODES, clusapi/CLUSCTL_CLUSTER_ENUM_COMMON_PROPERTIES, clusapi/CLUSCTL_CLUSTER_ENUM_PRIVATE_PROPERTIES, clusapi/CLUSCTL_CLUSTER_GET_CLUSDB_TIMESTAMP, clusapi/CLUSCTL_CLUSTER_GET_COMMON_PROPERTIES, clusapi/CLUSCTL_CLUSTER_GET_COMMON_PROPERTY_FMTS, clusapi/CLUSCTL_CLUSTER_GET_FQDN, clusapi/CLUSCTL_CLUSTER_GET_GUM_LOCK_OWNER, clusapi/CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTIES, clusapi/CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTY_FMTS, clusapi/CLUSCTL_CLUSTER_GET_RO_COMMON_PROPERTIES, clusapi/CLUSCTL_CLUSTER_GET_RO_PRIVATE_PROPERTIES, clusapi/CLUSCTL_CLUSTER_GET_SHARED_VOLUME_ID, clusapi/CLUSCTL_CLUSTER_GET_STORAGE_CONFIGURATION, clusapi/CLUSCTL_CLUSTER_GET_STORAGE_CONFIG_ATTRIBUTES, clusapi/CLUSCTL_CLUSTER_REMOVE_NODE, clusapi/CLUSCTL_CLUSTER_SET_ACCOUNT_ACCESS, clusapi/CLUSCTL_CLUSTER_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES, clusapi/CLUSCTL_CLUSTER_SET_CLUSTER_S2D_ENABLED, clusapi/CLUSCTL_CLUSTER_SET_COMMON_PROPERTIES, clusapi/CLUSCTL_CLUSTER_SET_DNS_DOMAIN, clusapi/CLUSCTL_CLUSTER_SET_PRIVATE_PROPERTIES, clusapi/CLUSCTL_CLUSTER_SET_STORAGE_CONFIGURATION, clusapi/CLUSCTL_CLUSTER_SHUTDOWN, clusapi/CLUSCTL_CLUSTER_UNKNOWN, clusapi/CLUSCTL_CLUSTER_VALIDATE_COMMON_PROPERTIES, clusapi/CLUSCTL_CLUSTER_VALIDATE_PRIVATE_PROPERTIES, clusapi/_CLUSCTL_CLUSTER_CODES, msclus/CLUSCTL_CLUSTER_BATCH_BLOCK_KEY, msclus/CLUSCTL_CLUSTER_BATCH_UNBLOCK_KEY, msclus/CLUSCTL_CLUSTER_CHECK_VOTER_DOWN, msclus/CLUSCTL_CLUSTER_CHECK_VOTER_EVICT, msclus/CLUSCTL_CLUSTER_CLEAR_NODE_CONNECTION_INFO, msclus/CLUSCTL_CLUSTER_CODES, msclus/CLUSCTL_CLUSTER_ENUM_COMMON_PROPERTIES, msclus/CLUSCTL_CLUSTER_ENUM_PRIVATE_PROPERTIES, msclus/CLUSCTL_CLUSTER_GET_CLUSDB_TIMESTAMP, msclus/CLUSCTL_CLUSTER_GET_COMMON_PROPERTIES, msclus/CLUSCTL_CLUSTER_GET_COMMON_PROPERTY_FMTS, msclus/CLUSCTL_CLUSTER_GET_FQDN, msclus/CLUSCTL_CLUSTER_GET_GUM_LOCK_OWNER, msclus/CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTIES, msclus/CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTY_FMTS, msclus/CLUSCTL_CLUSTER_GET_RO_COMMON_PROPERTIES, msclus/CLUSCTL_CLUSTER_GET_RO_PRIVATE_PROPERTIES, msclus/CLUSCTL_CLUSTER_GET_SHARED_VOLUME_ID, msclus/CLUSCTL_CLUSTER_GET_STORAGE_CONFIGURATION, msclus/CLUSCTL_CLUSTER_GET_STORAGE_CONFIG_ATTRIBUTES, msclus/CLUSCTL_CLUSTER_REMOVE_NODE, msclus/CLUSCTL_CLUSTER_SET_ACCOUNT_ACCESS, msclus/CLUSCTL_CLUSTER_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES, msclus/CLUSCTL_CLUSTER_SET_CLUSTER_S2D_ENABLED, msclus/CLUSCTL_CLUSTER_SET_COMMON_PROPERTIES, msclus/CLUSCTL_CLUSTER_SET_DNS_DOMAIN, msclus/CLUSCTL_CLUSTER_SET_PRIVATE_PROPERTIES, msclus/CLUSCTL_CLUSTER_SET_STORAGE_CONFIGURATION, msclus/CLUSCTL_CLUSTER_SHUTDOWN, msclus/CLUSCTL_CLUSTER_UNKNOWN, msclus/CLUSCTL_CLUSTER_VALIDATE_COMMON_PROPERTIES, msclus/CLUSCTL_CLUSTER_VALIDATE_PRIVATE_PROPERTIES, msclus/_CLUSCTL_CLUSTER_CODES, mscs.clusctl_cluster_codes
f1_keywords:
- clusapi/CLUSCTL_CLUSTER_CODES
dev_langs:
- c++
req.header: clusapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Enterprise, Windows Server 2008 Datacenter
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ClusAPI.h
- MsClus.h
api_name:
- CLUSCTL_CLUSTER_CODES
targetos: Windows
req.typenames: CLUSCTL_CLUSTER_CODES
req.redist: 
ms.custom: 19H1
---

# CLUSCTL_CLUSTER_CODES enumeration


## -description


Enumerates cluster <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/about-control-codes">control codes</a> used by 
    the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/nf-clusapi-clustercontrol">ClusterControl</a> function.


## -enum-fields




### -field CLUSCTL_CLUSTER_UNKNOWN

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-unknown">CLUSCTL_CLUSTER_UNKNOWN</a>.


### -field CLUSCTL_CLUSTER_GET_FQDN

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-fqdn">CLUSCTL_CLUSTER_GET_FQDN</a>.


### -field CLUSCTL_CLUSTER_SET_STORAGE_CONFIGURATION

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-storage-configuration">CLUSCTL_CLUSTER_SET_STORAGE_CONFIGURATION</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLUSCTL_CLUSTER_GET_STORAGE_CONFIGURATION

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-storage-configuration">CLUSCTL_CLUSTER_GET_STORAGE_CONFIGURATION</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLUSCTL_CLUSTER_GET_STORAGE_CONFIG_ATTRIBUTES

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-storage-config-attributes">CLUSCTL_CLUSTER_GET_STORAGE_CONFIG_ATTRIBUTES</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLUSCTL_CLUSTER_ENUM_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-enum-common-properties">CLUSCTL_CLUSTER_ENUM_COMMON_PROPERTIES</a>.


### -field CLUSCTL_CLUSTER_GET_RO_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-ro-common-properties">CLUSCTL_CLUSTER_GET_RO_COMMON_PROPERTIES</a>.


### -field CLUSCTL_CLUSTER_GET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-common-properties">CLUSCTL_CLUSTER_GET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_CLUSTER_SET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-common-properties">CLUSCTL_CLUSTER_SET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_CLUSTER_VALIDATE_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-validate-common-properties">CLUSCTL_CLUSTER_VALIDATE_COMMON_PROPERTIES</a>.


### -field CLUSCTL_CLUSTER_ENUM_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-enum-private-properties">CLUSCTL_CLUSTER_ENUM_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_CLUSTER_GET_RO_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-ro-private-properties">CLUSCTL_CLUSTER_GET_RO_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-private-properties">CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_CLUSTER_SET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-private-properties">CLUSCTL_CLUSTER_SET_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_CLUSTER_VALIDATE_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-validate-private-properties">CLUSCTL_CLUSTER_VALIDATE_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_CLUSTER_GET_COMMON_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-common-property-fmts">CLUSCTL_CLUSTER_GET_COMMON_PROPERTY_FMTS</a>.


### -field CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-private-property-fmts">CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTY_FMTS</a>.


### -field CLUSCTL_CLUSTER_CHECK_VOTER_EVICT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-check-voter-evict">CLUSCTL_CLUSTER_CHECK_VOTER_EVICT</a>.


### -field CLUSCTL_CLUSTER_CHECK_VOTER_DOWN

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-check-voter-down">CLUSCTL_CLUSTER_CHECK_VOTER_DOWN</a>.


### -field CLUSCTL_CLUSTER_SHUTDOWN

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-shutdown">CLUSCTL_CLUSTER_SHUTDOWN</a>.


### -field CLUSCTL_CLUSTER_BATCH_BLOCK_KEY

Not supported.


### -field CLUSCTL_CLUSTER_BATCH_UNBLOCK_KEY

Not supported.


### -field CLUSCTL_CLUSTER_GET_SHARED_VOLUME_ID

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-shared-volume-id">CLUSCTL_CLUSTER_GET_SHARED_VOLUME_ID</a>.

<b>Windows Server 2008:  </b>This control code is not supported before Windows Server 2008 R2.


### -field CLUSCTL_CLUSTER_GET_CLUSDB_TIMESTAMP

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-clusdb-timestamp">CLUSCTL_CLUSTER_GET_CLUSDB_TIMESTAMP</a>.


### -field CLUSCTL_CLUSTER_GET_GUM_LOCK_OWNER

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-get-gum-lock-owner">CLUSCTL_CLUSTER_GET_GUM_LOCK_OWNER</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLUSCTL_CLUSTER_REMOVE_NODE

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-remove-node">CLUSCTL_CLUSTER_REMOVE_NODE</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLUSCTL_CLUSTER_SET_ACCOUNT_ACCESS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-account-access">CLUSCTL_CLUSTER_SET_ACCOUNT_ACCESS</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLUSCTL_CLUSTER_CLEAR_NODE_CONNECTION_INFO

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-clear-node-connection-info">CLUSCTL_CLUSTER_CLEAR_NODE_CONNECTION_INFO</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLUSCTL_CLUSTER_SET_DNS_DOMAIN

See <a href="https://msdn.microsoft.com/C08360F8-4930-4BEA-B831-CD380EBCFF7D">CLUSCTL_CLUSTER_SET_DNS_DOMAIN</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLUSCTL_CLUSTER_SET_CLUSTER_S2D_ENABLED

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-cluster-das-mode-enabled">CLUSCTL_CLUSTER_SET_CLUSTER_S2D_ENABLED</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLUSCTL_CLUSTER_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cluster-set-cluster-s2d-cache-metadata-reserve-bytes">CLUSCTL_CLUSTER_SET_CLUSTER_S2D_CACHE_METADATA_RESERVE_BYTES</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This operation code is not available before Windows Server 2016.




### -field CLUSCTL_CLUSTER_RELOAD_AUTOLOGGER_CONFIG




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-control-codes">Cluster Control Codes</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/nf-clusapi-clustercontrol">ClusterControl</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-enumerations">Failover Cluster Enumerations</a>
 

 

