---
UID: NE:clusapi.CLUSCTL_GROUPSET_CODES
title: CLUSCTL_GROUPSET_CODES (clusapi.h)
description: Enumerates groupset control codes used by the ClusterGroupSetControl function.
old-location: mscs\clusctl_collection_codes.htm
tech.root: MsCS
ms.assetid: 2c160770-5ced-4914-bcca-c8f7405ad0b0
ms.date: 12/05/2018
ms.keywords: CLUSCTL_GROUPSET_CODES, CLUSCTL_GROUPSET_CODES enumeration [Failover Cluster], CLUSCTL_GROUPSET_GET_COMMON_PROPERTIES, CLUSCTL_GROUPSET_GET_GROUPS, CLUSCTL_GROUPSET_GET_PROVIDER_GROUPS, CLUSCTL_GROUPSET_GET_PROVIDER_GROUPSETS, CLUSCTL_GROUPSET_GET_RO_COMMON_PROPERTIES, CLUSCTL_GROUPSET_SET_COMMON_PROPERTIES, CLUSCTL_GROUP_GET_ID, CLUSCTL_GROUP_GET_PROVIDER_GROUPS, CLUSCTL_GROUP_GET_PROVIDER_GROUPSETS, msclus/CLUSCTL_GROUPSET_CODES, msclus/CLUSCTL_GROUPSET_GET_COMMON_PROPERTIES, msclus/CLUSCTL_GROUPSET_GET_GROUPS, msclus/CLUSCTL_GROUPSET_GET_PROVIDER_GROUPS, msclus/CLUSCTL_GROUPSET_GET_PROVIDER_GROUPSETS, msclus/CLUSCTL_GROUPSET_GET_RO_COMMON_PROPERTIES, msclus/CLUSCTL_GROUPSET_SET_COMMON_PROPERTIES, msclus/CLUSCTL_GROUP_GET_ID, msclus/CLUSCTL_GROUP_GET_PROVIDER_GROUPS, msclus/CLUSCTL_GROUP_GET_PROVIDER_GROUPSETS, mscs.clusctl_collection_codes
f1_keywords:
- clusapi/CLUSCTL_GROUPSET_CODES
dev_langs:
- c++
req.header: clusapi.h
req.include-header: Clusapi.h
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2016
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- msclus.h
api_name:
- CLUSCTL_GROUPSET_CODES
targetos: Windows
req.typenames: CLUSCTL_GROUPSET_CODES
req.redist: 
ms.custom: 19H1
---

# CLUSCTL_GROUPSET_CODES enumeration


## -description


Enumerates groupset <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/about-control-codes">control codes</a> used by 
    the <a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-clustergroupsetcontrol">ClusterGroupSetControl</a> function.


## -enum-fields




### -field CLUSCTL_GROUPSET_GET_COMMON_PROPERTIES

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-get-common-properties">CLUSCTL_GROUPSET_GET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_GROUPSET_GET_RO_COMMON_PROPERTIES

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-get-ro-common-properties">CLUSCTL_GROUPSET_GET_RO_COMMON_PROPERTIES</a>.


### -field CLUSCTL_GROUPSET_SET_COMMON_PROPERTIES

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-set-common-properties">CLUSCTL_GROUPSET_SET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_GROUPSET_GET_GROUPS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-get-groups">CLUSCTL_GROUPSET_GET_GROUPS</a>.


### -field CLUSCTL_GROUPSET_GET_PROVIDER_GROUPS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-get-provider-groups">CLUSCTL_GROUPSET_GET_PROVIDER_GROUPS</a>.


### -field CLUSCTL_GROUPSET_GET_PROVIDER_GROUPSETS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-collection-get-provider-collections">CLUSCTL_GROUPSET_GET_PROVIDER_GROUPSETS</a>.


### -field CLUSCTL_GROUP_GET_PROVIDER_GROUPS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-provider-groups">CLUSCTL_GROUP_GET_PROVIDER_GROUPS</a>.


### -field CLUSCTL_GROUP_GET_PROVIDER_GROUPSETS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-provider-collections">CLUSCTL_GROUP_GET_PROVIDER_GROUPSETS</a>.


### -field CLUSCTL_GROUPSET_GET_ID




#### - CLUSCTL_GROUP_GET_ID

See CLCTL_GET_ID.

