---
UID: NE:clusapi.CLUSCTL_NETWORK_CODES
title: CLUSCTL_NETWORK_CODES (clusapi.h)
description: Enumerates network control codes.
old-location: mscs\clusctl_network_codes.htm
tech.root: MsCS
ms.assetid: d9226efc-9dc8-491f-8056-ead799af552b
ms.date: 12/05/2018
ms.keywords: CLUSCTL_NETWORK_CODES, CLUSCTL_NETWORK_CODES enumeration [Failover Cluster], CLUSCTL_NETWORK_ENUM_COMMON_PROPERTIES, CLUSCTL_NETWORK_ENUM_PRIVATE_PROPERTIES, CLUSCTL_NETWORK_GET_CHARACTERISTICS, CLUSCTL_NETWORK_GET_COMMON_PROPERTIES, CLUSCTL_NETWORK_GET_COMMON_PROPERTY_FMTS, CLUSCTL_NETWORK_GET_FLAGS, CLUSCTL_NETWORK_GET_ID, CLUSCTL_NETWORK_GET_NAME, CLUSCTL_NETWORK_GET_PRIVATE_PROPERTIES, CLUSCTL_NETWORK_GET_PRIVATE_PROPERTY_FMTS, CLUSCTL_NETWORK_GET_RO_COMMON_PROPERTIES, CLUSCTL_NETWORK_GET_RO_PRIVATE_PROPERTIES, CLUSCTL_NETWORK_SET_COMMON_PROPERTIES, CLUSCTL_NETWORK_SET_PRIVATE_PROPERTIES, CLUSCTL_NETWORK_UNKNOWN, CLUSCTL_NETWORK_VALIDATE_COMMON_PROPERTIES, CLUSCTL_NETWORK_VALIDATE_PRIVATE_PROPERTIES, _CLUSCTL_NETWORK_CODES, _CLUSCTL_NETWORK_CODES enumeration [Failover Cluster], clusapi/CLUSCTL_NETWORK_CODES, clusapi/CLUSCTL_NETWORK_ENUM_COMMON_PROPERTIES, clusapi/CLUSCTL_NETWORK_ENUM_PRIVATE_PROPERTIES, clusapi/CLUSCTL_NETWORK_GET_CHARACTERISTICS, clusapi/CLUSCTL_NETWORK_GET_COMMON_PROPERTIES, clusapi/CLUSCTL_NETWORK_GET_COMMON_PROPERTY_FMTS, clusapi/CLUSCTL_NETWORK_GET_FLAGS, clusapi/CLUSCTL_NETWORK_GET_ID, clusapi/CLUSCTL_NETWORK_GET_NAME, clusapi/CLUSCTL_NETWORK_GET_PRIVATE_PROPERTIES, clusapi/CLUSCTL_NETWORK_GET_PRIVATE_PROPERTY_FMTS, clusapi/CLUSCTL_NETWORK_GET_RO_COMMON_PROPERTIES, clusapi/CLUSCTL_NETWORK_GET_RO_PRIVATE_PROPERTIES, clusapi/CLUSCTL_NETWORK_SET_COMMON_PROPERTIES, clusapi/CLUSCTL_NETWORK_SET_PRIVATE_PROPERTIES, clusapi/CLUSCTL_NETWORK_UNKNOWN, clusapi/CLUSCTL_NETWORK_VALIDATE_COMMON_PROPERTIES, clusapi/CLUSCTL_NETWORK_VALIDATE_PRIVATE_PROPERTIES, clusapi/_CLUSCTL_NETWORK_CODES, msclus/CLUSCTL_NETWORK_CODES, msclus/CLUSCTL_NETWORK_ENUM_COMMON_PROPERTIES, msclus/CLUSCTL_NETWORK_ENUM_PRIVATE_PROPERTIES, msclus/CLUSCTL_NETWORK_GET_CHARACTERISTICS, msclus/CLUSCTL_NETWORK_GET_COMMON_PROPERTIES, msclus/CLUSCTL_NETWORK_GET_COMMON_PROPERTY_FMTS, msclus/CLUSCTL_NETWORK_GET_FLAGS, msclus/CLUSCTL_NETWORK_GET_ID, msclus/CLUSCTL_NETWORK_GET_NAME, msclus/CLUSCTL_NETWORK_GET_PRIVATE_PROPERTIES, msclus/CLUSCTL_NETWORK_GET_PRIVATE_PROPERTY_FMTS, msclus/CLUSCTL_NETWORK_GET_RO_COMMON_PROPERTIES, msclus/CLUSCTL_NETWORK_GET_RO_PRIVATE_PROPERTIES, msclus/CLUSCTL_NETWORK_SET_COMMON_PROPERTIES, msclus/CLUSCTL_NETWORK_SET_PRIVATE_PROPERTIES, msclus/CLUSCTL_NETWORK_UNKNOWN, msclus/CLUSCTL_NETWORK_VALIDATE_COMMON_PROPERTIES, msclus/CLUSCTL_NETWORK_VALIDATE_PRIVATE_PROPERTIES, msclus/_CLUSCTL_NETWORK_CODES, mscs.clusctl_network_codes
f1_keywords:
- clusapi/CLUSCTL_NETWORK_CODES
dev_langs:
- c++
req.header: clusapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Datacenter, Windows Server 2008 Enterprise
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ClusAPI.h
- MsClus.h
api_name:
- CLUSCTL_NETWORK_CODES
targetos: Windows
req.typenames: CLUSCTL_NETWORK_CODES
req.redist: 
ms.custom: 19H1
---

# CLUSCTL_NETWORK_CODES enumeration


## -description


Enumerates <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/networks">network</a>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/about-control-codes">control codes</a>.


## -enum-fields




### -field CLUSCTL_NETWORK_UNKNOWN

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-unknown">CLUSCTL_NETWORK_UNKNOWN</a>.


### -field CLUSCTL_NETWORK_GET_CHARACTERISTICS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-characteristics">CLUSCTL_NETWORK_GET_CHARACTERISTICS</a>.


### -field CLUSCTL_NETWORK_GET_FLAGS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-flags">CLUSCTL_NETWORK_GET_FLAGS</a>.


### -field CLUSCTL_NETWORK_GET_NAME

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-name">CLUSCTL_NETWORK_GET_NAME</a>.


### -field CLUSCTL_NETWORK_GET_ID

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-id">CLUSCTL_NETWORK_GET_ID</a>.


### -field CLUSCTL_NETWORK_ENUM_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-enum-common-properties">CLUSCTL_NETWORK_ENUM_COMMON_PROPERTIES</a>.


### -field CLUSCTL_NETWORK_GET_RO_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-ro-common-properties">CLUSCTL_NETWORK_GET_RO_COMMON_PROPERTIES</a>.


### -field CLUSCTL_NETWORK_GET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-common-properties">CLUSCTL_NETWORK_GET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_NETWORK_SET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-set-common-properties">CLUSCTL_NETWORK_SET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_NETWORK_VALIDATE_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-validate-common-properties">CLUSCTL_NETWORK_VALIDATE_COMMON_PROPERTIES</a>.


### -field CLUSCTL_NETWORK_ENUM_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-enum-private-properties">CLUSCTL_NETWORK_ENUM_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_NETWORK_GET_RO_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-ro-private-properties">CLUSCTL_NETWORK_GET_RO_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_NETWORK_GET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-private-properties">CLUSCTL_NETWORK_GET_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_NETWORK_SET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-set-private-properties">CLUSCTL_NETWORK_SET_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_NETWORK_VALIDATE_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-validate-private-properties">CLUSCTL_NETWORK_VALIDATE_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_NETWORK_GET_COMMON_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-common-property-fmts">CLUSCTL_NETWORK_GET_COMMON_PROPERTY_FMTS</a>.


### -field CLUSCTL_NETWORK_GET_PRIVATE_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-private-property-fmts">CLUSCTL_NETWORK_GET_PRIVATE_PROPERTY_FMTS</a>.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-enumerations">Failover Cluster Enumerations</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/network-control-codes">Network Control Codes</a>
 

 

