---
UID: NE:clusapi.CLUSCTL_NODE_CODES
title: CLUSCTL_NODE_CODES (clusapi.h)
description: Enumerates node control codes.
old-location: mscs\clusctl_node_codes.htm
tech.root: MsCS
ms.assetid: 6f69e61a-10f8-4d8d-b504-ee35ddc17ed4
ms.date: 12/05/2018
ms.keywords: CLUSCTL_NODE_BLOCK_GEM_SEND_RECV, CLUSCTL_NODE_CODES, CLUSCTL_NODE_CODES enumeration [Failover Cluster], CLUSCTL_NODE_ENUM_COMMON_PROPERTIES, CLUSCTL_NODE_ENUM_PRIVATE_PROPERTIES, CLUSCTL_NODE_GET_CHARACTERISTICS, CLUSCTL_NODE_GET_CLUSTER_SERVICE_ACCOUNT_NAME, CLUSCTL_NODE_GET_COMMON_PROPERTIES, CLUSCTL_NODE_GET_COMMON_PROPERTY_FMTS, CLUSCTL_NODE_GET_FLAGS, CLUSCTL_NODE_GET_GEMID_VECTOR, CLUSCTL_NODE_GET_ID, CLUSCTL_NODE_GET_NAME, CLUSCTL_NODE_GET_PRIVATE_PROPERTIES, CLUSCTL_NODE_GET_PRIVATE_PROPERTY_FMTS, CLUSCTL_NODE_GET_RO_COMMON_PROPERTIES, CLUSCTL_NODE_GET_RO_PRIVATE_PROPERTIES, CLUSCTL_NODE_INJECT_GEM_FAULT, CLUSCTL_NODE_INTRODUCE_GEM_REPAIR_DELAY, CLUSCTL_NODE_SEND_DUMMY_GEM_MESSAGES, CLUSCTL_NODE_SET_COMMON_PROPERTIES, CLUSCTL_NODE_SET_PRIVATE_PROPERTIES, CLUSCTL_NODE_UNKNOWN, CLUSCTL_NODE_VALIDATE_COMMON_PROPERTIES, CLUSCTL_NODE_VALIDATE_PRIVATE_PROPERTIES, _CLUSCTL_NODE_CODES, _CLUSCTL_NODE_CODES enumeration [Failover Cluster], clusapi/CLUSCTL_NODE_BLOCK_GEM_SEND_RECV, clusapi/CLUSCTL_NODE_CODES, clusapi/CLUSCTL_NODE_ENUM_COMMON_PROPERTIES, clusapi/CLUSCTL_NODE_ENUM_PRIVATE_PROPERTIES, clusapi/CLUSCTL_NODE_GET_CHARACTERISTICS, clusapi/CLUSCTL_NODE_GET_CLUSTER_SERVICE_ACCOUNT_NAME, clusapi/CLUSCTL_NODE_GET_COMMON_PROPERTIES, clusapi/CLUSCTL_NODE_GET_COMMON_PROPERTY_FMTS, clusapi/CLUSCTL_NODE_GET_FLAGS, clusapi/CLUSCTL_NODE_GET_GEMID_VECTOR, clusapi/CLUSCTL_NODE_GET_ID, clusapi/CLUSCTL_NODE_GET_NAME, clusapi/CLUSCTL_NODE_GET_PRIVATE_PROPERTIES, clusapi/CLUSCTL_NODE_GET_PRIVATE_PROPERTY_FMTS, clusapi/CLUSCTL_NODE_GET_RO_COMMON_PROPERTIES, clusapi/CLUSCTL_NODE_GET_RO_PRIVATE_PROPERTIES, clusapi/CLUSCTL_NODE_INJECT_GEM_FAULT, clusapi/CLUSCTL_NODE_INTRODUCE_GEM_REPAIR_DELAY, clusapi/CLUSCTL_NODE_SEND_DUMMY_GEM_MESSAGES, clusapi/CLUSCTL_NODE_SET_COMMON_PROPERTIES, clusapi/CLUSCTL_NODE_SET_PRIVATE_PROPERTIES, clusapi/CLUSCTL_NODE_UNKNOWN, clusapi/CLUSCTL_NODE_VALIDATE_COMMON_PROPERTIES, clusapi/CLUSCTL_NODE_VALIDATE_PRIVATE_PROPERTIES, clusapi/_CLUSCTL_NODE_CODES, msclus/CLUSCTL_NODE_BLOCK_GEM_SEND_RECV, msclus/CLUSCTL_NODE_CODES, msclus/CLUSCTL_NODE_ENUM_COMMON_PROPERTIES, msclus/CLUSCTL_NODE_ENUM_PRIVATE_PROPERTIES, msclus/CLUSCTL_NODE_GET_CHARACTERISTICS, msclus/CLUSCTL_NODE_GET_CLUSTER_SERVICE_ACCOUNT_NAME, msclus/CLUSCTL_NODE_GET_COMMON_PROPERTIES, msclus/CLUSCTL_NODE_GET_COMMON_PROPERTY_FMTS, msclus/CLUSCTL_NODE_GET_FLAGS, msclus/CLUSCTL_NODE_GET_GEMID_VECTOR, msclus/CLUSCTL_NODE_GET_ID, msclus/CLUSCTL_NODE_GET_NAME, msclus/CLUSCTL_NODE_GET_PRIVATE_PROPERTIES, msclus/CLUSCTL_NODE_GET_PRIVATE_PROPERTY_FMTS, msclus/CLUSCTL_NODE_GET_RO_COMMON_PROPERTIES, msclus/CLUSCTL_NODE_GET_RO_PRIVATE_PROPERTIES, msclus/CLUSCTL_NODE_INJECT_GEM_FAULT, msclus/CLUSCTL_NODE_INTRODUCE_GEM_REPAIR_DELAY, msclus/CLUSCTL_NODE_SEND_DUMMY_GEM_MESSAGES, msclus/CLUSCTL_NODE_SET_COMMON_PROPERTIES, msclus/CLUSCTL_NODE_SET_PRIVATE_PROPERTIES, msclus/CLUSCTL_NODE_UNKNOWN, msclus/CLUSCTL_NODE_VALIDATE_COMMON_PROPERTIES, msclus/CLUSCTL_NODE_VALIDATE_PRIVATE_PROPERTIES, msclus/_CLUSCTL_NODE_CODES, mscs.clusctl_node_codes
f1_keywords:
- clusapi/CLUSCTL_NODE_CODES
dev_langs:
- c++
req.header: clusapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Datacenter, Windows Server 2008 Enterprise
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ClusAPI.h
- MsClus.h
api_name:
- CLUSCTL_NODE_CODES
targetos: Windows
req.typenames: CLUSCTL_NODE_CODES
req.redist: 
ms.custom: 19H1
---

# CLUSCTL_NODE_CODES enumeration


## -description


Enumerates <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/nodes">node</a>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/about-control-codes">control codes</a>.


## -enum-fields




### -field CLUSCTL_NODE_UNKNOWN

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-unknown">CLUSCTL_NODE_UNKNOWN</a>.


### -field CLUSCTL_NODE_GET_CHARACTERISTICS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-characteristics">CLUSCTL_NODE_GET_CHARACTERISTICS</a>.


### -field CLUSCTL_NODE_GET_FLAGS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-flags">CLUSCTL_NODE_GET_FLAGS</a>.


### -field CLUSCTL_NODE_GET_NAME

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-name">CLUSCTL_NODE_GET_NAME</a>.


### -field CLUSCTL_NODE_GET_ID

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-id">CLUSCTL_NODE_GET_ID</a>.


### -field CLUSCTL_NODE_ENUM_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-enum-common-properties">CLUSCTL_NODE_ENUM_COMMON_PROPERTIES</a>.


### -field CLUSCTL_NODE_GET_RO_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-ro-common-properties">CLUSCTL_NODE_GET_RO_COMMON_PROPERTIES</a>.


### -field CLUSCTL_NODE_GET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-common-properties">CLUSCTL_NODE_GET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_NODE_SET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-set-common-properties">CLUSCTL_NODE_SET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_NODE_VALIDATE_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-validate-common-properties">CLUSCTL_NODE_VALIDATE_COMMON_PROPERTIES</a>.


### -field CLUSCTL_NODE_ENUM_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-enum-private-properties">CLUSCTL_NODE_ENUM_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_NODE_GET_RO_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-ro-private-properties">CLUSCTL_NODE_GET_RO_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_NODE_GET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-private-properties">CLUSCTL_NODE_GET_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_NODE_SET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-set-private-properties">CLUSCTL_NODE_SET_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_NODE_VALIDATE_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-validate-private-properties">CLUSCTL_NODE_VALIDATE_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_NODE_GET_COMMON_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-common-property-fmts">CLUSCTL_NODE_GET_COMMON_PROPERTY_FMTS</a>.


### -field CLUSCTL_NODE_GET_PRIVATE_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-private-property-fmts">CLUSCTL_NODE_GET_PRIVATE_PROPERTY_FMTS</a>.


### -field CLUSCTL_NODE_GET_CLUSTER_SERVICE_ACCOUNT_NAME

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-cluster-service-account-name">CLUSCTL_NODE_GET_CLUSTER_SERVICE_ACCOUNT_NAME</a>.


### -field CLUSCTL_NODE_GET_STUCK_NODES


### -field CLUSCTL_NODE_INJECT_GEM_FAULT

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-inject-gem-fault">CLUSCTL_NODE_INJECT_GEM_FAULT</a>.

<b>Windows Server 2008 R2 and Windows Server 2012:  </b>This control code is not supported before Windows Server 2012 R2.




### -field CLUSCTL_NODE_INTRODUCE_GEM_REPAIR_DELAY

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-introduce-gem-repair-delay">CLUSCTL_NODE_INTRODUCE_GEM_REPAIR_DELAY</a>.

<b>Windows Server 2008 R2 and Windows Server 2012:  </b>This control code is not supported before Windows Server 2012 R2.




### -field CLUSCTL_NODE_SEND_DUMMY_GEM_MESSAGES

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-send-dummy-gem-messages">CLUSCTL_NODE_SEND_DUMMY_GEM_MESSAGES</a>.

<b>Windows Server 2008 R2 and Windows Server 2012:  </b>This control code is not supported before Windows Server 2012 R2.




### -field CLUSCTL_NODE_BLOCK_GEM_SEND_RECV

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-block-gem-send-recv">CLUSCTL_NODE_BLOCK_GEM_SEND_RECV</a>.

<b>Windows Server 2008 R2 and Windows Server 2012:  </b>This control code is not supported before Windows Server 2012 R2.




### -field CLUSCTL_NODE_GET_GEMID_VECTOR

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-gemid-vector">CLUSCTL_NODE_GET_GEMID_VECTOR</a>.

<b>Windows Server 2008 R2 and Windows Server 2012:  </b>This control code is not supported before Windows Server 2012 R2.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-enumerations">Failover Cluster Enumerations</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/node-control-codes">Node Control Codes</a>
 

 

