---
UID: NE:clusapi.CLUSCTL_RESOURCE_CODES
title: CLUSCTL_RESOURCE_CODES (clusapi.h)
description: Enumerates resource&#32;control codes.
old-location: mscs\clusctl_resource_codes.htm
tech.root: MsCS
ms.assetid: c90420de-48e9-4105-9848-a27abad9c452
ms.date: 12/05/2018
ms.keywords: CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY, CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN, CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT, CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT_EX, CLUSCTL_RESOURCE_ADD_DEPENDENCY, CLUSCTL_RESOURCE_ADD_OWNER, CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT, CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_32BIT, CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_64BIT, CLUSCTL_RESOURCE_CLUSTER_NAME_CHANGED, CLUSCTL_RESOURCE_CLUSTER_VERSION_CHANGED, CLUSCTL_RESOURCE_CODES, CLUSCTL_RESOURCE_CODES enumeration [Failover Cluster], CLUSCTL_RESOURCE_DELETE, CLUSCTL_RESOURCE_DELETE_CRYPTO_CHECKPOINT, CLUSCTL_RESOURCE_DELETE_REGISTRY_CHECKPOINT, CLUSCTL_RESOURCE_DISABLE_SHARED_VOLUME_DIRECTIO, CLUSCTL_RESOURCE_ENABLE_SHARED_VOLUME_DIRECTIO, CLUSCTL_RESOURCE_ENUM_COMMON_PROPERTIES, CLUSCTL_RESOURCE_ENUM_PRIVATE_PROPERTIES, CLUSCTL_RESOURCE_EVICT_NODE, CLUSCTL_RESOURCE_FILESERVER_SHARE_ADD, CLUSCTL_RESOURCE_FILESERVER_SHARE_DEL, CLUSCTL_RESOURCE_FILESERVER_SHARE_MODIFY, CLUSCTL_RESOURCE_FILESERVER_SHARE_REPORT, CLUSCTL_RESOURCE_FORCE_QUORUM, CLUSCTL_RESOURCE_FSWITNESS_GET_EPOCH_INFO, CLUSCTL_RESOURCE_FSWITNESS_RELEASE_LOCK, CLUSCTL_RESOURCE_FSWITNESS_SET_EPOCH_INFO, CLUSCTL_RESOURCE_GET_CHARACTERISTICS, CLUSCTL_RESOURCE_GET_CLASS_INFO, CLUSCTL_RESOURCE_GET_COMMON_PROPERTIES, CLUSCTL_RESOURCE_GET_COMMON_PROPERTY_FMTS, CLUSCTL_RESOURCE_GET_CRYPTO_CHECKPOINTS, CLUSCTL_RESOURCE_GET_DNS_NAME, CLUSCTL_RESOURCE_GET_FAILURE_INFO, CLUSCTL_RESOURCE_GET_FLAGS, CLUSCTL_RESOURCE_GET_ID, CLUSCTL_RESOURCE_GET_LOADBAL_PROCESS_LIST, CLUSCTL_RESOURCE_GET_NAME, CLUSCTL_RESOURCE_GET_NETWORK_NAME, CLUSCTL_RESOURCE_GET_OPERATION_CONTEXT, CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTIES, CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTY_FMTS, CLUSCTL_RESOURCE_GET_REGISTRY_CHECKPOINTS, CLUSCTL_RESOURCE_GET_REQUIRED_DEPENDENCIES, CLUSCTL_RESOURCE_GET_RESOURCE_TYPE, CLUSCTL_RESOURCE_GET_RO_COMMON_PROPERTIES, CLUSCTL_RESOURCE_GET_RO_PRIVATE_PROPERTIES, CLUSCTL_RESOURCE_GET_STATE_CHANGE_TIME, CLUSCTL_RESOURCE_INITIALIZE, CLUSCTL_RESOURCE_INSTALL_NODE, CLUSCTL_RESOURCE_IPADDRESS_RELEASE_LEASE, CLUSCTL_RESOURCE_IPADDRESS_RENEW_LEASE, CLUSCTL_RESOURCE_IS_QUORUM_BLOCKED, CLUSCTL_RESOURCE_JOINING_GROUP, CLUSCTL_RESOURCE_LEAVING_GROUP, CLUSCTL_RESOURCE_NETNAME_CREDS_NOTIFYCAM, CLUSCTL_RESOURCE_NETNAME_CREDS_UPDATED, CLUSCTL_RESOURCE_NETNAME_DELETE_CO, CLUSCTL_RESOURCE_NETNAME_GET_VIRTUAL_SERVER_TOKEN, CLUSCTL_RESOURCE_NETNAME_REGISTER_DNS_RECORDS, CLUSCTL_RESOURCE_NETNAME_REPAIR_VCO, CLUSCTL_RESOURCE_NETNAME_RESET_VCO, CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFO, CLUSCTL_RESOURCE_NETNAME_VALIDATE_VCO, CLUSCTL_RESOURCE_NOTIFY_OWNER_CHANGE, CLUSCTL_RESOURCE_NOTIFY_QUORUM_STATUS, CLUSCTL_RESOURCE_POOL_GET_DRIVE_INFO, CLUSCTL_RESOURCE_PREPARE_UPGRADE, CLUSCTL_RESOURCE_PROVIDER_STATE_CHANGE, CLUSCTL_RESOURCE_QUERY_DELETE, CLUSCTL_RESOURCE_QUERY_MAINTENANCE_MODE, CLUSCTL_RESOURCE_REMOVE_DEPENDENCY, CLUSCTL_RESOURCE_REMOVE_OWNER, CLUSCTL_RESOURCE_RLUA_GET_VIRTUAL_SERVER_TOKEN, CLUSCTL_RESOURCE_RLUA_SET_PWD_INFO, CLUSCTL_RESOURCE_RW_MODIFY_NOOP, CLUSCTL_RESOURCE_SET_COMMON_PROPERTIES, CLUSCTL_RESOURCE_SET_CSV_MAINTENANCE_MODE, CLUSCTL_RESOURCE_SET_MAINTENANCE_MODE, CLUSCTL_RESOURCE_SET_NAME, CLUSCTL_RESOURCE_SET_PRIVATE_PROPERTIES, CLUSCTL_RESOURCE_SET_SHARED_VOLUME_BACKUP_MODE, CLUSCTL_RESOURCE_STATE_CHANGE_REASON, CLUSCTL_RESOURCE_STORAGE_CLUSTER_DISK, CLUSCTL_RESOURCE_STORAGE_GET_DIRTY, CLUSCTL_RESOURCE_STORAGE_GET_DISKID, CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO, CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX, CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX2, CLUSCTL_RESOURCE_STORAGE_GET_DISK_NUMBER_INFO, CLUSCTL_RESOURCE_STORAGE_GET_MOUNTPOINTS, CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_INFO, CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES, CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_STATES, CLUSCTL_RESOURCE_STORAGE_IS_PATH_VALID, CLUSCTL_RESOURCE_STORAGE_IS_SHARED_VOLUME, CLUSCTL_RESOURCE_STORAGE_SET_DRIVELETTER, CLUSCTL_RESOURCE_UNKNOWN, CLUSCTL_RESOURCE_UPGRADE_COMPLETED, CLUSCTL_RESOURCE_UPGRADE_DLL, CLUSCTL_RESOURCE_VALIDATE_CHANGE_GROUP, CLUSCTL_RESOURCE_VALIDATE_COMMON_PROPERTIES, CLUSCTL_RESOURCE_VALIDATE_PRIVATE_PROPERTIES, _CLUSCTL_RESOURCE_CODES, _CLUSCTL_RESOURCE_CODES enumeration [Failover Cluster], clusapi/CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY, clusapi/CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN, clusapi/CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT, clusapi/CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT_EX, clusapi/CLUSCTL_RESOURCE_ADD_DEPENDENCY, clusapi/CLUSCTL_RESOURCE_ADD_OWNER, clusapi/CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT, clusapi/CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_32BIT, clusapi/CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_64BIT, clusapi/CLUSCTL_RESOURCE_CLUSTER_NAME_CHANGED, clusapi/CLUSCTL_RESOURCE_CLUSTER_VERSION_CHANGED, clusapi/CLUSCTL_RESOURCE_CODES, clusapi/CLUSCTL_RESOURCE_DELETE, clusapi/CLUSCTL_RESOURCE_DELETE_CRYPTO_CHECKPOINT, clusapi/CLUSCTL_RESOURCE_DELETE_REGISTRY_CHECKPOINT, clusapi/CLUSCTL_RESOURCE_DISABLE_SHARED_VOLUME_DIRECTIO, clusapi/CLUSCTL_RESOURCE_ENABLE_SHARED_VOLUME_DIRECTIO, clusapi/CLUSCTL_RESOURCE_ENUM_COMMON_PROPERTIES, clusapi/CLUSCTL_RESOURCE_ENUM_PRIVATE_PROPERTIES, clusapi/CLUSCTL_RESOURCE_EVICT_NODE, clusapi/CLUSCTL_RESOURCE_FILESERVER_SHARE_ADD, clusapi/CLUSCTL_RESOURCE_FILESERVER_SHARE_DEL, clusapi/CLUSCTL_RESOURCE_FILESERVER_SHARE_MODIFY, clusapi/CLUSCTL_RESOURCE_FILESERVER_SHARE_REPORT, clusapi/CLUSCTL_RESOURCE_FORCE_QUORUM, clusapi/CLUSCTL_RESOURCE_FSWITNESS_GET_EPOCH_INFO, clusapi/CLUSCTL_RESOURCE_FSWITNESS_RELEASE_LOCK, clusapi/CLUSCTL_RESOURCE_FSWITNESS_SET_EPOCH_INFO, clusapi/CLUSCTL_RESOURCE_GET_CHARACTERISTICS, clusapi/CLUSCTL_RESOURCE_GET_CLASS_INFO, clusapi/CLUSCTL_RESOURCE_GET_COMMON_PROPERTIES, clusapi/CLUSCTL_RESOURCE_GET_COMMON_PROPERTY_FMTS, clusapi/CLUSCTL_RESOURCE_GET_CRYPTO_CHECKPOINTS, clusapi/CLUSCTL_RESOURCE_GET_DNS_NAME, clusapi/CLUSCTL_RESOURCE_GET_FAILURE_INFO, clusapi/CLUSCTL_RESOURCE_GET_FLAGS, clusapi/CLUSCTL_RESOURCE_GET_ID, clusapi/CLUSCTL_RESOURCE_GET_LOADBAL_PROCESS_LIST, clusapi/CLUSCTL_RESOURCE_GET_NAME, clusapi/CLUSCTL_RESOURCE_GET_NETWORK_NAME, clusapi/CLUSCTL_RESOURCE_GET_OPERATION_CONTEXT, clusapi/CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTIES, clusapi/CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTY_FMTS, clusapi/CLUSCTL_RESOURCE_GET_REGISTRY_CHECKPOINTS, clusapi/CLUSCTL_RESOURCE_GET_REQUIRED_DEPENDENCIES, clusapi/CLUSCTL_RESOURCE_GET_RESOURCE_TYPE, clusapi/CLUSCTL_RESOURCE_GET_RO_COMMON_PROPERTIES, clusapi/CLUSCTL_RESOURCE_GET_RO_PRIVATE_PROPERTIES, clusapi/CLUSCTL_RESOURCE_GET_STATE_CHANGE_TIME, clusapi/CLUSCTL_RESOURCE_INITIALIZE, clusapi/CLUSCTL_RESOURCE_INSTALL_NODE, clusapi/CLUSCTL_RESOURCE_IPADDRESS_RELEASE_LEASE, clusapi/CLUSCTL_RESOURCE_IPADDRESS_RENEW_LEASE, clusapi/CLUSCTL_RESOURCE_IS_QUORUM_BLOCKED, clusapi/CLUSCTL_RESOURCE_JOINING_GROUP, clusapi/CLUSCTL_RESOURCE_LEAVING_GROUP, clusapi/CLUSCTL_RESOURCE_NETNAME_CREDS_NOTIFYCAM, clusapi/CLUSCTL_RESOURCE_NETNAME_CREDS_UPDATED, clusapi/CLUSCTL_RESOURCE_NETNAME_DELETE_CO, clusapi/CLUSCTL_RESOURCE_NETNAME_GET_VIRTUAL_SERVER_TOKEN, clusapi/CLUSCTL_RESOURCE_NETNAME_REGISTER_DNS_RECORDS, clusapi/CLUSCTL_RESOURCE_NETNAME_REPAIR_VCO, clusapi/CLUSCTL_RESOURCE_NETNAME_RESET_VCO, clusapi/CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFO, clusapi/CLUSCTL_RESOURCE_NETNAME_VALIDATE_VCO, clusapi/CLUSCTL_RESOURCE_NOTIFY_OWNER_CHANGE, clusapi/CLUSCTL_RESOURCE_NOTIFY_QUORUM_STATUS, clusapi/CLUSCTL_RESOURCE_POOL_GET_DRIVE_INFO, clusapi/CLUSCTL_RESOURCE_PREPARE_UPGRADE, clusapi/CLUSCTL_RESOURCE_PROVIDER_STATE_CHANGE, clusapi/CLUSCTL_RESOURCE_QUERY_DELETE, clusapi/CLUSCTL_RESOURCE_QUERY_MAINTENANCE_MODE, clusapi/CLUSCTL_RESOURCE_REMOVE_DEPENDENCY, clusapi/CLUSCTL_RESOURCE_REMOVE_OWNER, clusapi/CLUSCTL_RESOURCE_RLUA_GET_VIRTUAL_SERVER_TOKEN, clusapi/CLUSCTL_RESOURCE_RLUA_SET_PWD_INFO, clusapi/CLUSCTL_RESOURCE_RW_MODIFY_NOOP, clusapi/CLUSCTL_RESOURCE_SET_COMMON_PROPERTIES, clusapi/CLUSCTL_RESOURCE_SET_CSV_MAINTENANCE_MODE, clusapi/CLUSCTL_RESOURCE_SET_MAINTENANCE_MODE, clusapi/CLUSCTL_RESOURCE_SET_NAME, clusapi/CLUSCTL_RESOURCE_SET_PRIVATE_PROPERTIES, clusapi/CLUSCTL_RESOURCE_SET_SHARED_VOLUME_BACKUP_MODE, clusapi/CLUSCTL_RESOURCE_STATE_CHANGE_REASON, clusapi/CLUSCTL_RESOURCE_STORAGE_CLUSTER_DISK, clusapi/CLUSCTL_RESOURCE_STORAGE_GET_DIRTY, clusapi/CLUSCTL_RESOURCE_STORAGE_GET_DISKID, clusapi/CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO, clusapi/CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX, clusapi/CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX2, clusapi/CLUSCTL_RESOURCE_STORAGE_GET_DISK_NUMBER_INFO, clusapi/CLUSCTL_RESOURCE_STORAGE_GET_MOUNTPOINTS, clusapi/CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_INFO, clusapi/CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES, clusapi/CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_STATES, clusapi/CLUSCTL_RESOURCE_STORAGE_IS_PATH_VALID, clusapi/CLUSCTL_RESOURCE_STORAGE_IS_SHARED_VOLUME, clusapi/CLUSCTL_RESOURCE_STORAGE_SET_DRIVELETTER, clusapi/CLUSCTL_RESOURCE_UNKNOWN, clusapi/CLUSCTL_RESOURCE_UPGRADE_COMPLETED, clusapi/CLUSCTL_RESOURCE_UPGRADE_DLL, clusapi/CLUSCTL_RESOURCE_VALIDATE_CHANGE_GROUP, clusapi/CLUSCTL_RESOURCE_VALIDATE_COMMON_PROPERTIES, clusapi/CLUSCTL_RESOURCE_VALIDATE_PRIVATE_PROPERTIES, clusapi/_CLUSCTL_RESOURCE_CODES, msclus/CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY, msclus/CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN, msclus/CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT, msclus/CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT_EX, msclus/CLUSCTL_RESOURCE_ADD_DEPENDENCY, msclus/CLUSCTL_RESOURCE_ADD_OWNER, msclus/CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT, msclus/CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_32BIT, msclus/CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_64BIT, msclus/CLUSCTL_RESOURCE_CLUSTER_NAME_CHANGED, msclus/CLUSCTL_RESOURCE_CLUSTER_VERSION_CHANGED, msclus/CLUSCTL_RESOURCE_CODES, msclus/CLUSCTL_RESOURCE_DELETE, msclus/CLUSCTL_RESOURCE_DELETE_CRYPTO_CHECKPOINT, msclus/CLUSCTL_RESOURCE_DELETE_REGISTRY_CHECKPOINT, msclus/CLUSCTL_RESOURCE_DISABLE_SHARED_VOLUME_DIRECTIO, msclus/CLUSCTL_RESOURCE_ENABLE_SHARED_VOLUME_DIRECTIO, msclus/CLUSCTL_RESOURCE_ENUM_COMMON_PROPERTIES, msclus/CLUSCTL_RESOURCE_ENUM_PRIVATE_PROPERTIES, msclus/CLUSCTL_RESOURCE_EVICT_NODE, msclus/CLUSCTL_RESOURCE_FILESERVER_SHARE_ADD, msclus/CLUSCTL_RESOURCE_FILESERVER_SHARE_DEL, msclus/CLUSCTL_RESOURCE_FILESERVER_SHARE_MODIFY, msclus/CLUSCTL_RESOURCE_FILESERVER_SHARE_REPORT, msclus/CLUSCTL_RESOURCE_FORCE_QUORUM, msclus/CLUSCTL_RESOURCE_FSWITNESS_GET_EPOCH_INFO, msclus/CLUSCTL_RESOURCE_FSWITNESS_RELEASE_LOCK, msclus/CLUSCTL_RESOURCE_FSWITNESS_SET_EPOCH_INFO, msclus/CLUSCTL_RESOURCE_GET_CHARACTERISTICS, msclus/CLUSCTL_RESOURCE_GET_CLASS_INFO, msclus/CLUSCTL_RESOURCE_GET_COMMON_PROPERTIES, msclus/CLUSCTL_RESOURCE_GET_COMMON_PROPERTY_FMTS, msclus/CLUSCTL_RESOURCE_GET_CRYPTO_CHECKPOINTS, msclus/CLUSCTL_RESOURCE_GET_DNS_NAME, msclus/CLUSCTL_RESOURCE_GET_FAILURE_INFO, msclus/CLUSCTL_RESOURCE_GET_FLAGS, msclus/CLUSCTL_RESOURCE_GET_ID, msclus/CLUSCTL_RESOURCE_GET_LOADBAL_PROCESS_LIST, msclus/CLUSCTL_RESOURCE_GET_NAME, msclus/CLUSCTL_RESOURCE_GET_NETWORK_NAME, msclus/CLUSCTL_RESOURCE_GET_OPERATION_CONTEXT, msclus/CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTIES, msclus/CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTY_FMTS, msclus/CLUSCTL_RESOURCE_GET_REGISTRY_CHECKPOINTS, msclus/CLUSCTL_RESOURCE_GET_REQUIRED_DEPENDENCIES, msclus/CLUSCTL_RESOURCE_GET_RESOURCE_TYPE, msclus/CLUSCTL_RESOURCE_GET_RO_COMMON_PROPERTIES, msclus/CLUSCTL_RESOURCE_GET_RO_PRIVATE_PROPERTIES, msclus/CLUSCTL_RESOURCE_GET_STATE_CHANGE_TIME, msclus/CLUSCTL_RESOURCE_INITIALIZE, msclus/CLUSCTL_RESOURCE_INSTALL_NODE, msclus/CLUSCTL_RESOURCE_IPADDRESS_RELEASE_LEASE, msclus/CLUSCTL_RESOURCE_IPADDRESS_RENEW_LEASE, msclus/CLUSCTL_RESOURCE_IS_QUORUM_BLOCKED, msclus/CLUSCTL_RESOURCE_JOINING_GROUP, msclus/CLUSCTL_RESOURCE_LEAVING_GROUP, msclus/CLUSCTL_RESOURCE_NETNAME_CREDS_NOTIFYCAM, msclus/CLUSCTL_RESOURCE_NETNAME_CREDS_UPDATED, msclus/CLUSCTL_RESOURCE_NETNAME_DELETE_CO, msclus/CLUSCTL_RESOURCE_NETNAME_GET_VIRTUAL_SERVER_TOKEN, msclus/CLUSCTL_RESOURCE_NETNAME_REGISTER_DNS_RECORDS, msclus/CLUSCTL_RESOURCE_NETNAME_REPAIR_VCO, msclus/CLUSCTL_RESOURCE_NETNAME_RESET_VCO, msclus/CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFO, msclus/CLUSCTL_RESOURCE_NETNAME_VALIDATE_VCO, msclus/CLUSCTL_RESOURCE_NOTIFY_OWNER_CHANGE, msclus/CLUSCTL_RESOURCE_NOTIFY_QUORUM_STATUS, msclus/CLUSCTL_RESOURCE_POOL_GET_DRIVE_INFO, msclus/CLUSCTL_RESOURCE_PREPARE_UPGRADE, msclus/CLUSCTL_RESOURCE_PROVIDER_STATE_CHANGE, msclus/CLUSCTL_RESOURCE_QUERY_DELETE, msclus/CLUSCTL_RESOURCE_QUERY_MAINTENANCE_MODE, msclus/CLUSCTL_RESOURCE_REMOVE_DEPENDENCY, msclus/CLUSCTL_RESOURCE_REMOVE_OWNER, msclus/CLUSCTL_RESOURCE_RLUA_GET_VIRTUAL_SERVER_TOKEN, msclus/CLUSCTL_RESOURCE_RLUA_SET_PWD_INFO, msclus/CLUSCTL_RESOURCE_RW_MODIFY_NOOP, msclus/CLUSCTL_RESOURCE_SET_COMMON_PROPERTIES, msclus/CLUSCTL_RESOURCE_SET_CSV_MAINTENANCE_MODE, msclus/CLUSCTL_RESOURCE_SET_MAINTENANCE_MODE, msclus/CLUSCTL_RESOURCE_SET_NAME, msclus/CLUSCTL_RESOURCE_SET_PRIVATE_PROPERTIES, msclus/CLUSCTL_RESOURCE_SET_SHARED_VOLUME_BACKUP_MODE, msclus/CLUSCTL_RESOURCE_STATE_CHANGE_REASON, msclus/CLUSCTL_RESOURCE_STORAGE_CLUSTER_DISK, msclus/CLUSCTL_RESOURCE_STORAGE_GET_DIRTY, msclus/CLUSCTL_RESOURCE_STORAGE_GET_DISKID, msclus/CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO, msclus/CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX, msclus/CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX2, msclus/CLUSCTL_RESOURCE_STORAGE_GET_DISK_NUMBER_INFO, msclus/CLUSCTL_RESOURCE_STORAGE_GET_MOUNTPOINTS, msclus/CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_INFO, msclus/CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES, msclus/CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_STATES, msclus/CLUSCTL_RESOURCE_STORAGE_IS_PATH_VALID, msclus/CLUSCTL_RESOURCE_STORAGE_IS_SHARED_VOLUME, msclus/CLUSCTL_RESOURCE_STORAGE_SET_DRIVELETTER, msclus/CLUSCTL_RESOURCE_UNKNOWN, msclus/CLUSCTL_RESOURCE_UPGRADE_COMPLETED, msclus/CLUSCTL_RESOURCE_UPGRADE_DLL, msclus/CLUSCTL_RESOURCE_VALIDATE_CHANGE_GROUP, msclus/CLUSCTL_RESOURCE_VALIDATE_COMMON_PROPERTIES, msclus/CLUSCTL_RESOURCE_VALIDATE_PRIVATE_PROPERTIES, msclus/_CLUSCTL_RESOURCE_CODES, mscs.clusctl_resource_codes
f1_keywords:
- clusapi/CLUSCTL_RESOURCE_CODES
dev_langs:
- c++
req.header: clusapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Enterprise, Windows Server 2008 Datacenter
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ClusAPI.h
- MsClus.h
api_name:
- CLUSCTL_RESOURCE_CODES
targetos: Windows
req.typenames: CLUSCTL_RESOURCE_CODES
req.redist: 
ms.custom: 19H1
---

# CLUSCTL_RESOURCE_CODES enumeration


## -description


Enumerates <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resources">resource</a> <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/about-control-codes">control codes</a>.


## -enum-fields




### -field CLUSCTL_RESOURCE_UNKNOWN

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-unknown">CLUSCTL_RESOURCE_UNKNOWN</a>.


### -field CLUSCTL_RESOURCE_GET_CHARACTERISTICS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-characteristics">CLUSCTL_RESOURCE_GET_CHARACTERISTICS</a>.


### -field CLUSCTL_RESOURCE_GET_FLAGS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-flags">CLUSCTL_RESOURCE_GET_FLAGS</a>.


### -field CLUSCTL_RESOURCE_GET_CLASS_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-class-info">CLUSCTL_RESOURCE_GET_CLASS_INFO</a>.


### -field CLUSCTL_RESOURCE_GET_REQUIRED_DEPENDENCIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-required-dependencies">CLUSCTL_RESOURCE_GET_REQUIRED_DEPENDENCIES</a>.


### -field CLUSCTL_RESOURCE_GET_NAME

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-name">CLUSCTL_RESOURCE_GET_NAME</a>.


### -field CLUSCTL_RESOURCE_GET_ID

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-id">CLUSCTL_RESOURCE_GET_ID</a>.


### -field CLUSCTL_RESOURCE_GET_RESOURCE_TYPE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-resource-type">CLUSCTL_RESOURCE_GET_RESOURCE_TYPE</a>.


### -field CLUSCTL_RESOURCE_ENUM_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-enum-common-properties">CLUSCTL_RESOURCE_ENUM_COMMON_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_GET_RO_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-ro-common-properties">CLUSCTL_RESOURCE_GET_RO_COMMON_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_GET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-common-properties">CLUSCTL_RESOURCE_GET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_SET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-common-properties">CLUSCTL_RESOURCE_SET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_VALIDATE_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-validate-common-properties">CLUSCTL_RESOURCE_VALIDATE_COMMON_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_GET_COMMON_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-common-property-fmts">CLUSCTL_RESOURCE_GET_COMMON_PROPERTY_FMTS</a>.


### -field CLUSCTL_RESOURCE_ENUM_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-enum-private-properties">CLUSCTL_RESOURCE_ENUM_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_GET_RO_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-ro-private-properties">CLUSCTL_RESOURCE_GET_RO_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-private-properties">CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_SET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-private-properties">CLUSCTL_RESOURCE_SET_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_VALIDATE_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-validate-private-properties">CLUSCTL_RESOURCE_VALIDATE_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-private-property-fmts">CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTY_FMTS</a>.


### -field CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-registry-checkpoint">CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT</a>.


### -field CLUSCTL_RESOURCE_DELETE_REGISTRY_CHECKPOINT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-delete-registry-checkpoint">CLUSCTL_RESOURCE_DELETE_REGISTRY_CHECKPOINT</a>.


### -field CLUSCTL_RESOURCE_GET_REGISTRY_CHECKPOINTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-registry-checkpoints">CLUSCTL_RESOURCE_GET_REGISTRY_CHECKPOINTS</a>.


### -field CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-crypto-checkpoint">CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT</a>.


### -field CLUSCTL_RESOURCE_DELETE_CRYPTO_CHECKPOINT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-delete-crypto-checkpoint">CLUSCTL_RESOURCE_DELETE_CRYPTO_CHECKPOINT</a>.


### -field CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT_EX

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-crypto-checkpoint-ex">CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT_EX</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2012 R2.




### -field CLUSCTL_RESOURCE_GET_CRYPTO_CHECKPOINTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-crypto-checkpoints">CLUSCTL_RESOURCE_GET_CRYPTO_CHECKPOINTS</a>.


### -field CLUSCTL_RESOURCE_GET_LOADBAL_PROCESS_LIST

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-loadbal-process-list">CLUSCTL_RESOURCE_GET_LOADBAL_PROCESS_LIST</a>.


### -field CLUSCTL_RESOURCE_GET_NETWORK_NAME

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-network-name">CLUSCTL_RESOURCE_GET_NETWORK_NAME</a>.


### -field CLUSCTL_RESOURCE_NETNAME_GET_VIRTUAL_SERVER_TOKEN

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-get-virtual-server-token">CLUSCTL_RESOURCE_NETNAME_GET_VIRTUAL_SERVER_TOKEN</a>.


### -field CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-set-pwd-info">CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFO</a>.


### -field CLUSCTL_RESOURCE_NETNAME_DELETE_CO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-delete-co">CLUSCTL_RESOURCE_NETNAME_DELETE_CO</a>.


### -field CLUSCTL_RESOURCE_NETNAME_VALIDATE_VCO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-validate-vco">CLUSCTL_RESOURCE_NETNAME_VALIDATE_VCO</a>.


### -field CLUSCTL_RESOURCE_NETNAME_RESET_VCO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-reset-vco">CLUSCTL_RESOURCE_NETNAME_RESET_VCO</a>.


### -field CLUSCTL_RESOURCE_NETNAME_REPAIR_VCO


<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-repair-vco">CLUSCTL_RESOURCE_NETNAME_REPAIR_VCO</a>



### -field CLUSCTL_RESOURCE_NETNAME_REGISTER_DNS_RECORDS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-register-dns-records">CLUSCTL_RESOURCE_NETNAME_REGISTER_DNS_RECORDS</a>.


### -field CLUSCTL_RESOURCE_GET_DNS_NAME

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-dns-name">CLUSCTL_RESOURCE_GET_DNS_NAME</a>.


### -field CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-disk-info">CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO</a>.


### -field CLUSCTL_RESOURCE_STORAGE_GET_DISK_NUMBER_INFO

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-disk-number-info">CLUSCTL_RESOURCE_STORAGE_GET_DISK_NUMBER_INFO</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not supported before Windows Server 2016.




### -field CLUSCTL_RESOURCE_STORAGE_IS_PATH_VALID

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-is-path-valid">CLUSCTL_RESOURCE_STORAGE_IS_PATH_VALID</a>.


### -field CLUSCTL_RESOURCE_QUERY_DELETE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-query-delete">CLUSCTL_RESOURCE_QUERY_DELETE</a>.


### -field CLUSCTL_RESOURCE_UPGRADE_DLL

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-upgrade-dll">CLUSCTL_RESOURCE_UPGRADE_DLL</a>.


### -field CLUSCTL_RESOURCE_IPADDRESS_RENEW_LEASE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-ipaddress-renew-lease">CLUSCTL_RESOURCE_IPADDRESS_RENEW_LEASE</a>.


### -field CLUSCTL_RESOURCE_IPADDRESS_RELEASE_LEASE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-ipaddress-release-lease">CLUSCTL_RESOURCE_IPADDRESS_RELEASE_LEASE</a>.


### -field CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_64BIT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-registry-checkpoint-64bit">CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_64BIT</a>.


### -field CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_32BIT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-registry-checkpoint-32bit">CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_32BIT</a>.


### -field CLUSCTL_RESOURCE_QUERY_MAINTENANCE_MODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-query-maintenance-mode">CLUSCTL_RESOURCE_QUERY_MAINTENANCE_MODE</a>.


### -field CLUSCTL_RESOURCE_SET_MAINTENANCE_MODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-maintenance-mode">CLUSCTL_RESOURCE_SET_MAINTENANCE_MODE</a>.


### -field CLUSCTL_RESOURCE_STORAGE_SET_DRIVELETTER

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-set-driveletter">CLUSCTL_RESOURCE_STORAGE_SET_DRIVELETTER</a>.


### -field CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-disk-info-ex">CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX</a>.


### -field CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX2

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-disk-info-ex2">CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX2</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not supported before Windows Server 2016.




### -field CLUSCTL_RESOURCE_STORAGE_GET_MOUNTPOINTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-mountpoints">CLUSCTL_RESOURCE_STORAGE_GET_MOUNTPOINTS</a>.


### -field CLUSCTL_RESOURCE_STORAGE_GET_DIRTY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-dirty">CLUSCTL_RESOURCE_STORAGE_GET_DIRTY</a>.


### -field CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_INFO

Not supported.


### -field CLUSCTL_RESOURCE_SET_CSV_MAINTENANCE_MODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-csv-maintenance-mode">CLUSCTL_RESOURCE_SET_CSV_MAINTENANCE_MODE</a>.


### -field CLUSCTL_RESOURCE_ENABLE_SHARED_VOLUME_DIRECTIO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-enable-shared-volume-directio">CLUSCTL_RESOURCE_ENABLE_SHARED_VOLUME_DIRECTIO</a>.


### -field CLUSCTL_RESOURCE_DISABLE_SHARED_VOLUME_DIRECTIO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-disable-shared-volume-directio">CLUSCTL_RESOURCE_DISABLE_SHARED_VOLUME_DIRECTIO</a>.


### -field CLUSCTL_RESOURCE_SET_SHARED_VOLUME_BACKUP_MODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-shared-volume-backup-mode">CLUSCTL_RESOURCE_SET_SHARED_VOLUME_BACKUP_MODE</a>.


### -field CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-shared-volume-partition-names">CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_PARTITION_NAMES</a>.


### -field CLUSCTL_RESOURCE_GET_FAILURE_INFO

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-failure-info">CLUSCTL_RESOURCE_GET_FAILURE_INFO</a>.


### -field CLUSCTL_RESOURCE_STORAGE_GET_DISKID

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-diskid">CLUSCTL_RESOURCE_STORAGE_GET_DISKID</a>.


### -field CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_STATES

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-get-shared-volume-states">CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_STATES</a>.


### -field CLUSCTL_RESOURCE_STORAGE_IS_SHARED_VOLUME

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-is-shared-volume">CLUSCTL_RESOURCE_STORAGE_IS_SHARED_VOLUME</a>.


### -field CLUSCTL_RESOURCE_IS_QUORUM_BLOCKED

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-is-quorum-blocked">CLUSCTL_RESOURCE_IS_QUORUM_BLOCKED</a>.


### -field CLUSCTL_RESOURCE_POOL_GET_DRIVE_INFO

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-pool-get-drive-info">CLUSCTL_RESOURCE_POOL_GET_DRIVE_INFO</a>.


### -field CLUSCTL_RESOURCE_RLUA_GET_VIRTUAL_SERVER_TOKEN

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-rlua-get-virtual-server-token">CLUSCTL_RESOURCE_RLUA_GET_VIRTUAL_SERVER_TOKEN</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not supported before Windows Server 2012 R2.




### -field CLUSCTL_RESOURCE_RLUA_SET_PWD_INFO

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-rlua-set-pwd-info">CLUSCTL_RESOURCE_RLUA_SET_PWD_INFO</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not supported before Windows Server 2012 R2.




### -field CLUSCTL_RESOURCE_DELETE

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-delete">CLUSCTL_RESOURCE_DELETE</a>.


### -field CLUSCTL_RESOURCE_INSTALL_NODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-install-node">CLUSCTL_RESOURCE_INSTALL_NODE</a>.


### -field CLUSCTL_RESOURCE_EVICT_NODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-evict-node">CLUSCTL_RESOURCE_EVICT_NODE</a>.


### -field CLUSCTL_RESOURCE_ADD_DEPENDENCY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-dependency">CLUSCTL_RESOURCE_ADD_DEPENDENCY</a>.


### -field CLUSCTL_RESOURCE_REMOVE_DEPENDENCY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-remove-dependency">CLUSCTL_RESOURCE_REMOVE_DEPENDENCY</a>.


### -field CLUSCTL_RESOURCE_ADD_OWNER

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-add-owner">CLUSCTL_RESOURCE_ADD_OWNER</a>.


### -field CLUSCTL_RESOURCE_REMOVE_OWNER

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-remove-owner">CLUSCTL_RESOURCE_REMOVE_OWNER</a>.


### -field CLUSCTL_RESOURCE_SET_NAME

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-set-name">CLUSCTL_RESOURCE_SET_NAME</a>.


### -field CLUSCTL_RESOURCE_CLUSTER_NAME_CHANGED

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-cluster-name-changed">CLUSCTL_RESOURCE_CLUSTER_NAME_CHANGED</a>.


### -field CLUSCTL_RESOURCE_CLUSTER_VERSION_CHANGED

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-cluster-version-changed">CLUSCTL_RESOURCE_CLUSTER_VERSION_CHANGED</a>.


### -field CLUSCTL_RESOURCE_FORCE_QUORUM

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-force-quorum">CLUSCTL_RESOURCE_FORCE_QUORUM</a>.


### -field CLUSCTL_RESOURCE_INITIALIZE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-initialize">CLUSCTL_RESOURCE_INITIALIZE</a>.


### -field CLUSCTL_RESOURCE_STATE_CHANGE_REASON

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-state-change-reason">CLUSCTL_RESOURCE_STATE_CHANGE_REASON</a>.


### -field CLUSCTL_RESOURCE_PROVIDER_STATE_CHANGE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-provider-state-change">CLUSCTL_RESOURCE_PROVIDER_STATE_CHANGE</a>.


### -field CLUSCTL_RESOURCE_LEAVING_GROUP

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-leaving-group">CLUSCTL_RESOURCE_LEAVING_GROUP</a>.


### -field CLUSCTL_RESOURCE_JOINING_GROUP

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-joining-group">CLUSCTL_RESOURCE_JOINING_GROUP</a>.


### -field CLUSCTL_RESOURCE_FSWITNESS_GET_EPOCH_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fswitness-get-epoch-info">CLUSCTL_RESOURCE_FSWITNESS_GET_EPOCH_INFO</a>.


### -field CLUSCTL_RESOURCE_FSWITNESS_SET_EPOCH_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fswitness-set-epoch-info">CLUSCTL_RESOURCE_FSWITNESS_SET_EPOCH_INFO</a>.


### -field CLUSCTL_RESOURCE_FSWITNESS_RELEASE_LOCK

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fswitness-release-lock">CLUSCTL_RESOURCE_FSWITNESS_RELEASE_LOCK</a>.


### -field CLUSCTL_RESOURCE_NETNAME_CREDS_NOTIFYCAM

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-creds-notifycam">CLUSCTL_RESOURCE_NETNAME_CREDS_NOTIFYCAM</a>.


### -field CLUSCTL_RESOURCE_GET_OPERATION_CONTEXT

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-operation-context">CLUSCTL_RESOURCE_GET_OPERATION_CONTEXT</a>.


### -field CLUSCTL_RESOURCE_RW_MODIFY_NOOP

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-rw-modify-noop">CLUSCTL_RESOURCE_RW_MODIFY_NOOP</a>.


### -field CLUSCTL_RESOURCE_NOTIFY_QUORUM_STATUS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-notify-quorum-status">CLUSCTL_RESOURCE_NOTIFY_QUORUM_STATUS</a>.


### -field CLUSCTL_RESOURCE_NOTIFY_OWNER_CHANGE

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-notify-owner-change">CLUSCTL_RESOURCE_NOTIFY_OWNER_CHANGE</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not supported before Windows Server 2012 R2.




### -field CLUSCTL_RESOURCE_VALIDATE_CHANGE_GROUP

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-validate-change-group">CLUSCTL_RESOURCE_VALIDATE_CHANGE_GROUP</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not supported before Windows Server 2016.




### -field CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cloud-witness-resource-update-token">CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_TOKEN</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not supported before Windows Server 2016.




### -field CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cloud-witness-resource-update-key">CLUSCTL_CLOUD_WITNESS_RESOURCE_UPDATE_KEY</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not supported before Windows Server 2016.




### -field CLUSCTL_RESOURCE_PREPARE_UPGRADE

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-prepare-upgrade">CLUSCTL_RESOURCE_PREPARE_UPGRADE</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not supported before Windows Server 2016.




### -field CLUSCTL_RESOURCE_UPGRADE_COMPLETED

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-upgrade-completed">CLUSCTL_RESOURCE_UPGRADE_COMPLETED</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not supported before Windows Server 2016.




### -field CLUSCTL_RESOURCE_GET_STATE_CHANGE_TIME

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-state-change-time">CLUSCTL_RESOURCE_GET_STATE_CHANGE_TIME</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not supported before Windows Server 2016.




### -field CLUSCTL_RESOURCE_GET_INFRASTRUCTURE_SOFS_BUFFER


### -field CLUSCTL_RESOURCE_SET_INFRASTRUCTURE_SOFS_BUFFER


### -field CLUSCTL_RESOURCE_SCALEOUT_COMMAND


### -field CLUSCTL_RESOURCE_SCALEOUT_CONTROL


### -field CLUSCTL_RESOURCE_SCALEOUT_GET_CLUSTERS




#### - CLUSCTL_RESOURCE_FILESERVER_SHARE_ADD

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fileserver-share-add">CLUSCTL_RESOURCE_FILESERVER_SHARE_ADD</a>.


#### - CLUSCTL_RESOURCE_FILESERVER_SHARE_DEL

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fileserver-share-del">CLUSCTL_RESOURCE_FILESERVER_SHARE_DEL</a>.


#### - CLUSCTL_RESOURCE_FILESERVER_SHARE_MODIFY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fileserver-share-modify">CLUSCTL_RESOURCE_FILESERVER_SHARE_MODIFY</a>.


#### - CLUSCTL_RESOURCE_FILESERVER_SHARE_REPORT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-fileserver-share-report">CLUSCTL_RESOURCE_FILESERVER_SHARE_REPORT</a>.


#### - CLUSCTL_RESOURCE_NETNAME_CREDS_UPDATED

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-netname-creds-updated">CLUSCTL_RESOURCE_NETNAME_CREDS_UPDATED</a>.


#### - CLUSCTL_RESOURCE_STORAGE_CLUSTER_DISK

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-storage-cluster-disk">CLUSCTL_RESOURCE_STORAGE_CLUSTER_DISK</a>.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-enumerations">Failover Cluster Enumerations</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resource-control-codes">Resource Control Codes</a>
 

 

