---
UID: NE:codecapi.eAVEncMPVScanPattern
title: eAVEncMPVScanPattern (codecapi.h)
description: Specifies the macroblock scan pattern. This enumeration is used with the AVEncMPVScanPattern property.
old-location: dshow\eavencmpvscanpattern.htm
tech.root: DirectShow
ms.assetid: 8204705e-b944-4479-b8c8-d64ab9a4d5f2
ms.date: 12/05/2018
ms.keywords: codecapi/eAVEncMPVScanPattern, codecapi/eAVEncMPVScanPattern_AlternateScan, codecapi/eAVEncMPVScanPattern_Auto, codecapi/eAVEncMPVScanPattern_ZigZagScan, dshow.eavencmpvscanpattern, eAVEncMPVScanPattern, eAVEncMPVScanPattern enumeration [DirectShow], eAVEncMPVScanPatternEnumeration, eAVEncMPVScanPattern_AlternateScan, eAVEncMPVScanPattern_Auto, eAVEncMPVScanPattern_ZigZagScan
f1_keywords:
- codecapi/eAVEncMPVScanPattern
dev_langs:
- c++
req.header: codecapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps \| UWP apps]
req.target-min-winversvr: Windows 2000 Server [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- codecapi.h
api_name:
- eAVEncMPVScanPattern
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# eAVEncMPVScanPattern enumeration


## -description



Specifies the macroblock scan pattern. This enumeration is used with the <a href="https://docs.microsoft.com/windows/desktop/DirectShow/avencmpvscanpattern-property">AVEncMPVScanPattern</a> property.




## -enum-fields




### -field eAVEncMPVScanPattern_Auto

The encoder selects the scan pattern.


### -field eAVEncMPVScanPattern_ZigZagScan

Zig-zag scan.


### -field eAVEncMPVScanPattern_AlternateScan

Alternate-vertical scan.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/codec-api-enumerations">Codec API Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/api/strmif/nn-strmif-icodecapi">ICodecAPI Interface</a>
 

 

