---
UID: NF:combaseapi.IIDFromString
title: IIDFromString function (combaseapi.h)
description: Converts a string generated by the StringFromIID function back into the original interface identifier (IID).
old-location: com\iidfromstring.htm
tech.root: com
ms.assetid: 7fa72a65-68f8-438e-8a0c-6e0e0208420d
ms.date: 12/05/2018
ms.keywords: IIDFromString, IIDFromString function [COM], _com_IIDFromString, com.iidfromstring, combaseapi/IIDFromString
f1_keywords:
- combaseapi/IIDFromString
dev_langs:
- c++
req.header: combaseapi.h
req.include-header: Objbase.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps \| UWP apps]
req.target-min-winversvr: Windows 2000 Server [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Ole32.lib
req.dll: Ole32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Ole32.dll
- API-MS-Win-Core-Com-l1-1-0.dll
- ComBase.dll
- API-MS-Win-Core-Com-l1-1-1.dll
- API-MS-Win-DownLevel-Ole32-l1-1-0.dll
- API-MS-Win-DownLevel-Ole32-l1-1-1.dll
api_name:
- IIDFromString
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IIDFromString function


## -description


Converts a string generated by the <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-stringfromiid">StringFromIID</a> function back into the original interface identifier (IID).


## -parameters




### -param lpsz [in]

A pointer to the string representation of the IID.


### -param lpiid [out]

A pointer to the requested IID on return.


## -returns



This function can return the standard return values E_INVALIDARG, E_OUTOFMEMORY, and S_OK.




## -remarks



The function converts the interface identifier in a way that guarantees different interface identifiers will always be converted to different strings.





## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-stringfromiid">StringFromIID</a>
 

 

