---
UID: NE:commctrl.EC_ENDOFLINE
title: EC_ENDOFLINE (commctrl.h)
description: Indicates the end of line character used by an edit control.
old-location: controls\ec_endofline.htm
tech.root: Controls
ms.assetid: 8F84EFE4-E562-46D4-AEC8-2782C9EC31F7
ms.date: 12/05/2018
ms.keywords: EC_ENDOFLINE, EC_ENDOFLINE enumeration [Windows Controls], EC_ENDOFLINE_CR, EC_ENDOFLINE_CRLF, EC_ENDOFLINE_DETECTFROMCONTENT, EC_ENDOFLINE_LF, commctrl/EC_ENDOFLINE, commctrl/EC_ENDOFLINE_CR, commctrl/EC_ENDOFLINE_CRLF, commctrl/EC_ENDOFLINE_DETECTFROMCONTENT, commctrl/EC_ENDOFLINE_LF, controls.ec_endofline
f1_keywords:
- commctrl/EC_ENDOFLINE
dev_langs:
- c++
req.header: commctrl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10, version 1809 [desktop apps only]
req.target-min-winversvr: Windows Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Commctrl.h
api_name:
- EC_ENDOFLINE
targetos: Windows
req.typenames: EC_ENDOFLINE
req.redist: 
ms.custom: 19H1
---

# EC_ENDOFLINE enumeration


## -description


<p class="CCE_Message">[Some information relates to pre-released product which may be substantially modified before it's commercially released. Microsoft makes no warranties, express or implied, with respect to the information provided here.]

Indicates the end of line character used by an edit control. 


## -enum-fields




### -field EC_ENDOFLINE_DETECTFROMCONTENT

End of line character specified in content.


### -field EC_ENDOFLINE_CRLF

End of line character is CRLF.


### -field EC_ENDOFLINE_CR

End of line character is CR.


### -field EC_ENDOFLINE_LF

End of line character is LF.


## -see-also




<a href="https://docs.microsoft.com/en-us/windows/desktop/controls/em-getendofline">EM_GETENDOFLINE</a>



<a href="https://docs.microsoft.com/en-us/windows/desktop/controls/em-setendofline">EM_SETENDOFLINE</a>



<a href="https://docs.microsoft.com/en-us/windows/desktop/api/commctrl/nf-commctrl-edit_getendofline">Edit_GetEndOfLine</a>



<a href="https://docs.microsoft.com/en-us/windows/desktop/api/commctrl/nf-commctrl-edit_setendofline">Edit_SetEndOfLine</a>
 

 

