---
UID: NF:commctrl.Header_SetBitmapMargin
title: Header_SetBitmapMargin macro (commctrl.h)
description: Sets the width of the margin for a bitmap in an existing header control. You can use this macro or send the HDM_SETBITMAPMARGIN message explicitly.
old-location: controls\Header_SetBitmapMargin.htm
tech.root: Controls
ms.assetid: VS|Controls|~\controls\header\macros\header_setbitmapmargin.htm
ms.date: 12/05/2018
ms.keywords: Header_SetBitmapMargin, Header_SetBitmapMargin macro [Windows Controls], _win32_Header_SetBitmapMargin, _win32_Header_SetBitmapMargin_cpp, commctrl/Header_SetBitmapMargin, controls.Header_SetBitmapMargin, controls._win32_Header_SetBitmapMargin
f1_keywords:
- commctrl/Header_SetBitmapMargin
dev_langs:
- c++
req.header: commctrl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Commctrl.h
api_name:
- Header_SetBitmapMargin
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# Header_SetBitmapMargin macro


## -description


Sets the width of the margin for a bitmap in an existing header control. You can use this macro or send the <a href="https://docs.microsoft.com/windows/desktop/Controls/hdm-setbitmapmargin">HDM_SETBITMAPMARGIN</a> message explicitly. 


## -parameters




### -param hwnd

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">HWND</a></b>

A handle to a header control. 


### -param iWidth

Type: <b>int</b>

The width, specified in pixels, of the margin that surrounds a bitmap within an existing header control. 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/commctrl/nf-commctrl-header_getbitmapmargin">Header_GetBitmapMargin</a>
 

 

